/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.blendengine.imageprocessors.bgri;

import com.Fo2PiX.blendengine.imageprocessors.TrnsProcessor;
import com.Fo2PiX.blendengine.imageprocessors.TrnsProcessors;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;

public class BGRiTrnsProcessors
implements TrnsProcessors {
    public static final int CHLS = 3;
    public static final int CHO_R = 2;
    public static final int CHO_G = 1;
    public static final int CHO_B = 0;
    private final TrnsProcessor TrnsCpy = new RGBiTrnsCpyImpl();
    private final TrnsProcessor TrnsInv = new RGBiTrnsInvImpl();
    private final TrnsProcessor TrnsFlpX = new RGBiTrnsFlpXImpl();
    private final TrnsProcessor TrnsFlpY = new RGBiTrnsFlpYImpl();
    private final TrnsProcessor TrnsFlpXY = new RGBiTrnsFlpXYImpl();
    private final TrnsProcessor TrnsInvFlpX = new RGBiTrnsInvFlpXImpl();
    private final TrnsProcessor TrnsInvFlpY = new RGBiTrnsInvFlpYImpl();
    private final TrnsProcessor TrnsInvFlpXY = new RGBiTrnsInvFlpXYImpl();
    protected DataBufferByte SrcDB = null;
    protected DataBufferByte DstDB = null;
    protected byte[] SrcB = null;
    protected byte[] DstB = null;
    protected int Width = 0;
    protected int Height = 0;

    @Override
    public void setTrgts(Rectangle Size, DataBuffer Src, DataBuffer Dst) {
        this.SrcDB = (DataBufferByte)Src;
        this.DstDB = (DataBufferByte)Dst;
        this.SrcB = this.SrcDB.getData(0);
        this.DstB = this.DstDB.getData(0);
        this.Width = Size.width;
        this.Height = Size.height;
    }

    @Override
    public TrnsProcessor getTrnsProcessor(int Trns) {
        switch (Trns) {
            case 1: {
                return this.TrnsInv;
            }
            case 2: {
                return this.TrnsFlpX;
            }
            case 3: {
                return this.TrnsInvFlpX;
            }
            case 4: {
                return this.TrnsFlpY;
            }
            case 5: {
                return this.TrnsInvFlpY;
            }
            case 6: {
                return this.TrnsFlpXY;
            }
            case 7: {
                return this.TrnsInvFlpXY;
            }
        }
        return this.TrnsCpy;
    }

    @Override
    public void process(int Trns) {
        switch (Trns) {
            case 1: {
                this.TrnsInv.processImage();
                break;
            }
            case 2: {
                this.TrnsFlpX.processImage();
                break;
            }
            case 3: {
                this.TrnsInvFlpX.processImage();
                break;
            }
            case 4: {
                this.TrnsFlpY.processImage();
                break;
            }
            case 5: {
                this.TrnsInvFlpY.processImage();
                break;
            }
            case 6: {
                this.TrnsFlpXY.processImage();
                break;
            }
            case 7: {
                this.TrnsInvFlpXY.processImage();
                break;
            }
            default: {
                this.TrnsCpy.processImage();
            }
        }
    }

    class RGBiTrnsInvImpl
    implements TrnsProcessor {
        RGBiTrnsInvImpl() {
        }

        @Override
        public void processImage() {
            for (int i = 0; i < BGRiTrnsProcessors.this.SrcB.length; i += 3) {
                BGRiTrnsProcessors.this.DstB[i + 2] = (byte)(255 - BGRiTrnsProcessors.this.SrcB[i + 2]);
                BGRiTrnsProcessors.this.DstB[i + 1] = (byte)(255 - BGRiTrnsProcessors.this.SrcB[i + 1]);
                BGRiTrnsProcessors.this.DstB[i + 0] = (byte)(255 - BGRiTrnsProcessors.this.SrcB[i + 0]);
            }
        }
    }

    class RGBiTrnsInvFlpYImpl
    implements TrnsProcessor {
        RGBiTrnsInvFlpYImpl() {
        }

        @Override
        public void processImage() {
            int ii = 0;
            int iii = 0;
            for (int i = 0; i < BGRiTrnsProcessors.this.Height; ++i) {
                for (int j = 0; j < BGRiTrnsProcessors.this.Width; ++j) {
                    iii = j * 3 + BGRiTrnsProcessors.this.Width * (BGRiTrnsProcessors.this.Height - 1 - i) * 3;
                    BGRiTrnsProcessors.this.DstB[ii + 2] = (byte)(255 - BGRiTrnsProcessors.this.SrcB[iii + 2]);
                    BGRiTrnsProcessors.this.DstB[ii + 1] = (byte)(255 - BGRiTrnsProcessors.this.SrcB[iii + 1]);
                    BGRiTrnsProcessors.this.DstB[ii + 0] = (byte)(255 - BGRiTrnsProcessors.this.SrcB[iii + 0]);
                    ii += 3;
                }
            }
        }
    }

    class RGBiTrnsInvFlpXYImpl
    implements TrnsProcessor {
        RGBiTrnsInvFlpXYImpl() {
        }

        @Override
        public void processImage() {
            int ii = 0;
            int iii = 0;
            for (int i = 0; i < BGRiTrnsProcessors.this.Height; ++i) {
                for (int j = 0; j < BGRiTrnsProcessors.this.Width; ++j) {
                    iii = (BGRiTrnsProcessors.this.Width - 1 - j) * 3 + BGRiTrnsProcessors.this.Width * (BGRiTrnsProcessors.this.Height - 1 - i) * 3;
                    BGRiTrnsProcessors.this.DstB[ii + 2] = (byte)(255 - BGRiTrnsProcessors.this.SrcB[iii + 2]);
                    BGRiTrnsProcessors.this.DstB[ii + 1] = (byte)(255 - BGRiTrnsProcessors.this.SrcB[iii + 1]);
                    BGRiTrnsProcessors.this.DstB[ii + 0] = (byte)(255 - BGRiTrnsProcessors.this.SrcB[iii + 0]);
                    ii += 3;
                }
            }
        }
    }

    class RGBiTrnsInvFlpXImpl
    implements TrnsProcessor {
        RGBiTrnsInvFlpXImpl() {
        }

        @Override
        public void processImage() {
            int ii = 0;
            int iii = 0;
            for (int i = 0; i < BGRiTrnsProcessors.this.Height; ++i) {
                for (int j = 0; j < BGRiTrnsProcessors.this.Width; ++j) {
                    iii = (BGRiTrnsProcessors.this.Width - 1 - j) * 3 + BGRiTrnsProcessors.this.Width * i * 3;
                    BGRiTrnsProcessors.this.DstB[ii + 2] = (byte)(255 - BGRiTrnsProcessors.this.SrcB[iii + 2]);
                    BGRiTrnsProcessors.this.DstB[ii + 1] = (byte)(255 - BGRiTrnsProcessors.this.SrcB[iii + 1]);
                    BGRiTrnsProcessors.this.DstB[ii + 0] = (byte)(255 - BGRiTrnsProcessors.this.SrcB[iii + 0]);
                    ii += 3;
                }
            }
        }
    }

    class RGBiTrnsFlpYImpl
    implements TrnsProcessor {
        RGBiTrnsFlpYImpl() {
        }

        @Override
        public void processImage() {
            int ii = 0;
            int iii = 0;
            for (int i = 0; i < BGRiTrnsProcessors.this.Height; ++i) {
                for (int j = 0; j < BGRiTrnsProcessors.this.Width; ++j) {
                    iii = j * 3 + BGRiTrnsProcessors.this.Width * (BGRiTrnsProcessors.this.Height - 1 - i) * 3;
                    BGRiTrnsProcessors.this.DstB[ii + 2] = BGRiTrnsProcessors.this.SrcB[iii + 2];
                    BGRiTrnsProcessors.this.DstB[ii + 1] = BGRiTrnsProcessors.this.SrcB[iii + 1];
                    BGRiTrnsProcessors.this.DstB[ii + 0] = BGRiTrnsProcessors.this.SrcB[iii + 0];
                    ii += 3;
                }
            }
        }
    }

    class RGBiTrnsFlpXYImpl
    implements TrnsProcessor {
        RGBiTrnsFlpXYImpl() {
        }

        @Override
        public void processImage() {
            int ii = 0;
            int iii = 0;
            for (int i = 0; i < BGRiTrnsProcessors.this.Height; ++i) {
                for (int j = 0; j < BGRiTrnsProcessors.this.Width; ++j) {
                    iii = (BGRiTrnsProcessors.this.Width - 1 - j) * 3 + BGRiTrnsProcessors.this.Width * (BGRiTrnsProcessors.this.Height - 1 - i) * 3;
                    BGRiTrnsProcessors.this.DstB[ii + 2] = BGRiTrnsProcessors.this.SrcB[iii + 2];
                    BGRiTrnsProcessors.this.DstB[ii + 1] = BGRiTrnsProcessors.this.SrcB[iii + 1];
                    BGRiTrnsProcessors.this.DstB[ii + 0] = BGRiTrnsProcessors.this.SrcB[iii + 0];
                    ii += 3;
                }
            }
        }
    }

    class RGBiTrnsFlpXImpl
    implements TrnsProcessor {
        RGBiTrnsFlpXImpl() {
        }

        @Override
        public void processImage() {
            int ii = 0;
            int iii = 0;
            for (int i = 0; i < BGRiTrnsProcessors.this.Height; ++i) {
                for (int j = 0; j < BGRiTrnsProcessors.this.Width; ++j) {
                    iii = (BGRiTrnsProcessors.this.Width - 1 - j) * 3 + BGRiTrnsProcessors.this.Width * i * 3;
                    BGRiTrnsProcessors.this.DstB[ii + 2] = BGRiTrnsProcessors.this.SrcB[iii + 2];
                    BGRiTrnsProcessors.this.DstB[ii + 1] = BGRiTrnsProcessors.this.SrcB[iii + 1];
                    BGRiTrnsProcessors.this.DstB[ii + 0] = BGRiTrnsProcessors.this.SrcB[iii + 0];
                    ii += 3;
                }
            }
        }
    }

    class RGBiTrnsCpyImpl
    implements TrnsProcessor {
        RGBiTrnsCpyImpl() {
        }

        @Override
        public void processImage() {
            System.arraycopy(BGRiTrnsProcessors.this.SrcB, 0, BGRiTrnsProcessors.this.DstB, 0, BGRiTrnsProcessors.this.SrcB.length);
        }
    }
}

