/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.blendengine.imageprocessors.bgri;

import com.Fo2PiX.blendengine.imageprocessors.TrnsProcessor;
import com.Fo2PiX.blendengine.imageprocessors.TrnsProcessors;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;

public class BGRiTrnsStaticProcessors
implements TrnsProcessors {
    public static final int CHLS = 3;
    public static final int CHO_R = 2;
    public static final int CHO_G = 1;
    public static final int CHO_B = 0;
    private final RGBiTrnsCpyImpl TrnsCpy = new RGBiTrnsCpyImpl();
    private final RGBiTrnsInvImpl TrnsInv = new RGBiTrnsInvImpl();
    private final RGBiTrnsFlpXImpl TrnsFlpX = new RGBiTrnsFlpXImpl();
    private final RGBiTrnsFlpYImpl TrnsFlpY = new RGBiTrnsFlpYImpl();
    private final RGBiTrnsFlpXYImpl TrnsFlpXY = new RGBiTrnsFlpXYImpl();
    private final RGBiTrnsInvFlpXImpl TrnsInvFlpX = new RGBiTrnsInvFlpXImpl();
    private final RGBiTrnsInvFlpYImpl TrnsInvFlpY = new RGBiTrnsInvFlpYImpl();
    private final RGBiTrnsInvFlpXYImpl TrnsInvFlpXY = new RGBiTrnsInvFlpXYImpl();
    protected DataBufferByte SrcDB = null;
    protected DataBufferByte DstDB = null;

    @Override
    public void setTrgts(Rectangle Size, DataBuffer Src, DataBuffer Dst) {
        this.SrcDB = (DataBufferByte)Src;
        this.DstDB = (DataBufferByte)Dst;
        byte[] SrcB = this.SrcDB.getData(0);
        byte[] DstB = this.DstDB.getData(0);
        int Width = Size.width;
        int Height = Size.height;
        this.TrnsCpy.setTrgts(SrcB, DstB, Width, Height);
        this.TrnsInv.setTrgts(SrcB, DstB, Width, Height);
        this.TrnsFlpX.setTrgts(SrcB, DstB, Width, Height);
        this.TrnsFlpY.setTrgts(SrcB, DstB, Width, Height);
        this.TrnsInvFlpX.setTrgts(SrcB, DstB, Width, Height);
        this.TrnsInvFlpY.setTrgts(SrcB, DstB, Width, Height);
        this.TrnsInvFlpXY.setTrgts(SrcB, DstB, Width, Height);
    }

    @Override
    public TrnsProcessor getTrnsProcessor(int Trns) {
        switch (Trns) {
            case 1: {
                return this.TrnsInv;
            }
            case 2: {
                return this.TrnsFlpX;
            }
            case 3: {
                return this.TrnsInvFlpX;
            }
            case 4: {
                return this.TrnsFlpY;
            }
            case 5: {
                return this.TrnsInvFlpY;
            }
            case 6: {
                return this.TrnsFlpXY;
            }
            case 7: {
                return this.TrnsInvFlpXY;
            }
        }
        return this.TrnsCpy;
    }

    @Override
    public void process(int Trns) {
        switch (Trns) {
            case 1: {
                this.TrnsInv.processImage();
                break;
            }
            case 2: {
                this.TrnsFlpX.processImage();
                break;
            }
            case 3: {
                this.TrnsInvFlpX.processImage();
                break;
            }
            case 4: {
                this.TrnsFlpY.processImage();
                break;
            }
            case 5: {
                this.TrnsInvFlpY.processImage();
                break;
            }
            case 6: {
                this.TrnsFlpXY.processImage();
                break;
            }
            case 7: {
                this.TrnsInvFlpXY.processImage();
                break;
            }
            default: {
                this.TrnsCpy.processImage();
            }
        }
    }

    static class RGBiTrnsInvImpl
    implements TrnsProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        RGBiTrnsInvImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage() {
            for (int i = 0; i < this.SrcB.length; i += 3) {
                this.DstB[i + 2] = (byte)(255 - this.SrcB[i + 2]);
                this.DstB[i + 1] = (byte)(255 - this.SrcB[i + 1]);
                this.DstB[i + 0] = (byte)(255 - this.SrcB[i + 0]);
            }
        }
    }

    static class RGBiTrnsInvFlpYImpl
    implements TrnsProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        RGBiTrnsInvFlpYImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage() {
            int ii = 0;
            int iii = 0;
            for (int i = 0; i < this.Height; ++i) {
                for (int j = 0; j < this.Width; ++j) {
                    iii = j * 3 + this.Width * (this.Height - 1 - i) * 3;
                    this.DstB[ii + 2] = (byte)(255 - this.SrcB[iii + 2]);
                    this.DstB[ii + 1] = (byte)(255 - this.SrcB[iii + 1]);
                    this.DstB[ii + 0] = (byte)(255 - this.SrcB[iii + 0]);
                    ii += 3;
                }
            }
        }
    }

    static class RGBiTrnsInvFlpXYImpl
    implements TrnsProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        RGBiTrnsInvFlpXYImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage() {
            int ii = 0;
            int iii = 0;
            for (int i = 0; i < this.Height; ++i) {
                for (int j = 0; j < this.Width; ++j) {
                    iii = (this.Width - 1 - j) * 3 + this.Width * (this.Height - 1 - i) * 3;
                    this.DstB[ii + 2] = (byte)(255 - this.SrcB[iii + 2]);
                    this.DstB[ii + 1] = (byte)(255 - this.SrcB[iii + 1]);
                    this.DstB[ii + 0] = (byte)(255 - this.SrcB[iii + 0]);
                    ii += 3;
                }
            }
        }
    }

    static class RGBiTrnsInvFlpXImpl
    implements TrnsProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        RGBiTrnsInvFlpXImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage() {
            int ii = 0;
            int iii = 0;
            for (int i = 0; i < this.Height; ++i) {
                for (int j = 0; j < this.Width; ++j) {
                    iii = (this.Width - 1 - j) * 3 + this.Width * i * 3;
                    this.DstB[ii + 2] = (byte)(255 - this.SrcB[iii + 2]);
                    this.DstB[ii + 1] = (byte)(255 - this.SrcB[iii + 1]);
                    this.DstB[ii + 0] = (byte)(255 - this.SrcB[iii + 0]);
                    ii += 3;
                }
            }
        }
    }

    static class RGBiTrnsFlpYImpl
    implements TrnsProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        RGBiTrnsFlpYImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage() {
            int ii = 0;
            int iii = 0;
            for (int i = 0; i < this.Height; ++i) {
                for (int j = 0; j < this.Width; ++j) {
                    iii = j * 3 + this.Width * (this.Height - 1 - i) * 3;
                    this.DstB[ii + 2] = this.SrcB[iii + 2];
                    this.DstB[ii + 1] = this.SrcB[iii + 1];
                    this.DstB[ii + 0] = this.SrcB[iii + 0];
                    ii += 3;
                }
            }
        }
    }

    static class RGBiTrnsFlpXYImpl
    implements TrnsProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        RGBiTrnsFlpXYImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage() {
            int ii = 0;
            int iii = 0;
            for (int i = 0; i < this.Height; ++i) {
                for (int j = 0; j < this.Width; ++j) {
                    iii = (this.Width - 1 - j) * 3 + this.Width * (this.Height - 1 - i) * 3;
                    this.DstB[ii + 2] = this.SrcB[iii + 2];
                    this.DstB[ii + 1] = this.SrcB[iii + 1];
                    this.DstB[ii + 0] = this.SrcB[iii + 0];
                    ii += 3;
                }
            }
        }
    }

    static class RGBiTrnsFlpXImpl
    implements TrnsProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        RGBiTrnsFlpXImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage() {
            int ii = 0;
            int iii = 0;
            for (int i = 0; i < this.Height; ++i) {
                for (int j = 0; j < this.Width; ++j) {
                    iii = (this.Width - 1 - j) * 3 + this.Width * i * 3;
                    this.DstB[ii + 2] = this.SrcB[iii + 2];
                    this.DstB[ii + 1] = this.SrcB[iii + 1];
                    this.DstB[ii + 0] = this.SrcB[iii + 0];
                    ii += 3;
                }
            }
        }
    }

    static class RGBiTrnsCpyImpl
    implements TrnsProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        RGBiTrnsCpyImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage() {
            System.arraycopy(this.SrcB, 0, this.DstB, 0, this.SrcB.length);
        }
    }
}

