/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.blendengine.imageprocessors.m;

import com.Fo2PiX.blendengine.imageprocessors.BrtnsCtrstProcessor;
import com.Fo2PiX.blendengine.imageprocessors.BrtnsCtrstProcessors;
import com.Fo2PiX.blendengine.imageprocessors.ImageProcessorTables;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;

public class MBrtnsCtrstProcessors
implements BrtnsCtrstProcessors {
    private final BrtnsCtrstProcessor BrtnsCtrstCpy = new GBrtnsCtrstCpyImpl();
    private final BrtnsCtrstProcessor BrtnsCtrst0_50 = new GBrtnsCtrst0_50Impl();
    private final BrtnsCtrstProcessor BrtnsCtrst50_100 = new GBrtnsCtrst50_100Impl();
    private final BrtnsCtrstProcessor BrtnsCtrstThhld = new GBrtnsCtrstThhldImpl();
    protected DataBufferByte SrcDB = null;
    protected DataBufferByte DstDB = null;
    protected byte[] SrcB = null;
    protected byte[] DstB = null;

    @Override
    public void setTrgts(Rectangle Size, DataBuffer Src, DataBuffer Dst) {
        this.SrcDB = (DataBufferByte)Src;
        this.DstDB = (DataBufferByte)Dst;
        this.SrcB = this.SrcDB.getData(0);
        this.DstB = this.DstDB.getData(0);
    }

    @Override
    public BrtnsCtrstProcessor getBrtnsCtrstProcessor(int Val, double Brtns, double Ctrst) {
        if (Brtns == 1.0 && Ctrst == 50.0) {
            return this.BrtnsCtrstCpy;
        }
        if (Brtns > 1.85) {
            return this.BrtnsCtrstThhld;
        }
        if (Ctrst < 50.0) {
            return this.BrtnsCtrst0_50;
        }
        return this.BrtnsCtrst50_100;
    }

    @Override
    public void process(Rectangle Size, DataBuffer Src, DataBuffer Dst, double Brtns, double Ctrst) {
        if (Brtns == 1.0 && Ctrst == 50.0) {
            this.BrtnsCtrstCpy.processImage(Brtns, Ctrst);
        } else if (Brtns > 1.85) {
            this.BrtnsCtrstThhld.processImage(Brtns, Ctrst);
        } else if (Ctrst < 50.0) {
            this.BrtnsCtrst0_50.processImage(Brtns, Ctrst);
        } else {
            this.BrtnsCtrst50_100.processImage(Brtns, Ctrst);
        }
    }

    class GBrtnsCtrstThhldImpl
    implements BrtnsCtrstProcessor {
        GBrtnsCtrstThhldImpl() {
        }

        @Override
        public void processImage(double Brtns, double Ctrst) {
            int threshold = 255 - (int)(Ctrst / 100.0 * 255.0);
            for (int i = 0; i < MBrtnsCtrstProcessors.this.SrcB.length; ++i) {
                MBrtnsCtrstProcessors.this.DstB[i] = (MBrtnsCtrstProcessors.this.SrcB[i] & 0xFF) < threshold ? 0 : -1;
            }
        }
    }

    class GBrtnsCtrst50_100Impl
    implements BrtnsCtrstProcessor {
        GBrtnsCtrst50_100Impl() {
        }

        @Override
        public void processImage(double Brtns, double Ctrst) {
            int Gamma = ImageProcessorTables.Gamma50_100[(int)Ctrst];
            for (int i = 0; i < MBrtnsCtrstProcessors.this.SrcB.length; ++i) {
                MBrtnsCtrstProcessors.this.DstB[i] = (byte)(255.0 * Math.min(1.0, Brtns * ImageProcessorTables.Table50_100[Gamma][MBrtnsCtrstProcessors.this.SrcB[i] & 0xFF]));
            }
        }
    }

    class GBrtnsCtrst0_50Impl
    implements BrtnsCtrstProcessor {
        GBrtnsCtrst0_50Impl() {
        }

        @Override
        public void processImage(double Brtns, double Ctrst) {
            int Gamma = ImageProcessorTables.Gamma0_50[(int)Ctrst];
            for (int i = 0; i < MBrtnsCtrstProcessors.this.SrcB.length; ++i) {
                MBrtnsCtrstProcessors.this.DstB[i] = (byte)(255.0 * Math.min(1.0, Brtns * ImageProcessorTables.Table0_50[Gamma][MBrtnsCtrstProcessors.this.SrcB[i] & 0xFF]));
            }
        }
    }

    class GBrtnsCtrstCpyImpl
    implements BrtnsCtrstProcessor {
        GBrtnsCtrstCpyImpl() {
        }

        @Override
        public void processImage(double Brtns, double Ctrst) {
            System.arraycopy(MBrtnsCtrstProcessors.this.SrcB, 0, MBrtnsCtrstProcessors.this.DstB, 0, MBrtnsCtrstProcessors.this.SrcB.length);
        }
    }
}

