/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.blendengine.imageprocessors.m;

import com.Fo2PiX.blendengine.imageprocessors.BrtnsCtrstProcessor;
import com.Fo2PiX.blendengine.imageprocessors.BrtnsCtrstProcessors;
import com.Fo2PiX.blendengine.imageprocessors.ImageProcessorTables;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;

public class MBrtnsCtrstStaticProcessors
implements BrtnsCtrstProcessors {
    private final GBrtnsCtrstCpyImpl BrtnsCtrstCpy = new GBrtnsCtrstCpyImpl();
    private final GBrtnsCtrst0_50Impl BrtnsCtrst0_50 = new GBrtnsCtrst0_50Impl();
    private final GBrtnsCtrst50_100Impl BrtnsCtrst50_100 = new GBrtnsCtrst50_100Impl();
    private final GBrtnsCtrstThhldImpl BrtnsCtrstThhld = new GBrtnsCtrstThhldImpl();
    protected DataBufferByte SrcDB = null;
    protected DataBufferByte DstDB = null;

    @Override
    public void setTrgts(Rectangle Size, DataBuffer Src, DataBuffer Dst) {
        this.SrcDB = (DataBufferByte)Src;
        this.DstDB = (DataBufferByte)Dst;
        byte[] SrcB = this.SrcDB.getData(0);
        byte[] DstB = this.DstDB.getData(0);
        int Width = Size.width;
        int Height = Size.height;
        this.BrtnsCtrstCpy.setTrgts(SrcB, DstB, Width, Height);
        this.BrtnsCtrst0_50.setTrgts(SrcB, DstB, Width, Height);
        this.BrtnsCtrst50_100.setTrgts(SrcB, DstB, Width, Height);
        this.BrtnsCtrstThhld.setTrgts(SrcB, DstB, Width, Height);
    }

    @Override
    public BrtnsCtrstProcessor getBrtnsCtrstProcessor(int Val, double Brtns, double Ctrst) {
        if (Brtns == 1.0 && Ctrst == 50.0) {
            return this.BrtnsCtrstCpy;
        }
        if (Brtns > 1.85) {
            return this.BrtnsCtrstThhld;
        }
        if (Ctrst < 50.0) {
            return this.BrtnsCtrst0_50;
        }
        return this.BrtnsCtrst50_100;
    }

    @Override
    public void process(Rectangle Size, DataBuffer Src, DataBuffer Dst, double Brtns, double Ctrst) {
        if (Brtns == 1.0 && Ctrst == 50.0) {
            this.BrtnsCtrstCpy.processImage(Brtns, Ctrst);
        } else if (Brtns > 1.85) {
            this.BrtnsCtrstThhld.processImage(Brtns, Ctrst);
        } else if (Ctrst < 50.0) {
            this.BrtnsCtrst0_50.processImage(Brtns, Ctrst);
        } else {
            this.BrtnsCtrst50_100.processImage(Brtns, Ctrst);
        }
    }

    static class GBrtnsCtrstThhldImpl
    implements BrtnsCtrstProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        GBrtnsCtrstThhldImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage(double Brtns, double Ctrst) {
            int threshold = 255 - (int)(Ctrst / 100.0 * 255.0);
            for (int i = 0; i < this.SrcB.length; ++i) {
                this.DstB[i] = (this.SrcB[i] & 0xFF) < threshold ? 0 : -1;
            }
        }
    }

    static class GBrtnsCtrst50_100Impl
    implements BrtnsCtrstProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        GBrtnsCtrst50_100Impl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage(double Brtns, double Ctrst) {
            int Gamma = ImageProcessorTables.Gamma50_100[(int)Ctrst];
            for (int i = 0; i < this.SrcB.length; ++i) {
                this.DstB[i] = (byte)(255.0 * Math.min(1.0, Brtns * ImageProcessorTables.Table50_100[Gamma][this.SrcB[i] & 0xFF]));
            }
        }
    }

    static class GBrtnsCtrst0_50Impl
    implements BrtnsCtrstProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        GBrtnsCtrst0_50Impl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage(double Brtns, double Ctrst) {
            int Gamma = ImageProcessorTables.Gamma0_50[(int)Ctrst];
            for (int i = 0; i < this.SrcB.length; ++i) {
                this.DstB[i] = (byte)(255.0 * Math.min(1.0, Brtns * ImageProcessorTables.Table0_50[Gamma][this.SrcB[i] & 0xFF]));
            }
        }
    }

    static class GBrtnsCtrstCpyImpl
    implements BrtnsCtrstProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        GBrtnsCtrstCpyImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage(double Brtns, double Ctrst) {
            System.arraycopy(this.SrcB, 0, this.DstB, 0, this.SrcB.length);
        }
    }
}

