/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.blendengine.imageprocessors.m;

import com.Fo2PiX.blendengine.imageprocessors.TrnsProcessor;
import com.Fo2PiX.blendengine.imageprocessors.TrnsProcessors;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;

public class MTrnsProcessors
implements TrnsProcessors {
    private final TrnsProcessor TrnsCpy = new GTrnsCpyImpl();
    private final TrnsProcessor TrnsInv = new GTrnsInvImpl();
    private final TrnsProcessor TrnsFlpX = new GTrnsFlpXImpl();
    private final TrnsProcessor TrnsFlpY = new GTrnsFlpYImpl();
    private final TrnsProcessor TrnsFlpXY = new GTrnsFlpXYImpl();
    private final TrnsProcessor TrnsInvFlpX = new GTrnsInvFlpXImpl();
    private final TrnsProcessor TrnsInvFlpY = new GTrnsInvFlpYImpl();
    private final TrnsProcessor TrnsInvFlpXY = new GTrnsInvFlpXYImpl();
    protected DataBufferByte SrcDB = null;
    protected DataBufferByte DstDB = null;
    protected byte[] SrcB = null;
    protected byte[] DstB = null;
    protected int Width = 0;
    protected int Height = 0;

    @Override
    public void setTrgts(Rectangle Size, DataBuffer Src, DataBuffer Dst) {
        this.SrcDB = (DataBufferByte)Src;
        this.DstDB = (DataBufferByte)Dst;
        this.SrcB = this.SrcDB.getData(0);
        this.DstB = this.DstDB.getData(0);
        this.Width = Size.width;
        this.Height = Size.height;
    }

    @Override
    public TrnsProcessor getTrnsProcessor(int Trns) {
        switch (Trns) {
            case 1: {
                return this.TrnsInv;
            }
            case 2: {
                return this.TrnsFlpX;
            }
            case 3: {
                return this.TrnsInvFlpX;
            }
            case 4: {
                return this.TrnsFlpY;
            }
            case 5: {
                return this.TrnsInvFlpY;
            }
            case 6: {
                return this.TrnsFlpXY;
            }
            case 7: {
                return this.TrnsInvFlpXY;
            }
        }
        return this.TrnsCpy;
    }

    @Override
    public void process(int Trns) {
        switch (Trns) {
            case 1: {
                this.TrnsInv.processImage();
            }
            case 2: {
                this.TrnsFlpX.processImage();
            }
            case 3: {
                this.TrnsInvFlpX.processImage();
            }
            case 4: {
                this.TrnsFlpY.processImage();
            }
            case 5: {
                this.TrnsInvFlpY.processImage();
            }
            case 6: {
                this.TrnsFlpXY.processImage();
            }
            case 7: {
                this.TrnsInvFlpXY.processImage();
            }
        }
        this.TrnsCpy.processImage();
    }

    class GTrnsInvImpl
    implements TrnsProcessor {
        GTrnsInvImpl() {
        }

        public void processImage(Rectangle Size, byte[] Src, byte[] Dst) {
            for (int i = 0; i < Src.length; ++i) {
                Dst[i] = (byte)(255 - Src[i]);
            }
        }

        @Override
        public void processImage() {
            for (int i = 0; i < MTrnsProcessors.this.SrcB.length; ++i) {
                MTrnsProcessors.this.DstB[i] = (byte)(255 - MTrnsProcessors.this.SrcB[i]);
            }
        }
    }

    class GTrnsInvFlpYImpl
    implements TrnsProcessor {
        GTrnsInvFlpYImpl() {
        }

        @Override
        public void processImage() {
            int ii = 0;
            int iii = 0;
            for (int i = 0; i < MTrnsProcessors.this.Height; ++i) {
                for (int j = 0; j < MTrnsProcessors.this.Width; ++j) {
                    iii = j + MTrnsProcessors.this.Width * (MTrnsProcessors.this.Height - 1 - i);
                    MTrnsProcessors.this.DstB[ii] = (byte)(255 - MTrnsProcessors.this.SrcB[iii]);
                    ++ii;
                }
            }
        }
    }

    class GTrnsInvFlpXYImpl
    implements TrnsProcessor {
        GTrnsInvFlpXYImpl() {
        }

        public void processImage(Rectangle Size, byte[] Src, byte[] Dst) {
            int ii = 0;
            int iii = 0;
            int width = Size.width;
            int height = Size.height;
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    iii = width - 1 - j + width * (height - 1 - i);
                    Dst[ii] = (byte)(255 - Src[iii]);
                    ++ii;
                }
            }
        }

        @Override
        public void processImage() {
            int ii = 0;
            int iii = 0;
            for (int i = 0; i < MTrnsProcessors.this.Height; ++i) {
                for (int j = 0; j < MTrnsProcessors.this.Width; ++j) {
                    iii = MTrnsProcessors.this.Width - 1 - j + MTrnsProcessors.this.Width * (MTrnsProcessors.this.Height - 1 - i);
                    MTrnsProcessors.this.DstB[ii] = (byte)(255 - MTrnsProcessors.this.SrcB[iii]);
                    ++ii;
                }
            }
        }
    }

    class GTrnsInvFlpXImpl
    implements TrnsProcessor {
        GTrnsInvFlpXImpl() {
        }

        @Override
        public void processImage() {
            int ii = 0;
            int iii = 0;
            for (int i = 0; i < MTrnsProcessors.this.Height; ++i) {
                for (int j = 0; j < MTrnsProcessors.this.Width; ++j) {
                    iii = MTrnsProcessors.this.Width - 1 - j + MTrnsProcessors.this.Width * i;
                    MTrnsProcessors.this.DstB[ii] = (byte)(255 - MTrnsProcessors.this.SrcB[iii]);
                    ++ii;
                }
            }
        }
    }

    class GTrnsFlpYImpl
    implements TrnsProcessor {
        GTrnsFlpYImpl() {
        }

        @Override
        public void processImage() {
            int ii = 0;
            int iii = 0;
            for (int i = 0; i < MTrnsProcessors.this.Height; ++i) {
                for (int j = 0; j < MTrnsProcessors.this.Width; ++j) {
                    iii = j + MTrnsProcessors.this.Width * (MTrnsProcessors.this.Height - 1 - i);
                    MTrnsProcessors.this.DstB[ii] = MTrnsProcessors.this.SrcB[iii];
                    ++ii;
                }
            }
        }
    }

    class GTrnsFlpXYImpl
    implements TrnsProcessor {
        GTrnsFlpXYImpl() {
        }

        @Override
        public void processImage() {
            int ii = 0;
            int iii = 0;
            for (int i = 0; i < MTrnsProcessors.this.Height; ++i) {
                for (int j = 0; j < MTrnsProcessors.this.Width; ++j) {
                    iii = MTrnsProcessors.this.Width - 1 - j + MTrnsProcessors.this.Width * (MTrnsProcessors.this.Height - 1 - i);
                    MTrnsProcessors.this.DstB[ii] = MTrnsProcessors.this.SrcB[iii];
                    ++ii;
                }
            }
        }
    }

    class GTrnsFlpXImpl
    implements TrnsProcessor {
        GTrnsFlpXImpl() {
        }

        @Override
        public void processImage() {
            int ii = 0;
            int iii = 0;
            for (int i = 0; i < MTrnsProcessors.this.Height; ++i) {
                for (int j = 0; j < MTrnsProcessors.this.Width; ++j) {
                    iii = MTrnsProcessors.this.Width - 1 - j + MTrnsProcessors.this.Width * i;
                    MTrnsProcessors.this.DstB[ii] = MTrnsProcessors.this.SrcB[iii];
                    ++ii;
                }
            }
        }
    }

    class GTrnsCpyImpl
    implements TrnsProcessor {
        GTrnsCpyImpl() {
        }

        @Override
        public void processImage() {
            System.arraycopy(MTrnsProcessors.this.SrcB, 0, MTrnsProcessors.this.DstB, 0, MTrnsProcessors.this.SrcB.length);
        }
    }
}

