/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.blendengine.imageprocessors.m;

import com.Fo2PiX.blendengine.imageprocessors.TrnsProcessor;
import com.Fo2PiX.blendengine.imageprocessors.TrnsProcessors;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;

public class MTrnsStaticProcessors
implements TrnsProcessors {
    private final GTrnsCpyImpl TrnsCpy = new GTrnsCpyImpl();
    private final GTrnsInvImpl TrnsInv = new GTrnsInvImpl();
    private final GTrnsFlpXImpl TrnsFlpX = new GTrnsFlpXImpl();
    private final GTrnsFlpYImpl TrnsFlpY = new GTrnsFlpYImpl();
    private final GTrnsFlpXYImpl TrnsFlpXY = new GTrnsFlpXYImpl();
    private final GTrnsInvFlpXImpl TrnsInvFlpX = new GTrnsInvFlpXImpl();
    private final GTrnsInvFlpYImpl TrnsInvFlpY = new GTrnsInvFlpYImpl();
    private final GTrnsInvFlpXYImpl TrnsInvFlpXY = new GTrnsInvFlpXYImpl();
    protected DataBufferByte SrcDB = null;
    protected DataBufferByte DstDB = null;

    @Override
    public void setTrgts(Rectangle Size, DataBuffer Src, DataBuffer Dst) {
        this.SrcDB = (DataBufferByte)Src;
        this.DstDB = (DataBufferByte)Dst;
        byte[] SrcB = this.SrcDB.getData(0);
        byte[] DstB = this.DstDB.getData(0);
        int Width = Size.width;
        int Height = Size.height;
        this.TrnsCpy.setTrgts(SrcB, DstB, Width, Height);
        this.TrnsInv.setTrgts(SrcB, DstB, Width, Height);
        this.TrnsFlpX.setTrgts(SrcB, DstB, Width, Height);
        this.TrnsFlpY.setTrgts(SrcB, DstB, Width, Height);
        this.TrnsInvFlpX.setTrgts(SrcB, DstB, Width, Height);
        this.TrnsInvFlpY.setTrgts(SrcB, DstB, Width, Height);
        this.TrnsInvFlpXY.setTrgts(SrcB, DstB, Width, Height);
    }

    @Override
    public TrnsProcessor getTrnsProcessor(int Trns) {
        switch (Trns) {
            case 1: {
                return this.TrnsInv;
            }
            case 2: {
                return this.TrnsFlpX;
            }
            case 3: {
                return this.TrnsInvFlpX;
            }
            case 4: {
                return this.TrnsFlpY;
            }
            case 5: {
                return this.TrnsInvFlpY;
            }
            case 6: {
                return this.TrnsFlpXY;
            }
            case 7: {
                return this.TrnsInvFlpXY;
            }
        }
        return this.TrnsCpy;
    }

    @Override
    public void process(int Trns) {
        switch (Trns) {
            case 1: {
                this.TrnsInv.processImage();
            }
            case 2: {
                this.TrnsFlpX.processImage();
            }
            case 3: {
                this.TrnsInvFlpX.processImage();
            }
            case 4: {
                this.TrnsFlpY.processImage();
            }
            case 5: {
                this.TrnsInvFlpY.processImage();
            }
            case 6: {
                this.TrnsFlpXY.processImage();
            }
            case 7: {
                this.TrnsInvFlpXY.processImage();
            }
        }
        this.TrnsCpy.processImage();
    }

    static class GTrnsInvImpl
    implements TrnsProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        GTrnsInvImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        public void processImage(Rectangle Size, byte[] Src, byte[] Dst) {
            for (int i = 0; i < Src.length; ++i) {
                Dst[i] = (byte)(255 - Src[i]);
            }
        }

        @Override
        public void processImage() {
            for (int i = 0; i < this.SrcB.length; ++i) {
                this.DstB[i] = (byte)(255 - this.SrcB[i]);
            }
        }
    }

    static class GTrnsInvFlpYImpl
    implements TrnsProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        GTrnsInvFlpYImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage() {
            int ii = 0;
            int iii = 0;
            for (int i = 0; i < this.Height; ++i) {
                for (int j = 0; j < this.Width; ++j) {
                    iii = j + this.Width * (this.Height - 1 - i);
                    this.DstB[ii] = (byte)(255 - this.SrcB[iii]);
                    ++ii;
                }
            }
        }
    }

    static class GTrnsInvFlpXYImpl
    implements TrnsProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        GTrnsInvFlpXYImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        public void processImage(Rectangle Size, byte[] Src, byte[] Dst) {
            int ii = 0;
            int iii = 0;
            int width = Size.width;
            int height = Size.height;
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    iii = width - 1 - j + width * (height - 1 - i);
                    Dst[ii] = (byte)(255 - Src[iii]);
                    ++ii;
                }
            }
        }

        @Override
        public void processImage() {
            int ii = 0;
            int iii = 0;
            for (int i = 0; i < this.Height; ++i) {
                for (int j = 0; j < this.Width; ++j) {
                    iii = this.Width - 1 - j + this.Width * (this.Height - 1 - i);
                    this.DstB[ii] = (byte)(255 - this.SrcB[iii]);
                    ++ii;
                }
            }
        }
    }

    static class GTrnsInvFlpXImpl
    implements TrnsProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        GTrnsInvFlpXImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage() {
            int ii = 0;
            int iii = 0;
            for (int i = 0; i < this.Height; ++i) {
                for (int j = 0; j < this.Width; ++j) {
                    iii = this.Width - 1 - j + this.Width * i;
                    this.DstB[ii] = (byte)(255 - this.SrcB[iii]);
                    ++ii;
                }
            }
        }
    }

    static class GTrnsFlpYImpl
    implements TrnsProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        GTrnsFlpYImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage() {
            int ii = 0;
            int iii = 0;
            for (int i = 0; i < this.Height; ++i) {
                for (int j = 0; j < this.Width; ++j) {
                    iii = j + this.Width * (this.Height - 1 - i);
                    this.DstB[ii] = this.SrcB[iii];
                    ++ii;
                }
            }
        }
    }

    static class GTrnsFlpXYImpl
    implements TrnsProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        GTrnsFlpXYImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage() {
            int ii = 0;
            int iii = 0;
            for (int i = 0; i < this.Height; ++i) {
                for (int j = 0; j < this.Width; ++j) {
                    iii = this.Width - 1 - j + this.Width * (this.Height - 1 - i);
                    this.DstB[ii] = this.SrcB[iii];
                    ++ii;
                }
            }
        }
    }

    static class GTrnsFlpXImpl
    implements TrnsProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        GTrnsFlpXImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage() {
            int ii = 0;
            int iii = 0;
            for (int i = 0; i < this.Height; ++i) {
                for (int j = 0; j < this.Width; ++j) {
                    iii = this.Width - 1 - j + this.Width * i;
                    this.DstB[ii] = this.SrcB[iii];
                    ++ii;
                }
            }
        }
    }

    static class GTrnsCpyImpl
    implements TrnsProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        GTrnsCpyImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage() {
            System.arraycopy(this.SrcB, 0, this.DstB, 0, this.SrcB.length);
        }
    }
}

