/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.blendengine.operation;

import com.Fo2PiX.blendengine.operation.OpInfoScalableEdtSelArea;
import com.Fo2PiX.blendengine.tool.Brush;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OpInfoEdtSelAreaPnt
extends OpInfoScalableEdtSelArea<OpInfoEdtSelAreaPnt> {
    protected Brush Brush;
    public final int BrushMode;
    public final int SourceMode;
    public final ArrayList<Point> Points;
    public final ArrayList<Double> PresureLevels;
    public final ArrayList<Double> TiltAngles;

    protected OpInfoEdtSelAreaPnt(Dimension newBaseSize, double newStartPressure, double newStartTilt, int newBrshMode, int newSourceMode, Brush newBrush) {
        super(3, newBaseSize);
        this.Brush = newBrush;
        this.BrushMode = newBrshMode;
        this.SourceMode = newSourceMode;
        this.Points = new ArrayList();
        this.PresureLevels = new ArrayList();
        this.PresureLevels.add(newStartPressure);
        this.TiltAngles = new ArrayList();
        this.TiltAngles.add(newStartTilt);
    }

    public OpInfoEdtSelAreaPnt(Dimension newBaseSize, Point newStartPoint, double newStartPressure, double newStartTilt, int newBrshMode, int newSourceMode, Brush newBrush) {
        super(3, newBaseSize);
        this.Brush = newBrush;
        this.BrushMode = newBrshMode;
        this.SourceMode = newSourceMode;
        this.Points = new ArrayList();
        this.Points.add(new Point(newStartPoint));
        this.PresureLevels = new ArrayList();
        this.PresureLevels.add(newStartPressure);
        this.TiltAngles = new ArrayList();
        this.TiltAngles.add(newStartTilt);
    }

    public Brush getBrush() {
        return this.Brush;
    }

    public void scaleBrush(double newScalex, double newScaley) {
        this.Brush = this.Brush.getScaledInstance(newScalex, newScaley);
    }

    public void scaleBrush(Point2D.Double newScale) {
        this.Brush = this.Brush.getScaledInstance(newScale.getX(), newScale.getY());
    }

    @Override
    public OpInfoEdtSelAreaPnt scale(Point2D.Double newScale) {
        double sx = newScale.getX();
        double sy = newScale.getY();
        if (sx == 1.0 && sy == 1.0) {
            return this;
        }
        Dimension newBseSz = new Dimension((int)((double)this.BseSz.width * sx), (int)((double)this.BseSz.height * sy));
        OpInfoEdtSelAreaPnt newPntOp = new OpInfoEdtSelAreaPnt(newBseSz, this.PresureLevels.get(0), this.TiltAngles.get(0), this.BrushMode, this.SourceMode, this.Brush.getScaledInstance(sx, sy));
        for (Point newPoint : this.Points) {
            newPntOp.Points.add(new Point((int)((double)newPoint.x * sx), (int)((double)newPoint.y * sy)));
        }
        return newPntOp;
    }

    @Override
    public OpInfoEdtSelAreaPnt scale(Dimension newBseSz) {
        if (this.BseSz.equals(newBseSz)) {
            return this;
        }
        double sx = newBseSz.getWidth() / this.BseSz.getWidth();
        double sy = newBseSz.getHeight() / this.BseSz.getHeight();
        OpInfoEdtSelAreaPnt newPntOp = new OpInfoEdtSelAreaPnt(newBseSz, this.PresureLevels.get(0), this.TiltAngles.get(0), this.BrushMode, this.SourceMode, this.Brush.getScaledInstance(sx, sy));
        for (Point newPoint : this.Points) {
            newPntOp.Points.add(new Point((int)((double)newPoint.x * sx), (int)((double)newPoint.y * sy)));
        }
        return newPntOp;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OpInfoEdtSelAreaPnt) {
            OpInfoEdtSelAreaPnt d = (OpInfoEdtSelAreaPnt)obj;
            return this.Brush.equals(d.Brush) && this.SourceMode == d.SourceMode && this.Points.equals(d.Points);
        }
        return false;
    }

    @Override
    public void writeXML(Document newDoc, Element newParent, Dimension newSize) {
        if (newSize != null && newSize.equals(this.BseSz)) {
            this.scale(newSize).writeXML(newDoc, newParent, newSize);
        } else {
            Element RootSize = newDoc.createElement("Base");
            RootSize.appendChild(newDoc.createTextNode(String.valueOf(this.BseSz.width + "," + String.valueOf(this.BseSz.height))));
            newParent.appendChild(RootSize);
            Element BrushData = newDoc.createElement("Brush");
            this.Brush.writeXML(newDoc, BrushData);
            newParent.appendChild(BrushData);
            Element BrshType = newDoc.createElement("Type");
            if (this.BrushMode == 0) {
                BrshType.appendChild(newDoc.createTextNode("Standard"));
            } else {
                BrshType.appendChild(newDoc.createTextNode("Stutter"));
            }
            Element BrshMode = newDoc.createElement("Mode");
            newParent.appendChild(BrshType);
            if (this.SourceMode == 0) {
                BrshMode.appendChild(newDoc.createTextNode("add"));
            } else {
                BrshMode.appendChild(newDoc.createTextNode("remove"));
            }
            newParent.appendChild(BrshMode);
            Element Pnts = newDoc.createElement("Points");
            newParent.appendChild(Pnts);
            for (Point Point1 : this.Points) {
                Element Point2 = newDoc.createElement("Point");
                Point2.appendChild(newDoc.createTextNode(String.valueOf(Point1.x) + "," + String.valueOf(Point1.y)));
                Pnts.appendChild(Point2);
            }
        }
    }

    public void writeIncludeXML(Document newDoc, Element newParent, int newIdx, String newIncludeDocString, Document newIncludeDoc, Element newIncludeParent, Dimension newSize) {
        if (newSize != null && !newSize.equals(this.BseSz)) {
            this.scale(newSize).writeIncludeXML(newDoc, newParent, newIdx, newIncludeDocString, newIncludeDoc, newIncludeParent, newSize);
        } else {
            Element Include = newDoc.createElement("PaintInclude");
            Element Script = newDoc.createElement("Script");
            Script.appendChild(newDoc.createTextNode(newIncludeDocString));
            Element ScriptIdx = newDoc.createElement("PaintIncludeIndex");
            ScriptIdx.appendChild(newDoc.createTextNode(String.valueOf(newIdx)));
            Include.appendChild(Script);
            Include.appendChild(ScriptIdx);
            newParent.appendChild(Include);
            Element RootSize = newIncludeDoc.createElement("Base");
            RootSize.appendChild(newIncludeDoc.createTextNode(String.valueOf(this.BseSz.width + "," + String.valueOf(this.BseSz.height))));
            newIncludeParent.appendChild(RootSize);
            Element BrushData = newIncludeDoc.createElement("Brush");
            this.Brush.writeXML(newIncludeDoc, BrushData);
            newIncludeParent.appendChild(BrushData);
            Element BrshType = newIncludeDoc.createElement("Type");
            if (this.BrushMode == 0) {
                BrshType.appendChild(newIncludeDoc.createTextNode("Standard"));
            } else {
                BrshType.appendChild(newIncludeDoc.createTextNode("Stutter"));
            }
            Element BrshMode = newIncludeDoc.createElement("Mode");
            newIncludeParent.appendChild(BrshType);
            if (this.SourceMode == 0) {
                BrshMode.appendChild(newIncludeDoc.createTextNode("add"));
            } else {
                BrshMode.appendChild(newIncludeDoc.createTextNode("remove"));
            }
            newIncludeParent.appendChild(BrshMode);
            Element Pnts = newIncludeDoc.createElement("Points");
            newIncludeParent.appendChild(Pnts);
            for (Point Point1 : this.Points) {
                Element Point2 = newIncludeDoc.createElement("Point");
                Point2.appendChild(newIncludeDoc.createTextNode(String.valueOf(Point1.x) + "," + String.valueOf(Point1.y)));
                Pnts.appendChild(Point2);
            }
        }
    }

    public static void writeDefaultInteractionXML(Document newDoc, Element newParent, int newInteractionCount) {
        Element Interaction = newDoc.createElement("PaintInteraction");
        Element InteractionMessage = newDoc.createElement("Message");
        InteractionMessage.appendChild(newDoc.createTextNode("Interaction " + newInteractionCount + " (Paint)"));
        Interaction.appendChild(InteractionMessage);
        Element InteractionMessageWidth = newDoc.createElement("MessageWidth");
        InteractionMessageWidth.appendChild(newDoc.createTextNode("200"));
        Interaction.appendChild(InteractionMessageWidth);
        Element InteractionParameters = newDoc.createElement("BasicParameters");
        Interaction.appendChild(InteractionParameters);
        newParent.appendChild(Interaction);
    }
}

