/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.blendengine.script;

import com.Fo2PiX.blendengine.script.BlendScriptFolderInfo;
import com.Fo2PiX.blendengine.script.BlendScriptHeader;
import com.Fo2PiX.blendengine.script.filefilter.ScriptFilter;
import com.Fo2PiX.blendengine.script.scriptIO.XMLBlendScriptIO;
import com.arc.awt.event.ProgressListener;
import com.arc.io.util.Files;
import com.arc.xml.io.XMLIODecoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BlendScripts {
    public static final int INTERACTION_LAYOUT_STYLE_MINIMAL_ID = 0;
    public static final int INTERACTION_LAYOUT_STYLE_BASIC_ID = 1;
    public static final int INTERACTION_LAYOUT_STYLE_STANDARD_ID = 2;
    public static final String INTERACTION_LAYOUT_STYLE_MINIMAL = "Minimal";
    public static final String INTERACTION_LAYOUT_STYLE_BASIC = "Basic";
    public static final String INTERACTION_LAYOUT_STYLE_STANDARD = "Standard";
    public static final String WIZARD_SCRIPT = "Script";
    public static final String WIZARD_FOLDER = "Folder";
    public static final String WIZARD_FOLDERNAME = "Name";
    public static final String WIZARD_FOLDERDESCRIPTION = "Description";
    public static final HashMap<String, Integer> ScriptInteractionStyleMap = new HashMap();

    public static BlendScriptHeader findWizard(TreeNode newTreeNode, String newWizardName) {
        Enumeration<? extends TreeNode> e = newTreeNode.children();
        while (e.hasMoreElements()) {
            TreeNode n = e.nextElement();
            if (n.isLeaf() && ((DefaultMutableTreeNode)n).getUserObject() instanceof BlendScriptHeader) {
                BlendScriptHeader newHeader = (BlendScriptHeader)((DefaultMutableTreeNode)n).getUserObject();
                if (!newHeader.Name.equalsIgnoreCase(newWizardName)) continue;
                return newHeader;
            }
            BlendScriptHeader foundHeader = BlendScripts.findWizard(n, newWizardName);
            if (foundHeader == null) continue;
            return foundHeader;
        }
        return null;
    }

    protected static void sortFiles(File[] newTrgt) {
        for (int i = 0; i < newTrgt.length - 1; ++i) {
            for (int j = i + 1; j < newTrgt.length; ++j) {
                if (newTrgt[i].getName().compareTo(newTrgt[j].getName()) <= 0) continue;
                File t = newTrgt[i];
                newTrgt[i] = newTrgt[j];
                newTrgt[j] = t;
            }
        }
    }

    protected static void createScriptFolder(String newRoot, String newFolderPath, int defaultInteractionStyle, XMLIODecoder newDecoder, DefaultMutableTreeNode newParent, Element newTrgt, ProgressListener newProgressListener) throws IOException {
        Node Item;
        Node Name = newTrgt.getElementsByTagName(WIZARD_FOLDERNAME).item(0);
        if (Name != null && (Item = Name.getNextSibling()) != null) {
            String FolderName = Name.getFirstChild().getNodeValue();
            String Description = null;
            Node DescriptionNode = newTrgt.getElementsByTagName(WIZARD_FOLDERDESCRIPTION).item(0);
            if (DescriptionNode != null) {
                Description = DescriptionNode.getFirstChild().getNodeValue();
            }
            DefaultMutableTreeNode NewCat = new DefaultMutableTreeNode(new BlendScriptFolderInfo(FolderName, Description, true));
            newFolderPath = newFolderPath + FolderName + "/";
            do {
                if (Item.getNodeType() != 1) continue;
                if (Item.getLocalName().equalsIgnoreCase(WIZARD_FOLDER)) {
                    BlendScripts.createScriptFolder(newRoot, newFolderPath, defaultInteractionStyle, newDecoder, NewCat, (Element)Item, newProgressListener);
                    continue;
                }
                if (!Item.getLocalName().equalsIgnoreCase(WIZARD_SCRIPT)) continue;
                if (newProgressListener != null) {
                    newProgressListener.progressEvent("Reading " + Item.getFirstChild().getNodeValue().toLowerCase());
                }
                String newRelativeResource = newFolderPath + Item.getFirstChild().getNodeValue().replace('\\', '/');
                URL newResourceURL = BlendScripts.class.getClassLoader().getResource(newRoot + newRelativeResource);
                String newFullResource = newResourceURL.toString();
                URL newRootURL = new URL(newFullResource.substring(0, newFullResource.indexOf(newRelativeResource)));
                NewCat.add(new DefaultMutableTreeNode(XMLBlendScriptIO.readHeader(newResourceURL, newRootURL, defaultInteractionStyle, newDecoder)));
            } while ((Item = Item.getNextSibling()) != null);
            newParent.add(NewCat);
        }
    }

    protected static void createScriptFolder(URL newRoot, File newTrgt, int defaultInteractionStyle, XMLIODecoder newDecoder, DefaultMutableTreeNode newParent, boolean newSimpleSelectionType, HashMap<String, BlendScriptHeader> newWizardMap, ProgressListener newProgressListener) throws IOException {
        BlendScriptFolderInfo newFolderInfo = XMLBlendScriptIO.readFolderInfo(newTrgt, newDecoder);
        if (newFolderInfo.Visible) {
            DefaultMutableTreeNode NewCat;
            if (newSimpleSelectionType) {
                NewCat = newParent;
            } else {
                NewCat = new DefaultMutableTreeNode(newFolderInfo);
                newParent.add(NewCat);
            }
            File[] Contents = newTrgt.listFiles(new ScriptFilter(true));
            BlendScripts.sortFiles(Contents);
            for (File Content : Contents) {
                if (Content.isDirectory()) {
                    BlendScripts.createScriptFolder(newRoot, Content, defaultInteractionStyle, newDecoder, NewCat, newSimpleSelectionType, newWizardMap, newProgressListener);
                    continue;
                }
                if (newProgressListener != null) {
                    newProgressListener.progressEvent("Reading " + Content.getName().toLowerCase());
                }
                System.out.println("Reading " + Content.getName().toLowerCase());
                BlendScriptHeader newHeader = XMLBlendScriptIO.readHeader(Content.toURI().toURL(), newRoot, defaultInteractionStyle, newDecoder);
                NewCat.add(new DefaultMutableTreeNode(newHeader));
                newWizardMap.put(Content.getName(), newHeader);
            }
        }
    }

    protected static void createScratchScriptFolder(URL newRoot, File newTrgt, ZipFile newZip, int defaultInteractionStyle, XMLIODecoder newDecoder, DefaultMutableTreeNode newParent, boolean newSimpleSelectionType, HashMap<String, BlendScriptHeader> newWizardMap, ProgressListener newProgressListener) throws IOException {
        File newTrgtFolder;
        if (newProgressListener != null) {
            newProgressListener.progressEvent("Extracting " + newTrgt.getName().toLowerCase() + "...");
        }
        if (!(newTrgtFolder = Files.getFile((File)newTrgt)).isDirectory()) {
            newTrgtFolder.mkdir();
        }
        Enumeration<? extends ZipEntry> ZipEntries = newZip.entries();
        while (ZipEntries.hasMoreElements()) {
            int c;
            ZipEntry Entry2 = ZipEntries.nextElement();
            if (Entry2.isDirectory()) continue;
            byte[] EntryData = new byte[1000];
            InputStream EntryStream = newZip.getInputStream(Entry2);
            File EntryFile = new File(newTrgtFolder, Entry2.getName());
            FileOutputStream EntryFileStream = new FileOutputStream(EntryFile);
            while ((c = EntryStream.read(EntryData)) > -1) {
                EntryFileStream.write(EntryData, 0, c);
            }
            EntryStream.close();
            EntryFileStream.close();
        }
        BlendScriptFolderInfo newFolderInfo = XMLBlendScriptIO.readFolderInfo(newTrgtFolder, newDecoder);
        if (newFolderInfo.Visible) {
            DefaultMutableTreeNode NewCat;
            if (newSimpleSelectionType) {
                NewCat = newParent;
            } else {
                NewCat = new DefaultMutableTreeNode(newFolderInfo);
                newParent.add(NewCat);
            }
            File[] Contents = newTrgtFolder.listFiles(new ScriptFilter(true));
            BlendScripts.sortFiles(Contents);
            for (File Content : Contents) {
                if (Content.isDirectory()) continue;
                if (newProgressListener != null) {
                    newProgressListener.progressEvent("Reading " + newTrgt.getName().toLowerCase() + "...");
                }
                BlendScriptHeader newHeader = XMLBlendScriptIO.readHeader(Content.toURI().toURL(), newRoot, defaultInteractionStyle, newDecoder);
                NewCat.add(new DefaultMutableTreeNode(newHeader));
                newWizardMap.put(Content.getName(), newHeader);
            }
        }
    }

    public static void loadWizardTree(TreeNode newTreeNode, XMLIODecoder WizardDecoder, ArrayList<File> WizardRootList, HashMap<String, BlendScriptHeader> WizardNameMap, boolean ReadCache, File WizardCache, File WizardScratchRoot, int InteractionLayoutStyle, boolean SimpleStudio, ProgressListener newProgressListener) {
        DefaultMutableTreeNode WizardTree = (DefaultMutableTreeNode)newTreeNode;
        if (ReadCache && WizardCache != null && WizardCache.isFile()) {
            try {
                if (newProgressListener != null) {
                    newProgressListener.progressEvent("Reading Wizard Cache");
                }
                ObjectInputStream in = new ObjectInputStream(new FileInputStream(WizardCache));
                HashMap newWizardNameMap = (HashMap)in.readObject();
                WizardNameMap.putAll(newWizardNameMap);
                TreeNode newTree = (TreeNode)in.readObject();
                int ChildCount = newTree.getChildCount();
                for (int i = 0; i < ChildCount; ++i) {
                    WizardTree.add((DefaultMutableTreeNode)newTree.getChildAt(0));
                }
                in.close();
            }
            catch (Exception Ex) {
                System.out.println("Wizard Cache Corrupt");
                Ex.printStackTrace();
            }
        } else {
            for (File newWizardFolder : WizardRootList) {
                try {
                    File[] UnCompressedContents;
                    Files.deleteFolderContents((File)WizardScratchRoot);
                    URL newWizardRoot = newWizardFolder.toURI().toURL();
                    File newWizardScratchFolder = new File(WizardScratchRoot, newWizardFolder.getName());
                    URL newWizardScratchRoot = newWizardScratchFolder.toURI().toURL();
                    if (!newWizardScratchFolder.isDirectory()) {
                        newWizardScratchFolder.mkdir();
                    }
                    if ((UnCompressedContents = newWizardFolder.listFiles(new ScriptFilter(true))) != null && UnCompressedContents.length > 0) {
                        BlendScripts.sortFiles(UnCompressedContents);
                        for (File UnCompressedContent : UnCompressedContents) {
                            if (UnCompressedContent.isDirectory()) {
                                BlendScripts.createScriptFolder(newWizardRoot, UnCompressedContent, InteractionLayoutStyle, WizardDecoder, WizardTree, SimpleStudio, WizardNameMap, newProgressListener);
                                continue;
                            }
                            if (Files.getExtension((File)UnCompressedContent).equals("f2pz") || Files.getExtension((File)UnCompressedContent).equals("zip")) {
                                BlendScripts.createScratchScriptFolder(newWizardScratchRoot, Files.relocateFile((File)newWizardFolder, (File)newWizardScratchFolder, (File)UnCompressedContent), new ZipFile(UnCompressedContent), InteractionLayoutStyle, WizardDecoder, WizardTree, SimpleStudio, WizardNameMap, newProgressListener);
                                continue;
                            }
                            if (newProgressListener != null) {
                                newProgressListener.progressEvent("Reading " + UnCompressedContent.getName().toLowerCase());
                            }
                            BlendScriptHeader newHeader = XMLBlendScriptIO.readHeader(UnCompressedContent.toURI().toURL(), newWizardRoot, InteractionLayoutStyle, WizardDecoder);
                            WizardNameMap.put(UnCompressedContent.getName(), newHeader);
                            WizardTree.add(new DefaultMutableTreeNode(newHeader));
                        }
                    }
                    ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(WizardCache));
                    out.writeObject(WizardNameMap);
                    out.writeObject(WizardTree);
                    out.flush();
                    out.close();
                }
                catch (Exception Ex) {
                    Ex.printStackTrace();
                }
            }
        }
    }

    static {
        ScriptInteractionStyleMap.put(INTERACTION_LAYOUT_STYLE_MINIMAL, 0);
        ScriptInteractionStyleMap.put(INTERACTION_LAYOUT_STYLE_BASIC, 1);
        ScriptInteractionStyleMap.put(INTERACTION_LAYOUT_STYLE_STANDARD, 2);
    }
}

