/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.blendengine.tool;

import com.Fo2PiX.blendengine.tool.BrushImplRegular;
import com.Fo2PiX.blendengine.tool.BrushPoint;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class Brush
implements Serializable {
    private static final long serialVersionUID = 3162319424379863349L;
    public int CursorRectLeft;
    public int CursorRectRight;
    public int CursorRectTop;
    public int CursorRectBottom;
    public int CursorRectWidth;
    public int CursorRectHeight;
    public int BrushRectLeft;
    public int BrushRectRight;
    public int BrushRectTop;
    public int BrushRectBottom;
    public int BrushRectWidth;
    public int BrushRectHeight;
    public BrushPoint[] BrushPoints = null;
    public final BrushPoint[][][] CrossPoints = new BrushPoint[3][3][];

    public static Brush getBrush(Element newParent) {
        Node Width = newParent.getElementsByTagName("Width").item(0);
        Node Eccentricity = newParent.getElementsByTagName("Eccentricity").item(0);
        Node Softness = newParent.getElementsByTagName("Softness").item(0);
        Node Rotation = newParent.getElementsByTagName("Rotation").item(0);
        if (Width != null && Eccentricity != null && Softness != null && Rotation != null) {
            int WidthVal = Integer.parseInt(Width.getFirstChild().getNodeValue());
            int EccentricityVal = Integer.parseInt(Eccentricity.getFirstChild().getNodeValue());
            int SoftnessVal = Integer.parseInt(Softness.getFirstChild().getNodeValue());
            int RotationVal = Integer.parseInt(Rotation.getFirstChild().getNodeValue());
            return Brush.getBrush(WidthVal, EccentricityVal, SoftnessVal, RotationVal);
        }
        return null;
    }

    public static Brush getBrush(int newWidth, int newEccentricity, int newSoftness, int newRotation) {
        return new BrushImplRegular(newWidth, newEccentricity, newSoftness, newRotation);
    }

    public static Brush getDefaultBrush() {
        return Brush.getBrush(60, 30, 10, 45);
    }

    Brush() {
    }

    Rectangle getCombinedRectangle(Rectangle newRectangle1, Rectangle newRectangle2) {
        int left = Math.min(newRectangle1.x, newRectangle2.x);
        int top = Math.min(newRectangle1.y, newRectangle2.y);
        int right = Math.max(newRectangle1.x + newRectangle1.width, newRectangle2.x + newRectangle2.width);
        int bottom = Math.max(newRectangle1.y + newRectangle1.height, newRectangle2.x + newRectangle2.height);
        return new Rectangle(left, top, right - left, bottom - top);
    }

    public void getCombinedRectangle(Rectangle newRectangle1, Rectangle newRectangle2, Rectangle Dst) {
        int left = Math.min(newRectangle1.x, newRectangle2.x);
        int top = Math.min(newRectangle1.y, newRectangle2.y);
        int right = Math.max(newRectangle1.x + newRectangle1.width, newRectangle2.x + newRectangle2.width);
        int bottom = Math.max(newRectangle1.y + newRectangle1.height, newRectangle2.x + newRectangle2.height);
        Dst.setBounds(left, top, right - left, bottom - top);
    }

    Rectangle getBrushRect(Point newPoint) {
        return new Rectangle(newPoint.x + this.BrushRectLeft, newPoint.y + this.BrushRectTop, this.BrushRectWidth, this.BrushRectHeight);
    }

    Rectangle getBrushRect(int newx, int newy) {
        return new Rectangle(newx + this.BrushRectLeft, newy + this.BrushRectTop, this.BrushRectWidth, this.BrushRectHeight);
    }

    public void getBrushRect(int newx, int newy, Rectangle Dst) {
        Dst.setBounds(newx + this.BrushRectLeft, newy + this.BrushRectTop, this.BrushRectWidth, this.BrushRectHeight);
    }

    Rectangle getBrushDragRect(Point oldPoint, Point newPoint) {
        int left = Math.min(oldPoint.x, newPoint.x) + this.BrushRectLeft;
        int top = Math.min(oldPoint.y, newPoint.y) + this.BrushRectTop;
        int right = Math.max(oldPoint.x, newPoint.x) + this.BrushRectRight;
        int bottom = Math.max(oldPoint.y, newPoint.x) + this.BrushRectBottom;
        return new Rectangle(left, top, right - left + 1, bottom - top + 1);
    }

    Rectangle getBrushDragRect(int oldx, int oldy, int newx, int newy) {
        int left = Math.min(oldx, newx) + this.BrushRectLeft;
        int top = Math.min(oldy, newy) + this.BrushRectTop;
        int right = Math.max(oldx, newx) + this.BrushRectRight;
        int bottom = Math.max(oldy, newy) + this.BrushRectBottom;
        return new Rectangle(left, top, right - left + 1, bottom - top + 1);
    }

    public Rectangle getBrushDragRect(int oldx, int oldy, int newx, int newy, Rectangle Dst) {
        int left = Math.min(oldx, newx) + this.BrushRectLeft;
        int top = Math.min(oldy, newy) + this.BrushRectTop;
        int right = Math.max(oldx, newx) + this.BrushRectRight;
        int bottom = Math.max(oldy, newy) + this.BrushRectBottom;
        Dst.setBounds(left, top, right - left + 1, bottom - top + 1);
        return Dst;
    }

    public Rectangle getCursorRect(int newx, int newy) {
        return new Rectangle(newx + this.CursorRectLeft, newy + this.CursorRectTop, this.CursorRectWidth, this.CursorRectHeight);
    }

    public Rectangle getCursorRect(Point newPoint) {
        return new Rectangle(newPoint.x + this.CursorRectLeft, newPoint.y + this.CursorRectTop, this.CursorRectWidth, this.CursorRectHeight);
    }

    public Rectangle getCursorRect(int newx, int newy, double newScale) {
        int ScaledCursorRectLeft = (int)((double)this.CursorRectLeft * newScale + 0.5);
        int ScaledCursorRectTop = (int)((double)this.CursorRectTop * newScale + 0.5);
        int ScaledCursorRectWidth = (int)((double)this.CursorRectWidth * newScale + 0.5);
        int ScaledCursorRectHeight = (int)((double)this.CursorRectHeight * newScale + 0.5);
        return new Rectangle(newx + ScaledCursorRectLeft, newy + ScaledCursorRectTop, ScaledCursorRectWidth, ScaledCursorRectHeight);
    }

    public Rectangle getCursorRect(Point newPoint, double newScale) {
        int ScaledCursorRectLeft = (int)((double)this.CursorRectLeft * newScale + 0.5);
        int ScaledCursorRectTop = (int)((double)this.CursorRectTop * newScale + 0.5);
        int ScaledCursorRectWidth = (int)((double)this.CursorRectWidth * newScale + 0.5);
        int ScaledCursorRectHeight = (int)((double)this.CursorRectHeight * newScale + 0.5);
        return new Rectangle(newPoint.x + ScaledCursorRectLeft, newPoint.y + ScaledCursorRectTop, ScaledCursorRectWidth, ScaledCursorRectHeight);
    }

    public Rectangle getCursorDragRect(int oldx, int oldy, int newx, int newy) {
        int left = Math.min(oldx, newx) + this.CursorRectLeft;
        int top = Math.min(oldy, newy) + this.CursorRectTop;
        int right = Math.max(oldx, newx) + this.CursorRectRight;
        int bottom = Math.max(oldy, newy) + this.CursorRectBottom;
        return new Rectangle(left - 5, top - 5, right - left + 10, bottom - top + 10);
    }

    public Rectangle getCursorDragRect(Point oldPoint, Point newPoint) {
        int left = Math.min(oldPoint.x, newPoint.x) + this.CursorRectLeft;
        int top = Math.min(oldPoint.y, newPoint.y) + this.CursorRectTop;
        int right = Math.max(oldPoint.x, newPoint.x) + this.CursorRectRight;
        int bottom = Math.max(oldPoint.y, newPoint.y) + this.CursorRectBottom;
        return new Rectangle(left - 5, top - 5, right - left + 10, bottom - top + 10);
    }

    public Rectangle getCursorDragRect(int oldx, int oldy, int newx, int newy, double newScale) {
        int left = (int)((double)(Math.min(oldx, newx) + this.CursorRectLeft) * newScale + 0.5);
        int top = (int)((double)(Math.min(oldy, newy) + this.CursorRectTop) * newScale + 0.5);
        int right = (int)((double)(Math.max(oldx, newx) + this.CursorRectRight) * newScale + 0.5);
        int bottom = (int)((double)(Math.max(oldy, newy) + this.CursorRectBottom) * newScale + 0.5);
        return new Rectangle(left - 5, top - 5, right - left + 10, bottom - top + 10);
    }

    public Rectangle getCursorDragRect(int oldx, int oldy, int newx, int newy, double newTranslateX, double newTranslateY, double newScale) {
        int left = (int)((double)(Math.min(oldx, newx) + this.CursorRectLeft) * newScale + 0.5 + newTranslateX);
        int top = (int)((double)(Math.min(oldy, newy) + this.CursorRectTop) * newScale + 0.5 + newTranslateY);
        int right = (int)((double)(Math.max(oldx, newx) + this.CursorRectRight) * newScale + 0.5 + newTranslateX);
        int bottom = (int)((double)(Math.max(oldy, newy) + this.CursorRectBottom) * newScale + 0.5 + newTranslateY);
        return new Rectangle(left - 5, top - 5, right - left + 10, bottom - top + 10);
    }

    public Rectangle getCursorDragRect(Point oldPoint, Point newPoint, double newScale) {
        int left = Math.min(oldPoint.x, newPoint.x) + (int)((double)this.CursorRectLeft * newScale + 0.5);
        int top = Math.min(oldPoint.y, newPoint.y) + (int)((double)this.CursorRectTop * newScale + 0.5);
        int right = Math.max(oldPoint.x, newPoint.x) + (int)((double)this.CursorRectRight * newScale + 0.5);
        int bottom = Math.max(oldPoint.y, newPoint.y) + (int)((double)this.CursorRectBottom * newScale + 0.5);
        return new Rectangle(left - 5, top - 5, right - left + 10, bottom - top + 10);
    }

    public abstract void drawCursor(int var1, int var2, Graphics2D var3);

    public abstract void drawCursor(Point var1, Graphics2D var2);

    public abstract void drawCursor(int var1, int var2, Graphics2D var3, double var4);

    public abstract void drawCursor(Point var1, Graphics2D var2, double var3);

    public abstract Brush getScaledInstance(double var1, double var3);

    public abstract void writeXML(Document var1, Element var2);
}

