/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.blendengine.tool;

import com.Fo2PiX.blendengine.tool.Brush;
import com.Fo2PiX.blendengine.tool.BrushPoint;
import com.arc.awt.image.util.Images;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BrushImplRegular
extends Brush
implements Serializable {
    private static final long serialVersionUID = -7652900626695526499L;
    private static final String BRUSHIMPLREG = "RegularBrush";
    protected static final int BRUSH_APROX_THRESHOLD = 120;
    protected static final int BRUSHSIZE_MIN = 1;
    protected static final int BRUSHSIZE_MAX = 255;
    protected static final int BRUSHSHAPE_MIN = 1;
    protected static final int BRUSHSHAPE_MAX = 90;
    protected static final double BRUSHGAMMA_MIN = 1.0;
    protected static final double BRUSHGAMMA_MAX = 100.0;
    protected static final int BRUSHROTATION_MIN = 0;
    protected static final int BRUSHROTATION_MAX = 359;
    protected static final double EPSI = 0.04;
    protected final double dEccentricity;
    protected final double dRotation;
    public final int Width;
    public final int Eccentricity;
    public final int Softness;
    public final int Rotation;
    protected final int CursorDrawRectPos;
    protected final int CursorDrawRectSize;

    BrushImplRegular(int newWidth, int newEccentricity, int newSoftness, int newRotation) {
        this.Width = Math.min(Math.max(newWidth, 1), 255);
        this.Eccentricity = Math.min(Math.max(newEccentricity, 1), 90);
        this.Softness = Math.min(Math.max(newSoftness, 1), 100);
        this.Rotation = Math.min(Math.max(newRotation, 0), 359);
        int FullRotation = Math.min(Math.max(newRotation, 0), 359);
        this.dRotation = this.Eccentricity == 1 ? 0.0 : (FullRotation > 179 ? Math.toRadians(FullRotation - 180) : Math.toRadians(FullRotation));
        this.dEccentricity = (double)this.Eccentricity / 100.0;
        this.CursorDrawRectPos = this.Width / 2;
        this.CursorDrawRectSize = this.Width;
        double dSoftness = Math.pow(100.0, (double)(100 - this.Softness) / 100.0);
        double Accuracy = 0.02;
        double k = Math.pow(24.0, 1.0 / dSoftness);
        int Size = (int)(Math.ceil((double)this.Width * Math.pow((1.0 - Accuracy) / Accuracy, 1.0 / dSoftness)) / k);
        int x0 = Size / 2;
        int y0 = Size / 2;
        double X0 = (double)Size / 2.0;
        double Y0 = (double)Size / 2.0;
        double Alpha = (double)this.Width / 2.0;
        double Beta = Alpha * (1.0 - this.dEccentricity);
        BrushPoint[][] BrushLookup = new BrushPoint[Size][Size];
        BufferedImage Preview = Images.getImage((int)Size, (int)Size, (Color)Color.WHITE, (int)0);
        WritableRaster PreviewRaster = Preview.getRaster();
        DataBufferByte PreviewByteBuffer = (DataBufferByte)PreviewRaster.getDataBuffer();
        byte[] PreviewData = PreviewByteBuffer.getData(0);
        Graphics2D newGraphics = (Graphics2D)Preview.getGraphics();
        newGraphics.setColor(Color.white);
        newGraphics.fillRect(0, 0, Preview.getWidth(), Preview.getHeight());
        newGraphics.setColor(Color.black);
        newGraphics.translate(x0, y0);
        newGraphics.rotate(this.dRotation);
        newGraphics.scale(1.0, 1.0 - this.dEccentricity);
        newGraphics.drawOval(-this.CursorDrawRectPos, -this.CursorDrawRectPos, this.CursorDrawRectSize, this.CursorDrawRectSize);
        this.CursorRectLeft = 0;
        this.CursorRectRight = 0;
        this.CursorRectTop = 0;
        this.CursorRectBottom = 0;
        this.BrushRectLeft = 0;
        this.BrushRectRight = 0;
        this.BrushRectTop = 0;
        this.BrushRectBottom = 0;
        ArrayList<BrushPoint> Centre = new ArrayList<BrushPoint>();
        int t = y0;
        int r = x0;
        int b = y0;
        int l = x0;
        ArrayList<BrushPoint> T = new ArrayList<BrushPoint>();
        ArrayList<BrushPoint> B = new ArrayList<BrushPoint>();
        ArrayList<BrushPoint> L = new ArrayList<BrushPoint>();
        ArrayList<BrushPoint> R = new ArrayList<BrushPoint>();
        for (int Y = 0; Y < Size; ++Y) {
            for (int X = 0; X < Size; ++X) {
                double Xp = (((double)X - X0) * Math.cos(this.dRotation) + ((double)Y - Y0) * Math.sin(this.dRotation)) / Alpha;
                double Yp = (-((double)X - X0) * Math.sin(this.dRotation) + ((double)Y - Y0) * Math.cos(this.dRotation)) / Beta;
                double r1 = Math.sqrt(Xp * Xp + Yp * Yp);
                double rg = Math.pow(k * r1, dSoftness);
                double z = 1.0 / (1.0 + rg);
                int index = Y * Size + X;
                byte cvalue = PreviewData[index];
                int value = (int)(z * 256.0);
                if (value == 256) {
                    value = 255;
                }
                if (value <= 4) {
                    value = 0;
                }
                if (dSoftness == 1.0) {
                    value = value > 128 ? 255 : 0;
                }
                PreviewData[index] = (byte)(255 - value);
                if (cvalue == 0) {
                    this.CursorRectLeft = Math.min(this.CursorRectLeft, X);
                    this.CursorRectRight = Math.max(this.CursorRectRight, X);
                    this.CursorRectTop = Math.min(this.CursorRectTop, Y);
                    this.CursorRectBottom = Math.max(this.CursorRectBottom, Y);
                }
                if (value > 0) {
                    BrushPoint BlendPoint;
                    this.BrushRectLeft = Math.min(this.BrushRectLeft, X);
                    this.BrushRectRight = Math.max(this.BrushRectRight, X);
                    this.BrushRectTop = Math.min(this.BrushRectTop, Y);
                    this.BrushRectBottom = Math.max(this.BrushRectBottom, Y);
                    int offsetx = X - x0;
                    int offsety = Y - y0;
                    BrushLookup[X][Y] = BlendPoint = new BrushPoint(offsetx, offsety, value);
                    Centre.add(BlendPoint);
                    if (Y < t) {
                        t = Y;
                        T.clear();
                        T.add(BlendPoint);
                    } else if (Y == t) {
                        T.add(BlendPoint);
                    }
                    if (X < l) {
                        l = X;
                        L.clear();
                        L.add(BlendPoint);
                    } else if (X == l) {
                        L.add(BlendPoint);
                    }
                    if (Y > b) {
                        b = Y;
                        B.clear();
                        B.add(BlendPoint);
                    } else if (Y == b) {
                        B.add(BlendPoint);
                    }
                    if (X > r) {
                        r = X;
                        R.clear();
                        R.add(BlendPoint);
                        continue;
                    }
                    if (X != r) continue;
                    R.add(BlendPoint);
                    continue;
                }
                BrushLookup[X][Y] = null;
            }
        }
        ArrayList<BrushPoint> CCentre = new ArrayList<BrushPoint>();
        ArrayList<BrushPoint> CUp = new ArrayList<BrushPoint>();
        ArrayList<BrushPoint> CUpRight = new ArrayList<BrushPoint>();
        ArrayList<BrushPoint> CRight = new ArrayList<BrushPoint>();
        ArrayList<BrushPoint> CDownRight = new ArrayList<BrushPoint>();
        ArrayList<BrushPoint> CDown = new ArrayList<BrushPoint>();
        ArrayList<BrushPoint> CDownLeft = new ArrayList<BrushPoint>();
        ArrayList<BrushPoint> CLeft = new ArrayList<BrushPoint>();
        ArrayList<BrushPoint> CUpLeft = new ArrayList<BrushPoint>();
        this.BrushPoints = new BrushPoint[Centre.size()];
        Centre.toArray(this.BrushPoints);
        if (this.Width <= 120) {
            this.CrossPoints[1][1] = this.BrushPoints;
            this.CrossPoints[1][0] = this.BrushPoints;
            this.CrossPoints[2][0] = this.BrushPoints;
            this.CrossPoints[2][1] = this.BrushPoints;
            this.CrossPoints[2][2] = this.BrushPoints;
            this.CrossPoints[1][2] = this.BrushPoints;
            this.CrossPoints[0][2] = this.BrushPoints;
            this.CrossPoints[0][1] = this.BrushPoints;
            this.CrossPoints[0][0] = this.BrushPoints;
        } else {
            BrushPoint TopPoint = (BrushPoint)T.get(T.size() / 2);
            BrushPoint BottomPoint = (BrushPoint)B.get(B.size() / 2);
            BrushPoint LeftPoint = (BrushPoint)L.get(L.size() / 2);
            BrushPoint RightPoint = (BrushPoint)R.get(R.size() / 2);
            this.getEdge(x0 + TopPoint.x, y0 + TopPoint.y, x0, y0, x0, y0, BrushLookup, T);
            this.getEdge(x0 + BottomPoint.x, y0 + BottomPoint.y, x0, y0, x0, y0, BrushLookup, B);
            this.getEdge(x0 + LeftPoint.x, y0 + LeftPoint.y, x0, y0, x0, y0, BrushLookup, L);
            this.getEdge(x0 + RightPoint.x, y0 + RightPoint.y, x0, y0, x0, y0, BrushLookup, R);
            AffineTransform Trans = AffineTransform.getTranslateInstance(-x0, y0);
            Trans.scale(1.0, 1.0 - this.dEccentricity);
            Trans.translate(x0, -y0);
            AffineTransform Trans1 = AffineTransform.getRotateInstance(this.dRotation, x0, y0);
            Point2D.Double Top = new Point2D.Double(x0, 0.0);
            Trans.transform(Top, Top);
            Trans1.transform(Top, Top);
            Point2D.Double TopRight = new Point2D.Double(Size - 1, 0.0);
            Trans.transform(TopRight, TopRight);
            Trans1.transform(TopRight, TopRight);
            Point2D.Double Right = new Point2D.Double(Size - 1, y0);
            Trans.transform(Right, Right);
            Trans1.transform(Right, Right);
            Point2D.Double BottomRight = new Point2D.Double(Size - 1, Size - 1);
            Trans.transform(BottomRight, BottomRight);
            Trans1.transform(BottomRight, BottomRight);
            Point2D.Double Bottom = new Point2D.Double(x0, Size - 1);
            Trans.transform(Bottom, Bottom);
            Trans1.transform(Bottom, Bottom);
            Point2D.Double BottomLeft = new Point2D.Double(0.0, Size - 1);
            Trans.transform(BottomLeft, BottomLeft);
            Trans1.transform(BottomLeft, BottomLeft);
            Point2D.Double Left = new Point2D.Double(0.0, y0);
            Trans.transform(Left, Left);
            Trans1.transform(Left, Left);
            Point2D.Double TopLeft = new Point2D.Double(0.0, 0.0);
            Trans.transform(TopLeft, TopLeft);
            Trans1.transform(TopLeft, TopLeft);
            ArrayList<BrushPoint> TopList = new ArrayList<BrushPoint>();
            ArrayList<BrushPoint> TopRightList = new ArrayList<BrushPoint>();
            ArrayList<BrushPoint> RightList = new ArrayList<BrushPoint>();
            ArrayList<BrushPoint> BottomRightList = new ArrayList<BrushPoint>();
            ArrayList<BrushPoint> BottomList = new ArrayList<BrushPoint>();
            ArrayList<BrushPoint> BottomLeftList = new ArrayList<BrushPoint>();
            ArrayList<BrushPoint> LeftList = new ArrayList<BrushPoint>();
            ArrayList<BrushPoint> TopLeftList = new ArrayList<BrushPoint>();
            this.getEdge((int)(Top.x + 0.5), (int)(Top.y + 0.5), x0, y0, x0, y0, BrushLookup, TopList);
            this.getEdge((int)(TopRight.x + 0.5), (int)(TopRight.y + 0.5), x0, y0, x0, y0, BrushLookup, TopRightList);
            this.getEdge((int)(Right.x + 0.5), (int)(Right.y + 0.5), x0, y0, x0, y0, BrushLookup, RightList);
            this.getEdge((int)(BottomRight.x + 0.5), (int)(BottomRight.y + 0.5), x0, y0, x0, y0, BrushLookup, BottomRightList);
            this.getEdge((int)(Bottom.x + 0.5), (int)(Bottom.y + 0.5), x0, y0, x0, y0, BrushLookup, BottomList);
            this.getEdge((int)(BottomLeft.x + 0.5), (int)(BottomLeft.y + 0.5), x0, y0, x0, y0, BrushLookup, BottomLeftList);
            this.getEdge((int)(Left.x + 0.5), (int)(Left.y + 0.5), x0, y0, x0, y0, BrushLookup, LeftList);
            this.getEdge((int)(TopLeft.x + 0.5), (int)(TopLeft.y + 0.5), x0, y0, x0, y0, BrushLookup, TopLeftList);
            for (BrushPoint Index : T) {
                if (!CCentre.contains(BrushLookup[Index.x][Index.y])) {
                    CCentre.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUp.contains(BrushLookup[Index.x][Index.y])) {
                    CUp.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CRight.contains(BrushLookup[Index.x][Index.y])) {
                    CRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUpRight.contains(BrushLookup[Index.x][Index.y])) {
                    CUpRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUpRight.contains(BrushLookup[Index.x][Index.y + 1])) {
                    CUpRight.add(BrushLookup[Index.x][Index.y + 1]);
                }
                if (!CDownRight.contains(BrushLookup[Index.x][Index.y])) {
                    CDownRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CDownRight.contains(BrushLookup[Index.x - 1][Index.y])) {
                    CDownRight.add(BrushLookup[Index.x - 1][Index.y]);
                }
                if (!CDownLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CDownLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CDownLeft.contains(BrushLookup[Index.x + 1][Index.y])) {
                    CDownLeft.add(BrushLookup[Index.x + 1][Index.y]);
                }
                if (!CUpLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CUpLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (CUpLeft.contains(BrushLookup[Index.x][Index.y + 1])) continue;
                CUpLeft.add(BrushLookup[Index.x][Index.y + 1]);
            }
            for (BrushPoint Index : R) {
                if (!CCentre.contains(BrushLookup[Index.x][Index.y])) {
                    CCentre.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUp.contains(BrushLookup[Index.x][Index.y])) {
                    CUp.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CRight.contains(BrushLookup[Index.x][Index.y])) {
                    CRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CDown.contains(BrushLookup[Index.x][Index.y])) {
                    CDown.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUpRight.contains(BrushLookup[Index.x][Index.y])) {
                    CUpRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUpRight.contains(BrushLookup[Index.x - 1][Index.y])) {
                    CUpRight.add(BrushLookup[Index.x - 1][Index.y]);
                }
                if (!CDownRight.contains(BrushLookup[Index.x][Index.y])) {
                    CDownRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CDownRight.contains(BrushLookup[Index.x - 1][Index.y])) {
                    CDownRight.add(BrushLookup[Index.x - 1][Index.y]);
                }
                if (!CDownLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CDownLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CDownLeft.contains(BrushLookup[Index.x][Index.y - 1])) {
                    CDownLeft.add(BrushLookup[Index.x][Index.y - 1]);
                }
                if (!CUpLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CUpLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (CUpLeft.contains(BrushLookup[Index.x][Index.y + 1])) continue;
                CUpLeft.add(BrushLookup[Index.x][Index.y + 1]);
            }
            for (BrushPoint Index : B) {
                if (!CCentre.contains(BrushLookup[Index.x][Index.y])) {
                    CCentre.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CRight.contains(BrushLookup[Index.x][Index.y])) {
                    CRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CDown.contains(BrushLookup[Index.x][Index.y])) {
                    CDown.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUpRight.contains(BrushLookup[Index.x][Index.y])) {
                    CUpRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUpRight.contains(BrushLookup[Index.x - 1][Index.y])) {
                    CUpRight.add(BrushLookup[Index.x - 1][Index.y]);
                }
                if (!CDownRight.contains(BrushLookup[Index.x][Index.y])) {
                    CDownRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUpRight.contains(BrushLookup[Index.x][Index.y - 1])) {
                    CDownRight.add(BrushLookup[Index.x][Index.y - 1]);
                }
                if (!CDownLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CDownLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CDownLeft.contains(BrushLookup[Index.x][Index.y - 1])) {
                    CDownLeft.add(BrushLookup[Index.x][Index.y - 1]);
                }
                if (!CUpLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CUpLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (CUpLeft.contains(BrushLookup[Index.x + 1][Index.y])) continue;
                CUpLeft.add(BrushLookup[Index.x + 1][Index.y]);
            }
            for (BrushPoint Index : L) {
                if (!CCentre.contains(BrushLookup[Index.x][Index.y])) {
                    CCentre.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUp.contains(BrushLookup[Index.x][Index.y])) {
                    CUp.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CDown.contains(BrushLookup[Index.x][Index.y])) {
                    CDown.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUpRight.contains(BrushLookup[Index.x][Index.y])) {
                    CUpRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUpRight.contains(BrushLookup[Index.x][Index.y + 1])) {
                    CUpRight.add(BrushLookup[Index.x][Index.y + 1]);
                }
                if (!CDownRight.contains(BrushLookup[Index.x][Index.y])) {
                    CDownRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUpRight.contains(BrushLookup[Index.x][Index.y - 1])) {
                    CDownRight.add(BrushLookup[Index.x][Index.y - 1]);
                }
                if (!CDownLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CDownLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CDownLeft.contains(BrushLookup[Index.x + 1][Index.y])) {
                    CDownLeft.add(BrushLookup[Index.x + 1][Index.y]);
                }
                if (!CUpLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CUpLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (CUpLeft.contains(BrushLookup[Index.x + 1][Index.y])) continue;
                CUpLeft.add(BrushLookup[Index.x + 1][Index.y]);
            }
            for (BrushPoint Index : TopList) {
                if (!CCentre.contains(BrushLookup[Index.x][Index.y])) {
                    CCentre.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUp.contains(BrushLookup[Index.x][Index.y])) {
                    CUp.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CRight.contains(BrushLookup[Index.x][Index.y])) {
                    CRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CDown.contains(BrushLookup[Index.x][Index.y])) {
                    CDown.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUpRight.contains(BrushLookup[Index.x][Index.y])) {
                    CUpRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x][Index.y + 1] != null && !CUpRight.contains(BrushLookup[Index.x][Index.y + 1])) {
                    CUpRight.add(BrushLookup[Index.x][Index.y + 1]);
                }
                if (!CDownRight.contains(BrushLookup[Index.x][Index.y])) {
                    CDownRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x - 1][Index.y] != null && !CDownRight.contains(BrushLookup[Index.x - 1][Index.y])) {
                    CDownRight.add(BrushLookup[Index.x - 1][Index.y]);
                }
                if (!CDownLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CDownLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x + 1][Index.y] != null && !CDownLeft.contains(BrushLookup[Index.x + 1][Index.y])) {
                    CDownLeft.add(BrushLookup[Index.x + 1][Index.y]);
                }
                if (!CUpLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CUpLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x][Index.y + 1] == null || CUpLeft.contains(BrushLookup[Index.x][Index.y + 1])) continue;
                CUpLeft.add(BrushLookup[Index.x][Index.y + 1]);
            }
            for (BrushPoint Index : TopRightList) {
                if (!CCentre.contains(BrushLookup[Index.x][Index.y])) {
                    CCentre.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUp.contains(BrushLookup[Index.x][Index.y])) {
                    CUp.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CRight.contains(BrushLookup[Index.x][Index.y])) {
                    CRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CDown.contains(BrushLookup[Index.x][Index.y])) {
                    CDown.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUpRight.contains(BrushLookup[Index.x][Index.y])) {
                    CUpRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x][Index.y + 1] != null && !CUpRight.contains(BrushLookup[Index.x][Index.y + 1])) {
                    CUpRight.add(BrushLookup[Index.x][Index.y + 1]);
                }
                if (!CDownRight.contains(BrushLookup[Index.x][Index.y])) {
                    CDownRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x - 1][Index.y] != null && !CDownRight.contains(BrushLookup[Index.x - 1][Index.y])) {
                    CDownRight.add(BrushLookup[Index.x - 1][Index.y]);
                }
                if (!CDownLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CDownLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x + 1][Index.y] != null && !CDownLeft.contains(BrushLookup[Index.x + 1][Index.y])) {
                    CDownLeft.add(BrushLookup[Index.x + 1][Index.y]);
                }
                if (!CUpLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CUpLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x][Index.y + 1] == null || CUpLeft.contains(BrushLookup[Index.x][Index.y + 1])) continue;
                CUpLeft.add(BrushLookup[Index.x][Index.y + 1]);
            }
            for (BrushPoint Index : RightList) {
                if (!CCentre.contains(BrushLookup[Index.x][Index.y])) {
                    CCentre.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUp.contains(BrushLookup[Index.x][Index.y])) {
                    CUp.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CRight.contains(BrushLookup[Index.x][Index.y])) {
                    CRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CDown.contains(BrushLookup[Index.x][Index.y])) {
                    CDown.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUpRight.contains(BrushLookup[Index.x][Index.y])) {
                    CUpRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x - 1][Index.y] != null && !CUpRight.contains(BrushLookup[Index.x - 1][Index.y])) {
                    CUpRight.add(BrushLookup[Index.x - 1][Index.y]);
                }
                if (!CDownRight.contains(BrushLookup[Index.x][Index.y])) {
                    CDownRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x - 1][Index.y] != null && !CDownRight.contains(BrushLookup[Index.x - 1][Index.y])) {
                    CDownRight.add(BrushLookup[Index.x - 1][Index.y]);
                }
                if (!CDownLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CDownLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x][Index.y - 1] != null && !CDownLeft.contains(BrushLookup[Index.x][Index.y - 1])) {
                    CDownLeft.add(BrushLookup[Index.x][Index.y - 1]);
                }
                if (!CUpLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CUpLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x][Index.y + 1] == null || CUpLeft.contains(BrushLookup[Index.x][Index.y + 1])) continue;
                CUpLeft.add(BrushLookup[Index.x][Index.y + 1]);
            }
            for (BrushPoint Index : BottomRightList) {
                if (!CCentre.contains(BrushLookup[Index.x][Index.y])) {
                    CCentre.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUp.contains(BrushLookup[Index.x][Index.y])) {
                    CUp.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CRight.contains(BrushLookup[Index.x][Index.y])) {
                    CRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CDown.contains(BrushLookup[Index.x][Index.y])) {
                    CDown.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUpRight.contains(BrushLookup[Index.x][Index.y])) {
                    CUpRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x - 1][Index.y] != null && !CUpRight.contains(BrushLookup[Index.x - 1][Index.y])) {
                    CUpRight.add(BrushLookup[Index.x - 1][Index.y]);
                }
                if (!CDownRight.contains(BrushLookup[Index.x][Index.y])) {
                    CDownRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x - 1][Index.y] != null && !CDownRight.contains(BrushLookup[Index.x - 1][Index.y])) {
                    CDownRight.add(BrushLookup[Index.x - 1][Index.y]);
                }
                if (!CDownLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CDownLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x][Index.y - 1] != null && !CDownLeft.contains(BrushLookup[Index.x][Index.y - 1])) {
                    CDownLeft.add(BrushLookup[Index.x][Index.y - 1]);
                }
                if (!CUpLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CUpLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x][Index.y + 1] == null || CUpLeft.contains(BrushLookup[Index.x][Index.y + 1])) continue;
                CUpLeft.add(BrushLookup[Index.x][Index.y + 1]);
            }
            for (BrushPoint Index : BottomList) {
                if (!CCentre.contains(BrushLookup[Index.x][Index.y])) {
                    CCentre.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUp.contains(BrushLookup[Index.x][Index.y])) {
                    CUp.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CRight.contains(BrushLookup[Index.x][Index.y])) {
                    CRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CDown.contains(BrushLookup[Index.x][Index.y])) {
                    CDown.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUpRight.contains(BrushLookup[Index.x][Index.y])) {
                    CUpRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x - 1][Index.y] != null && !CUpRight.contains(BrushLookup[Index.x - 1][Index.y])) {
                    CUpRight.add(BrushLookup[Index.x - 1][Index.y]);
                }
                if (!CDownRight.contains(BrushLookup[Index.x][Index.y])) {
                    CDownRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x][Index.y - 1] != null && !CUpRight.contains(BrushLookup[Index.x][Index.y - 1])) {
                    CDownRight.add(BrushLookup[Index.x][Index.y - 1]);
                }
                if (!CDownLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CDownLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x][Index.y - 1] != null && !CDownLeft.contains(BrushLookup[Index.x][Index.y - 1])) {
                    CDownLeft.add(BrushLookup[Index.x][Index.y - 1]);
                }
                if (!CUpLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CUpLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x + 1][Index.y] == null || CUpLeft.contains(BrushLookup[Index.x + 1][Index.y])) continue;
                CUpLeft.add(BrushLookup[Index.x + 1][Index.y]);
            }
            for (BrushPoint Index : BottomLeftList) {
                if (!CCentre.contains(BrushLookup[Index.x][Index.y])) {
                    CCentre.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUp.contains(BrushLookup[Index.x][Index.y])) {
                    CUp.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CRight.contains(BrushLookup[Index.x][Index.y])) {
                    CRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CDown.contains(BrushLookup[Index.x][Index.y])) {
                    CDown.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUpRight.contains(BrushLookup[Index.x][Index.y])) {
                    CUpRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x - 1][Index.y] != null && !CUpRight.contains(BrushLookup[Index.x - 1][Index.y])) {
                    CUpRight.add(BrushLookup[Index.x - 1][Index.y]);
                }
                if (!CDownRight.contains(BrushLookup[Index.x][Index.y])) {
                    CDownRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x][Index.y - 1] != null && !CUpRight.contains(BrushLookup[Index.x][Index.y - 1])) {
                    CDownRight.add(BrushLookup[Index.x][Index.y - 1]);
                }
                if (!CDownLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CDownLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x][Index.y - 1] != null && !CDownLeft.contains(BrushLookup[Index.x][Index.y - 1])) {
                    CDownLeft.add(BrushLookup[Index.x][Index.y - 1]);
                }
                if (!CUpLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CUpLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x + 1][Index.y] == null || CUpLeft.contains(BrushLookup[Index.x + 1][Index.y])) continue;
                CUpLeft.add(BrushLookup[Index.x + 1][Index.y]);
            }
            for (BrushPoint Index : LeftList) {
                if (!CCentre.contains(BrushLookup[Index.x][Index.y])) {
                    CCentre.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUp.contains(BrushLookup[Index.x][Index.y])) {
                    CUp.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CRight.contains(BrushLookup[Index.x][Index.y])) {
                    CRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CDown.contains(BrushLookup[Index.x][Index.y])) {
                    CDown.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUpRight.contains(BrushLookup[Index.x][Index.y])) {
                    CUpRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x][Index.y + 1] != null && !CUpRight.contains(BrushLookup[Index.x][Index.y + 1])) {
                    CUpRight.add(BrushLookup[Index.x][Index.y + 1]);
                }
                if (!CDownRight.contains(BrushLookup[Index.x][Index.y])) {
                    CDownRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x][Index.y - 1] != null && !CUpRight.contains(BrushLookup[Index.x][Index.y - 1])) {
                    CDownRight.add(BrushLookup[Index.x][Index.y - 1]);
                }
                if (!CDownLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CDownLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x + 1][Index.y] != null && !CDownLeft.contains(BrushLookup[Index.x + 1][Index.y])) {
                    CDownLeft.add(BrushLookup[Index.x + 1][Index.y]);
                }
                if (!CUpLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CUpLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x + 1][Index.y] == null || CUpLeft.contains(BrushLookup[Index.x + 1][Index.y])) continue;
                CUpLeft.add(BrushLookup[Index.x + 1][Index.y]);
            }
            for (BrushPoint Index : TopLeftList) {
                if (!CCentre.contains(BrushLookup[Index.x][Index.y])) {
                    CCentre.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUp.contains(BrushLookup[Index.x][Index.y])) {
                    CUp.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CRight.contains(BrushLookup[Index.x][Index.y])) {
                    CRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CDown.contains(BrushLookup[Index.x][Index.y])) {
                    CDown.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (!CUpRight.contains(BrushLookup[Index.x][Index.y])) {
                    CUpRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x][Index.y + 1] != null && !CUpRight.contains(BrushLookup[Index.x][Index.y + 1])) {
                    CUpRight.add(BrushLookup[Index.x][Index.y + 1]);
                }
                if (!CDownRight.contains(BrushLookup[Index.x][Index.y])) {
                    CDownRight.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x][Index.y - 1] != null && !CUpRight.contains(BrushLookup[Index.x][Index.y - 1])) {
                    CDownRight.add(BrushLookup[Index.x][Index.y - 1]);
                }
                if (!CDownLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CDownLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x + 1][Index.y] != null && !CDownLeft.contains(BrushLookup[Index.x + 1][Index.y])) {
                    CDownLeft.add(BrushLookup[Index.x + 1][Index.y]);
                }
                if (!CUpLeft.contains(BrushLookup[Index.x][Index.y])) {
                    CUpLeft.add(BrushLookup[Index.x][Index.y]);
                }
                if (BrushLookup[Index.x + 1][Index.y] == null || CUpLeft.contains(BrushLookup[Index.x + 1][Index.y])) continue;
                CUpLeft.add(BrushLookup[Index.x + 1][Index.y]);
            }
            this.CrossPoints[1][1] = new BrushPoint[CCentre.size()];
            CCentre.toArray(this.CrossPoints[1][1]);
            this.CrossPoints[1][0] = new BrushPoint[CUp.size()];
            CUp.toArray(this.CrossPoints[1][0]);
            this.CrossPoints[2][0] = new BrushPoint[CUpRight.size()];
            CUpRight.toArray(this.CrossPoints[2][0]);
            this.CrossPoints[2][1] = new BrushPoint[CRight.size()];
            CRight.toArray(this.CrossPoints[2][1]);
            this.CrossPoints[2][2] = new BrushPoint[CDownRight.size()];
            CDownRight.toArray(this.CrossPoints[2][2]);
            this.CrossPoints[1][2] = new BrushPoint[CDown.size()];
            CDown.toArray(this.CrossPoints[1][2]);
            this.CrossPoints[0][2] = new BrushPoint[CDownLeft.size()];
            CDownLeft.toArray(this.CrossPoints[0][2]);
            this.CrossPoints[0][1] = new BrushPoint[CLeft.size()];
            CLeft.toArray(this.CrossPoints[0][1]);
            this.CrossPoints[0][0] = new BrushPoint[CUpLeft.size()];
            CUpLeft.toArray(this.CrossPoints[0][0]);
        }
        this.BrushRectLeft = Math.min(this.BrushRectLeft, this.CursorRectLeft);
        this.BrushRectRight = Math.max(this.BrushRectRight, this.CursorRectRight);
        this.BrushRectTop = Math.min(this.BrushRectTop, this.CursorRectTop);
        this.BrushRectBottom = Math.max(this.BrushRectBottom, this.CursorRectBottom);
        this.BrushRectWidth = this.BrushRectRight - this.BrushRectLeft + 1;
        this.BrushRectHeight = this.BrushRectBottom - this.BrushRectTop + 1;
        this.BrushRectLeft -= x0;
        this.BrushRectRight -= x0;
        this.BrushRectTop -= y0;
        this.BrushRectBottom -= y0;
        this.CursorRectWidth = this.CursorRectRight - this.CursorRectLeft + 1;
        this.CursorRectHeight = this.CursorRectBottom - this.CursorRectTop + 1;
        this.CursorRectLeft -= x0;
        this.CursorRectRight -= x0;
        this.CursorRectTop -= y0;
        this.CursorRectBottom -= y0;
    }

    protected void getEdge(int x0, int y0, int x1, int y1, int X, int Y, BrushPoint[][] BrushLookup, ArrayList<BrushPoint> Dst) {
        block11: {
            int sx;
            int sy;
            int s;
            block10: {
                s = BrushLookup[0].length;
                Dst.clear();
                if (x0 != x1 || y0 != y1) break block10;
                if (x0 < 0 || x0 >= s || y0 < 0 || y0 >= s || BrushLookup[x0][y0] == null || BrushLookup[x0][y0].a <= 0) break block11;
                Dst.add(new BrushPoint(x0, y0, BrushLookup[x0][y0].a));
                break block11;
            }
            int dy = y1 - y0;
            int dx = x1 - x0;
            if (dy < 0) {
                dy = -dy;
                sy = -1;
            } else {
                sy = 1;
            }
            if (dx < 0) {
                dx = -dx;
                sx = -1;
            } else {
                sx = 1;
            }
            if ((dx <<= 1) > (dy <<= 1)) {
                int f = dy - (dx >> 1);
                while (x0 != x1) {
                    if (f >= 0) {
                        y0 += sy;
                        f -= dx;
                    }
                    f += dy;
                    if ((x0 += sx) < 0 || x0 >= s || y0 < 0 || y0 >= s || BrushLookup[x0][y0] == null || BrushLookup[x0][y0].a <= 0) continue;
                    Dst.add(new BrushPoint(x0, y0, BrushLookup[x0][y0].a));
                }
            } else {
                int f = dx - (dy >> 1);
                while (y0 != y1) {
                    if (f >= 0) {
                        x0 += sx;
                        f -= dy;
                    }
                    f += dx;
                    if (x0 < 0 || x0 >= s || (y0 += sy) < 0 || y0 >= s || BrushLookup[x0][y0] == null || BrushLookup[x0][y0].a <= 0) continue;
                    Dst.add(new BrushPoint(x0, y0, BrushLookup[x0][y0].a));
                }
            }
        }
    }

    @Override
    public final void drawCursor(int newx, int newy, Graphics2D newGraphics) {
        newGraphics.setXORMode(Color.white);
        newGraphics.translate(newx, newy);
        newGraphics.rotate(this.dRotation);
        newGraphics.scale(1.0, 1.0 - this.dEccentricity);
        newGraphics.drawOval(-this.CursorDrawRectPos, -this.CursorDrawRectPos, this.CursorDrawRectSize, this.CursorDrawRectSize);
    }

    @Override
    public final void drawCursor(Point newPoint, Graphics2D newGraphics) {
        newGraphics.setXORMode(Color.white);
        newGraphics.translate(newPoint.x, newPoint.y);
        newGraphics.rotate(this.dRotation);
        newGraphics.scale(1.0, 1.0 - this.dEccentricity);
        newGraphics.drawOval(-this.CursorDrawRectPos, -this.CursorDrawRectPos, this.CursorDrawRectSize, this.CursorDrawRectSize);
    }

    @Override
    public final void drawCursor(int newx, int newy, Graphics2D newGraphics, double newScale) {
        int ScaledCursorDrawRectPos = (int)((double)this.CursorDrawRectPos * newScale + 0.5);
        int ScaledCursorDrawRectSize = (int)((double)this.CursorDrawRectSize * newScale + 0.5);
        newGraphics.setXORMode(Color.white);
        newGraphics.translate(newx, newy);
        newGraphics.rotate(this.dRotation);
        newGraphics.scale(1.0, 1.0 - this.dEccentricity);
        newGraphics.drawOval(-ScaledCursorDrawRectPos, -ScaledCursorDrawRectPos, ScaledCursorDrawRectSize, ScaledCursorDrawRectSize);
    }

    @Override
    public final void drawCursor(Point newPoint, Graphics2D newGraphics, double newScale) {
        int ScaledCursorDrawRectPos = (int)((double)this.CursorDrawRectPos * newScale + 0.5);
        int ScaledCursorDrawRectSize = (int)((double)this.CursorDrawRectSize * newScale + 0.5);
        newGraphics.setXORMode(Color.white);
        newGraphics.translate(newPoint.x, newPoint.y);
        newGraphics.rotate(this.dRotation);
        newGraphics.scale(1.0, 1.0 - this.dEccentricity);
        newGraphics.drawOval(-ScaledCursorDrawRectPos, -ScaledCursorDrawRectPos, ScaledCursorDrawRectSize, ScaledCursorDrawRectSize);
    }

    @Override
    public Brush getScaledInstance(double newScalex, double newScaley) {
        return new BrushImplRegular((int)((double)this.Width * ((newScalex + newScaley) / 2.0)), this.Eccentricity, this.Softness, this.Rotation);
    }

    @Override
    public void writeXML(Document newDoc, Element newParent) {
        Element BrushType = newDoc.createElement(BRUSHIMPLREG);
        Element BWidth = newDoc.createElement("Width");
        BWidth.appendChild(newDoc.createTextNode(String.valueOf(this.Width)));
        BrushType.appendChild(BWidth);
        Element BEccentricity = newDoc.createElement("Eccentricity");
        BEccentricity.appendChild(newDoc.createTextNode(String.valueOf(this.Eccentricity)));
        BrushType.appendChild(BEccentricity);
        Element BSoftness = newDoc.createElement("Softness");
        BSoftness.appendChild(newDoc.createTextNode(String.valueOf(this.Softness)));
        BrushType.appendChild(BSoftness);
        Element BRotation = newDoc.createElement("Rotation");
        BRotation.appendChild(newDoc.createTextNode(String.valueOf(this.Rotation)));
        BrushType.appendChild(BRotation);
        newParent.appendChild(BrushType);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BrushImplRegular) {
            BrushImplRegular d = (BrushImplRegular)obj;
            return this.Width == d.Width && this.Eccentricity == d.Eccentricity && this.Softness == d.Softness && this.Rotation == d.Rotation;
        }
        return false;
    }
}

