/*
 * Decompiled with CFR 0.152.
 */
package com.arc.awt.image.util;

import com.arc.awt.event.ProgressListener;
import com.arc.awt.image.util.ImageChangeEvent;
import com.arc.awt.image.util.ImageChangeListener;
import com.arc.awt.image.util.Images;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JPanel;

public class ImageTracker {
    protected BufferedImage TrackedImage;
    protected ArrayList<ImageChangeListener> TrackedImageListeners;
    protected int ImageID;
    protected int ScratchID;
    protected File ScratchFolder;
    protected String ScratchFormat;
    protected File ImageResetSrcFile;
    protected File ImageRestoreSrcFile;
    protected Dimension MaxPreviewSize;
    protected BufferedImage ImageResetSrcThumbnail;
    protected BufferedImage ImageRestoreSrcThumbnail;
    protected JPanel ImageTracker;
    protected ImageTrackerImageListener ImageListener;

    protected void imageChanged(BufferedImage newImage) {
        this.TrackedImage = newImage;
    }

    public ImageTracker(File newScratchFolder, String newScratchFormat, Dimension newMaxPreviewSize) {
        this.ScratchFolder = newScratchFolder;
        this.ScratchFormat = newScratchFormat;
        this.MaxPreviewSize = newMaxPreviewSize;
        this.ImageTracker = new JPanel();
        this.ImageListener = new ImageTrackerImageListener();
        this.TrackedImageListeners = new ArrayList();
    }

    public void setImage(BufferedImage newImage) {
        this.TrackedImage = newImage;
        ImageChangeEvent newEvent = new ImageChangeEvent(this, this.TrackedImage);
        for (ImageChangeListener TrackedImageListener : this.TrackedImageListeners) {
            TrackedImageListener.imageChanged(newEvent);
        }
    }

    public BufferedImage getImage() {
        return this.TrackedImage;
    }

    public BufferedImage getImage(ImageChangeListener newImageListener) {
        this.addImageListener(newImageListener);
        return this.TrackedImage;
    }

    public void addImageListener(ImageChangeListener newImageListener) {
        this.TrackedImageListeners.add(newImageListener);
    }

    public void removeImageListener(ImageChangeListener newImageListener) {
        this.TrackedImageListeners.remove(newImageListener);
    }

    public File setImageResetSrc(ProgressListener newProgressListener) throws IOException {
        ++this.ScratchID;
        this.ImageResetSrcFile = new File(this.ScratchFolder, "iArtWrk_" + String.valueOf(this.ScratchID) + "." + this.ScratchFormat);
        if (this.ImageResetSrcFile.exists() && !this.ImageResetSrcFile.delete()) {
            System.out.println("FAILED to delete Image Reset Src File " + this.ImageResetSrcFile.toString());
        }
        Images.writeImage(this.ImageResetSrcFile, this.TrackedImage, newProgressListener);
        int maxWidth = this.MaxPreviewSize.width;
        int maxHeight = this.MaxPreviewSize.height;
        int ImageWidth = this.TrackedImage.getWidth();
        int ImageHeight = this.TrackedImage.getHeight();
        double s0 = (double)maxWidth / (double)ImageWidth;
        double s1 = (double)maxHeight / (double)ImageHeight;
        double PrvZmTo = s0 == 1.0 && s1 == 1.0 ? 1.0 : (s0 < s1 ? Math.min(s0, 1.0) : Math.min(s1, 1.0));
        int newWidth = (int)((double)ImageWidth * PrvZmTo + 0.5);
        int newHeight = (int)((double)ImageHeight * PrvZmTo + 0.5);
        if (this.ImageResetSrcThumbnail == null || this.ImageResetSrcThumbnail.getWidth() != newWidth || this.ImageResetSrcThumbnail.getHeight() != newHeight) {
            this.ImageResetSrcThumbnail = Images.getImage(newWidth, newHeight, Color.WHITE);
        }
        Graphics2D g2d = this.ImageResetSrcThumbnail.createGraphics();
        g2d.drawImage(this.TrackedImage, 0, 0, newWidth, newHeight, this.ImageTracker);
        return this.ImageRestoreSrcFile;
    }

    public File setImageResetSrc(BufferedImage newImage, ProgressListener newProgressListener) throws IOException {
        this.setImage(newImage);
        return this.setImageResetSrc(newProgressListener);
    }

    public File getImageResetSrc() {
        return this.ImageResetSrcFile;
    }

    public BufferedImage getImageResetSrcThumbnail() {
        return this.ImageResetSrcThumbnail;
    }

    public void resetImage(ProgressListener newProgressListener) throws IOException {
        Images.readImage(this.ImageResetSrcFile, this.TrackedImage, (ImageChangeListener)this.ImageListener, newProgressListener);
    }

    public File setImageRestoreSrc(ProgressListener newProgressListener) throws IOException {
        ++this.ImageID;
        this.ScratchID = 0;
        this.ImageRestoreSrcFile = this.ImageResetSrcFile = new File(this.ScratchFolder, "iArtWrk_" + String.valueOf(this.ScratchID) + "." + this.ScratchFormat);
        if (this.ImageRestoreSrcFile.exists() && !this.ImageRestoreSrcFile.delete()) {
            System.out.println("FAILED to delete Image Restore Src File " + this.ImageRestoreSrcFile.toString());
        }
        Images.writeImage(this.ImageRestoreSrcFile, this.TrackedImage, newProgressListener);
        int maxWidth = this.MaxPreviewSize.width;
        int maxHeight = this.MaxPreviewSize.height;
        int ImageWidth = this.TrackedImage.getWidth();
        int ImageHeight = this.TrackedImage.getHeight();
        double s0 = (double)maxWidth / (double)ImageWidth;
        double s1 = (double)maxHeight / (double)ImageHeight;
        double PrvZmTo = s0 == 1.0 && s1 == 1.0 ? 1.0 : (s0 < s1 ? Math.min(s0, 1.0) : Math.min(s1, 1.0));
        int newWidth = (int)((double)ImageWidth * PrvZmTo + 0.5);
        int newHeight = (int)((double)ImageHeight * PrvZmTo + 0.5);
        if (this.ImageRestoreSrcThumbnail == null || this.ImageRestoreSrcThumbnail.getWidth() != newWidth || this.ImageRestoreSrcThumbnail.getHeight() != newHeight) {
            this.ImageRestoreSrcThumbnail = Images.getImage(newWidth, newHeight, Color.WHITE);
        }
        if (this.ImageResetSrcThumbnail == null || this.ImageResetSrcThumbnail.getWidth() != newWidth || this.ImageResetSrcThumbnail.getHeight() != newHeight) {
            this.ImageResetSrcThumbnail = Images.getImage(newWidth, newHeight, Color.WHITE);
        }
        Graphics2D g2d = this.ImageRestoreSrcThumbnail.createGraphics();
        g2d.drawImage(this.TrackedImage, 0, 0, newWidth, newHeight, this.ImageTracker);
        g2d = this.ImageResetSrcThumbnail.createGraphics();
        g2d.drawImage(this.TrackedImage, 0, 0, newWidth, newHeight, this.ImageTracker);
        return this.ImageRestoreSrcFile;
    }

    public File setImageRestoreSrc(BufferedImage newImage, ProgressListener newProgressListener) throws IOException {
        this.setImage(newImage);
        return this.setImageRestoreSrc(newProgressListener);
    }

    public File getImageRestoreSrc() {
        return this.ImageRestoreSrcFile;
    }

    public BufferedImage getImageRestoreSrcThumbnail() {
        return this.ImageRestoreSrcThumbnail;
    }

    public void restoreImage(ProgressListener newProgressListener) throws IOException {
        Images.readImage(this.ImageRestoreSrcFile, this.TrackedImage, (ImageChangeListener)this.ImageListener, newProgressListener);
    }

    public boolean isVolatileRestoreImage() {
        return this.TrackedImage != null && this.ImageResetSrcFile != this.ImageRestoreSrcFile;
    }

    public String getImageSrcID() {
        return String.valueOf(this.ImageID);
    }

    public String getImageID() {
        return String.valueOf(this.ImageID) + String.valueOf(this.ScratchID);
    }

    protected class ImageTrackerImageListener
    implements ImageChangeListener {
        protected ImageTrackerImageListener() {
        }

        @Override
        public void imageChanged(ImageChangeEvent e) {
            ImageTracker.this.TrackedImage = e.getImage();
            for (ImageChangeListener TrackedImageListener : ImageTracker.this.TrackedImageListeners) {
                TrackedImageListener.imageChanged(e);
            }
        }
    }
}

