/*
 * Decompiled with CFR 0.152.
 */
package com.arc.awt.image.util;

import com.arc.awt.event.ProgressListener;
import com.arc.awt.image.util.ImageChangeEvent;
import com.arc.awt.image.util.ImageChangeListener;
import com.arc.imageio.BasicBMPImageIO;
import com.arc.imageio.event.IIOReadProgressAdapter;
import com.arc.io.util.Files;
import com.arc.net.util.URLs;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class Images {
    public static final int COLOR_MODEL_M = 0;
    public static final int COLOR_MODEL_RGBB = 1;
    public static final int COLOR_MODEL_BGRI = 2;
    public static final int COLOR_MODEL_BGRAI = 3;
    public static final int COLOR_MODEL_ABGRI = 4;
    public static final int COLOR_MODEL_RGBI = 5;
    public static final int COLOR_MODEL_RGBAI = 6;
    public static final int COLOR_MODEL_ARGBI = 7;
    protected static ColorSpace WorkingColorSpace = ColorSpace.getInstance(1000);
    protected static int WorkingColorModel = 2;
    protected static Color DefaultColor = Color.WHITE;

    protected static boolean validateImageIOInplaceColorModel(int newColMdl, ImageReader newReader, ImageReadParam newReaderParam) {
        try {
            return !newReader.getFormatName().equalsIgnoreCase("bmp") || newColMdl == 2 || newColMdl == 3;
        }
        catch (Exception Ex) {
            Ex.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static BufferedImage readImageData(ImageInputStream newInputStream, boolean resetStream, String newFormat, Rectangle newRegion, BufferedImage newDestination, ImageChangeListener newImageListener, int newColMdl, ColorSpace newColSpce, ProgressListener newProgressListener) throws IIOException {
        try {
            if (newFormat.equalsIgnoreCase("bmp") && BasicBMPImageIO.validateReadColorModel(newInputStream, true, newColMdl)) {
                return BasicBMPImageIO.read(newInputStream, resetStream, newRegion, newDestination, newImageListener, newProgressListener);
            }
            try {
                int newHeight;
                ImageReader newReader = ImageIO.getImageReadersByFormatName(newFormat).next();
                newReader.setInput(newInputStream, true);
                if (newProgressListener != null) {
                    newReader.addIIOReadProgressListener(new IIOProgressListener(newProgressListener, 10));
                }
                int newWidth = newRegion == null ? newReader.getWidth(0) : newRegion.width;
                int n = newHeight = newRegion == null ? newReader.getHeight(0) : newRegion.height;
                if (newDestination == null || newWidth != newDestination.getWidth() || newHeight != newDestination.getHeight()) {
                    newDestination = Images.getImage(newWidth, newHeight, newColMdl, newColSpce);
                    if (newImageListener != null) {
                        newImageListener.imageChanged(new ImageChangeEvent(Images.class, newDestination));
                    }
                }
                ImageReadParam newReaderParams = newReader.getDefaultReadParam();
                newReaderParams.setDestination(newDestination);
                newReaderParams.setSourceRegion(newRegion);
                if (Images.validateImageIOInplaceColorModel(newColMdl, newReader, newReaderParams)) {
                    if (resetStream) {
                        newInputStream.mark();
                    }
                    newDestination = newReader.read(0, newReaderParams);
                    if (resetStream) {
                        newInputStream.reset();
                    }
                    BufferedImage bufferedImage = newDestination;
                    return bufferedImage;
                }
                if (resetStream) {
                    newInputStream.mark();
                }
                newReaderParams.setDestination(null);
                BufferedImage newImage = newReader.read(0, newReaderParams);
                Graphics2D g2d = newDestination.createGraphics();
                g2d.drawImage(newImage, null, 0, 0);
                g2d.dispose();
                if (resetStream) {
                    newInputStream.reset();
                }
                BufferedImage bufferedImage = newDestination;
                return bufferedImage;
            }
            catch (Exception Ex) {
                IIOException newException = new IIOException(Ex.getMessage());
                newException.initCause(Ex);
                throw newException;
            }
            finally {
                System.gc();
            }
        }
        catch (Exception Ex) {
            IIOException newException = new IIOException(Ex.getMessage());
            newException.initCause(Ex);
            throw newException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static BufferedImage readGreyscaleImageData(ImageInputStream newInputStream, boolean resetStream, String newFormat, Rectangle newRegion, BufferedImage newDestination, ImageChangeListener newImageListener, ProgressListener newProgressListener) throws IIOException {
        try {
            if (newFormat.equalsIgnoreCase("bmp") && BasicBMPImageIO.validateReadColorModel(newInputStream, true, 0)) {
                return BasicBMPImageIO.readGrey(newInputStream, resetStream, newRegion, newDestination, newImageListener, newProgressListener);
            }
            try {
                int newHeight;
                ImageReader newReader = ImageIO.getImageReadersByFormatName(newFormat).next();
                newReader.setInput(newInputStream, true);
                if (newProgressListener != null) {
                    newReader.addIIOReadProgressListener(new IIOProgressListener(newProgressListener, 10));
                }
                int newWidth = newRegion == null ? newReader.getWidth(0) : newRegion.width;
                int n = newHeight = newRegion == null ? newReader.getHeight(0) : newRegion.height;
                if (newDestination == null || newWidth != newDestination.getWidth() || newHeight != newDestination.getHeight()) {
                    newDestination = Images.getImage(newWidth, newHeight, 0);
                    if (newImageListener != null) {
                        newImageListener.imageChanged(new ImageChangeEvent(Images.class, newDestination));
                    }
                }
                ImageReadParam newReaderParams = newReader.getDefaultReadParam();
                newReaderParams.setSourceRegion(newRegion);
                if (resetStream) {
                    newInputStream.mark();
                }
                BufferedImage newImage = newReader.read(0, newReaderParams);
                Graphics2D g2d = newDestination.createGraphics();
                g2d.drawImage(newImage, null, 0, 0);
                g2d.dispose();
                if (resetStream) {
                    newInputStream.reset();
                }
                BufferedImage bufferedImage = newDestination;
                return bufferedImage;
            }
            catch (Exception Ex) {
                IIOException newException = new IIOException(Ex.getMessage());
                newException.initCause(Ex);
                throw newException;
            }
            finally {
                System.gc();
            }
        }
        catch (Exception Ex) {
            IIOException newException = new IIOException(Ex.getMessage());
            newException.initCause(Ex);
            throw newException;
        }
    }

    public static int getBitDepth() {
        return Images.getBitDepth(WorkingColorModel);
    }

    public static int getBitDepth(int newColMdl) {
        switch (newColMdl) {
            case 0: {
                return 1;
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 4;
            }
        }
        return Images.getBitDepth(WorkingColorModel);
    }

    public static String[] getSupportedReadFileFormats() {
        String[] ImageIOSet = ImageIO.getReaderFormatNames();
        if (Arrays.asList(ImageIOSet).contains("bmp") || Arrays.asList(ImageIOSet).contains("BMP")) {
            return ImageIOSet;
        }
        String[] newImageIOSet = new String[ImageIOSet.length + 1];
        newImageIOSet[0] = "bmp";
        System.arraycopy(ImageIOSet, 0, newImageIOSet, 1, ImageIOSet.length);
        return newImageIOSet;
    }

    public static String[] getSupportedWriteFileFormats() {
        String[] ImageIOSet = ImageIO.getWriterFormatNames();
        if (Arrays.asList(ImageIOSet).contains("bmp") || Arrays.asList(ImageIOSet).contains("BMP")) {
            return ImageIOSet;
        }
        String[] newImageIOSet = new String[ImageIOSet.length + 1];
        newImageIOSet[0] = "bmp";
        System.arraycopy(ImageIOSet, 0, newImageIOSet, 1, ImageIOSet.length);
        return newImageIOSet;
    }

    public static BufferedImage getImage(Dimension newSize) {
        return Images.getImage(newSize.width, newSize.height, DefaultColor, WorkingColorModel, WorkingColorSpace);
    }

    public static BufferedImage getImage(Dimension newSize, int newColMdl) {
        return Images.getImage(newSize.width, newSize.height, DefaultColor, newColMdl, WorkingColorSpace);
    }

    public static BufferedImage getImage(Dimension newSize, int newColMdl, ColorSpace newColSpce) {
        return Images.getImage(newSize.width, newSize.height, DefaultColor, newColMdl, newColSpce);
    }

    public static BufferedImage getImage(Dimension newSize, Color newCol) {
        return Images.getImage(newSize.width, newSize.height, newCol, WorkingColorModel, WorkingColorSpace);
    }

    public static BufferedImage getImage(Dimension newSize, Color newCol, int newColMdl) {
        return Images.getImage(newSize.width, newSize.height, newCol, newColMdl, WorkingColorSpace);
    }

    public static BufferedImage getImage(Dimension newSize, Color newCol, int newColMdl, ColorSpace newColSpce) {
        return Images.getImage(newSize.width, newSize.height, newCol, newColMdl, newColSpce);
    }

    public static BufferedImage getImage(int newWidth, int newHeight) {
        return Images.getImage(newWidth, newHeight, DefaultColor, WorkingColorModel, WorkingColorSpace);
    }

    public static BufferedImage getImage(int newWidth, int newHeight, int newColMdl) {
        return Images.getImage(newWidth, newHeight, DefaultColor, newColMdl, WorkingColorSpace);
    }

    public static BufferedImage getImage(int newWidth, int newHeight, int newColMdl, ColorSpace newColSpce) {
        return Images.getImage(newWidth, newHeight, DefaultColor, newColMdl, newColSpce);
    }

    public static BufferedImage getImage(int newWidth, int newHeight, Color newCol) {
        return Images.getImage(newWidth, newHeight, newCol, WorkingColorModel, WorkingColorSpace);
    }

    public static BufferedImage getImage(int newWidth, int newHeight, Color newCol, int newColMdl) {
        return Images.getImage(newWidth, newHeight, newCol, newColMdl, WorkingColorSpace);
    }

    public static BufferedImage getImage(int newWidth, int newHeight, Color newCol, int newColMdl, ColorSpace newColSpce) {
        switch (newColMdl) {
            case 0: {
                BufferedImage newImage = new BufferedImage(newWidth, newHeight, 10);
                Graphics2D g2d = newImage.createGraphics();
                g2d.setColor(newCol);
                g2d.fillRect(0, 0, newWidth, newHeight);
                return newImage;
            }
            case 1: {
                ComponentColorModel RGBbColorModel = new ComponentColorModel(newColSpce, new int[]{8, 8, 8}, false, false, 1, 0);
                WritableRaster RGBbRaster = Raster.createBandedRaster(0, newWidth, newHeight, 3, null);
                BufferedImage newImage = new BufferedImage(RGBbColorModel, RGBbRaster, false, null);
                Graphics2D g2d = newImage.createGraphics();
                g2d.setColor(newCol);
                g2d.fillRect(0, 0, newWidth, newHeight);
                return newImage;
            }
            case 2: {
                ComponentColorModel BGRiColorModel = new ComponentColorModel(newColSpce, new int[]{8, 8, 8}, false, false, 1, 0);
                WritableRaster BGRiRaster = Raster.createInterleavedRaster(0, newWidth, newHeight, newWidth * 3, 3, new int[]{2, 1, 0}, null);
                BufferedImage newImage = new BufferedImage(BGRiColorModel, BGRiRaster, false, null);
                Graphics2D g2d = newImage.createGraphics();
                g2d.setColor(newCol);
                g2d.fillRect(0, 0, newWidth, newHeight);
                return newImage;
            }
            case 3: {
                ComponentColorModel BGRAiColorModel = new ComponentColorModel(newColSpce, new int[]{8, 8, 8, 8}, true, false, 3, 0);
                WritableRaster BGRARaster = Raster.createInterleavedRaster(0, newWidth, newHeight, newWidth * 4, 4, new int[]{2, 1, 0, 3}, null);
                BufferedImage newImage = new BufferedImage(BGRAiColorModel, BGRARaster, false, null);
                Graphics2D g2d = newImage.createGraphics();
                g2d.setColor(newCol);
                g2d.fillRect(0, 0, newWidth, newHeight);
                return newImage;
            }
            case 4: {
                ComponentColorModel ABGRiColorModel = new ComponentColorModel(newColSpce, new int[]{8, 8, 8, 8}, true, false, 3, 0);
                WritableRaster ABGRRaster = Raster.createInterleavedRaster(0, newWidth, newHeight, newWidth * 4, 4, new int[]{3, 2, 1, 0}, null);
                BufferedImage newImage = new BufferedImage(ABGRiColorModel, ABGRRaster, false, null);
                Graphics2D g2d = newImage.createGraphics();
                g2d.setColor(newCol);
                g2d.fillRect(0, 0, newWidth, newHeight);
                return newImage;
            }
            case 5: {
                ComponentColorModel RGBiColorModel = new ComponentColorModel(newColSpce, new int[]{8, 8, 8}, false, false, 1, 0);
                WritableRaster RBGiRaster = Raster.createInterleavedRaster(0, newWidth, newHeight, newWidth * 3, 3, new int[]{0, 1, 2}, null);
                BufferedImage newImage = new BufferedImage(RGBiColorModel, RBGiRaster, false, null);
                Graphics2D g2d = newImage.createGraphics();
                g2d.setColor(newCol);
                g2d.fillRect(0, 0, newWidth, newHeight);
                return newImage;
            }
            case 6: {
                ComponentColorModel RGBAiColorModel = new ComponentColorModel(newColSpce, new int[]{8, 8, 8, 8}, true, true, 3, 0);
                WritableRaster RGBAiRaster = Raster.createInterleavedRaster(0, newWidth, newHeight, newWidth * 4, 4, new int[]{0, 1, 2, 3}, null);
                BufferedImage newImage = new BufferedImage(RGBAiColorModel, RGBAiRaster, true, null);
                Graphics2D g2d = newImage.createGraphics();
                g2d.setColor(newCol);
                g2d.fillRect(0, 0, newWidth, newHeight);
                return newImage;
            }
            case 7: {
                ComponentColorModel ARGBiColorModel = new ComponentColorModel(newColSpce, new int[]{8, 8, 8, 8}, true, true, 3, 0);
                WritableRaster ARGBiRaster = Raster.createInterleavedRaster(0, newWidth, newHeight, newWidth * 4, 4, new int[]{3, 0, 1, 2}, null);
                BufferedImage newImage = new BufferedImage(ARGBiColorModel, ARGBiRaster, true, null);
                Graphics2D g2d = newImage.createGraphics();
                g2d.setColor(newCol);
                g2d.fillRect(0, 0, newWidth, newHeight);
                return newImage;
            }
        }
        return null;
    }

    public static BufferedImage getImage(File newFile) throws IIOException {
        return Images.getImage(newFile, DefaultColor, WorkingColorModel, WorkingColorSpace);
    }

    public static BufferedImage getImage(File newFile, int newColMdl) throws IIOException {
        return Images.getImage(newFile, DefaultColor, newColMdl, WorkingColorSpace);
    }

    public static BufferedImage getImage(File newFile, int newColMdl, ColorSpace newColSpce) throws IIOException {
        return Images.getImage(newFile, DefaultColor, newColMdl, newColSpce);
    }

    public static BufferedImage getImage(File newFile, Color newCol) throws IIOException {
        return Images.getImage(newFile, newCol, WorkingColorModel, WorkingColorSpace);
    }

    public static BufferedImage getImage(File newFile, Color newCol, int newColMdl) throws IIOException {
        return Images.getImage(newFile, newCol, newColMdl, WorkingColorSpace);
    }

    public static BufferedImage getImage(File newFile, Color newCol, int newColMdl, ColorSpace newColSpce) throws IIOException {
        try {
            String newExtension = Files.getExtension((File)newFile);
            ImageInputStream newStream = ImageIO.createImageInputStream(newFile);
            BufferedImage newImage = Images.getImage(newStream, true, newExtension, newCol, newColMdl, newColSpce);
            newStream.close();
            return newImage;
        }
        catch (Exception Ex) {
            IIOException newException = new IIOException(Ex.getMessage());
            newException.initCause(Ex);
            throw newException;
        }
    }

    public static BufferedImage getImage(URL newURL) throws IIOException {
        return Images.getImage(newURL, DefaultColor, WorkingColorModel, WorkingColorSpace);
    }

    public static BufferedImage getImage(URL newURL, int newColMdl) throws IIOException {
        return Images.getImage(newURL, DefaultColor, newColMdl, WorkingColorSpace);
    }

    public static BufferedImage getImage(URL newURL, int newColMdl, ColorSpace newColSpce) throws IIOException {
        return Images.getImage(newURL, DefaultColor, newColMdl, newColSpce);
    }

    public static BufferedImage getImage(URL newURL, Color newCol) throws IIOException {
        return Images.getImage(newURL, newCol, WorkingColorModel, WorkingColorSpace);
    }

    public static BufferedImage getImage(URL newURL, Color newCol, int newColMdl) throws IIOException {
        return Images.getImage(newURL, newCol, newColMdl, WorkingColorSpace);
    }

    public static BufferedImage getImage(URL newURL, Color newCol, int newColMdl, ColorSpace newColSpce) throws IIOException {
        try {
            String newExtension = URLs.getExtension((URL)newURL);
            ImageInputStream newStream = ImageIO.createImageInputStream(newURL.openStream());
            BufferedImage newImage = Images.getImage(newStream, true, newExtension, newCol, newColMdl, newColSpce);
            newStream.close();
            return newImage;
        }
        catch (Exception Ex) {
            IIOException newException = new IIOException(Ex.getMessage());
            newException.initCause(Ex);
            throw newException;
        }
    }

    public static BufferedImage getImage(ImageInputStream newStream, boolean resetStream, String newFormat) throws IIOException {
        return Images.getImage(newStream, resetStream, newFormat, DefaultColor, WorkingColorModel, WorkingColorSpace);
    }

    public static BufferedImage getImage(ImageInputStream newStream, boolean resetStream, String newFormat, int newColMdl) throws IIOException {
        return Images.getImage(newStream, resetStream, newFormat, DefaultColor, newColMdl, WorkingColorSpace);
    }

    public static BufferedImage getImage(ImageInputStream newStream, boolean resetStream, String newFormat, int newColMdl, ColorSpace newColSpce) throws IIOException {
        return Images.getImage(newStream, resetStream, newFormat, DefaultColor, newColMdl, newColSpce);
    }

    public static BufferedImage getImage(ImageInputStream newStream, boolean resetStream, String newFormat, Color newCol) throws IIOException {
        return Images.getImage(newStream, resetStream, newFormat, newCol, WorkingColorModel, WorkingColorSpace);
    }

    public static BufferedImage getImage(ImageInputStream newStream, boolean resetStream, String newFormat, Color newCol, int newColMdl) throws IIOException {
        return Images.getImage(newStream, resetStream, newFormat, newCol, newColMdl, WorkingColorSpace);
    }

    public static BufferedImage getImage(ImageInputStream newStream, boolean resetStream, String newFormat, Color newCol, int newColMdl, ColorSpace newColSpce) throws IIOException {
        try {
            if (resetStream) {
                newStream.mark();
            }
            ImageReader newReader = ImageIO.getImageReadersByFormatName(newFormat).next();
            newReader.setInput(newStream, true);
            int newWidth = newReader.getWidth(0);
            int newHeight = newReader.getHeight(0);
            if (resetStream) {
                newStream.reset();
            }
            return Images.getImage(newWidth, newHeight, newCol, newColMdl, newColSpce);
        }
        catch (Exception Ex) {
            IIOException newException = new IIOException(Ex.getMessage());
            newException.initCause(Ex);
            throw newException;
        }
    }

    public static Dimension readImageSize(File newFile) throws IIOException {
        try {
            String newExtension = Files.getExtension((File)newFile);
            ImageInputStream newStream = ImageIO.createImageInputStream(newFile);
            Dimension newDimension = Images.readImageSize(newStream, true, newExtension);
            newStream.close();
            return newDimension;
        }
        catch (Exception Ex) {
            IIOException newException = new IIOException(Ex.getMessage());
            newException.initCause(Ex);
            throw newException;
        }
    }

    public static Dimension readImageSize(URL newURL) throws IIOException {
        try {
            String newExtension = URLs.getExtension((URL)newURL);
            ImageInputStream newStream = ImageIO.createImageInputStream(newURL.openStream());
            Dimension newDimension = Images.readImageSize(newStream, true, newExtension);
            newStream.close();
            return newDimension;
        }
        catch (Exception Ex) {
            IIOException newException = new IIOException(Ex.getMessage());
            newException.initCause(Ex);
            throw newException;
        }
    }

    public static Dimension readImageSize(ImageInputStream newStream, boolean newReset, String newFormat) throws IIOException {
        try {
            if (newReset) {
                newStream.mark();
            }
            ImageReader newReader = ImageIO.getImageReadersByFormatName(newFormat).next();
            newReader.setInput(newStream, true);
            int newWidth = newReader.getWidth(0);
            int newHeight = newReader.getHeight(0);
            if (newReset) {
                newStream.reset();
            }
            return new Dimension(newWidth, newHeight);
        }
        catch (Exception Ex) {
            IIOException newException = new IIOException(Ex.getMessage());
            newException.initCause(Ex);
            throw newException;
        }
    }

    public static BufferedImage readImage(URL newURL, BufferedImage newDestination, ImageChangeListener newImageListener, ProgressListener newProgressListener) throws IIOException {
        return Images.readImage(newURL, newDestination, newImageListener, null, WorkingColorModel, WorkingColorSpace, newProgressListener);
    }

    public static BufferedImage readImage(URL newURL, BufferedImage newDestination, ImageChangeListener newImageListener, int newColMdl, ProgressListener newProgressListener) throws IIOException {
        return Images.readImage(newURL, newDestination, newImageListener, null, newColMdl, WorkingColorSpace, newProgressListener);
    }

    public static BufferedImage readImage(URL newURL, BufferedImage newDestination, ImageChangeListener newImageListener, int newColMdl, ColorSpace newColSpce, ProgressListener newProgressListener) throws IIOException {
        return Images.readImage(newURL, newDestination, newImageListener, null, newColMdl, newColSpce, newProgressListener);
    }

    public static BufferedImage readImage(URL newURL, BufferedImage newDestination, ImageChangeListener newImageListener, Rectangle newRegion, ProgressListener newProgressListener) throws IIOException {
        return Images.readImage(newURL, newDestination, newImageListener, newRegion, WorkingColorModel, WorkingColorSpace, newProgressListener);
    }

    public static BufferedImage readImage(URL newURL, BufferedImage newDestination, ImageChangeListener newImageListener, Rectangle newRegion, int newColMdl, ProgressListener newProgressListener) throws IIOException {
        return Images.readImage(newURL, newDestination, newImageListener, newRegion, newColMdl, WorkingColorSpace, newProgressListener);
    }

    public static BufferedImage readImage(URL newURL, BufferedImage newDestination, ImageChangeListener newImageListener, Rectangle newRegion, int newColMdl, ColorSpace newColSpce, ProgressListener newProgressListener) throws IIOException {
        try {
            String newExtension = URLs.getExtension((URL)newURL);
            ImageInputStream newStream = ImageIO.createImageInputStream(newURL.openStream());
            BufferedImage newImage = Images.readImage(newStream, true, newDestination, newImageListener, newExtension, newRegion, newColMdl, newColSpce, newProgressListener);
            newStream.close();
            return newImage;
        }
        catch (Exception Ex) {
            IIOException newException = new IIOException(Ex.getMessage());
            newException.initCause(Ex);
            throw newException;
        }
    }

    public static BufferedImage readImage(File newFile, BufferedImage newDestination, ImageChangeListener newImageListener, ProgressListener newProgressListener) throws IIOException {
        return Images.readImage(newFile, newDestination, newImageListener, null, WorkingColorModel, WorkingColorSpace, newProgressListener);
    }

    public static BufferedImage readImage(File newFile, BufferedImage newDestination, ImageChangeListener newImageListener, int newColMdl, ProgressListener newProgressListener) throws IIOException {
        return Images.readImage(newFile, newDestination, newImageListener, null, newColMdl, WorkingColorSpace, newProgressListener);
    }

    public static BufferedImage readImage(File newFile, BufferedImage newDestination, ImageChangeListener newImageListener, int newColMdl, ColorSpace newColSpce, ProgressListener newProgressListener) throws IIOException {
        return Images.readImage(newFile, newDestination, newImageListener, null, newColMdl, newColSpce, newProgressListener);
    }

    public static BufferedImage readImage(File newFile, BufferedImage newDestination, ImageChangeListener newImageListener, Rectangle newRegion, int newColMdl, ProgressListener newProgressListener) throws IIOException {
        return Images.readImage(newFile, newDestination, newImageListener, newRegion, newColMdl, WorkingColorSpace, newProgressListener);
    }

    public static BufferedImage readImage(File newFile, BufferedImage newDestination, ImageChangeListener newImageListener, Rectangle newRegion, ProgressListener newProgressListener) throws IIOException {
        return Images.readImage(newFile, newDestination, newImageListener, newRegion, WorkingColorModel, WorkingColorSpace, newProgressListener);
    }

    public static BufferedImage readImage(File newFile, BufferedImage newDestination, ImageChangeListener newImageListener, Rectangle newRegion, int newColMdl, ColorSpace newColSpce, ProgressListener newProgressListener) throws IIOException {
        try {
            String newExtension = Files.getExtension((File)newFile);
            ImageInputStream newStream = ImageIO.createImageInputStream(newFile);
            BufferedImage newImage = Images.readImage(newStream, true, newDestination, newImageListener, newExtension, newRegion, newColMdl, newColSpce, newProgressListener);
            newStream.close();
            return newImage;
        }
        catch (Exception Ex) {
            IIOException newException = new IIOException(Ex.getMessage());
            newException.initCause(Ex);
            throw newException;
        }
    }

    public static BufferedImage readImage(ImageInputStream newStream, boolean resetStream, BufferedImage newDestination, ImageChangeListener newImageListener, String newFormat, ProgressListener newProgressListener) throws IIOException {
        return Images.readImage(newStream, resetStream, newDestination, newImageListener, newFormat, null, WorkingColorModel, WorkingColorSpace, newProgressListener);
    }

    public static BufferedImage readImage(ImageInputStream newStream, boolean resetStream, BufferedImage newDestination, ImageChangeListener newImageListener, String newFormat, int newColMdl, ProgressListener newProgressListener) throws IIOException {
        return Images.readImage(newStream, resetStream, newDestination, newImageListener, newFormat, null, newColMdl, WorkingColorSpace, newProgressListener);
    }

    public static BufferedImage readImage(ImageInputStream newStream, boolean resetStream, BufferedImage newDestination, ImageChangeListener newImageListener, String newFormat, int newColMdl, ColorSpace newColSpce, ProgressListener newProgressListener) throws IIOException {
        return Images.readImage(newStream, resetStream, newDestination, newImageListener, newFormat, null, newColMdl, newColSpce, newProgressListener);
    }

    public static BufferedImage readImage(ImageInputStream newStream, boolean resetStream, BufferedImage newDestination, ImageChangeListener newImageListener, String newFormat, Rectangle newRegion, ProgressListener newProgressListener) throws IIOException {
        return Images.readImage(newStream, resetStream, newDestination, newImageListener, newFormat, newRegion, WorkingColorModel, WorkingColorSpace, newProgressListener);
    }

    public static BufferedImage readImage(ImageInputStream newStream, boolean resetStream, BufferedImage newDestination, ImageChangeListener newImageListener, String newFormat, Rectangle newRegion, int newColMdl, ProgressListener newProgressListener) throws IIOException {
        return Images.readImage(newStream, resetStream, newDestination, newImageListener, newFormat, newRegion, newColMdl, WorkingColorSpace, newProgressListener);
    }

    public static BufferedImage readImage(ImageInputStream newStream, boolean resetStream, BufferedImage newDestination, ImageChangeListener newImageListener, String newFormat, Rectangle newRegion, int newColMdl, ColorSpace newColSpce, ProgressListener newProgressListener) throws IIOException {
        if (newColMdl == 0) {
            return Images.readGreyscaleImageData(newStream, resetStream, newFormat, newRegion, newDestination, newImageListener, newProgressListener);
        }
        return Images.readImageData(newStream, resetStream, newFormat, newRegion, newDestination, newImageListener, newColMdl, newColSpce, newProgressListener);
    }

    public static void writeImage(File newFile, BufferedImage newSource, ProgressListener newProgressListener) throws IIOException {
        Images.writeImage(newFile, newSource, WorkingColorModel, newProgressListener);
    }

    public static void writeImage(File newFile, BufferedImage newSource, int newColMdl, ProgressListener newProgressListener) throws IIOException {
        try {
            String newExtension = Files.getExtension((File)newFile);
            ImageOutputStream newStream = ImageIO.createImageOutputStream(newFile);
            Images.writeImage(newStream, newSource, newExtension, newColMdl, newProgressListener);
            newStream.close();
        }
        catch (Exception Ex) {
            IIOException newException = new IIOException(Ex.getMessage());
            newException.initCause(Ex);
            throw newException;
        }
    }

    public static void writeImage(ImageOutputStream newStream, BufferedImage newSource, String newFormat, ProgressListener newProgressListener) throws IIOException {
        Images.writeImage(newStream, newSource, newFormat, WorkingColorModel, newProgressListener);
    }

    public static void writeImage(ImageOutputStream newStream, BufferedImage newSource, String newFormat, int newColMdl, ProgressListener newProgressListener) throws IIOException {
        try {
            if (BasicBMPImageIO.validateWriteColorModel(newColMdl)) {
                BasicBMPImageIO.write(newStream, newSource);
            } else {
                ImageIO.write((RenderedImage)newSource, newFormat, newStream);
            }
        }
        catch (Exception Ex) {
            IIOException newException = new IIOException(Ex.getMessage());
            newException.initCause(Ex);
            throw newException;
        }
    }

    public static Color getDefaultColor() {
        return DefaultColor;
    }

    public static void setDefaultColor(Color newDefaultColor) {
        DefaultColor = newDefaultColor;
    }

    public static int getWorkingColorModel() {
        return WorkingColorModel;
    }

    public static void setWorkingColorModel(int newDefaultColorModel) {
        WorkingColorModel = Math.min(7, Math.max(0, newDefaultColorModel));
    }

    public static ColorSpace getWorkingColorSpace() {
        return WorkingColorSpace;
    }

    public static void setWorkingColorSpace(ColorSpace newDefaultColorSpace) {
        WorkingColorSpace = newDefaultColorSpace;
    }

    public static void setWorkingColorSpace(ColorSpace newDefaultColorSpace, int newDefaultColorModel) {
        WorkingColorModel = Math.min(7, Math.max(0, newDefaultColorModel));
        WorkingColorSpace = newDefaultColorSpace;
    }

    protected static class IIOProgressListener
    extends IIOReadProgressAdapter {
        protected final int Range;
        protected final ProgressListener Listener;

        public IIOProgressListener(ProgressListener newListener, int newRange) {
            this.Range = newRange;
            this.Listener = newListener;
            this.Listener.pushProgressRange(0, this.Range, 10000);
            Thread.yield();
        }

        @Override
        public void imageProgress(ImageReader source, float percentageDone) {
            this.Listener.progressEvent((int)(percentageDone / (float)this.Range));
            Thread.yield();
        }

        @Override
        public void imageComplete(ImageReader source) {
            this.Listener.popProgressRange();
            Thread.yield();
        }
    }
}

