/*
 * Decompiled with CFR 0.152.
 */
package com.arc.imageio;

import com.arc.awt.event.ProgressListener;
import com.arc.awt.image.util.ImageChangeEvent;
import com.arc.awt.image.util.ImageChangeListener;
import com.arc.awt.image.util.Images;
import com.arc.io.util.Files;
import com.arc.net.util.URLs;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;

public class BasicBMPImageIO {
    public static final int BITMAP_TYPE_BOTTOM_UP = 0;
    public static final int BITMAP_TYPE_TOP_DOWN = 1;
    protected static int WorkingBitmapType = 0;

    public static boolean validateReadColorModel(File newFile, int newColMdl) {
        try {
            String newExtension = Files.getExtension((File)newFile);
            if (!newExtension.equalsIgnoreCase("bmp")) {
                return false;
            }
            ImageInputStream newStream = ImageIO.createImageInputStream(newFile);
            boolean newValue = BasicBMPImageIO.validateReadColorModel(newStream, true, newColMdl);
            newStream.close();
            return newValue;
        }
        catch (Exception Ex) {
            return false;
        }
    }

    public static boolean validateReadColorModel(URL newFile, int newColMdl) {
        try {
            String newExtension = URLs.getExtension((URL)newFile);
            if (!newExtension.equalsIgnoreCase("bmp")) {
                return false;
            }
            ImageInputStream newStream = ImageIO.createImageInputStream(newFile.openStream());
            boolean newValue = BasicBMPImageIO.validateReadColorModel(newStream, true, newColMdl);
            newStream.close();
            return newValue;
        }
        catch (Exception Ex) {
            return false;
        }
    }

    public static boolean validateReadColorModel(ImageInputStream newStream, boolean newReset, int newColMdl) throws IOException {
        try {
            if (newReset) {
                newStream.mark();
            }
            byte[] FileHeaderBuffer = new byte[14];
            ByteBuffer FileHeader = ByteBuffer.wrap(FileHeaderBuffer);
            FileHeader.order(ByteOrder.LITTLE_ENDIAN);
            newStream.read(FileHeaderBuffer);
            FileHeader.rewind();
            byte[] InfoHeaderBuffer = new byte[40];
            ByteBuffer InfoHeader = ByteBuffer.wrap(InfoHeaderBuffer);
            InfoHeader.order(ByteOrder.LITTLE_ENDIAN);
            newStream.read(InfoHeaderBuffer);
            InfoHeader.rewind();
            short bitcount = InfoHeader.getShort(14);
            int compression = InfoHeader.getInt(16);
            if (newReset) {
                newStream.reset();
            }
            return compression == 0 && (newColMdl == 0 || newColMdl == 2 && bitcount == 24 || newColMdl == 3 && bitcount == 32);
        }
        catch (Exception Ex) {
            IOException newEx = new IOException();
            newEx.initCause(Ex);
            throw newEx;
        }
    }

    public static boolean validateWriteColorModel(int newColMdl) {
        return newColMdl == 3 || newColMdl == 2;
    }

    public static BufferedImage read(File newFile, BufferedImage newTarget, ImageChangeListener newImageListener, ProgressListener newProgressListener) throws IOException {
        ImageInputStream newStream = ImageIO.createImageInputStream(newFile);
        BufferedImage newImage = BasicBMPImageIO.read(newStream, true, newTarget, newImageListener, newProgressListener);
        newStream.close();
        return newImage;
    }

    public static BufferedImage read(File newFile, Rectangle newRegion, BufferedImage newTarget, ImageChangeListener newImageListener, ProgressListener newProgressListener) throws IOException {
        ImageInputStream newStream = ImageIO.createImageInputStream(newFile);
        BufferedImage newImage = BasicBMPImageIO.read(newStream, true, newRegion, newTarget, newImageListener, newProgressListener);
        newStream.close();
        return newImage;
    }

    public static BufferedImage read(URL newFile, BufferedImage newTarget, ImageChangeListener newImageListener, ProgressListener newProgressListener) throws IOException {
        ImageInputStream newStream = ImageIO.createImageInputStream(newFile.openStream());
        BufferedImage newImage = BasicBMPImageIO.read(newStream, true, newTarget, newImageListener, newProgressListener);
        newStream.close();
        return newImage;
    }

    public static BufferedImage read(URL newFile, Rectangle newRegion, BufferedImage newTarget, ImageChangeListener newImageListener, ProgressListener newProgressListener) throws IOException {
        ImageInputStream newStream = ImageIO.createImageInputStream(newFile.openStream());
        BufferedImage newImage = BasicBMPImageIO.read(newStream, true, newRegion, newTarget, newImageListener, newProgressListener);
        newStream.close();
        return newImage;
    }

    public static BufferedImage read(ImageInputStream newStream, boolean newReset, BufferedImage newTarget, ImageChangeListener newImageListener, ProgressListener newProgressListener) throws IOException {
        if (newReset) {
            newStream.mark();
        }
        byte[] FileHeaderBuffer = new byte[14];
        ByteBuffer FileHeader = ByteBuffer.wrap(FileHeaderBuffer);
        FileHeader.order(ByteOrder.LITTLE_ENDIAN);
        newStream.read(FileHeaderBuffer);
        FileHeader.rewind();
        byte[] InfoHeaderBuffer = new byte[40];
        ByteBuffer InfoHeader = ByteBuffer.wrap(InfoHeaderBuffer);
        InfoHeader.order(ByteOrder.LITTLE_ENDIAN);
        newStream.read(InfoHeaderBuffer);
        InfoHeader.rewind();
        boolean newType = false;
        int newWidth = InfoHeader.getInt(4);
        int newHeight = InfoHeader.getInt(8);
        if (newHeight < 0) {
            newType = true;
            newHeight = Math.abs(newHeight);
        }
        short newBitCount = InfoHeader.getShort(14);
        int newCompression = InfoHeader.getInt(16);
        if (newCompression == 0 && (newBitCount == 24 || newBitCount == 32)) {
            if (newProgressListener != null) {
                newProgressListener.pushProgressRange(0, 11, 10000);
            }
            if (newTarget == null || newTarget.getWidth() != newWidth || newTarget.getHeight() != newHeight) {
                newTarget = Images.getImage(newWidth, newHeight, Color.WHITE, newBitCount == 24 ? 2 : 3);
                if (newImageListener != null) {
                    newImageListener.imageChanged(new ImageChangeEvent(BasicBMPImageIO.class, newTarget));
                }
            }
            DataBufferByte RestoreDataBuffer = (DataBufferByte)newTarget.getRaster().getDataBuffer();
            byte[] RestoreData = RestoreDataBuffer.getData();
            double progress = (double)newHeight / 100.0;
            int colspan = newBitCount == 24 ? 3 : 4;
            int padcount = 4 - newWidth * colspan % 4;
            if (padcount == 4) {
                padcount = 0;
            }
            int rowspan = newWidth * colspan;
            byte[] pad = new byte[padcount];
            if (newProgressListener != null) {
                newProgressListener.progressEvent(1);
            }
            if (!newType) {
                int i = newHeight - 1;
                int j = 0;
                while (i >= 0) {
                    newStream.read(RestoreData, i * rowspan, rowspan);
                    newStream.read(pad);
                    if (newProgressListener != null) {
                        newProgressListener.progressEvent((int)((double)j / progress) + 1);
                    }
                    --i;
                    ++j;
                }
            } else if (newBitCount == 24) {
                for (int i = 0; i < newHeight; ++i) {
                    newStream.read(RestoreData, i * rowspan, rowspan);
                    newStream.read(pad);
                    if (newProgressListener == null) continue;
                    newProgressListener.progressEvent((int)((double)i / progress) + 1);
                }
            } else {
                newStream.read(RestoreData);
            }
            if (newProgressListener != null) {
                newProgressListener.popProgressRange();
            }
        } else {
            throw new IOException("Invalid BMP data");
        }
        if (newReset) {
            newStream.reset();
        }
        return newTarget;
    }

    public static BufferedImage read(ImageInputStream newStream, boolean newReset, Rectangle newRegion, BufferedImage newTarget, ImageChangeListener newImageListener, ProgressListener newProgressListener) throws IOException {
        if (newRegion == null) {
            return BasicBMPImageIO.read(newStream, newReset, newTarget, newImageListener, newProgressListener);
        }
        if (newReset) {
            newStream.mark();
        }
        byte[] FileHeaderBuffer = new byte[14];
        ByteBuffer FileHeader = ByteBuffer.wrap(FileHeaderBuffer);
        FileHeader.order(ByteOrder.LITTLE_ENDIAN);
        newStream.read(FileHeaderBuffer);
        FileHeader.rewind();
        byte[] InfoHeaderBuffer = new byte[40];
        ByteBuffer InfoHeader = ByteBuffer.wrap(InfoHeaderBuffer);
        InfoHeader.order(ByteOrder.LITTLE_ENDIAN);
        newStream.read(InfoHeaderBuffer);
        InfoHeader.rewind();
        boolean newType = false;
        int newWidth = InfoHeader.getInt(4);
        int newHeight = InfoHeader.getInt(8);
        if (newHeight < 0) {
            newType = true;
            newHeight = Math.abs(newHeight);
        }
        short newBitCount = InfoHeader.getShort(14);
        int newCompression = InfoHeader.getInt(16);
        if (newCompression == 0 && (newBitCount == 24 || newBitCount == 32)) {
            int i;
            if (newProgressListener != null) {
                newProgressListener.pushProgressRange(0, 12, 10000);
            }
            if (newTarget == null || newTarget.getWidth() != newRegion.width || newTarget.getHeight() != newRegion.height) {
                newTarget = Images.getImage(newWidth, newHeight, Color.WHITE, newBitCount == 24 ? 2 : 3);
                if (newImageListener != null) {
                    newImageListener.imageChanged(new ImageChangeEvent(BasicBMPImageIO.class, newTarget));
                }
            }
            BufferedImage TempImage = Images.getImage(newWidth, newHeight, Color.WHITE, newBitCount == 24 ? 2 : 3);
            DataBufferByte RestoreDataBuffer = (DataBufferByte)TempImage.getRaster().getDataBuffer();
            byte[] RestoreData = RestoreDataBuffer.getData();
            double progress = (double)newHeight / 100.0;
            int colspan = newBitCount == 24 ? 3 : 4;
            int padcount = 4 - newWidth * colspan % 4;
            if (padcount == 4) {
                padcount = 0;
            }
            int rowspan = newWidth * colspan;
            byte[] pad = new byte[padcount];
            if (newProgressListener != null) {
                newProgressListener.progressEvent(1);
            }
            if (!newType) {
                i = newHeight - 1;
                int j = 0;
                while (i >= 0) {
                    newStream.read(RestoreData, i * rowspan, rowspan);
                    newStream.read(pad);
                    if (newProgressListener != null) {
                        newProgressListener.progressEvent((int)((double)j / progress) + 1);
                    }
                    --i;
                    ++j;
                }
            } else if (newBitCount == 24) {
                for (i = 0; i < newHeight; ++i) {
                    newStream.read(RestoreData, i * rowspan, rowspan);
                    newStream.read(pad);
                    if (newProgressListener == null) continue;
                    newProgressListener.progressEvent((int)((double)i / progress) + 1);
                }
            } else {
                newStream.read(RestoreData);
            }
            Graphics2D g2d = newTarget.createGraphics();
            g2d.drawImage(TempImage, null, -newRegion.x, -newRegion.y);
            if (newProgressListener != null) {
                newProgressListener.progressEvent(12);
                newProgressListener.popProgressRange();
            }
        } else {
            throw new IOException("Invalid BMP data");
        }
        if (newReset) {
            newStream.reset();
        }
        return newTarget;
    }

    public static BufferedImage readGrey(File newFile, BufferedImage newTarget, ImageChangeListener newImageListener, ProgressListener newProgressListener) throws IOException {
        ImageInputStream newStream = ImageIO.createImageInputStream(newFile);
        BufferedImage newImage = BasicBMPImageIO.readGrey(newStream, true, newTarget, newImageListener, newProgressListener);
        newStream.close();
        return newImage;
    }

    public static BufferedImage readGrey(File newFile, Rectangle newRegion, BufferedImage newTarget, ImageChangeListener newImageListener, ProgressListener newProgressListener) throws IOException {
        ImageInputStream newStream = ImageIO.createImageInputStream(newFile);
        BufferedImage newImage = BasicBMPImageIO.readGrey(newStream, true, newRegion, newTarget, newImageListener, newProgressListener);
        newStream.close();
        return newImage;
    }

    public static BufferedImage readGrey(URL newFile, BufferedImage newTarget, ImageChangeListener newImageListener, ProgressListener newProgressListener) throws IOException {
        ImageInputStream newStream = ImageIO.createImageInputStream(newFile.openStream());
        BufferedImage newImage = BasicBMPImageIO.readGrey(newStream, true, newTarget, newImageListener, newProgressListener);
        newStream.close();
        return newImage;
    }

    public static BufferedImage readGrey(URL newFile, Rectangle newRegion, BufferedImage newTarget, ImageChangeListener newImageListener, ProgressListener newProgressListener) throws IOException {
        ImageInputStream newStream = ImageIO.createImageInputStream(newFile.openStream());
        BufferedImage newImage = BasicBMPImageIO.readGrey(newStream, true, newRegion, newTarget, newImageListener, newProgressListener);
        newStream.close();
        return newImage;
    }

    public static BufferedImage readGrey(ImageInputStream newStream, boolean newReset, BufferedImage newTarget, ImageChangeListener newImageListener, ProgressListener newProgressListener) throws IOException {
        if (newReset) {
            newStream.mark();
        }
        byte[] FileHeaderBuffer = new byte[14];
        ByteBuffer FileHeader = ByteBuffer.wrap(FileHeaderBuffer);
        FileHeader.order(ByteOrder.LITTLE_ENDIAN);
        newStream.read(FileHeaderBuffer);
        FileHeader.rewind();
        byte[] InfoHeaderBuffer = new byte[40];
        ByteBuffer InfoHeader = ByteBuffer.wrap(InfoHeaderBuffer);
        InfoHeader.order(ByteOrder.LITTLE_ENDIAN);
        newStream.read(InfoHeaderBuffer);
        InfoHeader.rewind();
        boolean newType = false;
        int newWidth = InfoHeader.getInt(4);
        int newHeight = InfoHeader.getInt(8);
        if (newHeight < 0) {
            newType = true;
            newHeight = Math.abs(newHeight);
        }
        short newBitCount = InfoHeader.getShort(14);
        int newCompression = InfoHeader.getInt(16);
        if (newCompression == 0 && (newBitCount == 24 || newBitCount == 32)) {
            if (newProgressListener != null) {
                newProgressListener.pushProgressRange(0, 11, 10000);
            }
            if (newTarget == null || newTarget.getWidth() != newWidth || newTarget.getHeight() != newHeight) {
                newTarget = Images.getImage(newWidth, newHeight, Color.WHITE, newBitCount == 24 ? 2 : 3);
                if (newImageListener != null) {
                    newImageListener.imageChanged(new ImageChangeEvent(BasicBMPImageIO.class, newTarget));
                }
            }
            DataBufferByte RestoreDataBuffer = (DataBufferByte)newTarget.getRaster().getDataBuffer();
            byte[] RestoreData = RestoreDataBuffer.getData();
            double progress = (double)newHeight / 100.0;
            int colspan = newBitCount == 24 ? 3 : 4;
            int newPad = 4 - newWidth * colspan % 4;
            if (newPad == 4) {
                newPad = 0;
            }
            int rowspan = newWidth * colspan;
            byte[] row = new byte[rowspan];
            byte[] pad = new byte[newPad];
            if (newProgressListener != null) {
                newProgressListener.progressEvent(1);
            }
            if (!newType) {
                int i = newHeight - 1;
                int k = i * newWidth;
                while (i >= 0) {
                    newStream.read(row);
                    newStream.read(pad);
                    int j = 0;
                    int l = 0;
                    int m = 0;
                    while (j < rowspan) {
                        RestoreData[k + l] = (byte)(((row[j] & 0xFF) + (row[j + 1] & 0xFF) + (row[j + 2] & 0xFF)) / 3);
                        j += colspan;
                        ++l;
                        ++m;
                    }
                    if (newProgressListener != null) {
                        newProgressListener.progressEvent((int)((double)m / progress) + 1);
                    }
                    k = --i * newWidth;
                }
            } else {
                int i = 0;
                int k = i * newWidth;
                while (i < newHeight) {
                    newStream.read(row);
                    newStream.read(pad);
                    int j = 0;
                    int l = 0;
                    while (j < rowspan) {
                        RestoreData[k + l] = (byte)(((row[j] & 0xFF) + (row[j + 1] & 0xFF) + (row[j + 2] & 0xFF)) / 3);
                        j += colspan;
                        ++l;
                    }
                    if (newProgressListener != null) {
                        newProgressListener.progressEvent((int)((double)i / progress) + 1);
                    }
                    k = ++i * newWidth;
                }
            }
            if (newProgressListener != null) {
                newProgressListener.popProgressRange();
            }
        } else {
            throw new IOException("Invalid BMP data");
        }
        if (newReset) {
            newStream.reset();
        }
        return newTarget;
    }

    public static BufferedImage readGrey(ImageInputStream newStream, boolean newReset, Rectangle newRegion, BufferedImage newTarget, ImageChangeListener newImageListener, ProgressListener newProgressListener) throws IOException {
        if (newRegion == null) {
            return BasicBMPImageIO.readGrey(newStream, newReset, newTarget, newImageListener, newProgressListener);
        }
        return BasicBMPImageIO.readGrey(newStream, newReset, newTarget, newImageListener, newProgressListener);
    }

    public static int getCompression(File newFile) throws IOException {
        ImageInputStream newStream = ImageIO.createImageInputStream(newFile);
        int newCompression = BasicBMPImageIO.getHeight(newStream, true);
        newStream.close();
        return newCompression;
    }

    public static int getBitCount(File newFile) throws IOException {
        ImageInputStream newStream = ImageIO.createImageInputStream(newFile);
        int newBitCount = BasicBMPImageIO.getHeight(newStream, true);
        newStream.close();
        return newBitCount;
    }

    public static int getWidth(File newFile) throws IOException {
        ImageInputStream newStream = ImageIO.createImageInputStream(newFile);
        int newWidth = BasicBMPImageIO.getHeight(newStream, true);
        newStream.close();
        return newWidth;
    }

    public static int getHeight(File newFile) throws IOException {
        ImageInputStream newStream = ImageIO.createImageInputStream(newFile);
        int newHeight = BasicBMPImageIO.getHeight(newStream, true);
        newStream.close();
        return newHeight;
    }

    public static int getCompression(URL newFile) throws IOException {
        ImageInputStream newStream = ImageIO.createImageInputStream(newFile.openStream());
        int newCompression = BasicBMPImageIO.getCompression(newStream, true);
        newStream.close();
        return newCompression;
    }

    public static int getBitCount(URL newFile) throws IOException {
        ImageInputStream newStream = ImageIO.createImageInputStream(newFile.openStream());
        int newBitCount = BasicBMPImageIO.getBitCount(newStream, true);
        newStream.close();
        return newBitCount;
    }

    public static int getWidth(URL newFile) throws IOException {
        ImageInputStream newStream = ImageIO.createImageInputStream(newFile.openStream());
        int newWidth = BasicBMPImageIO.getWidth(newStream, true);
        newStream.close();
        return newWidth;
    }

    public static int getHeight(URL newFile) throws IOException {
        ImageInputStream newStream = ImageIO.createImageInputStream(newFile.openStream());
        int newHeight = BasicBMPImageIO.getHeight(newStream, true);
        newStream.close();
        return newHeight;
    }

    public static int getCompression(ImageInputStream newStream, boolean newReset) throws IOException {
        if (newReset) {
            newStream.mark();
        }
        byte[] FileHeaderBuffer = new byte[14];
        ByteBuffer FileHeader = ByteBuffer.wrap(FileHeaderBuffer);
        FileHeader.order(ByteOrder.LITTLE_ENDIAN);
        newStream.read(FileHeaderBuffer);
        FileHeader.rewind();
        byte[] InfoHeaderBuffer = new byte[40];
        ByteBuffer InfoHeader = ByteBuffer.wrap(InfoHeaderBuffer);
        InfoHeader.order(ByteOrder.LITTLE_ENDIAN);
        newStream.read(InfoHeaderBuffer);
        InfoHeader.rewind();
        if (newReset) {
            newStream.reset();
        }
        return InfoHeader.getInt(16);
    }

    public static int getBitCount(ImageInputStream newStream, boolean newReset) throws IOException {
        if (newReset) {
            newStream.mark();
        }
        byte[] FileHeaderBuffer = new byte[14];
        ByteBuffer FileHeader = ByteBuffer.wrap(FileHeaderBuffer);
        FileHeader.order(ByteOrder.LITTLE_ENDIAN);
        newStream.read(FileHeaderBuffer);
        FileHeader.rewind();
        byte[] InfoHeaderBuffer = new byte[40];
        ByteBuffer InfoHeader = ByteBuffer.wrap(InfoHeaderBuffer);
        InfoHeader.order(ByteOrder.LITTLE_ENDIAN);
        newStream.read(InfoHeaderBuffer);
        InfoHeader.rewind();
        if (newReset) {
            newStream.reset();
        }
        return InfoHeader.getShort(14);
    }

    public static int getWidth(ImageInputStream newStream, boolean newReset) throws IOException {
        if (newReset) {
            newStream.mark();
        }
        byte[] FileHeaderBuffer = new byte[14];
        ByteBuffer FileHeader = ByteBuffer.wrap(FileHeaderBuffer);
        FileHeader.order(ByteOrder.LITTLE_ENDIAN);
        newStream.read(FileHeaderBuffer);
        FileHeader.rewind();
        byte[] InfoHeaderBuffer = new byte[40];
        ByteBuffer InfoHeader = ByteBuffer.wrap(InfoHeaderBuffer);
        InfoHeader.order(ByteOrder.LITTLE_ENDIAN);
        newStream.read(InfoHeaderBuffer);
        InfoHeader.rewind();
        if (newReset) {
            newStream.reset();
        }
        return InfoHeader.getInt(4);
    }

    public static int getHeight(ImageInputStream newStream, boolean newReset) throws IOException {
        if (newReset) {
            newStream.mark();
        }
        byte[] FileHeaderBuffer = new byte[14];
        ByteBuffer FileHeader = ByteBuffer.wrap(FileHeaderBuffer);
        FileHeader.order(ByteOrder.LITTLE_ENDIAN);
        newStream.read(FileHeaderBuffer);
        FileHeader.rewind();
        byte[] InfoHeaderBuffer = new byte[40];
        ByteBuffer InfoHeader = ByteBuffer.wrap(InfoHeaderBuffer);
        InfoHeader.order(ByteOrder.LITTLE_ENDIAN);
        newStream.read(InfoHeaderBuffer);
        InfoHeader.rewind();
        if (newReset) {
            newStream.reset();
        }
        return InfoHeader.getInt(8);
    }

    public static void write(File newFile, BufferedImage newSource) throws IOException {
        BasicBMPImageIO.write(newFile, newSource, WorkingBitmapType);
    }

    public static void write(File newFile, BufferedImage newSource, int newType) throws IOException {
        if (!newFile.toString().endsWith("bmp")) {
            newFile = new File(newFile.toString() + ".bmp");
        }
        ImageOutputStream newStream = ImageIO.createImageOutputStream(newFile);
        BasicBMPImageIO.write(newStream, newSource, newType);
        newStream.close();
    }

    public static void write(ImageOutputStream newStream, BufferedImage newSource) throws IOException {
        BasicBMPImageIO.write(newStream, newSource, WorkingBitmapType);
    }

    public static void write(ImageOutputStream newStream, BufferedImage newSource, int newType) throws IOException {
        byte[] bfType = new byte[]{66, 77};
        int bfSize = 0;
        short bfReserved1 = 0;
        short bfReserved2 = 0;
        int bfOffBits = 54;
        int colspan = newSource.getColorModel().getNumComponents();
        int biSize = 40;
        int biWidth = newSource.getWidth();
        int biHeight = newType == 0 ? newSource.getHeight() : -newSource.getHeight();
        short biPlanes = 1;
        short biBitCount = (short)(colspan == 3 ? 24 : 32);
        int biCompression = 0;
        int biSizeImage = 0;
        int biXPelsPerMeter = 0;
        int biYPelsPerMeter = 0;
        int biClrUsed = 0;
        int biClrImportant = 0;
        int padcount = 4 - biWidth * colspan % 4;
        if (padcount == 4) {
            padcount = 0;
        }
        biSizeImage = biWidth * biHeight * colspan + padcount;
        bfSize = biSizeImage + 14 + 40;
        byte[] FileHeaderBuffer = new byte[14];
        ByteBuffer FileHeader = ByteBuffer.wrap(FileHeaderBuffer);
        FileHeader.order(ByteOrder.LITTLE_ENDIAN);
        FileHeader.put(bfType);
        FileHeader.putInt(bfSize);
        FileHeader.putShort(bfReserved1);
        FileHeader.putShort(bfReserved2);
        FileHeader.putInt(bfOffBits);
        FileHeader.rewind();
        byte[] InfoHeaderBuffer = new byte[40];
        ByteBuffer InfoHeader = ByteBuffer.wrap(InfoHeaderBuffer);
        InfoHeader.order(ByteOrder.LITTLE_ENDIAN);
        InfoHeader.putInt(biSize);
        InfoHeader.putInt(biWidth);
        InfoHeader.putInt(biHeight);
        InfoHeader.putShort(biPlanes);
        InfoHeader.putShort(biBitCount);
        InfoHeader.putInt(biCompression);
        InfoHeader.putInt(biSizeImage);
        InfoHeader.putInt(biXPelsPerMeter);
        InfoHeader.putInt(biYPelsPerMeter);
        InfoHeader.putInt(biClrUsed);
        InfoHeader.putInt(biClrImportant);
        InfoHeader.rewind();
        newStream.write(FileHeaderBuffer);
        newStream.write(InfoHeaderBuffer);
        DataBufferByte SourceDataBuffer = (DataBufferByte)newSource.getRaster().getDataBuffer();
        byte[] SourceData = SourceDataBuffer.getData();
        int rowspan = biWidth * colspan;
        byte[] pad = new byte[padcount];
        if (newType == 0) {
            for (int i = biHeight - 1; i >= 0; --i) {
                newStream.write(SourceData, i * rowspan, rowspan);
                newStream.write(pad);
            }
        } else if (biBitCount == 24) {
            for (int i = 0; i < biHeight; --i) {
                newStream.write(SourceData, i * rowspan, rowspan);
                newStream.write(pad);
            }
        } else {
            newStream.write(SourceData);
        }
    }

    public static void setWorkingBitmapType(int newType) {
        WorkingBitmapType = newType;
    }
}

