/*
 * Decompiled with CFR 0.152.
 */
package com.arc.imageio;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class BasicPMPImageIO {
    public static BufferedImage read(BufferedImage newTarget, File newFile) throws FileNotFoundException, IOException {
        FileChannel ImageResetSrcChannel = new FileInputStream(newFile).getChannel();
        ByteBuffer InfoHeader = ByteBuffer.allocate(16);
        InfoHeader.order(ByteOrder.LITTLE_ENDIAN);
        ImageResetSrcChannel.read(InfoHeader);
        InfoHeader.rewind();
        ImageResetSrcChannel.close();
        int newWidth = InfoHeader.getInt(0);
        int newHeight = InfoHeader.getInt(4);
        int newExpectedWidth = InfoHeader.getInt(8);
        int newExpectedHeight = InfoHeader.getInt(12);
        if (newTarget == null || newTarget.getWidth() != newWidth || newTarget.getHeight() != newHeight) {
            newTarget = new BufferedImage(newWidth, newHeight, 5);
        }
        DataBufferByte RestoreDataBuffer = (DataBufferByte)newTarget.getRaster().getDataBuffer();
        byte[] RestoreData = RestoreDataBuffer.getData();
        FileImageInputStream ImageRestoreStream = new FileImageInputStream(newFile);
        ImageRestoreStream.seek(16L);
        ImageRestoreStream.read(RestoreData);
        ImageRestoreStream.close();
        return newTarget;
    }

    public static BufferedImage read(BufferedImage newTarget, Rectangle newRegion, File newFile) throws FileNotFoundException, IOException {
        FileChannel ImageResetSrcChannel = new FileInputStream(newFile).getChannel();
        ByteBuffer InfoHeader = ByteBuffer.allocate(16);
        InfoHeader.order(ByteOrder.LITTLE_ENDIAN);
        ImageResetSrcChannel.read(InfoHeader);
        InfoHeader.rewind();
        ImageResetSrcChannel.close();
        int newWidth = InfoHeader.getInt(0);
        int newHeight = InfoHeader.getInt(4);
        int newExpectedWidth = InfoHeader.getInt(8);
        int newExpectedHeight = InfoHeader.getInt(12);
        if (newTarget == null || newTarget.getWidth() != newRegion.width || newTarget.getHeight() != newRegion.height) {
            newTarget = new BufferedImage(newRegion.width, newRegion.height, 5);
        }
        BufferedImage TempImage = new BufferedImage(newWidth, newHeight, 5);
        DataBufferByte RestoreDataBuffer = (DataBufferByte)TempImage.getRaster().getDataBuffer();
        byte[] RestoreData = RestoreDataBuffer.getData();
        FileImageInputStream ImageRestoreStream = new FileImageInputStream(newFile);
        ImageRestoreStream.seek(16L);
        ImageRestoreStream.read(RestoreData);
        ImageRestoreStream.close();
        Graphics2D g2d = newTarget.createGraphics();
        g2d.drawImage(TempImage, null, -newRegion.x, -newRegion.y);
        return newTarget;
    }

    public static BufferedImage readGrey(BufferedImage newTarget, File newFile) throws FileNotFoundException, IOException {
        FileChannel ImageResetSrcChannel = new FileInputStream(newFile).getChannel();
        ByteBuffer InfoHeader = ByteBuffer.allocate(16);
        InfoHeader.order(ByteOrder.LITTLE_ENDIAN);
        ImageResetSrcChannel.read(InfoHeader);
        InfoHeader.rewind();
        ImageResetSrcChannel.close();
        int newWidth = InfoHeader.getInt(0);
        int newHeight = InfoHeader.getInt(4);
        int newExpectedWidth = InfoHeader.getInt(8);
        int newExpectedHeight = InfoHeader.getInt(12);
        if (newTarget == null || newTarget.getWidth() != newWidth || newTarget.getHeight() != newHeight) {
            newTarget = new BufferedImage(newWidth, newHeight, 10);
        }
        DataBufferByte RestoreDataBuffer = (DataBufferByte)newTarget.getRaster().getDataBuffer();
        byte[] RestoreData = RestoreDataBuffer.getData();
        FileImageInputStream ImageRestoreStream = new FileImageInputStream(newFile);
        int rowspan = newWidth * 3;
        byte[] row = new byte[rowspan];
        ImageRestoreStream.seek(16L);
        int i = 0;
        int k = i * newWidth;
        while (i < newHeight) {
            ImageRestoreStream.read(row);
            int l = 0;
            int j = 0;
            while (l < newWidth) {
                RestoreData[k + l] = (byte)(((row[j] & 0xFF) + (row[j + 1] & 0xFF) + (row[j + 2] & 0xFF)) / 3);
                ++l;
                j += 3;
            }
            k = ++i * newWidth;
        }
        ImageRestoreStream.close();
        return newTarget;
    }

    public static int getWidth(File newFile) throws FileNotFoundException, IOException {
        FileChannel ImageResetSrcChannel = new FileInputStream(newFile).getChannel();
        ByteBuffer InfoHeader = ByteBuffer.allocate(16);
        InfoHeader.order(ByteOrder.LITTLE_ENDIAN);
        ImageResetSrcChannel.read(InfoHeader);
        InfoHeader.rewind();
        ImageResetSrcChannel.close();
        int newWidth = InfoHeader.getInt(0);
        int newHeight = InfoHeader.getInt(4);
        int newExpectedWidth = InfoHeader.getInt(8);
        int newExpectedHeight = InfoHeader.getInt(12);
        return newExpectedWidth;
    }

    public static int getHeight(File newFile) throws FileNotFoundException, IOException {
        FileChannel ImageResetSrcChannel = new FileInputStream(newFile).getChannel();
        ByteBuffer InfoHeader = ByteBuffer.allocate(16);
        InfoHeader.order(ByteOrder.LITTLE_ENDIAN);
        ImageResetSrcChannel.read(InfoHeader);
        InfoHeader.rewind();
        ImageResetSrcChannel.close();
        int newWidth = InfoHeader.getInt(0);
        int newHeight = InfoHeader.getInt(4);
        int newExpectedWidth = InfoHeader.getInt(8);
        int newExpectedHeight = InfoHeader.getInt(12);
        return newExpectedHeight;
    }

    public static BufferedImage read(BufferedImage newTarget, URL newFile) throws FileNotFoundException, IOException {
        InputStream newFileStream = newFile.openStream();
        MemoryCacheImageInputStream ImageRestoreStream = new MemoryCacheImageInputStream(newFileStream);
        byte[] FileHeaderBuffer = new byte[16];
        ByteBuffer FileHeader = ByteBuffer.wrap(FileHeaderBuffer);
        FileHeader.order(ByteOrder.LITTLE_ENDIAN);
        ImageRestoreStream.read(FileHeaderBuffer);
        FileHeader.rewind();
        int newWidth = FileHeader.getInt(0);
        int newHeight = FileHeader.getInt(4);
        int newExpectedWidth = FileHeader.getInt(0);
        int newExptetedHeight = FileHeader.getInt(4);
        if (newTarget == null || newTarget.getWidth() != newWidth || newTarget.getHeight() != newHeight) {
            newTarget = new BufferedImage(newWidth, newHeight, 5);
        }
        DataBufferByte RestoreDataBuffer = (DataBufferByte)newTarget.getRaster().getDataBuffer();
        byte[] RestoreData = RestoreDataBuffer.getData();
        ImageRestoreStream.read(RestoreData);
        ImageRestoreStream.close();
        newFileStream.close();
        return newTarget;
    }

    public static BufferedImage read(BufferedImage newTarget, Rectangle newRegion, URL newFile) throws FileNotFoundException, IOException {
        InputStream newFileStream = newFile.openStream();
        MemoryCacheImageInputStream ImageRestoreStream = new MemoryCacheImageInputStream(newFileStream);
        byte[] FileHeaderBuffer = new byte[16];
        ByteBuffer FileHeader = ByteBuffer.wrap(FileHeaderBuffer);
        FileHeader.order(ByteOrder.LITTLE_ENDIAN);
        ImageRestoreStream.read(FileHeaderBuffer);
        FileHeader.rewind();
        int newWidth = FileHeader.getInt(0);
        int newHeight = FileHeader.getInt(4);
        int newExpectedWidth = FileHeader.getInt(0);
        int newExptetedHeight = FileHeader.getInt(4);
        if (newTarget == null || newTarget.getWidth() != newRegion.width || newTarget.getHeight() != newRegion.height) {
            newTarget = new BufferedImage(newRegion.width, newRegion.height, 5);
        }
        BufferedImage TempImage = new BufferedImage(newWidth, newHeight, 5);
        DataBufferByte RestoreDataBuffer = (DataBufferByte)TempImage.getRaster().getDataBuffer();
        byte[] RestoreData = RestoreDataBuffer.getData();
        ImageRestoreStream.read(RestoreData);
        Graphics2D g2d = newTarget.createGraphics();
        g2d.drawImage(TempImage, null, -newRegion.x, -newRegion.y);
        ImageRestoreStream.close();
        newFileStream.close();
        return newTarget;
    }

    public static BufferedImage readGrey(BufferedImage newTarget, URL newFile) throws FileNotFoundException, IOException {
        InputStream newFileStream = newFile.openStream();
        MemoryCacheImageInputStream ImageRestoreStream = new MemoryCacheImageInputStream(newFileStream);
        byte[] FileHeaderBuffer = new byte[16];
        ByteBuffer FileHeader = ByteBuffer.wrap(FileHeaderBuffer);
        FileHeader.order(ByteOrder.LITTLE_ENDIAN);
        ImageRestoreStream.read(FileHeaderBuffer);
        FileHeader.rewind();
        int newWidth = FileHeader.getInt(0);
        int newHeight = FileHeader.getInt(4);
        int newExpectedWidth = FileHeader.getInt(0);
        int newExptetedHeight = FileHeader.getInt(4);
        if (newTarget == null || newTarget.getWidth() != newWidth || newTarget.getHeight() != newHeight) {
            newTarget = new BufferedImage(newWidth, newHeight, 10);
        }
        DataBufferByte RestoreDataBuffer = (DataBufferByte)newTarget.getRaster().getDataBuffer();
        byte[] RestoreData = RestoreDataBuffer.getData();
        int rowspan = newWidth * 3;
        byte[] row = new byte[rowspan];
        int i = 0;
        int k = i * newWidth;
        while (i < newWidth) {
            ImageRestoreStream.read(row);
            int l = 0;
            int j = 0;
            while (l < newWidth) {
                RestoreData[k + l] = (byte)(((row[j] & 0xFF) + (row[j + 1] & 0xFF) + (row[j + 2] & 0xFF)) / 3);
                ++l;
                j += 3;
            }
            k = --i * newWidth;
        }
        ImageRestoreStream.close();
        newFileStream.close();
        return newTarget;
    }

    public static int getWidth(URL newFile) throws FileNotFoundException, IOException {
        InputStream newFileStream = newFile.openStream();
        MemoryCacheImageInputStream ImageRestoreStream = new MemoryCacheImageInputStream(newFileStream);
        byte[] FileHeaderBuffer = new byte[16];
        ByteBuffer FileHeader = ByteBuffer.wrap(FileHeaderBuffer);
        FileHeader.order(ByteOrder.LITTLE_ENDIAN);
        ImageRestoreStream.read(FileHeaderBuffer);
        FileHeader.rewind();
        int newWidth = FileHeader.getInt(0);
        int newHeight = FileHeader.getInt(4);
        int newExpectedWidth = FileHeader.getInt(0);
        int newExptetedHeight = FileHeader.getInt(4);
        return newWidth;
    }

    public static int getHeight(URL newFile) throws FileNotFoundException, IOException {
        InputStream newFileStream = newFile.openStream();
        MemoryCacheImageInputStream ImageRestoreStream = new MemoryCacheImageInputStream(newFileStream);
        byte[] FileHeaderBuffer = new byte[16];
        ByteBuffer FileHeader = ByteBuffer.wrap(FileHeaderBuffer);
        FileHeader.order(ByteOrder.LITTLE_ENDIAN);
        ImageRestoreStream.read(FileHeaderBuffer);
        FileHeader.rewind();
        int newWidth = FileHeader.getInt(0);
        int newHeight = FileHeader.getInt(4);
        int newExpectedWidth = FileHeader.getInt(0);
        int newExptetedHeight = FileHeader.getInt(4);
        return newHeight;
    }

    public static File write(BufferedImage newTarget, File newFile) throws FileNotFoundException, IOException {
        if (!newFile.toString().endsWith("pmp")) {
            newFile = new File(newFile.toString() + ".pmp");
        }
        ByteBuffer FileHeader = ByteBuffer.allocate(16);
        FileHeader.order(ByteOrder.LITTLE_ENDIAN);
        FileHeader.putInt(newTarget.getWidth());
        FileHeader.putInt(newTarget.getHeight());
        FileHeader.putInt(newTarget.getWidth());
        FileHeader.putInt(newTarget.getHeight());
        FileHeader.rewind();
        FileOutputStream ImageRestoreSrcStream = new FileOutputStream(newFile);
        FileChannel ImageRestoreSrcChannel = new FileOutputStream(newFile).getChannel();
        ImageRestoreSrcChannel.write(FileHeader);
        ImageRestoreSrcChannel.force(false);
        ImageRestoreSrcChannel.close();
        ImageRestoreSrcStream.close();
        DataBufferByte RestoreDataBuffer = (DataBufferByte)newTarget.getRaster().getDataBuffer();
        byte[] RestoreData = RestoreDataBuffer.getData();
        FileImageOutputStream ImageRestoreStream = new FileImageOutputStream(newFile);
        ImageRestoreStream.seek(16L);
        ImageRestoreStream.write(RestoreData);
        ImageRestoreStream.close();
        return newFile;
    }
}

