/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.server;

import com.sun.xml.internal.stream.buffer.XMLStreamBuffer;
import com.sun.xml.internal.ws.api.streaming.XMLStreamReaderFactory;
import com.sun.xml.internal.ws.streaming.TidyXMLStreamReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class SDDocumentSource {
    public abstract XMLStreamReader read(XMLInputFactory var1) throws IOException, XMLStreamException;

    public abstract XMLStreamReader read() throws IOException, XMLStreamException;

    public abstract URL getSystemId();

    public static SDDocumentSource create(final URL uRL) {
        return new SDDocumentSource(){
            private final URL systemId;
            {
                this.systemId = uRL;
            }

            public XMLStreamReader read(XMLInputFactory xMLInputFactory) throws IOException, XMLStreamException {
                InputStream inputStream = uRL.openStream();
                return new TidyXMLStreamReader(xMLInputFactory.createXMLStreamReader(this.systemId.toExternalForm(), inputStream), inputStream);
            }

            public XMLStreamReader read() throws IOException, XMLStreamException {
                InputStream inputStream = uRL.openStream();
                return new TidyXMLStreamReader(XMLStreamReaderFactory.create(this.systemId.toExternalForm(), inputStream, false), inputStream);
            }

            public URL getSystemId() {
                return this.systemId;
            }
        };
    }

    public static SDDocumentSource create(final URL uRL, final XMLStreamBuffer xMLStreamBuffer) {
        return new SDDocumentSource(){

            public XMLStreamReader read(XMLInputFactory xMLInputFactory) throws XMLStreamException {
                return xMLStreamBuffer.readAsXMLStreamReader();
            }

            public XMLStreamReader read() throws XMLStreamException {
                return xMLStreamBuffer.readAsXMLStreamReader();
            }

            public URL getSystemId() {
                return uRL;
            }
        };
    }
}

