/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.sourcelibrary;

import com.Fo2PiX.sourcelibrary.sourcelibraryservice.SourceLibraryServiceUtils;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class SourceLibraryCache {
    public static final String GROUP_VIEW_ALL = "All";
    private static final boolean GROUP_VIEW_ALL_ENABLED = false;
    private Map<String, ImageInfo> ImageIDMap;
    private Map<String, CategoryInfo> ImageCategoryMap;
    private Map<String, String[]> SetList;
    private String[] SetListNames;
    private String[] ImageCategoryList;
    private String[] NonCachableCategories;
    private Map<String, String> CatSetMap;

    public SourceLibraryCache(String[] newImageCategorySetList, String[] newImageCategoryList, String[] newDymanicCategoryList) {
        int i;
        this.ImageCategoryList = newImageCategoryList;
        this.SetList = Collections.synchronizedMap(new HashMap());
        this.CatSetMap = Collections.synchronizedMap(new HashMap());
        String All = GROUP_VIEW_ALL;
        this.SetList.put(All, this.ImageCategoryList);
        String Solid = "Solid Colours";
        this.CatSetMap.put(Solid, SourceLibraryServiceUtils.getValueList(newImageCategorySetList[0], 0)[0]);
        String[] SetListNamesTemp = new String[newImageCategorySetList.length];
        for (i = 0; i < newImageCategorySetList.length; ++i) {
            String[] FullCatList = SourceLibraryServiceUtils.getValueList(newImageCategorySetList[i], 0);
            String[] CatList = new String[FullCatList.length - 1];
            System.arraycopy(FullCatList, 1, CatList, 0, CatList.length);
            this.SetList.put(FullCatList[0], CatList);
            for (String Cat : CatList) {
                this.CatSetMap.put(Cat, FullCatList[0]);
            }
            SetListNamesTemp[i] = FullCatList[0];
        }
        this.SetListNames = SetListNamesTemp;
        this.NonCachableCategories = newDymanicCategoryList;
        this.ImageIDMap = Collections.synchronizedMap(new HashMap());
        this.ImageCategoryMap = Collections.synchronizedMap(new HashMap());
        for (i = 0; i < this.ImageCategoryList.length; ++i) {
            String CurrentID = this.ImageCategoryList[i];
            if (SourceLibraryServiceUtils.containsValue(this.NonCachableCategories, CurrentID)) continue;
            this.ImageCategoryMap.put(CurrentID, new CategoryInfo(CurrentID));
        }
    }

    public void flushThumbnailCache() {
        ImageInfo[] CurrentImageInfoCache = (ImageInfo[])this.ImageIDMap.values().toArray();
        for (int i = 0; i < CurrentImageInfoCache.length; ++i) {
            CurrentImageInfoCache[i].setThumbnailImage(null);
        }
    }

    public void flushImageCache() {
        ImageInfo[] CurrentImageInfoCache = (ImageInfo[])this.ImageIDMap.values().toArray();
        for (int i = 0; i < CurrentImageInfoCache.length; ++i) {
            CurrentImageInfoCache[i].setSourceImage(null);
        }
    }

    public void flushCache() {
        this.flushThumbnailCache();
        this.flushImageCache();
    }

    public String[] getImageCategorySubsetList() {
        return this.SetListNames;
    }

    public String[] getImageCategorySubsetListContents(String Id) {
        return this.SetList.get(Id);
    }

    public String[] getImageCategoryList() {
        return this.ImageCategoryList;
    }

    public String getImageCategorySubset(String Id) {
        return this.CatSetMap.get(Id);
    }

    public void cacheImageList(String newCategoryID, String[][] newImageList) {
        CategoryInfo CurrentInfo;
        for (int i = 0; i < newImageList.length; ++i) {
            for (int j = 0; j < newImageList[i].length; ++j) {
                if (this.ImageIDMap.containsKey(newImageList[i][j])) continue;
                this.ImageIDMap.put(newImageList[i][j], new ImageInfo(newImageList[i][j]));
            }
        }
        if (!SourceLibraryServiceUtils.containsValue(this.NonCachableCategories, newCategoryID) && this.ImageCategoryMap.containsKey(newCategoryID) && (CurrentInfo = this.ImageCategoryMap.get(newCategoryID)) != null && CurrentInfo.getImageIDList() == null) {
            CurrentInfo.setImageIDList(newImageList);
        }
    }

    public String[][] getImageList(String newCategoryID) {
        if (this.ImageCategoryMap.containsKey(newCategoryID)) {
            return this.ImageCategoryMap.get(newCategoryID).getImageIDList();
        }
        return null;
    }

    public void cacheThumbnail(String newImageID, URL newThumbnail) {
        if (!this.ImageIDMap.containsKey(newImageID)) {
            this.ImageIDMap.put(newImageID, new ImageInfo(newImageID));
        }
        this.ImageIDMap.get(newImageID).setThumbnailImage(newThumbnail);
    }

    public URL getThumbnail(String newImageID) {
        if (this.ImageIDMap.containsKey(newImageID)) {
            return this.ImageIDMap.get(newImageID).getThumbnailImage();
        }
        return null;
    }

    public void cacheImage(String newImageID, URL newImage) {
        if (!this.ImageIDMap.containsKey(newImageID)) {
            this.ImageIDMap.put(newImageID, new ImageInfo(newImageID));
        }
        this.ImageIDMap.get(newImageID).setSourceImage(newImage);
    }

    public URL getImage(String newImageID) {
        if (this.ImageIDMap.containsKey(newImageID)) {
            return this.ImageIDMap.get(newImageID).getSourceImage();
        }
        return null;
    }

    private class CategoryInfo {
        private String ID;
        private String[][] ImageIDList;

        public CategoryInfo(String newID) {
            this.ID = newID;
            this.ImageIDList = null;
        }

        public void setImageIDList(String[][] newImageIDList) {
            this.ImageIDList = newImageIDList;
        }

        public String[][] getImageIDList() {
            return this.ImageIDList == null ? (String[][])null : this.ImageIDList;
        }

        public String getID() {
            return this.ID;
        }
    }

    private class ImageInfo {
        private String ID;
        private URL SourceImage = null;
        private URL ThumbnailImage = null;

        public ImageInfo(String newID) {
            this.ID = newID;
        }

        public void setSourceImage(URL newImageURL) {
            this.SourceImage = newImageURL;
        }

        public URL getSourceImage() {
            return this.SourceImage;
        }

        public void setThumbnailImage(URL newThumbnailImage) {
            this.ThumbnailImage = newThumbnailImage;
        }

        public URL getThumbnailImage() {
            return this.ThumbnailImage;
        }

        public String getID() {
            return this.ID;
        }
    }
}

