/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.sourcelibrary;

import com.Fo2PiX.blendengine.operation.OpInfo;
import com.Fo2PiX.sourcelibrary.SourceLibrary;
import com.Fo2PiX.sourcelibrary.SourceLibraryCache;
import com.Fo2PiX.sourcelibrary.SourceLibraryEditor;
import com.Fo2PiX.sourcelibrary.sourcelibraryservice.SourceLibraryService;
import com.Fo2PiX.sourcelibrary.sourcelibraryservice.SourceLibraryServiceFactory;
import com.Fo2PiX.sourcelibrary.sourcelibraryservice.SourceLibraryServiceUtils;
import com.arc.awt.event.ProgressListener;
import com.arc.imageio.BasicBMPImageIO;
import com.arc.net.util.URLs;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import javax.imageio.ImageIO;

class SourceLibraryImplNativeService
implements SourceLibrary {
    protected SourceLibraryService LibraryEngine;
    protected Dimension ThumbnailSize;
    protected Dimension SourceSize;
    protected String LibraryRoot;
    protected String SourceImage;
    protected File WorkFolder;
    protected int LibraryType = 0;
    protected SourceLibraryCache LibraryCache;
    protected int LibraryServiceCallingConvention;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SourceLibraryImplNativeService(URL newSource, File newWorkFolder, File newMountPoint, String newServer, ProgressListener newProgressProc) throws UnknownHostException, IOException {
        String LaunchCommand;
        String TextureTabName;
        String KeepTabName;
        String UserTabName;
        this.LibraryEngine = SourceLibraryServiceFactory.getSourceLibrary(newSource, newMountPoint, newServer, newProgressProc);
        this.LibraryServiceCallingConvention = 0;
        String LaunchMessage = this.LibraryEngine.sendMessage("startprocess=[yes] image_filetype=[bmp]", null, null, newProgressProc);
        String Error = SourceLibraryServiceUtils.getValue(LaunchMessage, "error");
        if (Error != null) {
            throw new IOException(Error);
        }
        if (newProgressProc != null) {
            newProgressProc.progressEvent(newProgressProc.getProgressMessage() + ".");
        }
        int ThumbnailWidth = Integer.parseInt(SourceLibraryServiceUtils.getValue(LaunchMessage, "cols"));
        int ThumbnailHeight = Integer.parseInt(SourceLibraryServiceUtils.getValue(LaunchMessage, "rows"));
        int SourceWidth = Integer.parseInt(SourceLibraryServiceUtils.getValue(LaunchMessage, "layered_cols"));
        int SourceHeight = Integer.parseInt(SourceLibraryServiceUtils.getValue(LaunchMessage, "layered_rows"));
        this.ThumbnailSize = new Dimension(ThumbnailWidth, ThumbnailHeight);
        this.SourceSize = new Dimension(SourceWidth, SourceHeight);
        this.LibraryRoot = SourceLibraryServiceUtils.getValue(LaunchMessage, "discdrive");
        if (this.LibraryRoot == null || (UserTabName = SourceLibraryServiceUtils.getValue(LaunchMessage, "tab_user")) == null || (KeepTabName = SourceLibraryServiceUtils.getValue(LaunchMessage, "tab_keep")) == null || (this.SourceImage = SourceLibraryServiceUtils.getValue(LaunchMessage, "output")) == null || (TextureTabName = SourceLibraryServiceUtils.getValue(LaunchMessage, "tab_texture")) == null || (LaunchCommand = SourceLibraryServiceUtils.getValue(LaunchMessage, "output_buttons")) == null) throw new IOException("Invalid library parameters");
        LaunchMessage = "startprocess=[no] select_picture=[" + this.SourceImage + "] select_button=[" + LaunchCommand + "]";
        LaunchMessage = this.LibraryEngine.sendMessage(LaunchMessage, null, null, newProgressProc);
        if (newProgressProc != null) {
            newProgressProc.progressEvent(newProgressProc.getProgressMessage() + ".");
        }
        if ((Error = SourceLibraryServiceUtils.getValue(LaunchMessage, "error")) != null) {
            throw new IOException(Error);
        }
        String[] FullSetList = SourceLibraryServiceUtils.getValueList(LaunchMessage, "output_buttons", 0);
        if (FullSetList == null) throw new IOException("Empty category list");
        String[] SetList = SourceLibraryServiceUtils.filterValueList(FullSetList, new String[]{KeepTabName, UserTabName, TextureTabName});
        String[] SubsetList = SourceLibraryServiceUtils.getSubsetList(SourceLibraryServiceUtils.getValue(LaunchMessage, "subsets"));
        System.out.println(UserTabName);
        System.out.println(KeepTabName);
        System.out.println(TextureTabName);
        for (int i = 0; i < FullSetList.length; ++i) {
            System.out.println(FullSetList[i]);
        }
        this.LibraryCache = new SourceLibraryCache(SubsetList, SetList, new String[0]);
        LaunchMessage = null;
        LaunchCommand = null;
        newWorkFolder = null;
        FullSetList = null;
        newSource = null;
        newServer = null;
        System.gc();
    }

    @Override
    public String[] getGrpList(String newGrpListVw, ProgressListener newProgressProc) {
        if (newGrpListVw == null) {
            return this.LibraryCache.getImageCategoryList();
        }
        return this.LibraryCache.getImageCategorySubsetListContents(newGrpListVw);
    }

    @Override
    public String getGrpName(String newCategoryID, ProgressListener newProgressProc) {
        if (newCategoryID != null) {
            return SourceLibraryServiceUtils.getDisplayName(newCategoryID, "_T_");
        }
        return null;
    }

    @Override
    public String getGrpView(String newGrp, ProgressListener newProgressProc) {
        return this.LibraryCache.getImageCategorySubset(newGrp);
    }

    @Override
    public String[][] getSrcList(String newCategoryID, ProgressListener newProgressProc) {
        if (newCategoryID != null) {
            if (newProgressProc != null && !newProgressProc.progressEvent("Checking data cache...")) {
                return null;
            }
            String[][] CategoryList = this.LibraryCache.getImageList(newCategoryID);
            if (CategoryList != null) {
                return CategoryList;
            }
            if (newProgressProc != null && !newProgressProc.progressEvent("No cache found, generating requested image list...")) {
                return null;
            }
            String RequestMessage = "startprocess=[no] select_picture=[" + this.SourceImage + "] select_button=[" + newCategoryID + "]";
            RequestMessage = this.LibraryEngine.sendMessage(RequestMessage, null, null, newProgressProc);
            CategoryList = SourceLibraryServiceUtils.splitValueList(SourceLibraryServiceUtils.getValueList(RequestMessage, "output_names", 0), SourceLibraryServiceUtils.getValue(RequestMessage, "output_names_break"));
            this.LibraryCache.cacheImageList(newCategoryID, CategoryList);
            return CategoryList;
        }
        return null;
    }

    @Override
    public String getSrcName(String newImageID, ProgressListener newProgressProc) {
        if (newImageID != null) {
            String DispName = SourceLibraryServiceUtils.getDisplayName(newImageID, "_P_");
            return DispName.substring(0, DispName.length() - 1);
        }
        return null;
    }

    @Override
    public String getSrcGrp(String newImageID, ProgressListener newProgressProc) {
        if (newImageID != null) {
            if (newProgressProc != null && !newProgressProc.progressEvent("Checking data cache...")) {
                return null;
            }
            String RequestMessage = "startprocess=[no] want_layer=[" + newImageID + "]";
            RequestMessage = this.LibraryEngine.sendMessage(RequestMessage, null, null, newProgressProc);
            return SourceLibraryServiceUtils.getValue(RequestMessage, "style_name");
        }
        return null;
    }

    @Override
    public String getSrcLocalName(String newImageID, ProgressListener newProgressProc) {
        if (newImageID != null) {
            String Grp = this.getSrcGrp(newImageID, null);
            String[][] GrpSrcList = this.getSrcList(Grp, null);
            for (int i = 0; i < GrpSrcList[0].length; ++i) {
                if (!GrpSrcList[0][i].equals(newImageID)) continue;
                return String.valueOf(i + 1);
            }
            return String.valueOf(-1);
        }
        return null;
    }

    public URL getSrcThmb(String newImageID, ProgressListener newProgressProc) {
        try {
            if (newImageID != null) {
                if (newProgressProc != null && !newProgressProc.progressEvent("Checking data cache...")) {
                    return null;
                }
                URL Thumbnail = this.LibraryCache.getThumbnail(newImageID);
                if (Thumbnail != null) {
                    return Thumbnail;
                }
                if (newProgressProc != null && !newProgressProc.progressEvent("No cache found, generating requested thumbnail...")) {
                    return null;
                }
                String RequestMessage = "startprocess=[no] want_picture=[" + newImageID + "]";
                RequestMessage = this.LibraryEngine.sendMessage(RequestMessage, null, null, newProgressProc);
                Thumbnail = new URL(SourceLibraryServiceUtils.getURL(this.LibraryRoot, SourceLibraryServiceUtils.getValue(RequestMessage, "output"), "bmp"));
                this.LibraryCache.cacheThumbnail(newImageID, Thumbnail);
                return Thumbnail;
            }
            return null;
        }
        catch (MalformedURLException Ex) {
            return null;
        }
    }

    @Override
    public URL getSrc(String newImageID, Dimension newSrcSize, ProgressListener newProgressProc) {
        try {
            String RequestMessage;
            if (newImageID == null) {
                newImageID = "z_0/x0/1_P_16_";
            }
            if (newSrcSize != null && newSrcSize.equals(this.ThumbnailSize)) {
                return this.getSrcThmb(newImageID, newProgressProc);
            }
            if (newProgressProc != null && !newProgressProc.progressEvent("Checking data cache...")) {
                return null;
            }
            URL Image2 = this.LibraryCache.getImage(newImageID);
            if (Image2 != null) {
                return Image2;
            }
            if (newProgressProc != null && !newProgressProc.progressEvent("Generating requested image...")) {
                return null;
            }
            if (this.LibraryServiceCallingConvention == 0) {
                RequestMessage = "startprocess=[no] iwant_layer=[" + newImageID + "]";
                String Required = SourceLibraryServiceUtils.getValue(RequestMessage = this.LibraryEngine.sendMessage(RequestMessage, null, null, newProgressProc), "irequire");
                if (Required != null) {
                    if (newProgressProc != null && !newProgressProc.progressEvent("Generating Required image components...")) {
                        return null;
                    }
                    String[] RequireList = SourceLibraryServiceUtils.getValueList(Required, 0);
                    for (int i = RequireList.length - 1; i >= 0; --i) {
                        if (newProgressProc != null && !newProgressProc.progressEvent("Generating image " + this.getSrcName(RequireList[i], newProgressProc) + "...")) {
                            return null;
                        }
                        RequestMessage = "startprocess=[no] iwant_layer=[" + RequireList[i] + "]";
                        RequestMessage = this.LibraryEngine.sendMessage(RequestMessage, null, null, null);
                        Thread.yield();
                    }
                }
            } else {
                RequestMessage = "startprocess=[no] want_layer=[" + newImageID + "]";
                RequestMessage = this.LibraryEngine.sendMessage(RequestMessage, null, null, newProgressProc);
            }
            Image2 = new URL(SourceLibraryServiceUtils.getURL(this.LibraryRoot, SourceLibraryServiceUtils.getValue(RequestMessage, "output_layers"), "bmp"));
            this.LibraryCache.cacheImage(newImageID, Image2);
            if (newProgressProc != null && !newProgressProc.progressEvent("Caching requested image...")) {
                return null;
            }
            return Image2;
        }
        catch (MalformedURLException Ex) {
            return null;
        }
    }

    @Override
    public URL getSrc(Dimension newSrcSize, ProgressListener newProgressProc) {
        return this.getSrc("z_0/x0/1_P_16_", newSrcSize, newProgressProc);
    }

    @Override
    public SourceLibraryEditor getEdtr(ProgressListener newProgressProc) {
        return null;
    }

    @Override
    public String[] getVwList(ProgressListener newProgressProc) {
        return this.LibraryCache.getImageCategorySubsetList();
    }

    @Override
    public String getVwName(String newVw, ProgressListener newProgressProc) {
        return newVw;
    }

    @Override
    public URL close(ProgressListener newProgressProc) {
        this.LibraryEngine.sendMessage("startprocess=[closeController]", null, null, newProgressProc);
        return null;
    }

    @Override
    public OpInfo[] getSrcScrpt(String newImageID, ProgressListener newProgressProc) {
        if (newImageID.indexOf("-") >= 0) {
            String Script = newImageID.substring(newImageID.indexOf("-") + 1, newImageID.length());
            String x = Script.substring(Script.indexOf("x") + 1, Script.indexOf("y"));
            String y = Script.substring(Script.indexOf("y") + 1, Script.indexOf("x", Script.indexOf("x") + 1));
            String x1 = Script.substring(Script.indexOf("x", Script.indexOf("y")) + 1, Script.indexOf("y", Script.indexOf("y") + 1));
            String y1 = Script.substring(Script.indexOf("y", Script.indexOf("y") + 1) + 1, Script.length());
            System.out.println("IMAGE SCRIPT = " + Script);
            System.out.println("IMAGE SCRIPT Ps = " + x + " " + y + " " + x1 + " " + y1);
            return null;
        }
        return null;
    }

    @Override
    public OpInfo[] getSrcLinkScrpt(String newImageID, ProgressListener newProgressProc) {
        if (newImageID.indexOf("-") >= 0) {
            String Script = newImageID.substring(newImageID.indexOf("-") + 1, newImageID.length());
            String x = Script.substring(Script.indexOf("x") + 1, Script.indexOf("y"));
            String y = Script.substring(Script.indexOf("y") + 1, Script.indexOf("x", Script.indexOf("x") + 1));
            String x1 = Script.substring(Script.indexOf("x", Script.indexOf("y")) + 1, Script.indexOf("y", Script.indexOf("y") + 1));
            String y1 = Script.substring(Script.indexOf("y", Script.indexOf("y") + 1) + 1, Script.length());
            System.out.println("IMAGE SCRIPT = " + Script);
            System.out.println("IMAGE SCRIPT Ps = " + x + " " + y + " " + x1 + " " + y1);
            return null;
        }
        return null;
    }

    @Override
    public int getType(ProgressListener newProgressProc) {
        return this.LibraryType;
    }

    @Override
    public String getID(ProgressListener newProgressProc) {
        return "Library 1";
    }

    public String getFormat(ProgressListener newProgressProc) {
        return null;
    }

    @Override
    public Dimension getSrcSize(String newImageID, ProgressListener newProgressProc) {
        return this.SourceSize;
    }

    @Override
    public Dimension getSrcSize(String newSrc, Dimension newSize, int newType, ProgressListener newProgressProc) {
        switch (newType) {
            case 0: {
                return SourceLibraryServiceUtils.getFillSize(this.SourceSize, newSize);
            }
        }
        return SourceLibraryServiceUtils.getFitSize(this.SourceSize, newSize);
    }

    public Dimension getSrcThmbSize(ProgressListener newProgressProc) {
        return this.ThumbnailSize;
    }

    @Override
    public void save(OutputStream newOutputStream, ProgressListener newProgressProc) {
        try {
            BufferedImage SourceImage = null;
            URL SourceURL = this.getSrc(null, null);
            String Ex = URLs.getExtension((URL)SourceURL);
            SourceImage = Ex.equals("bmp") ? BasicBMPImageIO.read((URL)SourceURL, (BufferedImage)SourceImage, null, null) : ImageIO.read(SourceURL);
            ImageIO.write((RenderedImage)SourceImage, "png", newOutputStream);
        }
        catch (IOException Ex) {
            Ex.printStackTrace();
        }
    }

    @Override
    public void backup(File newLocation, ProgressListener newProgressProc) {
        String RequestMessage = "startprocess=[backup] select_folder=[" + newLocation.toString() + "]";
        RequestMessage = this.LibraryEngine.sendMessage(RequestMessage, null, null, newProgressProc);
    }

    @Override
    public void restore(File newLocation, ProgressListener newProgressProc) {
        String RequestMessage = "startprocess=[restore] select_folder=[" + newLocation.toString() + "]";
        RequestMessage = this.LibraryEngine.sendMessage(RequestMessage, null, null, newProgressProc);
    }
}

