/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.sourcelibrary.sourcelibraryservice;

import com.Fo2PiX.sourcelibrary.sourcelibraryservice.SourceLibraryServiceUtils;
import com.arc.imageio.BasicBMPImageIO;
import com.arc.imageio.BasicPMPImageIO;
import com.arc.io.util.Files;
import com.arc.net.util.URLs;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URL;
import javax.imageio.ImageIO;

class SourceLibraryServiceImplBase {
    protected static final Dimension DEFAULT_LIBRARY_SERVICE_THUMBNAIL_SIZE = new Dimension(80, 80);
    protected static final String DATA_FOLDER = "sessiondata";
    protected static final String OUTPUT_BUFFER = "keepbuffer";
    protected File SessionMntPoint;
    protected File SessionDataMntPoint;
    protected String SessionDataMntPointURL;

    SourceLibraryServiceImplBase() {
    }

    protected void InitService(URL newInitData) throws IOException {
        this.InitService(newInitData, DEFAULT_LIBRARY_SERVICE_THUMBNAIL_SIZE);
    }

    private void InitService(URL newInitData, Dimension newThumbnailSize) throws IOException {
        if (this.SessionMntPoint.isDirectory()) {
            Files.deleteFolderContents((File)this.SessionMntPoint);
        } else {
            this.SessionMntPoint.mkdir();
        }
        this.SessionDataMntPoint.mkdir();
        BufferedImage InitImage = null;
        InitImage = URLs.getExtension((URL)newInitData).equals("bmp") ? BasicBMPImageIO.read((URL)newInitData, null, null, null) : (URLs.getExtension((URL)newInitData).equals("pmp") ? BasicPMPImageIO.read(null, (URL)newInitData) : ImageIO.read(newInitData));
        if ("bmp".toLowerCase().equals("bmp")) {
            BasicBMPImageIO.write((File)new File(this.SessionMntPoint, "Src.bmp"), (BufferedImage)InitImage);
            BasicBMPImageIO.write((File)new File(this.SessionDataMntPoint, "keepbuffer.bmp"), (BufferedImage)InitImage);
        } else if ("bmp".toLowerCase().equals("pmp")) {
            BasicPMPImageIO.write((BufferedImage)InitImage, (File)new File(this.SessionMntPoint, "Src.bmp"));
            BasicPMPImageIO.write((BufferedImage)InitImage, (File)new File(this.SessionDataMntPoint, "keepbuffer.bmp"));
        } else {
            ImageIO.write((RenderedImage)InitImage, "bmp", new File(this.SessionMntPoint, "Src.bmp"));
            ImageIO.write((RenderedImage)InitImage, "bmp", new File(this.SessionDataMntPoint, "keepbuffer.bmp"));
        }
        Dimension SourceSize = new Dimension(InitImage.getWidth(), InitImage.getHeight());
        Dimension ThumbnailSize = SourceLibraryServiceUtils.getFillSize(SourceSize, newThumbnailSize);
        ObjectOutputStream e = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(new File(this.SessionMntPoint, "Src.nfo"))));
        e.writeObject(SourceSize);
        e.writeObject(ThumbnailSize);
        e.close();
    }
}

