/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.sourcelibrary.sourcelibraryservice;

import com.Fo2PiX.sourcelibrary.sourcelibraryservice.SourceLibraryServiceImplNativeLclSktStb;
import com.arc.awt.event.ProgressListener;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;

public class SourceLibraryServiceUtils {
    public static final int DEFAULT_SERVICE_CONNECTIONS = 10;
    public static final int DEFAULT_SERVICE_PORT = 666;
    public static final String DEFAULT_SERVICE_ID = "pamsession";
    public static final String IMAGE_ID_KEY = "_P_";
    public static final String CATEGORY_ID_KEY = "_T_";
    public static final String INIT_OPEN = "startprocess=[open]";
    public static final String INIT_NEW = "startprocess=[ok]";

    public static String getServer(String newServer) {
        int pos;
        if (newServer != null && (pos = newServer.indexOf(":")) >= 0) {
            return newServer.substring(0, pos);
        }
        return newServer;
    }

    public static int getPort(String newServer) {
        int pos;
        if (newServer != null && (pos = newServer.indexOf(":")) >= 0) {
            return Integer.parseInt(newServer.substring(pos + 1, newServer.length()));
        }
        return 666;
    }

    public static String setValue(String newMessage, String newKey, String newValue) {
        String Message = "";
        String TaggedKey = "";
        TaggedKey = newKey + "=[";
        int InstructionIndex = 0;
        if (newMessage.length() > 0) {
            InstructionIndex = newMessage.indexOf(TaggedKey);
            if (InstructionIndex >= 0) {
                Message = newMessage.substring(0, InstructionIndex + TaggedKey.length());
                Message = Message + newValue + newMessage.substring(newMessage.indexOf("]", InstructionIndex));
            } else {
                Message = newMessage + " " + newKey + "=[" + newValue + "]";
            }
        }
        return Message;
    }

    public static String getValue(String newMessage, String newKey) {
        String Value = "";
        String TaggedKey = "";
        TaggedKey = newKey + "=";
        int InstructionIndex = 0;
        if (newMessage.length() > 0 && (InstructionIndex = newMessage.indexOf(TaggedKey)) >= 0) {
            Value = newMessage.substring(InstructionIndex + (TaggedKey.length() + 1), newMessage.indexOf("]", InstructionIndex + TaggedKey.length()));
        }
        if (Value.equals("")) {
            return null;
        }
        return Value.trim();
    }

    public static String[] getValueList(String newValueList, int newStart) {
        ArrayList<String> ButtonList = new ArrayList<String>();
        int BPos = 0;
        int Pos = newValueList.indexOf(",");
        int EntryCounter = 0;
        String NewEntry = null;
        while (Pos >= 0) {
            NewEntry = newValueList.substring(BPos, Pos);
            if (EntryCounter >= newStart) {
                ButtonList.add(NewEntry.trim());
            }
            ++EntryCounter;
            BPos = Pos + 1;
            Pos = newValueList.indexOf(",", BPos);
        }
        String last = newValueList.substring(BPos, newValueList.length());
        if (last.length() > 0) {
            ButtonList.add(last.trim());
        }
        if (ButtonList.size() > 0) {
            String[] ReturnArray = new String[ButtonList.size()];
            return ButtonList.toArray(ReturnArray);
        }
        return null;
    }

    public static String[] getValueList(String newMessage, String newKey, int newStart) {
        String newValueList = "";
        String TaggedKey = "";
        TaggedKey = newKey + "=";
        int InstructionIndex = 0;
        if (newMessage.length() > 0 && (InstructionIndex = newMessage.indexOf(TaggedKey)) >= 0) {
            newValueList = newMessage.substring(InstructionIndex + (TaggedKey.length() + 1), newMessage.indexOf("]", InstructionIndex + TaggedKey.length()));
        }
        if (newValueList.equals("")) {
            return null;
        }
        ArrayList<String> ValueList = new ArrayList<String>();
        int BPos = 0;
        int Pos = newValueList.indexOf(",");
        int EntryCounter = 0;
        String NewEntry = null;
        while (Pos >= 0) {
            NewEntry = newValueList.substring(BPos, Pos);
            if (EntryCounter >= newStart) {
                ValueList.add(NewEntry.trim());
            }
            ++EntryCounter;
            BPos = Pos + 1;
            Pos = newValueList.indexOf(",", BPos);
        }
        String last = newValueList.substring(BPos, newValueList.length());
        if (last.length() > 0) {
            ValueList.add(last.trim());
        }
        if (ValueList.size() > 0) {
            String[] ReturnArray = new String[ValueList.size()];
            return ValueList.toArray(ReturnArray);
        }
        return null;
    }

    public static boolean containsValue(String[] newValueList, String newValue) {
        for (int j = 0; j < newValueList.length; ++j) {
            if (!newValue.equals(newValueList[j])) continue;
            return true;
        }
        return false;
    }

    public static String[][] splitValueList(String[] newValueList, int newValue) {
        ArrayList<String[]> SplitArrayList = new ArrayList<String[]>();
        int newCount = 0;
        ArrayList<String> newList = new ArrayList<String>();
        for (int i = 0; i < newValueList.length; ++i) {
            if (newCount == newValue) {
                String[] StringList = new String[newList.size()];
                StringList = newList.toArray(StringList);
                SplitArrayList.add(StringList);
                newList.clear();
                newCount = 0;
                continue;
            }
            ++newCount;
            newList.add(newValueList[i]);
        }
        if (newList.size() > 0) {
            String[] StringList = new String[newList.size()];
            StringList = newList.toArray(StringList);
            SplitArrayList.add(StringList);
        }
        String[][] SplitValueList = new String[SplitArrayList.size()][];
        SplitValueList = (String[][])SplitArrayList.toArray((T[])SplitValueList);
        return SplitValueList;
    }

    public static String[][] splitValueList(String[] newValueList, String newValue) {
        ArrayList<String[]> SplitArrayList = new ArrayList<String[]>();
        ArrayList<String> newList = new ArrayList<String>();
        for (int i = 0; i < newValueList.length; ++i) {
            if (newValueList[i].equals(newValue)) {
                String[] StringList = new String[newList.size()];
                StringList = newList.toArray(StringList);
                SplitArrayList.add(StringList);
                newList.clear();
                ++i;
                continue;
            }
            newList.add(newValueList[i]);
        }
        if (newList.size() > 0) {
            String[] StringList = new String[newList.size()];
            StringList = newList.toArray(StringList);
            SplitArrayList.add(StringList);
        }
        String[][] SplitValueList = new String[SplitArrayList.size()][];
        SplitValueList = (String[][])SplitArrayList.toArray((T[])SplitValueList);
        return SplitValueList;
    }

    public static String[] filterValueList(String[] newValueList, String newFilter) {
        ArrayList<String> FilteredArrayList = new ArrayList<String>();
        for (int i = 0; i < newValueList.length; ++i) {
            if (newValueList[i].equals(newFilter)) continue;
            FilteredArrayList.add(newValueList[i]);
        }
        String[] FilteredValueList = new String[FilteredArrayList.size()];
        return FilteredArrayList.toArray(FilteredValueList);
    }

    public static String[] filterValueList(String[] newValueList, String[] newFilterList) {
        ArrayList<String> FilteredArrayList = new ArrayList<String>();
        for (int i = 0; i < newValueList.length; ++i) {
            if (SourceLibraryServiceUtils.containsValue(newFilterList, newValueList[i])) continue;
            FilteredArrayList.add(newValueList[i]);
        }
        String[] FilteredValueList = new String[FilteredArrayList.size()];
        return FilteredArrayList.toArray(FilteredValueList);
    }

    public static String getURL(String newRoot, String newTarget, String newExtension) {
        newTarget = newTarget.replace('\\', '/');
        if (newRoot.endsWith("/")) {
            return newRoot + newTarget + "." + newExtension;
        }
        return newRoot + "/" + newTarget + "." + newExtension;
    }

    public static String getDisplayName(String newID, String newKey) {
        int KeyIndex = newID.indexOf(newKey);
        int TagIndex = newID.lastIndexOf("-");
        if (KeyIndex >= 0 && TagIndex >= 0) {
            return newID.substring(KeyIndex + newKey.length(), TagIndex);
        }
        if (KeyIndex >= 0) {
            return newID.substring(KeyIndex + newKey.length(), newID.length());
        }
        return newID;
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String getExtension(URL f) {
        String ext = null;
        String s = f.getFile();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static boolean isValidSource(URL s) {
        String extension = SourceLibraryServiceUtils.getExtension(s);
        if (extension != null) {
            return extension.equals("jpeg") || extension.equals("jpg") || extension.equals("png") || extension.equals("bmp") || extension.equals("pmp");
        }
        return false;
    }

    public static String getInitString(URL s) {
        String e;
        if (SourceLibraryServiceUtils.isValidSource(s) && (e = SourceLibraryServiceUtils.getExtension(s)) != null) {
            if (e.equals("pam")) {
                return "startprocess=[open] cwd=[" + System.getProperty("user.dir") + "]";
            }
            return "startprocess=[ok] cwd=[" + System.getProperty("user.dir") + "]";
        }
        return null;
    }

    public static String getLaunchString(String newMessage, String newBufferName, Dimension newSourceSize, Dimension newThumbnailSize) {
        newMessage = newMessage + " imagename=[" + newBufferName + "] ";
        newMessage = newMessage + "cols=[" + String.valueOf(newThumbnailSize.width) + "] rows=[" + String.valueOf(newThumbnailSize.height) + "] ";
        newMessage = newMessage + "layered_cols=[" + String.valueOf(newSourceSize.width) + "] layered_rows=[" + String.valueOf(newSourceSize.height) + "] ";
        newMessage = newMessage + "print_cols=[" + String.valueOf(newSourceSize.width) + "] print_rows=[" + String.valueOf(newSourceSize.height) + "] ";
        newMessage = newMessage + "screen_cols=[" + String.valueOf(newSourceSize.width) + "] screen_rows=[" + String.valueOf(newSourceSize.height) + "] ";
        newMessage = newMessage + "keep_aspect_ratio=[no] number_positions=[9] number_layers=[3] number_buttons=[20]";
        return newMessage;
    }

    public static void startNativeSourceLibraryService(File newMntPoint, String newServiceID, Socket newServiceSkt, BufferedReader newServiceIn, PrintWriter newServiceOut, ProgressListener newProgressProc) throws IOException {
        if (!newMntPoint.isDirectory()) {
            newMntPoint.mkdir();
        }
        String newInitString = newServiceIn.readLine();
        SourceLibraryServiceImplNativeLclSktStb SktServer = new SourceLibraryServiceImplNativeLclSktStb(null, newInitString, new File(newMntPoint, DEFAULT_SERVICE_ID), newServiceSkt, newServiceOut, newServiceIn, newProgressProc);
        newServiceOut.println("session_id=[" + newServiceID + "]");
        newServiceOut.flush();
        SktServer.run();
    }

    public static String[] getSubsetList(String newString) {
        int SubsetPos = newString.indexOf("<");
        String NewSubset = null;
        String NewSubsetContent = null;
        ArrayList<String> NewSubsetList = new ArrayList<String>();
        while (SubsetPos >= 0) {
            int n = SubsetPos + 1;
            SubsetPos = newString.indexOf(">", SubsetPos);
            NewSubset = newString.substring(n, SubsetPos).trim();
            NewSubsetContent = newString.substring(SubsetPos + 1, (SubsetPos = newString.indexOf("<", SubsetPos)) >= 0 ? SubsetPos : newString.length());
            if (NewSubset.equalsIgnoreCase("My") || NewSubset.equalsIgnoreCase("Hints") || NewSubset.length() <= 0) continue;
            NewSubsetList.add(NewSubset + "," + NewSubsetContent);
        }
        if (NewSubsetList.size() > 0) {
            String[] SubsetList = new String[NewSubsetList.size()];
            return NewSubsetList.toArray(SubsetList);
        }
        return null;
    }

    public static Dimension getFitSize(Dimension newSourceSize, Dimension newTargetSize) {
        return null;
    }

    public static Dimension getFillSize(Dimension newSourceSize, Dimension newTargetSize) {
        Dimension Size = new Dimension(newTargetSize);
        if (newSourceSize.width != newSourceSize.height) {
            if (newSourceSize.width > newSourceSize.height) {
                double Ratio = (double)newSourceSize.width / (double)newSourceSize.height;
                Size.setSize((int)((double)newTargetSize.width * Ratio), newTargetSize.height);
            } else {
                double Ratio = (double)newSourceSize.height / (double)newSourceSize.width;
                Size.setSize(newTargetSize.width, (int)((double)newTargetSize.height * Ratio));
            }
        }
        return Size;
    }

    public static void main(String[] args) {
        try {
            int newServicePort = 0;
            File newServiceFolder = null;
            switch (args.length) {
                case 0: {
                    newServicePort = 666;
                    newServiceFolder = new File(System.getProperty("user.dir"), "Create");
                    break;
                }
                case 1: {
                    newServicePort = Integer.parseInt(args[0]);
                    newServiceFolder = new File(System.getProperty("user.dir"), "Create");
                    break;
                }
                default: {
                    newServicePort = Integer.parseInt(args[0]);
                    newServiceFolder = new File(args[1]);
                }
            }
            while (true) {
                System.out.println("Waiting for connection");
            }
        }
        catch (Exception e) {
            System.err.println("Could not listen on port: " + String.valueOf(666));
            System.exit(1);
            return;
        }
    }
}

