/*
 * Decompiled with CFR 0.152.
 */
package com.arc.xml.io;

import com.arc.xml.io.XMLIODecoder;
import com.arc.xml.io.XMLIODecoderImplCompressed;
import com.arc.xml.io.XMLIODecoderImplPlainText;
import com.arc.xml.io.XMLIODecoderImplSecretKey;
import com.arc.xml.io.XMLIOEncoder;
import com.arc.xml.io.XMLIOEncoderImplCompressed;
import com.arc.xml.io.XMLIOEncoderImplPainText;
import com.arc.xml.io.XMLIOEncoderImplSecretKey;
import com.arc.xml.io.XMLIOSecretKeyGenerator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

public class XMLIO {
    public static final int ENCODED_TYPE_PLAINTEXT = 0;
    public static final int ENCODED_TYPE_SECRETKEY = 1;
    public static final int ENCODED_TYPE_COMPRESSED = 2;
    protected static final XMLIOEncoder PlainTextEncoder = new XMLIOEncoderImplPainText();
    protected static final XMLIOEncoder CompressedEncoder = new XMLIOEncoderImplCompressed();
    protected static XMLIOEncoder SecretKeyEncoder = null;
    protected static final XMLIODecoder PlainTextDecoder = new XMLIODecoderImplPlainText();
    protected static final XMLIODecoder CompressedDecoder = new XMLIODecoderImplCompressed();
    protected static XMLIODecoder SecretKeyDecoder = null;

    public static void initXMLIOSecretKeyGenerator(XMLIOSecretKeyGenerator newSecretKeyGenerator) {
        SecretKeyEncoder = new XMLIOEncoderImplSecretKey(newSecretKeyGenerator);
        SecretKeyDecoder = new XMLIODecoderImplSecretKey(newSecretKeyGenerator);
    }

    public static XMLIOEncoder getXMLIOEncoder(int newType) {
        switch (newType) {
            case 0: {
                return PlainTextEncoder;
            }
            case 1: {
                return SecretKeyEncoder;
            }
            case 2: {
                return CompressedEncoder;
            }
        }
        return PlainTextEncoder;
    }

    public static XMLIODecoder getXMLIODecoder(int newType) {
        switch (newType) {
            case 0: {
                return PlainTextDecoder;
            }
            case 1: {
                return SecretKeyDecoder;
            }
            case 2: {
                return CompressedDecoder;
            }
        }
        return PlainTextDecoder;
    }

    public OutputStream getOutputStreamForFile(File newFile, int newType) throws IOException {
        switch (newType) {
            case 0: {
                return PlainTextEncoder.getOutputStreamForFile(newFile);
            }
            case 1: {
                return SecretKeyEncoder.getOutputStreamForFile(newFile);
            }
            case 2: {
                return CompressedEncoder.getOutputStreamForFile(newFile);
            }
        }
        return PlainTextEncoder.getOutputStreamForFile(newFile);
    }

    public InputStream getInputStreamForFile(File newFile, int newType) throws IOException {
        switch (newType) {
            case 0: {
                return PlainTextDecoder.getInputStreamForFile(newFile);
            }
            case 1: {
                return SecretKeyDecoder.getInputStreamForFile(newFile);
            }
            case 2: {
                return CompressedDecoder.getInputStreamForFile(newFile);
            }
        }
        return PlainTextDecoder.getInputStreamForFile(newFile);
    }

    public InputStream getInputStreamForURL(URL newResource, int newType) throws IOException {
        switch (newType) {
            case 0: {
                return PlainTextDecoder.getInputStreamForURL(newResource);
            }
            case 1: {
                return SecretKeyDecoder.getInputStreamForURL(newResource);
            }
            case 2: {
                return CompressedDecoder.getInputStreamForURL(newResource);
            }
        }
        return PlainTextDecoder.getInputStreamForURL(newResource);
    }
}

