/*
 * Decompiled with CFR 0.152.
 */
package com.arc.xml.io;

import com.arc.xml.io.XMLIODecoder;
import com.arc.xml.io.XMLIOImplSecretKeyBase;
import com.arc.xml.io.XMLIOSecretKeyGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.GZIPInputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;

class XMLIODecoderImplSecretKey
extends XMLIOImplSecretKeyBase
implements XMLIODecoder {
    XMLIODecoderImplSecretKey(XMLIOSecretKeyGenerator newSecretKeyGenerator) {
        super(newSecretKeyGenerator);
    }

    @Override
    public InputStream getInputStreamForFile(File newFile) throws IOException {
        try {
            byte[] keyBytes = XMLIODecoderImplSecretKey.addParity(this.swapBytes(new byte[]{this.KeyGenerator.getByte(0), this.KeyGenerator.getByte(1), this.KeyGenerator.getByte(2), this.KeyGenerator.getByte(3), this.KeyGenerator.getByte(4), this.KeyGenerator.getByte(5), this.KeyGenerator.getByte(6)}));
            if (DESKeySpec.isParityAdjusted(keyBytes, 0)) {
                SecretKeySpec key = new SecretKeySpec(keyBytes, "DES");
                Cipher cipher = Cipher.getInstance("DES");
                cipher.init(2, key);
                return new CipherInputStream(new GZIPInputStream(new FileInputStream(newFile)), cipher);
            }
            return null;
        }
        catch (Exception Ex) {
            IOException ChainEx = new IOException();
            ChainEx.initCause(Ex);
            throw ChainEx;
        }
    }

    @Override
    public InputStream getInputStreamForURL(URL newResource) throws IOException {
        String newResourceString = newResource.toString();
        if (newResourceString.indexOf("//") >= 0) {
            newResource = new URL(newResourceString.replaceAll("//", "/"));
        }
        try {
            byte[] keyBytes = XMLIODecoderImplSecretKey.addParity(this.swapBytes(new byte[]{this.KeyGenerator.getByte(0), this.KeyGenerator.getByte(1), this.KeyGenerator.getByte(2), this.KeyGenerator.getByte(3), this.KeyGenerator.getByte(4), this.KeyGenerator.getByte(5), this.KeyGenerator.getByte(6)}));
            if (DESKeySpec.isParityAdjusted(keyBytes, 0)) {
                SecretKeySpec key = new SecretKeySpec(keyBytes, "DES");
                Cipher cipher = Cipher.getInstance("DES");
                cipher.init(2, key);
                return new CipherInputStream(new GZIPInputStream(newResource.openStream()), cipher);
            }
            return null;
        }
        catch (Exception Ex) {
            IOException ChainEx = new IOException();
            ChainEx.initCause(Ex);
            throw ChainEx;
        }
    }

    @Override
    public InputStream wrapStream(InputStream newStream) throws IOException {
        try {
            byte[] keyBytes = XMLIODecoderImplSecretKey.addParity(this.swapBytes(new byte[]{this.KeyGenerator.getByte(0), this.KeyGenerator.getByte(1), this.KeyGenerator.getByte(2), this.KeyGenerator.getByte(3), this.KeyGenerator.getByte(4), this.KeyGenerator.getByte(5), this.KeyGenerator.getByte(6)}));
            if (DESKeySpec.isParityAdjusted(keyBytes, 0)) {
                SecretKeySpec key = new SecretKeySpec(keyBytes, "DES");
                Cipher cipher = Cipher.getInstance("DES");
                cipher.init(2, key);
                return new CipherInputStream(new GZIPInputStream(newStream), cipher);
            }
            return null;
        }
        catch (Exception Ex) {
            IOException ChainEx = new IOException();
            ChainEx.initCause(Ex);
            throw ChainEx;
        }
    }
}

