/*
 * Decompiled with CFR 0.152.
 */
package com.arc.xml.io;

import com.arc.xml.io.XMLIOEncoder;
import com.arc.xml.io.XMLIOImplSecretKeyBase;
import com.arc.xml.io.XMLIOSecretKeyGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;

class XMLIOEncoderImplSecretKey
extends XMLIOImplSecretKeyBase
implements XMLIOEncoder {
    XMLIOEncoderImplSecretKey(XMLIOSecretKeyGenerator newSecretKeyGenerator) {
        super(newSecretKeyGenerator);
    }

    @Override
    public OutputStream getOutputStreamForFile(File newFile) throws IOException {
        try {
            byte[] keyBytes = XMLIOEncoderImplSecretKey.addParity(this.swapBytes(new byte[]{this.KeyGenerator.getByte(0), this.KeyGenerator.getByte(1), this.KeyGenerator.getByte(2), this.KeyGenerator.getByte(3), this.KeyGenerator.getByte(4), this.KeyGenerator.getByte(5), this.KeyGenerator.getByte(6)}));
            if (DESKeySpec.isParityAdjusted(keyBytes, 0)) {
                SecretKeySpec key = new SecretKeySpec(keyBytes, "DES");
                Cipher cipher = Cipher.getInstance("DES");
                cipher.init(1, key);
                return new CipherOutputStream(new GZIPOutputStream(new FileOutputStream(newFile)), cipher);
            }
            return null;
        }
        catch (Exception Ex) {
            IOException ChainEx = new IOException();
            ChainEx.initCause(Ex);
            throw ChainEx;
        }
    }

    @Override
    public OutputStream wrapStream(OutputStream newStream) throws IOException {
        try {
            byte[] keyBytes = XMLIOEncoderImplSecretKey.addParity(this.swapBytes(new byte[]{this.KeyGenerator.getByte(0), this.KeyGenerator.getByte(1), this.KeyGenerator.getByte(2), this.KeyGenerator.getByte(3), this.KeyGenerator.getByte(4), this.KeyGenerator.getByte(5), this.KeyGenerator.getByte(6)}));
            if (DESKeySpec.isParityAdjusted(keyBytes, 0)) {
                SecretKeySpec key = new SecretKeySpec(keyBytes, "DES");
                Cipher cipher = Cipher.getInstance("DES");
                cipher.init(1, key);
                return new CipherOutputStream(new GZIPOutputStream(newStream), cipher);
            }
            return null;
        }
        catch (Exception Ex) {
            IOException ChainEx = new IOException();
            ChainEx.initCause(Ex);
            throw ChainEx;
        }
    }
}

