/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.iArt.filefilter;

import com.Fo2PiX.iArt.filefilter.ImageWriterFilter;
import com.Fo2PiX.iArt.iArt;
import com.arc.io.util.Files;
import com.arc.lang.Strings;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class ImageReaderFilter
extends FileFilter
implements FilenameFilter {
    protected static HashMap KnownNameMaps = new HashMap();
    protected String[] SupportedTypes;
    protected String Description;

    ImageReaderFilter(iArt newApp, String newType) {
        this.SupportedTypes = new String[]{newType};
        this.Description = newType + " " + newApp.Config.APP_LABEL_STRINGS.getString("LABEL_FILES");
    }

    public ImageReaderFilter(iArt newApp) {
        this.SupportedTypes = ImageIO.getReaderFormatNames();
        this.Description = newApp.Config.APP_LABEL_STRINGS.getString("LABEL_ALL_SUPPORTED_IMAGE_FILES_DESCRIPTION");
    }

    @Override
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String extension = null;
        extension = Files.getExtension((File)f);
        if (extension != null) {
            for (int i = 0; i < this.SupportedTypes.length; ++i) {
                if (!extension.equalsIgnoreCase(this.SupportedTypes[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean accept(File dir, String name) {
        String extension = null;
        File Filename = new File(dir, name);
        extension = Files.getExtension((File)Filename);
        if (extension != null) {
            for (int i = 0; i < this.SupportedTypes.length; ++i) {
                if (!extension.equalsIgnoreCase(this.SupportedTypes[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.Description;
    }

    public static void addChoosableFileFilters(iArt newApp, JFileChooser newChooser) {
        ArrayList<String> Formats = new ArrayList<String>();
        String[] RawFormats = ImageIO.getReaderFormatNames();
        for (int i = 0; i < RawFormats.length; ++i) {
            RawFormats[i] = RawFormats[i].toLowerCase();
            if (Strings.containsIgnoreCase(Formats, (String)RawFormats[i])) continue;
            Formats.add(RawFormats[i]);
        }
        for (String Format : Formats) {
            newChooser.addChoosableFileFilter(new ImageWriterFilter(newApp, Format));
        }
    }

    static {
        KnownNameMaps.put("jpg", new String[]{"jpeg"});
        KnownNameMaps.put("jpeg", new String[]{"jpg"});
    }
}

