/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.iArt.filefilter;

import com.Fo2PiX.iArt.filefilter.DocumentFileFilter;
import com.Fo2PiX.iArt.filefilter.ImageReaderFilter;
import com.Fo2PiX.iArt.filefilter.ProjectFileFilter;
import com.Fo2PiX.iArt.iArt;
import java.awt.FileDialog;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class LoadFilter
extends FileFilter
implements FilenameFilter {
    protected static ImageReaderFilter ImageFilter;
    protected static ProjectFileFilter ProjectFilter;
    protected static DocumentFileFilter DocFilter;
    protected boolean CanLoadProject;
    protected String Description;

    protected static void initFilters(iArt newApp) {
        ImageFilter = new ImageReaderFilter(newApp);
        ProjectFilter = new ProjectFileFilter(newApp.Config.APP_LABEL_STRINGS.getString("LABEL_PROJECT") + " " + newApp.Config.APP_LABEL_STRINGS.getString("LABEL_FILES"));
        DocFilter = new DocumentFileFilter("Document " + newApp.Config.APP_LABEL_STRINGS.getString("LABEL_FILES"));
    }

    protected LoadFilter(String newDescription, boolean newCanLoadProject) {
        this.CanLoadProject = newCanLoadProject;
        this.Description = newDescription;
    }

    @Override
    public boolean accept(File f) {
        return ImageFilter.accept(f) || this.CanLoadProject && ProjectFilter.accept(f) || DocFilter.accept(f);
    }

    @Override
    public boolean accept(File dir, String name) {
        return ImageFilter.accept(dir, name) || this.CanLoadProject && ProjectFilter.accept(dir, name) || DocFilter.accept(dir, name);
    }

    @Override
    public String getDescription() {
        return this.Description;
    }

    public static void addChoosableFileFilters(iArt newApp, JFileChooser newChooser, boolean newCanLoadProject) {
        if (ImageFilter == null || ProjectFilter == null || DocFilter == null) {
            LoadFilter.initFilters(newApp);
        }
        LoadFilter AllFilter = new LoadFilter(newApp.Config.APP_LABEL_STRINGS.getString("LABEL_ALL_SUPPORTED_FILES_DESCRIPTION"), newCanLoadProject);
        newChooser.addChoosableFileFilter(AllFilter);
        if (newCanLoadProject) {
            newChooser.addChoosableFileFilter(ProjectFilter);
        }
        newChooser.addChoosableFileFilter(ImageFilter);
        newChooser.addChoosableFileFilter(DocFilter);
        ImageReaderFilter.addChoosableFileFilters(newApp, newChooser);
        newChooser.setFileFilter(AllFilter);
    }

    public static void addChoosableFileFilters(iArt newApp, FileDialog newDialog, boolean newCanSaveProject) {
        newDialog.setFilenameFilter(new LoadFilter(newApp.Config.APP_LABEL_STRINGS.getString("LABEL_ALL_SUPPORTED_FILES_DESCRIPTION"), newCanSaveProject));
    }
}

