/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.iArt.filefilter;

import com.Fo2PiX.iArt.filefilter.FileFilterInfo;
import com.Fo2PiX.iArt.filefilter.ImageReaderFilter;
import com.Fo2PiX.iArt.filefilter.ImageWriterFilter;
import com.Fo2PiX.iArt.filefilter.ProjectFileFilter;
import com.Fo2PiX.iArt.iArt;
import java.awt.FileDialog;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class SaveFilter
extends FileFilter
implements FileFilterInfo,
FilenameFilter {
    static ImageWriterFilter ImageFilter;
    static ProjectFileFilter ProjectFilter;
    protected boolean CanSaveProject;
    protected String Description;

    protected static void initFilters(iArt newApp) {
        ImageFilter = new ImageWriterFilter(newApp);
        ProjectFilter = new ProjectFileFilter(newApp.Config.APP_LABEL_STRINGS.getString("LABEL_PROJECT") + " " + newApp.Config.APP_LABEL_STRINGS.getString("LABEL_FILES"));
    }

    protected SaveFilter(String newDescription, boolean newCanSaveProject) {
        this.CanSaveProject = newCanSaveProject;
        this.Description = newDescription;
    }

    @Override
    public boolean accept(File f) {
        return ImageFilter.accept(f) || ProjectFilter.accept(f);
    }

    @Override
    public boolean accept(File dir, String name) {
        return ImageFilter.accept(dir, name) || ProjectFilter.accept(dir, name);
    }

    @Override
    public String getDescription() {
        return this.Description;
    }

    @Override
    public String getExtension() {
        return this.CanSaveProject ? "f2pr" : "jpg";
    }

    public static void addChoosableFileFilters(iArt newApp, JFileChooser newChooser, boolean newCanSaveProject) {
        if (ImageFilter == null || ProjectFilter == null) {
            SaveFilter.initFilters(newApp);
        }
        SaveFilter AllFilter = null;
        if (newCanSaveProject) {
            AllFilter = new SaveFilter(newApp.Config.APP_LABEL_STRINGS.getString("LABEL_ALL_SUPPORTED_FILES_DESCRIPTION"), newCanSaveProject);
            newChooser.addChoosableFileFilter(AllFilter);
            newChooser.addChoosableFileFilter(ProjectFilter);
        }
        newChooser.addChoosableFileFilter(ImageFilter);
        ImageReaderFilter.addChoosableFileFilters(newApp, newChooser);
        if (newCanSaveProject) {
            newChooser.setFileFilter(AllFilter);
        } else {
            newChooser.setFileFilter(ImageFilter);
        }
    }

    public static void addChoosableFileFilters(iArt newApp, FileDialog newDialog, boolean newCanSaveProject) {
        newDialog.setFilenameFilter(new SaveFilter(newApp.Config.APP_LABEL_STRINGS.getString("LABEL_ALL_SUPPORTED_FILES_DESCRIPTION"), newCanSaveProject));
    }
}

