/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.iArt;

import com.Fo2PiX.iArt.iArt;
import com.arc.io.util.Files;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.prefs.Preferences;
import javax.swing.JMenuItem;

public class iArtConfig {
    public static final double VER = 0.9;
    public static final int PLATFORM_WIN32 = 0;
    public static final int PLATFORM_OSX = 1;
    public static final int PLATFORM_LINUX = 2;
    public static final int PLATFORM_SOLARIS = 3;
    public static final int PLATFORM_UNIX = 4;
    public static final int PLATFORM_UNKNOWN = 5;
    public static final int IMAGE_SIZE_SPEED_MAX = 1000;
    public static final int IMAGE_SIZE_QUALITY_MAX = 1500;
    public static final int IMAGE_SIZE_SPEED = 0;
    public static final int IMAGE_SIZE_QUALITY = 1;
    public static final int SIMPLE_STUDIO_TYPE_MULTIPLE = 0;
    public static final int SIMPLE_STUDIO_TYPE_SINGLE = 1;
    public static final int SIMPLE_LAYOUT_TYPE_ART = 0;
    public static final int SIMPLE_LAYOUT_TYPE_CARD = 1;
    public static final int SIMPLE_LAYOUT_TYPE_INVITE = 2;
    public static final int PRINT_TYPE_NATIVE = 0;
    public static final int PRINT_TYPE_WRAPPER = 1;
    public static final int GUI_STYLE_SIMPLE = 0;
    public static final int GUI_STYLE_COMPACT = 1;
    public static final int GUI_TYPE_SIMPLE = 0;
    public static final int GUI_TYPE_STANDARD = 1;
    public static final int LAYOUT_TYPE_STANDARD = 0;
    public static final int LAYOUT_TYPE_EPSON = 1;
    public static final int LAYOUT_TYPE_ARTCREATA = 2;
    public static final int LAYOUT_TYPE_CARDCREATA = 3;
    public static final int MAX_PREVIEW_WIDTH = 300;
    public static final int MAX_PREVIEW_HEIGHT = 300;
    protected static final int DEFAULT_APP_WIDTH = 1024;
    protected static final int DEFAULT_APP_HEIGHT = 740;
    protected static final String WINDOW_WIDTH = "WindowWidth";
    protected static final String WINDOW_HEIGHT = "WindowHeight";
    protected static final String WINDOW_XPOS = "WindowXPos";
    protected static final String WINDOW_YPOS = "WindowYPos";
    protected static final String RECENT_IMAGE_LIST = "RecentImageList";
    protected static final String RECENT_IMAGE_FOLDER = "RecentImageFolder";
    protected static final String TIP_ANIMATION_MODE = "tip_animation_mode";
    protected static final String TIP_DISPLAY_MODE = "tip_display_mode";
    protected static final String TIP_TOGGLE_MODE = "tip_toggle_mode";
    protected static final String CANVAS_BACKGROUND_COLOUR = "canvas_background_colour";
    protected static final String HORIZONTAL_CENTRE_CANVAS = "horizontal_centre_canvas";
    protected static final String VERTICAL_CENTRE_CANVAS = "horizontal_centre_canvas";
    protected static final String GUI_STYLE = "gui";
    protected static final String MPIXEL_SIZE = "pixel";
    protected static final String LAYOUT_TYPE = "layout";
    protected static final String PRINT_TYPE = "print";
    protected static final String RESIZE_TYPE = "resize";
    protected static final String INPROCESS_COMMANDLINE_PARAM = "inprocess";
    protected static final String REDIRECTOUT_COMMANDLINE_PARAM = "redirectout";
    protected static final String REDIRECTERR_COMMANDLINE_PARAM = "redirecterr";
    protected static final String DEFAULTLOCALE_COMMANDLINE_PARAM = "defaultlocale";
    protected static final String EVENT_DELAY_COMMANDLINE_PARAM = "eventdelay";
    protected static final String FORCE_SIZE_COMMANDLINE_PARAM = "forcesize";
    protected static final String FORMAT_SIZE_COMMANDLINE_PARAM = "format";
    protected static final String IMAGE_SIZE_COMMANDLINE_PARAM = "imagesize";
    protected static final String SCRATCH_FOLDER_COMMANDLINE_PARAM = "scratch";
    protected static final String SCRATCH_FOLDER_USER_VARIABLE = "!USER!";
    protected static final String SCRATCH_FOLDER_APP_VARIABLE = "!APP!";
    public final int Platform;
    public final double MajorVersion;
    public final double MinorVersion;
    public final ResourceBundle APP_STRINGS;
    public final ResourceBundle APP_LABEL_STRINGS;
    public final ResourceBundle APP_ACTION_STRINGS;
    public final ResourceBundle APP_ERRORS_STRINGS;
    public final boolean ShowLayoutDPI;
    public final boolean SimpleView;
    public final boolean SimpleAdjust;
    public final boolean SimpleStudio;
    public final boolean SimpleLayout;
    public final boolean Education;
    public final int SimpleStudioType;
    public final int SimpleLayoutType;
    public final boolean InProcessEnabled;
    public final boolean NullRedirectOut;
    public final boolean RedirectOut;
    public final boolean RedirectErr;
    public final boolean ForceSize;
    public final int ImageSize;
    public final Locale DefaultLocale;
    public final Locale ActiveLocale;
    public final long PixelLimit;
    public final long EventDelay;
    public final int GuiStyle;
    public final int ResizeType;
    public final int LayoutType;
    public final int PrintType;
    public final ColorSpace ColSpc;
    public final int ColMdl;
    public final File RootFolder;
    public final File UserFolder;
    public final File TempFolder;
    public final File ScratchFolder;
    public final File SkinsFolder;
    public final Stack<File> RecentImageStack;
    public final Stack<JMenuItem> RecentMenuItemStack;
    public final String RecentImageString;
    public final Dimension DefaultSize;
    public final Point DefaultLocation;
    public final Point CentrePoint;
    public final String StudioConfig;
    public boolean TipAnimationEnabled;
    public boolean TipVisible;
    public boolean TipToggle;
    public int CanvasBackgroundColour;
    public boolean HorizontalCentreCanvas;
    public boolean VerticalCentreCanvas;
    public File ImagesFolder;

    protected iArtConfig(int newPlatform, boolean newInProcessEnabled, boolean newRedirectOut, boolean newRedirectErr, boolean newForceSize, int newImageSize, String newDefaultLocale, long newEventTimeout, long newPixelLimit, int newGuiStyle, int newResizeType, int newLayoutType, int newPrintType, ColorSpace newColSpc, int newColMdl) {
        int YPos;
        int XPos;
        int Height;
        int Width;
        this.Platform = newPlatform;
        switch (this.Platform) {
            case 1: {
                this.StudioConfig = "com/Fo2PiX/iArt/view/controller/config/Studiox.cfg";
                break;
            }
            default: {
                this.StudioConfig = "com/Fo2PiX/iArt/view/controller/config/Studio.cfg";
            }
        }
        String[] LocaleArgs = newDefaultLocale.split("_");
        this.ActiveLocale = this.DefaultLocale = new Locale(LocaleArgs[0], LocaleArgs[1]);
        this.ImageSize = newImageSize;
        ResourceBundle VersionBundle = ResourceBundle.getBundle("com/Fo2PiX/iArt/Version");
        this.MajorVersion = Double.parseDouble(VersionBundle.getString("MAJOR_VERSION"));
        this.MinorVersion = Double.parseDouble(VersionBundle.getString("MINOR_VERSION"));
        this.APP_STRINGS = ResourceBundle.getBundle("com/Fo2PiX/iArt/language/App_Strings", this.ActiveLocale);
        this.APP_LABEL_STRINGS = ResourceBundle.getBundle("com/Fo2PiX/iArt/language/App_Label_Strings", this.ActiveLocale);
        this.APP_ACTION_STRINGS = ResourceBundle.getBundle("com/Fo2PiX/iArt/language/App_Action_Strings", this.ActiveLocale);
        this.APP_ERRORS_STRINGS = ResourceBundle.getBundle("com/Fo2PiX/iArt/language/App_Error_Strings", this.ActiveLocale);
        Preferences Prefs = Preferences.userNodeForPackage(iArt.class);
        Prefs = Prefs.node(this.APP_STRINGS.getString("APP_NAME"));
        this.NullRedirectOut = false;
        this.SimpleView = false;
        this.SimpleAdjust = false;
        this.SimpleStudio = false;
        this.SimpleLayout = false;
        this.Education = false;
        this.ShowLayoutDPI = true;
        this.SimpleStudioType = 0;
        this.SimpleLayoutType = 0;
        this.ColSpc = newColSpc;
        this.ColMdl = newColMdl;
        this.InProcessEnabled = newInProcessEnabled;
        this.RedirectOut = newRedirectOut;
        this.RedirectErr = newRedirectErr;
        this.ForceSize = newForceSize;
        this.EventDelay = newEventTimeout;
        this.PixelLimit = newPixelLimit;
        this.GuiStyle = newGuiStyle;
        this.ResizeType = newResizeType;
        this.LayoutType = newLayoutType;
        this.PrintType = newPrintType;
        this.RootFolder = new File(System.getProperty("user.dir"));
        this.UserFolder = new File(System.getProperty("user.home"));
        this.SkinsFolder = new File(this.RootFolder, "skinlf");
        this.TempFolder = new File(System.getProperty("java.io.tmpdir"));
        this.TempFolder.mkdirs();
        this.ScratchFolder = new File(this.TempFolder, SCRATCH_FOLDER_COMMANDLINE_PARAM);
        if (!this.ScratchFolder.exists() || !this.ScratchFolder.isDirectory()) {
            this.ScratchFolder.mkdir();
        }
        Files.deleteFolderContents((File)this.ScratchFolder);
        String RecentImageFolderPath = Prefs.get(RECENT_IMAGE_FOLDER, "");
        if (RecentImageFolderPath.equalsIgnoreCase("")) {
            switch (this.Platform) {
                case 1: {
                    this.ImagesFolder = new File(this.RootFolder, "../../../../images");
                    break;
                }
                default: {
                    this.ImagesFolder = new File(this.RootFolder, "images");
                    break;
                }
            }
        } else {
            this.ImagesFolder = new File(RecentImageFolderPath);
        }
        this.RecentImageStack = new Stack();
        this.RecentMenuItemStack = new Stack();
        this.RecentImageString = Prefs.get(RECENT_IMAGE_LIST, "");
        this.CentrePoint = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        if (this.ForceSize) {
            Width = 1024;
            Height = 740;
            XPos = this.CentrePoint.x - Width / 2;
            YPos = this.CentrePoint.y - Height / 2;
        } else {
            Width = Prefs.getInt(WINDOW_WIDTH, 1024);
            Height = Prefs.getInt(WINDOW_HEIGHT, 740);
            XPos = Prefs.getInt(WINDOW_XPOS, this.CentrePoint.x - Width / 2);
            YPos = Prefs.getInt(WINDOW_YPOS, this.CentrePoint.y - Height / 2);
            Rectangle MaxBounds = new Rectangle();
            GraphicsDevice[] gs = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
            for (int j = 0; j < gs.length; ++j) {
                GraphicsDevice gd = gs[j];
                MaxBounds = MaxBounds.union(gd.getDefaultConfiguration().getBounds());
            }
            if (Width > MaxBounds.width) {
                Width = 1024;
            }
            if (Height > MaxBounds.height) {
                Height = 740;
            }
            if (XPos < MaxBounds.x || XPos > MaxBounds.x + MaxBounds.width || YPos < MaxBounds.y || YPos > MaxBounds.y + MaxBounds.height) {
                XPos = this.CentrePoint.x - Width / 2;
                YPos = this.CentrePoint.y - Height / 2;
            }
        }
        this.DefaultSize = new Dimension(Width, Height);
        this.DefaultLocation = new Point(XPos, YPos);
        this.TipAnimationEnabled = Prefs.getBoolean(TIP_ANIMATION_MODE, this.Platform != 1);
        this.TipVisible = Prefs.getBoolean(TIP_DISPLAY_MODE, true);
        this.TipToggle = Prefs.getBoolean(TIP_TOGGLE_MODE, true);
        this.CanvasBackgroundColour = Prefs.getInt(CANVAS_BACKGROUND_COLOUR, this.Platform == 1 ? Color.BLACK.getRGB() : Color.LIGHT_GRAY.getRGB());
        this.HorizontalCentreCanvas = Prefs.getBoolean("horizontal_centre_canvas", true);
        this.VerticalCentreCanvas = Prefs.getBoolean("horizontal_centre_canvas", true);
        try {
            if (this.RedirectOut) {
                PrintStream stdout = null;
                stdout = new PrintStream(new FileOutputStream(System.getProperty("user.dir") + "\\DataOut.log"));
                System.setOut(stdout);
            } else if (this.NullRedirectOut) {
                OutputStream newStream = new OutputStream(){

                    @Override
                    public void write(byte[] b) throws IOException {
                    }

                    @Override
                    public void write(byte[] b, int off, int len) throws IOException {
                    }

                    @Override
                    public void write(int b) throws IOException {
                    }
                };
                System.setOut(new PrintStream(newStream));
            }
            if (this.RedirectErr) {
                PrintStream stderr = null;
                stderr = new PrintStream(new FileOutputStream(System.getProperty("user.dir") + "\\DataErr.log"));
                System.setErr(stderr);
            }
        }
        catch (Exception Ex) {
            System.out.println("Failed to redirect Streams");
            Ex.printStackTrace();
        }
    }

    public void save(Dimension newSize, Point newLocation) {
        try {
            Preferences Prefs = Preferences.userNodeForPackage(iArt.class);
            Prefs = Prefs.node(this.APP_STRINGS.getString("APP_NAME"));
            String RecentImageFolder = this.ImagesFolder.toString();
            Prefs.put(RECENT_IMAGE_FOLDER, RecentImageFolder);
            String RecentImageList = "";
            for (int i = 0; i < this.RecentMenuItemStack.size(); ++i) {
                RecentImageList = RecentImageList + ((iArt.RecentMenuItem)this.RecentMenuItemStack.get((int)i)).RecentFile.toString();
                if (i >= this.RecentMenuItemStack.size() - 1) continue;
                RecentImageList = RecentImageList + ",";
            }
            Prefs.put(RECENT_IMAGE_LIST, RecentImageList);
            Prefs.putInt(WINDOW_WIDTH, newSize.width);
            Prefs.putInt(WINDOW_HEIGHT, newSize.height);
            Prefs.putInt(WINDOW_XPOS, newLocation.x);
            Prefs.putInt(WINDOW_YPOS, newLocation.y);
            Prefs.putBoolean(TIP_ANIMATION_MODE, this.TipAnimationEnabled);
            Prefs.putBoolean(TIP_DISPLAY_MODE, this.TipVisible);
            Prefs.putBoolean(TIP_TOGGLE_MODE, this.TipToggle);
            Prefs.putInt(CANVAS_BACKGROUND_COLOUR, this.CanvasBackgroundColour);
            Prefs.putBoolean("horizontal_centre_canvas", this.HorizontalCentreCanvas);
            Prefs.getBoolean("horizontal_centre_canvas", this.VerticalCentreCanvas);
            Prefs.flush();
        }
        catch (Exception Ex) {
            System.out.println("Failed to save Preferences");
            Ex.printStackTrace();
        }
    }

    public boolean checkString(ResourceBundle newBundle, String newID) {
        try {
            newBundle.getString(newID);
            return true;
        }
        catch (Exception Ex) {
            return false;
        }
    }

    public static final int getPlatform() {
        int p = 5;
        String osname = "";
        osname = System.getProperty("os.name");
        if (osname.toUpperCase().indexOf("WINDOWS") != -1 || osname.toUpperCase().indexOf("MICROSOFT") != -1) {
            p = 0;
        } else if (System.getProperty("mrj.version") != null || osname.toUpperCase().indexOf("APPLE") != -1 || osname.toUpperCase().indexOf("MAC") != -1) {
            p = 1;
        } else if (osname.toUpperCase().indexOf("SUN") != -1 || osname.toUpperCase().indexOf("SOLARIS") != -1) {
            p = 3;
        } else if (osname.toUpperCase().indexOf("LINUX") != -1 || osname.toUpperCase().indexOf("REDHAT") != -1 || osname.toUpperCase().indexOf("SUSE") != -1 || osname.toUpperCase().indexOf("MANDRAKE") != -1 || osname.toUpperCase().indexOf("DEBIAN") != -1) {
            p = 2;
        } else if (osname.toUpperCase().indexOf("NIX") != -1) {
            p = 4;
        }
        return p;
    }

    public static iArtConfig readConfig(String[] args, ColorSpace newColSpc, int newColMdl) {
        int NewGuiStyle = 1;
        int NewResizeType = 1;
        int NewLayoutType = 1;
        int NewPrintType = 1;
        boolean NewForceSize = false;
        boolean NewInProcessEnabled = true;
        boolean NewRedirectOutEnabled = false;
        boolean NewRedirectErrEnabled = false;
        String DefaultLocale = "en_GB";
        String DefaultFormat = "bmp";
        int ImageSize = 0;
        long EventDelay = 0L;
        long PixelLimit = 4L;
        String TempFolder = System.getProperty("user.dir");
        for (int i = 0; i < args.length; ++i) {
            System.out.println(args[i]);
            if (args[i].toLowerCase().indexOf(GUI_STYLE) == 0) {
                NewGuiStyle = 0;
                if (args[i].substring(GUI_STYLE.length()).equalsIgnoreCase("compact")) {
                    NewGuiStyle = 1;
                }
            }
            if (args[i].toLowerCase().indexOf(RESIZE_TYPE) == 0) {
                NewResizeType = 1;
                if (args[i].substring(RESIZE_TYPE.length()).equalsIgnoreCase("simple")) {
                    NewResizeType = 0;
                }
            }
            if (args[i].toLowerCase().indexOf(LAYOUT_TYPE) == 0) {
                NewLayoutType = 1;
                if (args[i].substring(LAYOUT_TYPE.length()).equalsIgnoreCase("simple")) {
                    NewLayoutType = 0;
                }
            }
            if (args[i].toLowerCase().indexOf(PRINT_TYPE) == 0) {
                NewPrintType = 1;
                if (args[i].substring(PRINT_TYPE.length()).equalsIgnoreCase("native")) {
                    NewPrintType = 0;
                }
            }
            if (args[i].toLowerCase().indexOf(FORCE_SIZE_COMMANDLINE_PARAM) == 0) {
                boolean bl = NewForceSize = args[i].substring(FORCE_SIZE_COMMANDLINE_PARAM.length()).equalsIgnoreCase("true");
            }
            if (args[i].toLowerCase().indexOf(INPROCESS_COMMANDLINE_PARAM) == 0) {
                boolean bl = NewInProcessEnabled = !args[i].substring(INPROCESS_COMMANDLINE_PARAM.length()).equalsIgnoreCase("false");
            }
            if (args[i].toLowerCase().indexOf(REDIRECTOUT_COMMANDLINE_PARAM) == 0) {
                boolean bl = NewRedirectOutEnabled = args[i].substring(REDIRECTOUT_COMMANDLINE_PARAM.length()).equalsIgnoreCase("true");
            }
            if (args[i].toLowerCase().indexOf(REDIRECTOUT_COMMANDLINE_PARAM) == 0) {
                boolean bl = NewRedirectErrEnabled = args[i].substring(REDIRECTOUT_COMMANDLINE_PARAM.length()).equalsIgnoreCase("true");
            }
            if (args[i].toLowerCase().indexOf(EVENT_DELAY_COMMANDLINE_PARAM) == 0) {
                EventDelay = Long.parseLong(args[i].substring(EVENT_DELAY_COMMANDLINE_PARAM.length()));
            }
            if (args[i].toLowerCase().indexOf(MPIXEL_SIZE) == 0) {
                PixelLimit = Long.parseLong(args[i].substring(MPIXEL_SIZE.length()));
            }
            if (args[i].toLowerCase().indexOf(DEFAULTLOCALE_COMMANDLINE_PARAM) == 0) {
                DefaultLocale = args[i].substring(DEFAULTLOCALE_COMMANDLINE_PARAM.length());
            }
            if (args[i].toLowerCase().indexOf(FORMAT_SIZE_COMMANDLINE_PARAM) == 0) {
                DefaultFormat = args[i].substring(FORMAT_SIZE_COMMANDLINE_PARAM.length());
            }
            if (args[i].toLowerCase().indexOf(IMAGE_SIZE_COMMANDLINE_PARAM) == 0) {
                int n = ImageSize = args[i].substring(IMAGE_SIZE_COMMANDLINE_PARAM.length()).equalsIgnoreCase("quality") ? 1 : 0;
            }
            if (args[i].toLowerCase().indexOf(SCRATCH_FOLDER_COMMANDLINE_PARAM) != 0) continue;
            String ScratchString = args[i].substring(SCRATCH_FOLDER_COMMANDLINE_PARAM.length());
            if (ScratchString.indexOf(SCRATCH_FOLDER_USER_VARIABLE) == 0) {
                ScratchString = System.getProperty("user.home") + ScratchString.substring(SCRATCH_FOLDER_USER_VARIABLE.length());
            } else if (ScratchString.indexOf(SCRATCH_FOLDER_APP_VARIABLE) == 0) {
                ScratchString = System.getProperty("user.dir") + ScratchString.substring(SCRATCH_FOLDER_APP_VARIABLE.length());
            }
            TempFolder = ScratchString;
            System.out.println("Scratch = <" + TempFolder + ">");
        }
        System.setProperty("java.io.tmpdir", TempFolder);
        return new iArtConfig(iArtConfig.getPlatform(), NewInProcessEnabled, NewRedirectOutEnabled, NewRedirectErrEnabled, NewForceSize, ImageSize, DefaultLocale, EventDelay, PixelLimit, NewGuiStyle, NewResizeType, NewLayoutType, NewPrintType, newColSpc, newColMdl);
    }
}

