/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.iArt;

import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class iArtPickerBase
extends JPanel {
    protected static final int NUDGE_EVENT_ID = 0;
    protected static final int NUDGE_UP = 0;
    protected static final int NUDGE_DOWN = 1;
    protected static final int NUDGE_LEFT = 2;
    protected static final int NUDGE_RIGHT = 3;
    protected static final int RANGE_MIN = 0;
    protected static final int RANGE_MAX = 100;
    public int x;
    public int y;
    public int offsetx;
    public int offsety;
    protected ArrayList MouseListenerList;
    protected ArrayList MouseMotionListenerList;
    protected Rectangle PickerRect;
    protected int CursorSize;
    protected int CursorCentre;
    protected Rectangle CursorRect;
    protected BufferedImage PickerImageOn;
    protected BufferedImage PickerImageOff;
    protected boolean MouseOver;
    protected boolean VisibleEnabled;

    protected void pickerMousePressed(MouseEvent e) {
        int m;
        this.requestFocus();
        int newx = e.getX();
        int newy = e.getY();
        if (this.PickerRect.contains(newx, newy) && ((m = e.getModifiers()) & 0x410) != 0) {
            if (!this.CursorRect.contains(newx, newy)) {
                if (e.isShiftDown()) {
                    this.x = this.drawToX(newx);
                } else if (e.isAltDown()) {
                    this.y = this.drawToY(newy);
                } else {
                    this.x = this.drawToX(newx);
                    this.y = this.drawToY(newy);
                }
            }
            MouseEvent e1 = new MouseEvent(this, e.getID(), e.getWhen(), m, this.x, this.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
            for (int i = 0; i < this.MouseListenerList.size(); ++i) {
                ((MouseListener)this.MouseListenerList.get(i)).mousePressed(e1);
            }
            this.CursorRect.setBounds(this.xToDraw(this.x) - this.CursorCentre, this.yToDraw(this.y) - this.CursorCentre, this.CursorSize, this.CursorSize);
            this.repaint();
        }
    }

    protected void pickerMouseReleased(MouseEvent e) {
        int newx = e.getX();
        int newy = e.getY();
        int m = e.getModifiers();
        if ((m & 0x410) != 0) {
            if (!this.CursorRect.contains(newx, newy)) {
                this.x = this.drawToX(newx);
                this.y = this.drawToY(newy);
            }
            MouseEvent e1 = new MouseEvent(this, e.getID(), e.getWhen(), m, this.x, this.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
            for (int i = 0; i < this.MouseListenerList.size(); ++i) {
                ((MouseListener)this.MouseListenerList.get(i)).mouseReleased(e1);
            }
            this.CursorRect.setBounds(this.xToDraw(this.x) - this.CursorCentre, this.yToDraw(this.y) - this.CursorCentre, this.CursorSize, this.CursorSize);
            this.repaint();
        }
    }

    protected void pickerMouseEntered(MouseEvent e) {
        int newy;
        this.MouseOver = true;
        int newx = e.getX();
        if (this.PickerRect.contains(newx, newy = e.getY())) {
            if (!this.CursorRect.contains(newx, newy)) {
                newx = this.drawToX(newx);
                newy = this.drawToY(newy);
            } else {
                newx = this.x;
                newy = this.y;
            }
            MouseEvent e1 = new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiers(), newx, newy, e.getClickCount(), e.isPopupTrigger(), e.getButton());
            for (int i = 0; i < this.MouseListenerList.size(); ++i) {
                ((MouseListener)this.MouseListenerList.get(i)).mouseEntered(e1);
            }
        }
        this.repaint();
    }

    protected void pickerMouseExited(MouseEvent e) {
        int newy;
        this.MouseOver = false;
        int newx = e.getX();
        if (this.PickerRect.contains(newx, newy = e.getY())) {
            if (!this.CursorRect.contains(newx, newy)) {
                newx = this.drawToX(newx);
                newy = this.drawToY(newy);
            } else {
                newx = this.x;
                newy = this.y;
            }
            MouseEvent e1 = new MouseEvent(this, e.getID(), e.getWhen(), e.getModifiers(), newx, newy, e.getClickCount(), e.isPopupTrigger(), e.getButton());
            for (int i = 0; i < this.MouseListenerList.size(); ++i) {
                ((MouseListener)this.MouseListenerList.get(i)).mouseExited(e1);
            }
        }
        this.repaint();
    }

    protected void pickerMouseClicked(MouseEvent e) {
        int m;
        int newy;
        int newx = e.getX();
        if (this.PickerRect.contains(newx, newy = e.getY()) && ((m = e.getModifiers()) & 0x410) != 0) {
            if (!this.CursorRect.contains(newx, newy)) {
                this.x = this.drawToX(e.getX());
                this.y = this.drawToY(e.getY());
            }
            MouseEvent e1 = new MouseEvent(this, e.getID(), e.getWhen(), m, this.x, this.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
            for (int i = 0; i < this.MouseListenerList.size(); ++i) {
                ((MouseListener)this.MouseListenerList.get(i)).mouseClicked(e1);
            }
            this.CursorRect.setBounds(this.xToDraw(this.x) - this.CursorCentre, this.yToDraw(this.y) - this.CursorCentre, this.CursorSize, this.CursorSize);
            this.repaint();
        }
    }

    protected void pickerMouseDragged(MouseEvent e) {
        int newx = e.getX();
        int newy = e.getY();
        int m = e.getModifiers();
        if ((m & 0x410) != 0) {
            if (e.isShiftDown()) {
                this.x = this.drawToX(newx);
            } else if (e.isAltDown()) {
                this.y = this.drawToY(newy);
            } else {
                this.x = this.drawToX(newx);
                this.y = this.drawToY(newy);
            }
            MouseEvent e1 = new MouseEvent(this, e.getID(), e.getWhen(), m, this.x, this.y, e.getClickCount(), e.isPopupTrigger(), e.getButton());
            for (int i = 0; i < this.MouseMotionListenerList.size(); ++i) {
                ((MouseMotionListener)this.MouseMotionListenerList.get(i)).mouseDragged(e1);
            }
            this.CursorRect.setBounds(this.xToDraw(this.x) - this.CursorCentre, this.yToDraw(this.y) - this.CursorCentre, this.CursorSize, this.CursorSize);
            this.repaint();
        }
    }

    protected void pickerMouseMoved(MouseEvent e) {
    }

    protected void pickerNudged(int newDirection, boolean newReleased) {
        if (newReleased) {
            MouseEvent e1 = new MouseEvent(this, 0, System.currentTimeMillis(), 0, this.x, this.y, 1, false, 1);
            for (int i = 0; i < this.MouseListenerList.size(); ++i) {
                ((MouseListener)this.MouseListenerList.get(i)).mouseReleased(e1);
            }
        } else {
            switch (newDirection) {
                case 0: {
                    this.y = Math.min(100, this.y + 1);
                    break;
                }
                case 1: {
                    this.y = Math.max(0, this.y - 1);
                    break;
                }
                case 2: {
                    this.x = Math.max(0, this.x - 1);
                    break;
                }
                case 3: {
                    this.x = Math.min(100, this.x + 1);
                }
            }
            this.CursorRect.setBounds(this.xToDraw(this.x) - this.CursorCentre, this.yToDraw(this.y) - this.CursorCentre, this.CursorSize, this.CursorSize);
            this.repaint();
            MouseEvent e1 = new MouseEvent(this, 0, System.currentTimeMillis(), 0, this.x, this.y, 1, false, 1);
            for (int i = 0; i < this.MouseMotionListenerList.size(); ++i) {
                ((MouseMotionListener)this.MouseMotionListenerList.get(i)).mouseDragged(e1);
            }
        }
    }

    protected void paintPickerBorder(Graphics2D g) {
    }

    protected void paintPickerBackground(Graphics2D g) {
    }

    protected void paintPickerCursor(Graphics2D g) {
    }

    protected int xToDraw(int newX) {
        return newX;
    }

    protected int drawToX(int newDrawX) {
        return newDrawX;
    }

    protected int yToDraw(int newY) {
        return newY;
    }

    protected int drawToY(int newDrawY) {
        return newDrawY;
    }

    public iArtPickerBase() {
        this(50, 50);
    }

    public iArtPickerBase(int newx, int newy) {
        super.addMouseListener(new PickerMouseAdapter());
        super.addMouseMotionListener(new PickerMouseMotionAdapter());
        this.VisibleEnabled = true;
        this.MouseOver = false;
        this.PickerImageOn = null;
        this.PickerImageOff = null;
        this.x = newx;
        this.y = newy;
        this.MouseListenerList = new ArrayList();
        this.MouseMotionListenerList = new ArrayList();
        this.setLayout(new FlowLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.getInputMap().put(KeyStroke.getKeyStroke("UP"), "NUDGE_UP_ID");
        this.getActionMap().put("NUDGE_UP_ID", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iArtPickerBase.this.pickerNudged(0, false);
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("released UP"), "NUDGE_UP_RELEASED_ID");
        this.getActionMap().put("NUDGE_UP_RELEASED_ID", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iArtPickerBase.this.pickerNudged(0, true);
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("DOWN"), "NUDGE_DOWN_ID");
        this.getActionMap().put("NUDGE_DOWN_ID", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iArtPickerBase.this.pickerNudged(1, false);
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("released DOWN"), "NUDGE_DOWN_RELEASED_ID");
        this.getActionMap().put("NUDGE_DOWN_RELEASED_ID", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iArtPickerBase.this.pickerNudged(1, true);
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("LEFT"), "NUDGE_LEFT_ID");
        this.getActionMap().put("NUDGE_LEFT_ID", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iArtPickerBase.this.pickerNudged(2, false);
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("released LEFT"), "NUDGE_LEFT_RELEASED_ID");
        this.getActionMap().put("NUDGE_LEFT_RELEASED_ID", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iArtPickerBase.this.pickerNudged(2, true);
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("RIGHT"), "NUDGE_RIGHT_ID");
        this.getActionMap().put("NUDGE_RIGHT_ID", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iArtPickerBase.this.pickerNudged(3, false);
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke("released RIGHT"), "NUDGE_RIGHT_RELEASED_ID");
        this.getActionMap().put("NUDGE_RIGHT_RELEASED_ID", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                iArtPickerBase.this.pickerNudged(3, true);
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                iArtPickerBase.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                iArtPickerBase.this.repaint();
            }
        });
    }

    public boolean isVisibleEnabled() {
        return this.VisibleEnabled;
    }

    public void setVisibleEnabled(boolean newValue) {
        this.VisibleEnabled = newValue;
    }

    public void setValueSilently(int newx, int newy) {
        this.x = newx;
        this.y = newy;
        this.CursorRect.setBounds(this.xToDraw(this.x) - this.CursorCentre, this.yToDraw(this.y) - this.CursorCentre, this.CursorSize, this.CursorSize);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintPickerBorder((Graphics2D)g.create());
        this.paintPickerBackground((Graphics2D)g.create());
        this.paintPickerCursor((Graphics2D)g.create());
    }

    @Override
    public void addMouseListener(MouseListener l) {
        this.MouseListenerList.add(l);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener l) {
        this.MouseMotionListenerList.add(l);
    }

    @Override
    public void removeMouseListener(MouseListener l) {
        this.MouseListenerList.remove(l);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener l) {
        this.MouseListenerList.remove(l);
    }

    protected class PickerMouseMotionAdapter
    extends MouseMotionAdapter {
        protected PickerMouseMotionAdapter() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (iArtPickerBase.this.isEnabled()) {
                iArtPickerBase.this.pickerMouseDragged(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (iArtPickerBase.this.isEnabled()) {
                iArtPickerBase.this.pickerMouseMoved(e);
            }
        }
    }

    protected class PickerMouseAdapter
    extends MouseAdapter {
        protected PickerMouseAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (iArtPickerBase.this.isEnabled()) {
                iArtPickerBase.this.pickerMousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (iArtPickerBase.this.isEnabled()) {
                iArtPickerBase.this.pickerMouseReleased(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (iArtPickerBase.this.isEnabled()) {
                iArtPickerBase.this.pickerMouseEntered(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (iArtPickerBase.this.isEnabled()) {
                iArtPickerBase.this.pickerMouseExited(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (iArtPickerBase.this.isEnabled()) {
                iArtPickerBase.this.pickerMouseClicked(e);
            }
        }
    }
}

