/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.iArt;

import com.Fo2PiX.iArt.iArt;
import com.Fo2PiX.iArt.swing.JImageView;
import com.arc.awt.event.ProgressListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;

public class iArtStatusBar
extends JPanel
implements ProgressListener {
    protected static final int DEFAULT_PROGRESS_TIMEOUT = 10000;
    protected String ProgressBarTitle = "";
    protected JLabel ImageInfo = new JLabel(" ");
    protected JLabel AppStatus = new JLabel(" ");
    protected JLabel Progress = new JLabel(" ");
    protected JLabel StencilLabel = new JLabel(" ");
    protected JLabel RecordLabel = new JLabel(" ");
    protected JPanel ProgressSection;
    protected JProgressBar ProgressBar = new JProgressBar(0);
    protected GridBagConstraints ProgressBarConstraints = new GridBagConstraints();
    protected boolean AutoVwRepaintEnabled = false;
    protected boolean ProgressBarEnabled = false;
    protected boolean TimeoutEnabled = false;
    protected Timer ProgressTimer;
    protected iArt App;
    protected JImageView Vw;
    protected JStatusBarProgressRange CurrentRange = null;

    protected void addCompartments() {
        if (this.App.Config.Platform == 1) {
            Font LFont = this.ImageInfo.getFont();
            this.ImageInfo.setFont(LFont.deriveFont((float)LFont.getSize() - 2.0f));
            this.AppStatus.setFont(LFont.deriveFont((float)LFont.getSize() - 2.0f));
            this.Progress.setFont(LFont.deriveFont((float)LFont.getSize() - 2.0f));
            this.StencilLabel.setFont(LFont.deriveFont((float)LFont.getSize() - 2.0f));
            this.RecordLabel.setFont(LFont.deriveFont((float)LFont.getSize() - 2.0f));
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.gridx = 0;
        c.fill = 0;
        JStatusBarInnerPanel ImageInfoSection = new JStatusBarInnerPanel(){
            Dimension Size = new Dimension();

            @Override
            public Dimension getPreferredSize() {
                this.Size.setSize(250, super.getPreferredSize().height + 3);
                return this.Size;
            }
        };
        ImageInfoSection.add((Component)this.ImageInfo, "Center");
        this.add((Component)ImageInfoSection, c);
        Box myBox = new Box(0);
        myBox.setPreferredSize(new Dimension(1, this.getPreferredSize().height));
        this.add(myBox);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 2;
        c.fill = 1;
        JStatusBarInnerPanel ScriptInfoSection = new JStatusBarInnerPanel(){
            Dimension Size = new Dimension();

            @Override
            public Dimension getPreferredSize() {
                this.Size.setSize(100, super.getPreferredSize().height);
                return this.Size;
            }
        };
        ScriptInfoSection.add((Component)this.Progress, "Center");
        this.add((Component)ScriptInfoSection, c);
        myBox = new Box(0);
        myBox.setPreferredSize(new Dimension(1, this.getPreferredSize().height));
        this.add(myBox);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 4;
        c.fill = 1;
        this.ProgressSection = new JPanel();
        this.ProgressSection.setBorder(BorderFactory.createEtchedBorder());
        this.ProgressSection.setLayout(new GridBagLayout());
        this.ProgressBarConstraints.weightx = 1.0;
        this.ProgressBarConstraints.weighty = 1.0;
        this.ProgressBarConstraints.fill = 1;
        this.add((Component)this.ProgressSection, c);
        myBox = new Box(0);
        myBox.setPreferredSize(new Dimension(1, this.getPreferredSize().height));
        this.add(myBox);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 6;
        c.fill = 0;
        JStatusBarInnerPanel MachineStatusSection = new JStatusBarInnerPanel(){
            Dimension Size = new Dimension();

            @Override
            public Dimension getPreferredSize() {
                this.Size.setSize(35, super.getPreferredSize().height + 3);
                return this.Size;
            }
        };
        MachineStatusSection.add((Component)this.StencilLabel, "Center");
        this.add((Component)MachineStatusSection, c);
        this.StencilLabel.setFont(this.StencilLabel.getFont().deriveFont(1));
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridx = 7;
        c.fill = 0;
        JStatusBarInnerPanel RecordSection = new JStatusBarInnerPanel(){
            Dimension Size = new Dimension();

            @Override
            public Dimension getPreferredSize() {
                this.Size.setSize(35, super.getPreferredSize().height + 3);
                return this.Size;
            }
        };
        RecordSection.add((Component)this.RecordLabel, "Center");
        this.add((Component)RecordSection, c);
        this.RecordLabel.setForeground(Color.RED);
        this.RecordLabel.setFont(this.StencilLabel.getFont().deriveFont(1));
    }

    protected void setCurrentRange(JStatusBarProgressRange newRange) {
        this.CurrentRange = newRange;
        if (this.CurrentRange != null) {
            this.CurrentRange.update(this.ProgressBar);
        }
    }

    public iArtStatusBar(iArt newApp, JImageView newVw) {
        this.Vw = newVw;
        this.App = newApp;
        this.addCompartments();
        this.ProgressTimer = new Timer(10000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                iArtStatusBar.this.ProgressBar.setIndeterminate(true);
                iArtStatusBar.this.ProgressBar.validate();
                iArtStatusBar.this.ProgressBar.repaint();
                iArtStatusBar.this.ProgressTimer.stop();
            }
        });
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public boolean progressEvent(String newUpdateMessage) {
        this.Progress.setText(newUpdateMessage);
        return true;
    }

    public boolean progressEvent(String newUpdateMessage, int newValue) {
        this.Progress.setText(newUpdateMessage);
        this.progressEvent(newValue);
        return true;
    }

    public void pushProgressRange(int newMinValue, int newMaxValue, int newTimeout) {
        this.setCurrentRange(new JStatusBarProgressRange(this.CurrentRange, newMaxValue, 0, newTimeout));
        if (this.CurrentRange.InnerRange == null) {
            this.setProgressBarEnabled(true);
        }
    }

    public void popProgressRange() {
        if (this.CurrentRange.InnerRange != null) {
            this.CurrentRange.InnerRange.setModValue(this.CurrentRange.InnerRange.getValue() + 1);
        }
        this.setCurrentRange(this.CurrentRange.InnerRange);
        if (this.CurrentRange == null) {
            this.setProgressBarEnabled(false);
        }
    }

    public boolean progressEvent(int newValue) {
        if (this.CurrentRange != null && this.ProgressBarEnabled) {
            this.ProgressBar.setIndeterminate(false);
            this.CurrentRange.setValue(newValue);
            this.CurrentRange.update(this.ProgressBar);
            if (this.TimeoutEnabled) {
                this.ProgressTimer.restart();
            }
        }
        if (this.AutoVwRepaintEnabled) {
            this.Vw.repaint();
        }
        return true;
    }

    public String getProgressMessage() {
        return this.Progress.getText();
    }

    public int getProgressValue() {
        return this.CurrentRange.getValue();
    }

    public void setImageInfo(String newImageInfo) {
        if (!this.App.Config.SimpleView) {
            this.ImageInfo.setText(newImageInfo);
        }
    }

    public void setProgressBarEnabled(boolean newValue) {
        if (this.ProgressBarEnabled != newValue) {
            this.ProgressBarEnabled = newValue;
            if (!this.ProgressBarEnabled || this.CurrentRange == null) {
                this.ProgressSection.remove(this.ProgressBar);
                this.ProgressSection.setBorder(BorderFactory.createEtchedBorder());
                if (this.CurrentRange != null) {
                    this.CurrentRange = null;
                }
            } else {
                this.ProgressSection.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
                this.ProgressSection.add((Component)this.ProgressBar, this.ProgressBarConstraints);
            }
            this.ProgressSection.revalidate();
            this.ProgressSection.repaint();
        }
    }

    public void setTimeoutEnabled(boolean newValue) {
        if (this.TimeoutEnabled != newValue) {
            this.TimeoutEnabled = newValue;
            if (!this.TimeoutEnabled || this.CurrentRange == null) {
                this.ProgressTimer.stop();
                this.ProgressBar.setIndeterminate(false);
                this.ProgressBar.validate();
                this.ProgressBar.repaint();
            } else {
                this.ProgressTimer.setDelay(this.CurrentRange.Timeout);
                this.ProgressTimer.restart();
            }
            this.ProgressSection.revalidate();
            this.ProgressSection.repaint();
        }
    }

    public void setAutoVwRepaintEnabled(boolean newValue) {
    }

    public void setProgressText(String newString) {
        this.Progress.setText(newString);
    }

    public void setRecordActive(boolean newValue) {
        if (newValue && !this.App.Config.SimpleView) {
            this.RecordLabel.setText("R");
        } else {
            this.RecordLabel.setText(" ");
        }
    }

    public void setStencilActive(boolean newValue) {
        if (newValue && !this.App.Config.SimpleView) {
            this.StencilLabel.setText("S");
        } else {
            this.StencilLabel.setText(" ");
        }
    }

    protected class JStatusBarInnerPanel
    extends JPanel {
        public JStatusBarInnerPanel() {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 10, 0, 10)));
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }
    }

    protected class JStatusBarProgressRange {
        protected int Value;
        protected int ModValue;
        protected int TotalValue;
        public final int Range;
        public final int TotalRange;
        public final int Timeout;
        protected JStatusBarProgressRange InnerRange;

        public JStatusBarProgressRange(JStatusBarProgressRange newInnerRange, int newRange, int newValue, int newTimeout) {
            this.Timeout = newTimeout;
            this.Range = newRange;
            this.TotalRange = newInnerRange == null ? this.Range : newInnerRange.TotalRange * this.Range;
            this.setValue(newValue);
            this.setModValue(newValue);
            this.InnerRange = newInnerRange;
        }

        public void setInnerRange(JStatusBarProgressRange newInnerRange) {
            this.InnerRange = newInnerRange;
        }

        public JStatusBarProgressRange getInnerRange() {
            return this.InnerRange;
        }

        public void setModValue(int newValue) {
            this.ModValue = Math.max(Math.min(newValue, this.Range), 0);
        }

        public int getModValue() {
            return this.ModValue;
        }

        public void setValue(int newValue) {
            this.Value = Math.max(Math.min(newValue, this.Range), 0);
        }

        public int getValue() {
            return this.Value;
        }

        public int getTotalValue() {
            return this.InnerRange == null ? Math.max(this.ModValue, this.Value) : this.InnerRange.getTotalValue() * this.Range + Math.max(this.ModValue, this.Value);
        }

        public void update(JProgressBar newProgressBar) {
            newProgressBar.getModel().setRangeProperties(this.getTotalValue(), 0, 0, this.TotalRange, false);
            newProgressBar.revalidate();
            newProgressBar.repaint();
        }
    }
}

