/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.iArt.view.accessory;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class iArtColourPicker
extends JPanel {
    private Color ColVal = Color.BLACK;
    private float BorderWidth = 0.0f;
    private BufferedImage PickerImg;
    private int PickerWidth;
    private int PickerHeight;
    private int HueX = 2;
    private int HueY = 2;
    private int ValueX = 0;
    private int ValueY = 0;

    protected boolean RangeCheck(int x, int y) {
        return (double)x >= 0.1 * (double)this.BorderWidth && (double)x < (double)this.PickerWidth - 0.1 * (double)this.BorderWidth && (double)y >= 0.1 * (double)this.BorderWidth && (double)y < 0.9 * (double)this.BorderWidth;
    }

    protected boolean inBorder(int x, int y) {
        if (y >= 0 && (double)y < 0.1 * (double)this.BorderWidth) {
            return true;
        }
        if ((double)y >= 0.9 * (double)this.BorderWidth && y < this.PickerHeight) {
            return true;
        }
        if ((double)y >= 0.1 * (double)this.BorderWidth && (double)y < 0.9 * (double)this.BorderWidth && x >= 0 && (double)x < 0.1 * (double)this.BorderWidth) {
            return true;
        }
        return (double)y >= 0.1 * (double)this.BorderWidth && (double)y < 0.9 * (double)this.BorderWidth && (double)x >= (double)this.PickerWidth - 0.1 * (double)this.BorderWidth && x < this.PickerWidth;
    }

    protected void MoveCursor(Color col) {
        if (this.isEnabled()) {
            this.setColour(col);
            float[] hsbvals = new float[3];
            Color.RGBtoHSB(col.getRed(), col.getGreen(), col.getBlue(), hsbvals);
            this.ConstructInnerBox(hsbvals[0]);
            this.repaint();
        }
    }

    protected void createSwatch() {
        this.ConstructBorder();
        this.ConstructInnerBox(1.0f);
    }

    protected int mapCoordinRingtoColor(int x, int y) {
        float startHue = 1.0f;
        float startSat = 1.0f;
        float startBri = 1.0f;
        double perimeter = (double)(this.PickerWidth * 2) + ((double)this.PickerHeight - (double)this.BorderWidth * 0.2) * 2.0;
        double scale = 1.0 / perimeter;
        if (y >= 0 && (double)y < 0.1 * (double)this.BorderWidth) {
            startSat = 1.0f;
            startBri = 1.0f;
            startHue = (float)x / (float)perimeter;
        } else if ((double)y >= 0.9 * (double)this.BorderWidth && y < this.PickerHeight) {
            startSat = 1.0f;
            startBri = 1.0f;
            startHue = (float)(((double)(this.PickerWidth - x + this.PickerWidth) + ((double)this.PickerHeight - 0.2 * (double)this.BorderWidth)) * scale);
        } else if ((double)y >= 0.1 * (double)this.BorderWidth && (double)y < 0.9 * (double)this.BorderWidth && x >= 0 && (double)x < 0.1 * (double)this.BorderWidth) {
            startSat = 1.0f;
            startBri = 1.0f;
            startHue = (float)(((double)(this.PickerHeight - y + 2 * this.PickerWidth) + ((double)this.PickerHeight - 0.2 * (double)this.BorderWidth)) * scale);
        } else if ((double)y >= 0.1 * (double)this.BorderWidth && (double)y < 0.9 * (double)this.BorderWidth && (double)x >= (double)this.PickerWidth - 0.1 * (double)this.BorderWidth && x < this.PickerWidth) {
            startSat = 1.0f;
            startBri = 1.0f;
            startHue = (float)((double)(y + this.PickerWidth) * scale);
        }
        int start = Color.getHSBColor(startHue, startSat, startBri).getRGB();
        return start;
    }

    protected int mapCoordToColor(int x, int y, float currentHue) {
        double yrange;
        float startHue = currentHue;
        float startSat = 1.0f;
        float startBri = 1.0f;
        if ((double)y >= 0.1 * (double)this.BorderWidth && (double)y < 0.8 * (double)this.BorderWidth && (double)x >= 0.1 * (double)this.BorderWidth + 0.1 * (double)this.PickerWidth && (double)x < (double)this.PickerWidth - 0.1 * (double)this.BorderWidth) {
            yrange = 0.8 * (double)this.BorderWidth - 0.1 * (double)this.BorderWidth;
            double xrange = (double)this.PickerWidth - 0.1 * (double)this.BorderWidth - (0.1 * (double)this.BorderWidth + 0.1 * (double)this.PickerWidth);
            startBri = (float)(((double)y - 0.1 * (double)this.BorderWidth) / yrange);
            startSat = (float)(((double)x - 0.1 * (double)this.BorderWidth - 0.1 * (double)this.PickerWidth) / xrange);
            startHue = currentHue;
        } else if ((double)y >= 0.2 * (double)this.BorderWidth && (double)y < 0.8 * (double)this.BorderWidth && (double)x >= 0.1 * (double)this.BorderWidth && (double)x < 0.1 * (double)this.BorderWidth + 0.1 * (double)this.PickerWidth) {
            yrange = 0.8 * (double)this.BorderWidth - 0.1 * (double)this.BorderWidth;
            startSat = 0.0f;
            startBri = (float)(((double)y - 0.1 * (double)this.BorderWidth) / yrange);
            startHue = currentHue;
        } else if ((double)y >= 0.8 * (double)this.BorderWidth && (double)y < 0.9 * (double)this.BorderWidth && (double)x >= 0.1 * (double)this.BorderWidth + 0.1 * (double)this.PickerWidth && (double)x < (double)this.PickerWidth - 0.1 * (double)this.BorderWidth) {
            double xrange = (double)this.PickerWidth - 0.1 * (double)this.BorderWidth - (0.1 * (double)this.BorderWidth + 0.1 * (double)this.PickerWidth);
            startSat = (float)(((double)x - 0.1 * (double)this.BorderWidth - 0.1 * (double)this.PickerWidth) / xrange);
            startBri = 1.0f;
            startHue = currentHue;
        } else if ((double)y >= 0.1 * (double)this.BorderWidth && (double)y < 0.2 * (double)this.BorderWidth && (double)x >= 0.1 * (double)this.BorderWidth && (double)x < 0.1 * (double)this.BorderWidth + 0.1 * (double)this.PickerWidth) {
            startSat = 1.0f;
            startBri = 0.0f;
            startHue = currentHue;
        } else if ((double)y >= 0.8 * (double)this.BorderWidth && (double)y < 0.9 * (double)this.BorderWidth && (double)x >= 0.1 * (double)this.BorderWidth && (double)x < 0.1 * (double)this.BorderWidth + 0.1 * (double)this.PickerWidth) {
            startSat = 0.0f;
            startBri = 1.0f;
            startHue = currentHue;
        } else if ((double)y >= 0.8 * (double)this.BorderWidth && (double)y < 0.9 * (double)this.BorderWidth && (double)x >= (double)this.PickerWidth - 0.1 * (double)this.BorderWidth - 0.1 * (double)this.PickerWidth && (double)x < (double)this.PickerWidth - 0.1 * (double)this.BorderWidth) {
            startSat = 1.0f;
            startBri = 1.0f;
            startHue = currentHue;
        }
        int start = Color.getHSBColor(startHue, startSat, startBri).getRGB();
        return start;
    }

    protected void ConstructBorder() {
        int start1;
        int start;
        int j;
        this.PickerImg = new BufferedImage(this.PickerWidth, this.PickerHeight, 5);
        int i = 0;
        while ((double)i < 0.1 * (double)this.BorderWidth) {
            for (j = 0; j < this.PickerWidth; ++j) {
                start = this.mapCoordinRingtoColor(j, i);
                this.PickerImg.setRGB(j, i, start);
                start1 = this.mapCoordinRingtoColor(j, (int)((double)i + 0.9 * (double)this.BorderWidth));
                this.PickerImg.setRGB(j, (int)((double)i + 0.9 * (double)this.BorderWidth), start1);
            }
            ++i;
        }
        for (i = 0; i < this.PickerHeight; ++i) {
            j = 0;
            while ((double)j < 0.1 * (double)this.BorderWidth) {
                start = this.mapCoordinRingtoColor(j, i);
                this.PickerImg.setRGB(j, i, start);
                start1 = this.mapCoordinRingtoColor((int)((double)(j + this.PickerWidth) - 0.1 * (double)this.BorderWidth), i);
                this.PickerImg.setRGB((int)((double)(j + this.PickerWidth) - 0.1 * (double)this.BorderWidth), i, start1);
                ++j;
            }
        }
    }

    protected void ConstructInnerBox(float starhu) {
        int i = (int)(0.1 * (double)this.BorderWidth);
        while ((double)i < 0.9 * (double)this.BorderWidth) {
            int j = (int)(0.1 * (double)this.BorderWidth);
            while ((double)j < (double)this.PickerWidth - 0.1 * (double)this.BorderWidth) {
                int start = this.mapCoordToColor(j, i, starhu);
                this.PickerImg.setRGB(j, i, start);
                ++j;
            }
            ++i;
        }
    }

    public iArtColourPicker() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                iArtColourPicker.this.refresh();
            }
        });
    }

    public void refresh() {
        Color Col = this.ColVal;
        this.PickerWidth = this.getWidth();
        this.PickerHeight = this.getHeight();
        this.BorderWidth = this.PickerHeight;
        this.createSwatch();
        this.setColour(Col);
        this.repaint();
    }

    public void setColour(Color newColour) {
        float[] hsbvals = new float[4];
        Color.RGBtoHSB(newColour.getRed(), newColour.getGreen(), newColour.getBlue(), hsbvals);
        int xnew = 0;
        int ynew = 0;
        if (hsbvals[1] == 1.0f && hsbvals[2] == 1.0f) {
            xnew = (int)((double)this.PickerWidth - 0.1 * (double)this.BorderWidth - 0.1 * (double)this.PickerWidth);
            ynew = (int)(0.8 * (double)this.BorderWidth);
        } else if (hsbvals[1] == 0.0f && hsbvals[2] == 1.0f) {
            xnew = (int)(0.1 * (double)this.BorderWidth + 0.1 * (double)this.PickerWidth);
            ynew = (int)(0.8 * (double)this.BorderWidth);
        } else if (hsbvals[1] == 1.0f && hsbvals[2] == 0.0f) {
            xnew = (int)(0.1 * (double)this.BorderWidth + 0.1 * (double)this.PickerWidth);
            ynew = (int)(0.2 * (double)this.BorderWidth);
        } else {
            double yrange = 0.8 * (double)this.BorderWidth - 0.1 * (double)this.BorderWidth;
            double xrange = (double)this.PickerWidth - 0.1 * (double)this.BorderWidth - 0.1 * (double)this.BorderWidth - 0.1 * (double)this.PickerWidth;
            ynew = (int)((double)hsbvals[2] * yrange + 0.1 * (double)this.BorderWidth);
            xnew = (int)((double)hsbvals[1] * xrange + (0.1 * (double)this.BorderWidth + 0.1 * (double)this.PickerWidth));
        }
        this.ValueX = xnew;
        this.ValueY = ynew;
        this.ColVal = newColour;
        float[] hsbvals1 = new float[3];
        Color.RGBtoHSB(this.ColVal.getRed(), this.ColVal.getGreen(), this.ColVal.getBlue(), hsbvals1);
        float hue = hsbvals1[0];
        double perimeter = (double)(this.PickerWidth * 2) + ((double)this.PickerHeight - (double)this.BorderWidth * 0.2) * 2.0;
        double scale = 1.0 / perimeter;
        this.HueX = (int)((double)hue * perimeter);
        this.HueY = (int)(0.05 * (double)this.BorderWidth);
        int tempringX = (int)((double)hue * perimeter);
        if (tempringX - this.PickerWidth > 0) {
            this.HueX = (int)((double)this.PickerWidth - 0.05 * (double)this.BorderWidth);
            this.HueY = (int)((double)hue / scale - (double)this.PickerWidth);
        }
        if ((double)(tempringX - this.PickerWidth) - ((double)this.PickerHeight - (double)this.BorderWidth * 0.2) > 0.0) {
            this.HueY = (int)(0.95 * (double)this.BorderWidth);
            this.HueX = this.PickerWidth - (int)((double)hue / scale - (double)this.PickerWidth - ((double)this.PickerHeight - (double)this.BorderWidth * 0.2));
        }
        if ((double)(tempringX - 2 * this.PickerWidth) - ((double)this.PickerHeight - (double)this.BorderWidth * 0.2) > 0.0) {
            this.HueX = (int)(0.05 * (double)this.BorderWidth);
            this.HueX = this.PickerHeight - (int)((double)hue / scale - (double)(2 * this.PickerWidth) - ((double)this.PickerHeight - (double)this.BorderWidth * 0.2));
        }
        this.ConstructInnerBox(hsbvals[0]);
        this.repaint();
    }

    public Color getColour(int newX, int newY, boolean newDrag) {
        if (this.isEnabled()) {
            if (this.inBorder(newX = Math.max(Math.min(this.PickerWidth - 1, newX), 0), newY = Math.max(Math.min(this.PickerHeight - 1, newY), 0))) {
                this.HueX = newX;
                this.HueY = newY;
                float[] hsbvals = new float[3];
                Color newCol = new Color(this.PickerImg.getRGB(newX, newY));
                Color.RGBtoHSB(newCol.getRed(), newCol.getGreen(), newCol.getBlue(), hsbvals);
                this.ConstructInnerBox(hsbvals[0]);
            } else {
                this.ValueX = newX;
                this.ValueY = newY;
            }
            this.ColVal = new Color(this.PickerImg.getRGB(this.ValueX, this.ValueY));
            this.repaint();
            return this.ColVal;
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.isEnabled() && this.PickerImg != null) {
            g.drawImage(this.PickerImg, 0, 0, this);
            int Red = this.ColVal.getRed();
            int Green = this.ColVal.getGreen();
            int Blue = this.ColVal.getBlue();
            Color Inverse = new Color(255 - Red, 255 - Green, 255 - Blue);
            g.setColor(Inverse);
            g.drawLine(this.ValueX, this.ValueY, this.ValueX, this.ValueY);
            g.drawRect(this.ValueX - 3, this.ValueY - 3, 6, 6);
            Color color1 = new Color(this.PickerImg.getRGB(this.HueX, this.HueY));
            g.setColor(new Color(255 - color1.getRed(), 255 - color1.getGreen(), 255 - color1.getBlue()));
            g.drawLine(this.HueX - 3, this.HueY, this.HueX + 3, this.HueY);
            g.drawLine(this.HueX, this.HueY - 3, this.HueX, this.HueY + 3);
        } else {
            g.setColor(Color.lightGray);
            g.fillRect(0, 0, this.PickerWidth, this.PickerHeight);
        }
        g.setColor(Color.black);
    }
}

