/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.iArt.view.accessory;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class iArtSourceSelectionGroupPanelButton
extends JButton {
    public static final int THUMBNAIL_DISPLAY_MODE_BUTTON_NAME = 0;
    public static final int THUMBNAIL_DISPLAY_MODE_SOURCE_NAME = 1;
    private static final int THUMBNAIL_BUTTON_BORDER = 10;
    private String Name;
    private String ImgName;
    private String ImgDispName;
    private Color DefaultCol;
    private Color SelectedCol;
    private Color BackgroundCol;
    private boolean Selected;
    private BufferedImage ThmbImg;
    private BufferedImage ThmbLoadImg;
    private Dimension ThmbLoadImgPos;
    private JPopupMenu ThmbPopupMenu;
    private Dimension ThmbDispSize;
    private int ThmbDispMode;

    private void buildLayout() {
        this.setFocusable(false);
        this.setFocusPainted(false);
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.setAlignmentY(0.0f);
    }

    public iArtSourceSelectionGroupPanelButton(String newName, String newImgName, String newImgDispName, Dimension newThmbSize, BufferedImage newThmbLoadImg, JPopupMenu newThmbPopupMenu, ActionListener newActionListener) {
        this.buildLayout();
        this.addActionListener(newActionListener);
        this.Name = newName;
        this.ImgName = newImgName;
        this.ImgDispName = newImgDispName;
        this.DefaultCol = new Color(170, 170, 170);
        this.SelectedCol = new Color(250, 230, 160);
        this.BackgroundCol = new Color(204, 204, 204);
        this.ThmbImg = null;
        this.Selected = false;
        this.ThmbLoadImg = newThmbLoadImg;
        this.ThmbPopupMenu = newThmbPopupMenu;
        this.ThmbDispMode = 0;
        this.ThmbDispSize = new Dimension(newThmbSize.width + 10, newThmbSize.height + 10);
        this.ThmbLoadImgPos = new Dimension(this.ThmbDispSize.width / 2 - this.ThmbLoadImg.getWidth() / 2, this.ThmbDispSize.height / 2 - this.ThmbLoadImg.getHeight() / 2);
        if (this.ThmbPopupMenu != null) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (SwingUtilities.isRightMouseButton(e)) {
                        iArtSourceSelectionGroupPanelButton.this.ThmbPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        Dimension TextPos;
        TextLayout ImageIDLayout;
        Graphics2D g2D = (Graphics2D)g;
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        iArtSourceSelectionGroupPanelButton iArtSourceSelectionGroupPanelButton2 = this;
        synchronized (iArtSourceSelectionGroupPanelButton2) {
            if (this.getSelected()) {
                g2D.setColor(this.SelectedCol);
                g2D.fillRoundRect(0, 0, this.ThmbDispSize.width, this.ThmbDispSize.height, 5, 5);
                g2D.setColor(this.BackgroundCol);
                g2D.fillRect(5, 5, this.ThmbDispSize.width - 10, this.ThmbDispSize.height - 10);
            } else {
                g2D.setColor(this.DefaultCol);
                g2D.fillRoundRect(0, 0, this.ThmbDispSize.width, this.ThmbDispSize.height, 5, 5);
                g2D.setColor(this.BackgroundCol);
                g2D.fillRect(5, 5, this.ThmbDispSize.width - 10, this.ThmbDispSize.height - 10);
            }
            if (this.ThmbImg != null) {
                g2D.drawImage(this.ThmbImg, null, 5, 5);
            } else {
                g2D.drawImage(this.ThmbLoadImg, null, this.ThmbLoadImgPos.width, this.ThmbLoadImgPos.height);
            }
            ImageIDLayout = this.ThmbDispMode == 1 ? new TextLayout(this.Name + " (" + this.ImgDispName + ")", new Font(null, 0, 10), g2D.getFontRenderContext()) : new TextLayout(this.Name, new Font(null, 0, 10), g2D.getFontRenderContext());
            int InnterBoxWidth = 45;
            Dimension OuterBoxPos = new Dimension(8, 8);
            Dimension OuterBoxSize = new Dimension(InnterBoxWidth + 4, (int)(ImageIDLayout.getAscent() + 8.0f));
            Dimension InnerBoxPos = new Dimension(10, 10);
            Dimension InnterBoxSize = new Dimension(InnterBoxWidth, (int)(ImageIDLayout.getAscent() + 4.0f));
            TextPos = new Dimension((int)((float)(InnerBoxPos.width + InnterBoxWidth / 2) - ImageIDLayout.getAdvance() / 2.0f), (int)((float)InnerBoxPos.height + ImageIDLayout.getAscent()));
            if (this.isSelected()) {
                g2D.setColor(this.SelectedCol);
                g2D.fillRoundRect(OuterBoxPos.width, OuterBoxPos.height, OuterBoxSize.width, OuterBoxSize.height, 10, 10);
            } else {
                g2D.setColor(this.DefaultCol);
                g2D.fillRoundRect(OuterBoxPos.width, OuterBoxPos.height, OuterBoxSize.width, OuterBoxSize.height, 10, 10);
            }
            g2D.setColor(this.BackgroundCol);
            g2D.fillRoundRect(InnerBoxPos.width, InnerBoxPos.height, InnterBoxSize.width, InnterBoxSize.height, 10, 10);
        }
        g2D.setColor(Color.BLACK);
        ImageIDLayout.draw(g2D, TextPos.width, TextPos.height);
    }

    public synchronized void setSelectedColour(Color newColor) {
        this.SelectedCol = newColor;
    }

    public synchronized Color getSelectedColour() {
        return this.SelectedCol;
    }

    public synchronized void setSelected(boolean newValue, Color newColor) {
        this.SelectedCol = newColor;
        this.setSelected(newValue);
    }

    @Override
    public synchronized void setSelected(boolean newValue) {
        this.Selected = newValue;
        this.repaint();
    }

    public synchronized boolean getSelected() {
        return this.Selected;
    }

    public synchronized void setImage(BufferedImage newButtonThumbnailImage) {
        this.ThmbImg = newButtonThumbnailImage;
        this.repaint();
    }

    public synchronized BufferedImage getImage() {
        return this.ThmbImg;
    }

    public synchronized void invalidateImage() {
        this.ThmbImg = null;
        this.repaint();
    }

    public String getImageName() {
        return this.ImgName;
    }

    @Override
    public String getName() {
        return this.Name;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.ThmbDispSize.width, this.ThmbDispSize.height);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public static Dimension getDisplaySize(Dimension newThumbnailSize) {
        return new Dimension(newThumbnailSize.width + 10, newThumbnailSize.height + 10);
    }
}

