/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.iArt.view.controller.Studio.document;

import com.Fo2PiX.blendengine.operation.OpInfo;
import com.Fo2PiX.iArt.view.controller.Studio.document.Document;
import java.util.List;
import java.util.Vector;

public abstract class DocumentElementBase {
    public static final int ELM_TYPE_ROOT = 0;
    public static final int ELM_TYPE_FRAGMENT_CONTAINER = 1;
    public static final int ELM_TYPE_FRAGMENT = 2;
    public static final int ELM_TYPE_FRAGMENT_CONTENT = 3;
    protected Document Doc;
    protected Vector<OpInfo> OpList;
    public final Vector<String> Editors;
    public final int Type;

    DocumentElementBase(int newType, Document newDoc, Vector<OpInfo> newOpList) {
        this.Type = newType;
        this.Doc = newDoc;
        this.OpList = newOpList;
        this.Editors = new Vector();
        this.Editors.add(System.getProperty("user.name"));
    }

    public boolean isValidDocumentElement() {
        return false;
    }

    public Document getDocument() {
        if (this.isValidDocumentElement()) {
            return this.Doc;
        }
        throw new IllegalStateException("Element not contained in valid Document");
    }

    public int getIndex() {
        if (this.isValidDocumentElement()) {
            return 0;
        }
        throw new IllegalStateException("Element not contained in valid Document");
    }

    public int getStartOpListIndex() {
        if (this.isValidDocumentElement()) {
            return -1;
        }
        throw new IllegalStateException("Element not contained in valid Document");
    }

    public int getEndOpListIndex() {
        if (this.isValidDocumentElement()) {
            return this.getStartOpListIndex() + this.getOpListSize();
        }
        throw new IllegalStateException("Element not contained in valid Document");
    }

    public List<OpInfo> getOpList(List<OpInfo> newOpList) {
        return newOpList != null ? newOpList : new Vector();
    }

    public int getOpListSize() {
        return 0;
    }

    public List<OpInfo> getPreOpList() {
        if (this.isValidDocumentElement()) {
            return this.OpList.subList(0, this.getStartOpListIndex() + 1);
        }
        throw new IllegalStateException("Element not contained in valid Document");
    }

    public List<OpInfo> getPreOpList(int newStartIndex) {
        if (this.isValidDocumentElement()) {
            int CurrentIndex = this.getStartOpListIndex() + 1;
            return newStartIndex < CurrentIndex && newStartIndex > -1 ? this.OpList.subList(newStartIndex, CurrentIndex) : null;
        }
        throw new IllegalStateException("Element not contained in valid Document");
    }

    public List<OpInfo> getPostOpList() {
        if (this.isValidDocumentElement()) {
            return this.OpList.subList(this.getStartOpListIndex() + 1, this.OpList.size());
        }
        throw new IllegalStateException("Element not contained in valid Document");
    }

    public List<OpInfo> getPostOpList(int newEndIndex) {
        if (this.isValidDocumentElement()) {
            int CurrentIndex = this.getEndOpListIndex() + 1;
            return newEndIndex > CurrentIndex && newEndIndex < this.OpList.size() ? this.OpList.subList(CurrentIndex, newEndIndex + 1) : null;
        }
        throw new IllegalStateException("Element not contained in valid Document");
    }

    public OpInfo instanceOf(Class<? extends OpInfo> newOpType) {
        List<OpInfo> newList = this.getOpList(null);
        for (OpInfo newItem : newList) {
            if (!newOpType.isInstance(newItem)) continue;
            return newItem;
        }
        return null;
    }

    public OpInfo instanceOf(int newStartIdx, Class<? extends OpInfo> newOpType) {
        List<OpInfo> newList = this.getOpList(null);
        for (int i = newStartIdx; i < newList.size(); ++i) {
            OpInfo newItem = newList.get(i);
            if (!newOpType.isInstance(newItem)) continue;
            return newItem;
        }
        return null;
    }

    public OpInfo lastInstanceOf(Class<? extends OpInfo> newOpType) {
        List<OpInfo> newList = this.getOpList(null);
        for (int i = newList.size() - 1; i >= 0; --i) {
            OpInfo newItem = newList.get(i);
            if (!newOpType.isInstance(newItem)) continue;
            return newItem;
        }
        return null;
    }

    public OpInfo lastInstanceOf(int newStartIdx, Class<? extends OpInfo> newOpType) {
        List<OpInfo> newList = this.getOpList(null);
        for (int i = newStartIdx - 1; i >= 0; --i) {
            OpInfo newItem = newList.get(i);
            if (!newOpType.isInstance(newItem)) continue;
            return newItem;
        }
        return null;
    }
}

