/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.iArt.view.controller.Studio.document;

import com.Fo2PiX.blendengine.operation.OpInfo;
import com.Fo2PiX.iArt.view.controller.Studio.document.Document;
import com.Fo2PiX.iArt.view.controller.Studio.document.DocumentElementContainer;
import com.Fo2PiX.iArt.view.controller.Studio.document.DocumentElementContainerBase;
import com.Fo2PiX.iArt.view.controller.Studio.document.DocumentFragmentElement;
import com.Fo2PiX.iArt.view.controller.Studio.document.DocumentRootElement;
import com.Fo2PiX.iArt.view.controller.Studio.document.EditableDocumentElement;
import com.Fo2PiX.iArt.view.controller.Studio.document.event.ElementEditListener;
import com.Fo2PiX.iArt.view.controller.Studio.operation.FragmentContainerElementEdit;
import java.util.List;
import java.util.Vector;

public abstract class DocumentFragmentContainerElement
extends DocumentElementContainerBase
implements DocumentElementContainer<DocumentRootElement, DocumentFragmentElement>,
EditableDocumentElement<FragmentContainerElementEdit> {
    public static final int FRAGMENT_CONTAINER_TYPE_MANUAL = 0;
    public static final int FRAGMENT_CONTAINER_TYPE_WIZARD = 1;
    protected DocumentRootElement Container;
    protected Vector<DocumentFragmentElement> Content;
    protected FragmentContainerElementEdit OpenContentEdit;
    public final int FragmentContainerType;

    protected DocumentFragmentContainerElement getPreviousElement() {
        int index = this.getIndex();
        if (index > 0) {
            return this.Container.getContent().get(index - 1);
        }
        return null;
    }

    protected DocumentFragmentContainerElement getNextElement() {
        int index = this.getIndex();
        if (index < 0) {
            return this.Container.getContent().get(index + 1);
        }
        return null;
    }

    DocumentFragmentContainerElement(int newType, Document newDoc, Vector<OpInfo> newOpList, Vector<OpInfo> newLeadIn) {
        super(1, newDoc, newOpList, newLeadIn);
        this.FragmentContainerType = newType;
        this.Container = null;
        this.OpenContentEdit = null;
        this.Content = new Vector();
    }

    DocumentFragmentContainerElement(int newType, Document newDoc, Vector<OpInfo> newOpList) {
        super(1, newDoc, newOpList);
        this.FragmentContainerType = newType;
        this.Container = null;
        this.OpenContentEdit = null;
        this.Content = new Vector();
    }

    @Override
    public boolean isValidDocumentElement() {
        return this.Container != null;
    }

    @Override
    public void setContainer(DocumentRootElement newContainer) {
        this.Container = newContainer;
    }

    @Override
    public DocumentRootElement getContainer() {
        return this.Container;
    }

    @Override
    public int getIndex() {
        int index;
        if (this.isValidDocumentElement() && (index = this.Container.getContent().indexOf(this)) > -1) {
            return index;
        }
        throw new IllegalStateException("Element not contained in valid Document");
    }

    @Override
    public int getStartOpListIndex() {
        int index = this.getIndex();
        if (index == 0) {
            return this.Container.getContentStartOpListIndex();
        }
        return this.getPreviousElement().getEndOpListIndex();
    }

    @Override
    public List<OpInfo> getOpList(List<OpInfo> newOpList) {
        if (newOpList == null) {
            newOpList = new Vector<OpInfo>();
        }
        newOpList.addAll(this.getLeadIn());
        for (DocumentFragmentElement ContentElement : this.Content) {
            ContentElement.getOpList(newOpList);
        }
        newOpList.addAll(this.getLeadOut());
        return newOpList;
    }

    @Override
    public int getOpListSize() {
        int count = this.getLeadInSize();
        for (DocumentFragmentElement ContentElement : this.Content) {
            count += ContentElement.getOpListSize();
        }
        return count += this.getLeadOutSize();
    }

    @Override
    public Vector<DocumentFragmentElement> getContent() {
        return this.Content;
    }

    @Override
    public List<OpInfo> getContentOpList(List<OpInfo> newOpList) {
        if (newOpList == null) {
            newOpList = new Vector<OpInfo>();
        }
        for (DocumentFragmentElement ContentElement : this.Content) {
            ContentElement.getOpList(newOpList);
        }
        return newOpList;
    }

    @Override
    public int getContentOpListSize() {
        int count = 0;
        for (DocumentFragmentElement ContentElement : this.Content) {
            count += ContentElement.getOpListSize();
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return this.Content.isEmpty();
    }

    @Override
    public int size() {
        return this.Content.size();
    }

    @Override
    public void editOpened(FragmentContainerElementEdit newEdit) {
        this.OpenContentEdit = newEdit;
    }

    @Override
    public void editCommited(FragmentContainerElementEdit newEdit) {
        this.OpenContentEdit = null;
    }

    @Override
    public void editCancelled(FragmentContainerElementEdit newEdit) {
        this.OpenContentEdit = null;
    }

    @Override
    public void editRestored(FragmentContainerElementEdit newEdit) {
        this.OpenContentEdit = null;
    }

    @Override
    public void editRecalled(FragmentContainerElementEdit newEdit) {
        this.OpenContentEdit = null;
    }

    @Override
    public FragmentContainerElementEdit newEdit(ElementEditListener<FragmentContainerElementEdit> newEditListener) {
        if (this.OpenContentEdit == null && this.Container.getCurrentEdit() != null) {
            FragmentContainerElementEdit newEditOp = new FragmentContainerElementEdit(this.getDocument(), this, newEditListener);
            newEditOp.open();
            return newEditOp;
        }
        throw new IllegalStateException("Fragment Container Element already open for edit");
    }

    @Override
    public FragmentContainerElementEdit getCurrentEdit() {
        return this.OpenContentEdit;
    }

    public String getLabel() {
        return "Container";
    }
}

