/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.iArt.view.controller.Studio.document;

import com.Fo2PiX.blendengine.operation.OpInfo;
import com.Fo2PiX.iArt.view.controller.Studio.document.Document;
import com.Fo2PiX.iArt.view.controller.Studio.document.DocumentElementContainer;
import com.Fo2PiX.iArt.view.controller.Studio.document.DocumentElementContainerBase;
import com.Fo2PiX.iArt.view.controller.Studio.document.DocumentFragmentContainerElement;
import com.Fo2PiX.iArt.view.controller.Studio.document.DocumentFragmentContentElement;
import com.Fo2PiX.iArt.view.controller.Studio.document.EditableDocumentElement;
import com.Fo2PiX.iArt.view.controller.Studio.document.event.ElementEditListener;
import com.Fo2PiX.iArt.view.controller.Studio.operation.FragmentElementEdit;
import java.util.List;
import java.util.Vector;

public abstract class DocumentFragmentElement
extends DocumentElementContainerBase
implements DocumentElementContainer<DocumentFragmentContainerElement, DocumentFragmentContentElement>,
EditableDocumentElement<FragmentElementEdit> {
    public static final int FRAGMENT_TYPE_MANUAL = 0;
    public static final int FRAGMENT_TYPE_WIZARD = 1;
    protected DocumentFragmentContainerElement Container;
    protected Vector<DocumentFragmentContentElement> Content;
    protected FragmentElementEdit OpenContentEdit;
    public final int FragmentType;

    protected DocumentFragmentElement getPreviousElement() {
        int index = this.getIndex();
        if (index > 0) {
            return this.Container.getContent().get(index - 1);
        }
        return null;
    }

    protected DocumentFragmentElement getNextElement() {
        int index = this.getIndex();
        if (index < 0) {
            return this.Container.getContent().get(index + 1);
        }
        return null;
    }

    DocumentFragmentElement(int newType, Document newDoc, Vector<OpInfo> newOpList, Vector<OpInfo> newLeadIn) {
        super(2, newDoc, newOpList, newLeadIn);
        this.FragmentType = newType;
        this.Container = null;
        this.OpenContentEdit = null;
        this.Content = new Vector();
    }

    DocumentFragmentElement(int newType, Document newDoc, Vector<OpInfo> newOpList) {
        super(2, newDoc, newOpList);
        this.FragmentType = newType;
        this.Container = null;
        this.OpenContentEdit = null;
        this.Content = new Vector();
    }

    @Override
    public boolean isValidDocumentElement() {
        return this.Container != null;
    }

    @Override
    public void setContainer(DocumentFragmentContainerElement newContainer) {
        this.Container = newContainer;
    }

    @Override
    public DocumentFragmentContainerElement getContainer() {
        return this.Container;
    }

    @Override
    public int getIndex() {
        int index;
        if (this.Container != null && (index = this.Container.getContent().indexOf(this)) > -1) {
            return index;
        }
        throw new IllegalStateException("Element not contained in valid Document");
    }

    @Override
    public int getStartOpListIndex() {
        int index = this.getIndex();
        if (index == 0) {
            return this.Container.getContentStartOpListIndex();
        }
        return this.getPreviousElement().getEndOpListIndex();
    }

    @Override
    public List<OpInfo> getOpList(List<OpInfo> newOpList) {
        if (newOpList == null) {
            newOpList = new Vector<OpInfo>();
        }
        newOpList.addAll(this.getLeadIn());
        for (DocumentFragmentContentElement ContentElement : this.Content) {
            ContentElement.getOpList(newOpList);
        }
        newOpList.addAll(this.getLeadOut());
        return newOpList;
    }

    @Override
    public int getOpListSize() {
        int count = this.getLeadInSize();
        for (DocumentFragmentContentElement ContentElement : this.Content) {
            count += ContentElement.getOpListSize();
        }
        return count += this.getLeadOutSize();
    }

    @Override
    public Vector<DocumentFragmentContentElement> getContent() {
        return this.Content;
    }

    @Override
    public List<OpInfo> getContentOpList(List<OpInfo> newOpList) {
        if (newOpList == null) {
            newOpList = new Vector<OpInfo>();
        }
        for (DocumentFragmentContentElement ContentElement : this.Content) {
            ContentElement.getOpList(newOpList);
        }
        return newOpList;
    }

    @Override
    public int getContentOpListSize() {
        int count = 0;
        for (DocumentFragmentContentElement ContentElement : this.Content) {
            count += ContentElement.getOpListSize();
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return this.Content.isEmpty();
    }

    @Override
    public int size() {
        return this.Content.size();
    }

    @Override
    public void editOpened(FragmentElementEdit newEdit) {
        this.OpenContentEdit = newEdit;
    }

    @Override
    public void editCommited(FragmentElementEdit newEdit) {
        this.OpenContentEdit = null;
    }

    @Override
    public void editCancelled(FragmentElementEdit newEdit) {
        this.OpenContentEdit = null;
    }

    @Override
    public void editRestored(FragmentElementEdit newEdit) {
        this.OpenContentEdit = null;
    }

    @Override
    public void editRecalled(FragmentElementEdit newEdit) {
        this.OpenContentEdit = null;
    }

    @Override
    public FragmentElementEdit newEdit(ElementEditListener<FragmentElementEdit> newEditListener) {
        if (this.OpenContentEdit == null && this.Container.getCurrentEdit() != null) {
            FragmentElementEdit newEditOp = new FragmentElementEdit(this.getDocument(), this, newEditListener);
            newEditOp.open();
            return newEditOp;
        }
        throw new IllegalStateException("Fragment Element already open for edit");
    }

    @Override
    public FragmentElementEdit getCurrentEdit() {
        return this.OpenContentEdit;
    }

    public String getLabel() {
        return "Step";
    }
}

