/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.iArt.view.controller.Studio.script;

import com.Fo2PiX.blendengine.BlendEngine;
import com.Fo2PiX.iArt.view.controller.Studio.script.ScriptBlock;
import com.Fo2PiX.sourcelibrary.SourceLibrary;
import javax.swing.SwingUtilities;

public class ScriptBlockProcessor
extends Thread {
    public static final int SCRIPT_BLOCK_PROCESSOR_TYPE_ASYNCHRONOUS = 0;
    public static final int SCRIPT_BLOCK_PROCESSOR_TYPE_SYNCHRONOUS = 1;
    protected int Type;
    protected BlendEngine Blender;
    protected SourceLibrary Library;
    protected ScriptBlock Block;
    protected int BlockStartBlendIdx;

    public ScriptBlockProcessor(int newType, BlendEngine newBlender, SourceLibrary newLibrary, ScriptBlock newBlock) {
        this.Type = newType;
        this.Blender = newBlender;
        this.Library = newLibrary;
        this.Block = newBlock;
        this.BlockStartBlendIdx = -1;
    }

    @Override
    public synchronized void start() {
        if (this.Block != null && !this.Block.Content.isEmpty()) {
            this.BlockStartBlendIdx = this.Blender.getOpIdx();
            if (this.Type == 0) {
                super.start();
            } else {
                this.run();
            }
        }
    }

    @Override
    public void run() {
        try {
            this.Block.BlockListener.blockStartedAction();
            this.Blender.blendOps(this.Block.Content, this.Library, this.Block.ContentListener);
            if (this.isInterrupted()) {
                throw new InterruptedException();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScriptBlockProcessor.this.Block.BlockListener.blockCompletedAction(ScriptBlockProcessor.this.BlockStartBlendIdx, ScriptBlockProcessor.this.Block.Content);
                }
            });
        }
        catch (InterruptedException Ex) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScriptBlockProcessor.this.Block.BlockListener.blockCancelledAction();
                }
            });
        }
        catch (Exception Ex) {
            Ex.printStackTrace();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScriptBlockProcessor.this.Block.BlockListener.blockFailedAction();
                }
            });
        }
    }
}

