/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.iArt.view.controller.Studio.script;

import com.Fo2PiX.blendengine.BlendEngine;
import com.Fo2PiX.iArt.view.controller.Studio.script.ScriptBlock;
import com.Fo2PiX.sourcelibrary.SourceLibrary;
import com.arc.awt.event.ProgressListener;
import java.util.Vector;
import javax.swing.SwingUtilities;

public class ScriptBlocksProcessor
extends Thread {
    public static final int SCRIPT_BLOCKS_PROCESSOR_TYPE_ASYNCHRONOUS = 0;
    public static final int SCRIPT_BLOCKS_PROCESSOR_TYPE_SYNCHRONOUS = 1;
    protected int Type;
    protected BlendEngine Blender;
    protected SourceLibrary Library;
    protected Vector<ScriptBlock> Blocks;
    protected ProgressListener BlocksProgressListener;
    protected ScriptBlock CurrentBlock;
    protected int BlockStartBlendIdx;

    public ScriptBlocksProcessor(int newType, BlendEngine newBlender, SourceLibrary newLibrary, Vector<ScriptBlock> newBlocks, ProgressListener newBlocksProgressListener) {
        this.Type = newType;
        this.Blender = newBlender;
        this.Library = newLibrary;
        this.Blocks = newBlocks;
        this.BlocksProgressListener = newBlocksProgressListener;
        this.CurrentBlock = null;
        this.BlockStartBlendIdx = -1;
    }

    @Override
    public synchronized void start() {
        if (this.Blocks != null) {
            if (this.Type == 0) {
                super.start();
            } else {
                this.run();
            }
        }
    }

    @Override
    public void run() {
        if (this.Blocks.size() > 1) {
            this.BlocksProgressListener.pushProgressRange(0, this.Blocks.size(), 10000);
            for (int i = 0; i < this.Blocks.size(); ++i) {
                this.BlocksProgressListener.progressEvent(i);
                this.BlockStartBlendIdx = this.Blender.getOpIdx();
                this.CurrentBlock = this.Blocks.get(i);
                if (!this.runBlock()) break;
            }
            this.BlocksProgressListener.progressEvent(this.Blocks.size());
            this.BlocksProgressListener.popProgressRange();
        } else {
            this.CurrentBlock = this.Blocks.get(0);
            this.runBlock();
        }
    }

    public boolean runBlock() {
        try {
            this.CurrentBlock.BlockListener.blockStartedAction();
            this.Blender.blendOps(this.CurrentBlock.Content, this.Library, this.CurrentBlock.ContentListener);
            if (this.isInterrupted()) {
                throw new InterruptedException();
            }
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    ScriptBlocksProcessor.this.CurrentBlock.BlockListener.blockCompletedAction(ScriptBlocksProcessor.this.BlockStartBlendIdx, ScriptBlocksProcessor.this.CurrentBlock.Content);
                }
            });
            return true;
        }
        catch (InterruptedException Ex) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScriptBlocksProcessor.this.CurrentBlock.BlockListener.blockCancelledAction();
                }
            });
            return false;
        }
        catch (Exception Ex) {
            Ex.printStackTrace();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScriptBlocksProcessor.this.CurrentBlock.BlockListener.blockFailedAction();
                }
            });
            return false;
        }
    }
}

