/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.iArt.view.pagelayout;

import com.Fo2PiX.iArt.iArt;
import com.Fo2PiX.iArt.iArtComboBox;
import com.Fo2PiX.iArt.iArtIDUtils;
import com.Fo2PiX.iArt.iArtUtils;
import com.Fo2PiX.iArt.swing.JImageView;
import com.Fo2PiX.iArt.view.pagelayout.PageLayoutOp;
import com.Fo2PiX.iArt.view.pagelayout.PageLayoutOpImageScale;
import com.Fo2PiX.iArt.view.pagelayout.iArtPageLayout;
import com.arc.awt.event.ProgressListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public abstract class iArtPageLayoutImplBase
implements iArtPageLayout {
    protected static final int DEFAULT_IMAGE_FILL_IDX = 0;
    protected iArt App;
    protected JImageView VwPanel;
    protected long NextEvent;
    protected JLabel ImageFillLabel;
    protected iArtComboBox ImageFillCombo;
    protected Rectangle2D PageAreaBounds;
    protected Rectangle2D ImageAreaBounds;
    protected JTabbedPane PreviewPanel;
    protected JLabel PageSizeValueLabel;
    protected JLabel ImageSizeValueLabel;
    protected JLabel ImageDpiValueLabel;
    protected AffineTransform ImageScale;
    protected AffineTransform ImageTrns;
    protected int OpListIdx;
    protected ArrayList<PageLayoutOp> OpList;
    protected PageLayoutOpImageScale OpImageScale;
    protected String ImageSrcID;

    protected void undoOp(PageLayoutOp newUndoOp) {
        switch (newUndoOp.Type) {
            case 0: {
                this.OpImageScale = ((PageLayoutOpImageScale)newUndoOp).LastOp;
            }
        }
        if (newUndoOp.InnerOp != null) {
            this.undoOp(newUndoOp.InnerOp);
        } else {
            this.synchControlValues();
            this.validatePageLayout();
        }
    }

    protected void redoOp(PageLayoutOp newRedoOp) {
        switch (newRedoOp.Type) {
            case 0: {
                this.OpImageScale = (PageLayoutOpImageScale)newRedoOp;
            }
        }
        if (newRedoOp.InnerOp != null) {
            this.redoOp(newRedoOp.InnerOp);
        } else {
            this.synchControlValues();
            this.validatePageLayout();
        }
    }

    protected void buildStandardLayout(JPanel newControlPanel, GridBagConstraints newConstraints, JLabel newLayoutLabel, JLabel newLayoutComboLabel, JComboBox newLayoutCombo, JLabel newFormatComboLabel, JComboBox newFormatCombo) {
        newConstraints.gridx = 0;
        newConstraints.gridy = 0;
        newConstraints.weightx = 0.0;
        newConstraints.weighty = 0.0;
        newConstraints.gridwidth = 1;
        newConstraints.fill = 2;
        newControlPanel.add((Component)newLayoutLabel, newConstraints);
        newConstraints.gridx = 1;
        newConstraints.weightx = 0.0;
        newConstraints.weighty = 0.0;
        newConstraints.gridwidth = 1;
        newConstraints.fill = 0;
        newConstraints.anchor = 10;
        newControlPanel.add(Box.createRigidArea(new Dimension(5, 5)), newConstraints);
        if (newFormatCombo.getItemCount() > 1) {
            ++newConstraints.gridy;
            newControlPanel.add(Box.createVerticalStrut(5), newConstraints);
            ++newConstraints.gridy;
            iArtUtils.buildComboLayout(newFormatComboLabel, newFormatCombo, newControlPanel, newConstraints);
            if (this.VwPanel.getPageFormat().hasPageFormatInterface()) {
                this.VwPanel.getPageFormat().addPageFormatInterface(newControlPanel, newConstraints);
            }
        }
        if (newLayoutCombo.getItemCount() > 1) {
            ++newConstraints.gridy;
            newControlPanel.add(Box.createVerticalStrut(5), newConstraints);
            ++newConstraints.gridy;
            iArtUtils.buildComboLayout(newLayoutComboLabel, newLayoutCombo, newControlPanel, newConstraints);
        }
    }

    protected void synchControls() {
        if (this.OpListIdx < this.OpList.size() - 1) {
            this.App.RedoAction.setEnabled(true);
        } else {
            this.App.RedoAction.setEnabled(false);
        }
        if (this.OpListIdx > 0) {
            this.App.UndoAction.setEnabled(true);
        } else {
            this.App.RedoAction.setEnabled(false);
        }
        if (this.OpListIdx != 0) {
            this.App.ResetAction.setEnabled(true);
        } else {
            this.App.ResetAction.setEnabled(false);
        }
        this.App.CancelAction.setEnabled(false);
        this.App.RestoreAction.setEnabled(false);
        this.App.OpenAction.setEnabled(true);
        this.App.SaveAction.setEnabled(true);
        this.App.PageAction.setEnabled(true);
        this.App.PrintAction.setEnabled(true);
        this.App.ExitAction.setEnabled(true);
        this.App.CopyAction.setEnabled(true);
        this.App.PasteAction.setEnabled(true);
        this.App.AboutAction.setEnabled(true);
        this.App.HelpAction.setEnabled(true);
        if (this.App.Config.SimpleLayout) {
            this.App.AdjustAction.setEnabled(false);
            this.App.StudioAction.setEnabled(false);
        } else {
            this.App.AdjustAction.setEnabled(true);
            this.App.StudioAction.setEnabled(true);
        }
        this.App.LayoutAction.setEnabled(true);
        this.App.Menubar.setEnabled(true);
        this.PreviewPanel.setEnabled(true);
        this.ImageFillCombo.setEnabled(true);
    }

    protected void synchControlValues() {
        this.ImageFillCombo.setSelectedIndexSilently(this.OpImageScale.SelectedIdx);
    }

    protected void buildControls() {
        this.PageSizeValueLabel = new JLabel();
        this.ImageSizeValueLabel = new JLabel();
        this.ImageDpiValueLabel = new JLabel();
        this.PageAreaBounds = new Rectangle2D.Double();
        this.ImageAreaBounds = new Rectangle2D.Double();
        this.ImageFillCombo = new iArtComboBox(new String[]{"100%", "90%", "80%", "70%", "60%", "50%"});
        this.ImageFillCombo.addQuietItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    iArtPageLayoutImplBase.this.OpImageScale = new PageLayoutOpImageScale(iArtPageLayoutImplBase.this.ImageFillCombo.getSelectedIndex(), iArtPageLayoutImplBase.this.OpImageScale);
                    iArtPageLayoutImplBase.this.OpList.add(++iArtPageLayoutImplBase.this.OpListIdx, iArtPageLayoutImplBase.this.OpImageScale);
                    iArtPageLayoutImplBase.this.validatePageLayout();
                    iArtPageLayoutImplBase.this.App.UndoAction.setEnabled(true);
                    iArtPageLayoutImplBase.this.App.RedoAction.setEnabled(false);
                    iArtPageLayoutImplBase.this.App.ResetAction.setEnabled(true);
                }
            }
        });
        this.ImageFillCombo.setEnabled(false);
        this.ImageFillLabel = new JLabel(this.App.Config.APP_LABEL_STRINGS.getString("LABEL_LAYOUTIMAGE"));
    }

    protected void buildActions() {
    }

    protected boolean isResetRequired() {
        return !this.VwPanel.VwImageTracker.getImageSrcID().equalsIgnoreCase(this.ImageSrcID);
    }

    protected PageLayoutOp getResetOp() {
        PageLayoutOpImageScale newResetOp;
        this.OpImageScale = newResetOp = new PageLayoutOpImageScale(0, null);
        return newResetOp;
    }

    protected void reset(PageLayoutOp newResetOp) {
        this.OpList.clear();
        this.OpList.add(newResetOp);
        this.OpListIdx = 0;
    }

    protected void init(ProgressListener newProgressListener) {
        this.reset(this.getResetOp());
    }

    public iArtPageLayoutImplBase(iArt newApp, JImageView newVw, JTabbedPane newPreviewPanel) {
        this.App = newApp;
        this.VwPanel = newVw;
        this.PreviewPanel = newPreviewPanel;
        this.ImageScale = new AffineTransform();
        this.ImageTrns = new AffineTransform();
        this.OpList = new ArrayList();
        this.NextEvent = 0L;
        this.buildActions();
        this.buildControls();
    }

    @Override
    public void validatePageLayout() {
        if (this.VwPanel != null) {
            this.VwPanel.revalidateView();
        }
    }

    @Override
    public void setEnabled(boolean newValue) {
        if (!newValue) {
            this.App.UndoAction.setEnabled(false);
            this.App.RedoAction.setEnabled(false);
            this.App.ResetAction.setEnabled(false);
            this.App.RestoreAction.setEnabled(false);
            this.App.CancelAction.setEnabled(false);
            this.App.OpenAction.setEnabled(false);
            this.App.SaveAction.setEnabled(false);
            this.App.PageAction.setEnabled(false);
            this.App.PrintAction.setEnabled(false);
            this.App.ExitAction.setEnabled(false);
            this.App.CopyAction.setEnabled(false);
            this.App.PasteAction.setEnabled(false);
            this.App.AboutAction.setEnabled(false);
            this.App.HelpAction.setEnabled(false);
            this.App.AdjustAction.setEnabled(false);
            this.App.StudioAction.setEnabled(false);
            this.App.LayoutAction.setEnabled(false);
            this.App.Menubar.setEnabled(false);
            this.PreviewPanel.setEnabled(false);
            this.ImageFillCombo.setEnabled(false);
        } else {
            this.synchControls();
        }
    }

    @Override
    public void openPageLayout(ProgressListener newProgressListener) {
        if (this.ImageSrcID == null) {
            this.init(newProgressListener);
        } else if (this.isResetRequired()) {
            this.reset(this.getResetOp());
        }
        this.ImageSrcID = this.VwPanel.VwImageTracker.getImageSrcID();
        this.synchControlValues();
    }

    @Override
    public void closePageLayout(ProgressListener newProgressListener) {
    }

    @Override
    public void undoAction(ActionEvent newEvent) {
        if (this.OpListIdx > 0) {
            PageLayoutOp LastOp = this.OpList.get(this.OpListIdx--);
            this.undoOp(LastOp);
            this.App.UndoAction.setEnabled(false);
            this.App.RedoAction.setEnabled(true);
            if (this.OpListIdx == 0) {
                this.App.ResetAction.setEnabled(false);
            }
        }
    }

    @Override
    public void redoAction(ActionEvent newEvent) {
        if (this.OpListIdx < this.OpList.size() - 1) {
            PageLayoutOp LastOp = this.OpList.get(++this.OpListIdx);
            this.redoOp(LastOp);
            this.App.UndoAction.setEnabled(true);
            this.App.RedoAction.setEnabled(false);
            this.App.ResetAction.setEnabled(true);
        }
    }

    @Override
    public void cancelAction(ActionEvent newEvent) {
    }

    @Override
    public void resetAction(ActionEvent newEvent) {
        this.reset(this.getResetOp());
        this.synchControlValues();
        this.validatePageLayout();
        this.App.UndoAction.setEnabled(false);
        this.App.RedoAction.setEnabled(false);
        this.App.ResetAction.setEnabled(false);
    }

    @Override
    public void restoreAction(ActionEvent newEvent) {
    }

    @Override
    public void dispose() {
    }

    public String toString() {
        return iArtIDUtils.getReadableName(this.getID());
    }

    @Override
    public boolean isSaveData() {
        return false;
    }

    @Override
    public BufferedImage getSaveImage() {
        return null;
    }

    @Override
    public void loadData(InputStream newDataStream) {
    }

    @Override
    public void saveData(OutputStream newDataStream) {
    }

    @Override
    public boolean canLoadData() {
        return false;
    }

    @Override
    public boolean canSaveData() {
        return false;
    }

    protected double getImageScale() {
        switch (this.ImageFillCombo.getSelectedIndex()) {
            case 0: {
                return 1.0;
            }
            case 1: {
                return 0.9;
            }
            case 2: {
                return 0.8;
            }
            case 3: {
                return 0.7;
            }
            case 4: {
                return 0.6;
            }
            case 5: {
                return 0.5;
            }
        }
        return 1.0;
    }

    protected void calcBounds(Graphics2D g2d, PageFormat pageFormat) {
        this.PageAreaBounds.setRect(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
        this.ImageAreaBounds.setRect(this.PageAreaBounds);
    }

    protected void paintImage(Graphics2D g2d, PageFormat pageFormat) {
        int ix = (int)this.ImageAreaBounds.getX();
        int iy = (int)this.ImageAreaBounds.getY();
        int iw = (int)this.ImageAreaBounds.getWidth();
        int ih = (int)this.ImageAreaBounds.getHeight();
        double imagefill = this.getImageScale();
        double scale = 1.0;
        if (this.VwPanel.VwImage != null) {
            double scaleImageX = (double)iw * imagefill / (double)this.VwPanel.VwImage.getWidth();
            double scaleImageY = (double)ih * imagefill / (double)this.VwPanel.VwImage.getHeight();
            scale = Math.min(scaleImageX, scaleImageY);
        }
        int newWidth = (int)((double)this.VwPanel.VwImage.getWidth() * scale);
        int newHeight = (int)((double)this.VwPanel.VwImage.getHeight() * scale);
        Point2D FormatScale = this.VwPanel.getPageFormat() != null ? this.VwPanel.getPageFormat().getScale() : new Point2D.Double(1.0, 1.0);
        this.PageSizeValueLabel.setText(String.valueOf((int)(pageFormat.getWidth() * 0.352777778 * FormatScale.getX() + 0.5)) + " x " + String.valueOf((int)(pageFormat.getHeight() * 0.352777778 * FormatScale.getY() + 0.5)) + " mm");
        this.ImageSizeValueLabel.setText(String.valueOf((int)((double)newWidth * 0.352777778 + 0.5 * FormatScale.getX())) + " x " + String.valueOf((int)((double)newHeight * 0.352777778 * FormatScale.getY() + 0.5)) + " mm");
        this.ImageDpiValueLabel.setText(String.valueOf((int)((double)this.VwPanel.VwImageWidth / ((double)newWidth / 72.0) * FormatScale.getX())) + " dpi");
        this.ImageScale.setToScale(scale, scale);
        this.ImageTrns.setToTranslation(ix + (iw - newWidth) / 2, iy + (ih - newHeight) / 2);
        this.ImageTrns.concatenate(this.ImageScale);
        g2d.transform(this.ImageTrns);
        if (this.VwPanel.VwImage != null) {
            g2d.drawImage(this.VwPanel.VwImage, null, 0, 0);
        }
        g2d.dispose();
    }

    @Override
    public void paintPageLayout(Graphics graphics, PageFormat pageFormat, boolean print) {
        this.calcBounds((Graphics2D)graphics, pageFormat);
        this.paintImage((Graphics2D)graphics.create(), pageFormat);
    }

    @Override
    public void initialisePageLayout() {
    }

    @Override
    public void addControls(JPanel newControlPanel, JLabel newPageLabel, JLabel newPageLayoutComboLabel, JComboBox newPageLayoutCombo, JLabel newPageFormatComboLabel, JComboBox newPageFormatCombo, GridBagConstraints newConstraints) {
        this.buildStandardLayout(newControlPanel, newConstraints, newPageLabel, newPageLayoutComboLabel, newPageLayoutCombo, newPageFormatComboLabel, newPageFormatCombo);
        ++newConstraints.gridy;
        newControlPanel.add(Box.createVerticalStrut(5), newConstraints);
        ++newConstraints.gridy;
        iArtUtils.buildComboLayout(this.ImageFillLabel, (JComboBox)((Object)this.ImageFillCombo), newControlPanel, newConstraints);
        ++newConstraints.gridy;
        newControlPanel.add(Box.createVerticalStrut(5), newConstraints);
        ++newConstraints.gridy;
        iArtUtils.buildLabelLayout(new JLabel(this.App.Config.APP_LABEL_STRINGS.getString("LABEL_LAYOUTPAGESIZE")), this.PageSizeValueLabel, newControlPanel, newConstraints);
        ++newConstraints.gridy;
        newControlPanel.add(Box.createVerticalStrut(5), newConstraints);
        ++newConstraints.gridy;
        iArtUtils.buildLabelLayout(new JLabel(this.App.Config.APP_LABEL_STRINGS.getString("LABEL_LAYOUTIMAGESIZE")), this.ImageSizeValueLabel, newControlPanel, newConstraints);
        if (this.App.Config.ShowLayoutDPI) {
            ++newConstraints.gridy;
            newControlPanel.add(Box.createVerticalStrut(5), newConstraints);
            ++newConstraints.gridy;
            iArtUtils.buildLabelLayout(new JLabel(this.App.Config.APP_LABEL_STRINGS.getString("LABEL_LAYOUTIMAGEDPI")), this.ImageDpiValueLabel, newControlPanel, newConstraints);
        }
    }

    @Override
    public void finishControls(JPanel newControlPanel, GridBagConstraints newConstraints) {
    }

    @Override
    public void removeControls(JPanel newControlPanel) {
        newControlPanel.removeAll();
    }

    @Override
    public void resetPageLayout(ProgressListener newProgressListener) {
    }
}

