/*
 * Decompiled with CFR 0.152.
 */
package com.arc.io;

import com.arc.awt.event.ProgressListener;
import com.arc.io.DataInputEvent;
import com.arc.io.DataInputFileListener;
import com.arc.io.DataInputListener;
import com.arc.io.DataInputTransferableListener;
import com.arc.io.util.Files;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class DataInputManager {
    protected HashMap<String, DataInputFileListener> FileFormatMap = new HashMap();
    protected HashMap<DataFlavor, DataInputTransferableListener> DataFlavorMap = new HashMap();
    protected HashMap<DataInputFileListener, Vector<String>> FileTargetListenerList = new HashMap();
    protected HashMap<DataInputTransferableListener, Vector<DataFlavor>> TransferableTargetListenerList = new HashMap();
    protected Vector<File> RecentFileList = new Vector();
    protected int RecentFileListLength;
    protected String ThreadName;
    protected boolean AsynchLoadingEnabled;

    protected boolean addRecentFile(File newFile) {
        if (!this.RecentFileList.contains(newFile)) {
            this.RecentFileList.add(0, newFile);
            if (this.RecentFileList.size() > this.RecentFileListLength) {
                this.RecentFileList.subList(this.RecentFileListLength, this.RecentFileList.size()).clear();
            }
            return false;
        }
        return true;
    }

    protected File getFile(Transferable newTransferable) {
        try {
            List FileList = (List)newTransferable.getTransferData(DataFlavor.javaFileListFlavor);
            return (File)FileList.get(0);
        }
        catch (Exception Ex) {
            System.out.println("Failed to obtain FileList from Transferable...");
            Ex.printStackTrace();
            return null;
        }
    }

    protected DataFlavor getDataFlavor(Transferable newTransferable) {
        for (DataFlavor TransferFlavor : newTransferable.getTransferDataFlavors()) {
            if (!this.DataFlavorMap.containsKey(TransferFlavor)) continue;
            return TransferFlavor;
        }
        return null;
    }

    protected boolean fireDataInputStartedEvent(final DataInputListener newDataInputListener, final DataInputEvent newInputEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            return newDataInputListener.DataInputStarted(newInputEvent);
        }
        FutureTask<Boolean> InputStartedEvent = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return newDataInputListener.DataInputStarted(newInputEvent);
            }
        });
        try {
            SwingUtilities.invokeAndWait(InputStartedEvent);
            return InputStartedEvent.get();
        }
        catch (Exception Ex) {
            Ex.printStackTrace();
            return false;
        }
    }

    protected void fireDataInputCompletedEvent(final DataInputListener newDataInputListener, final DataInputEvent newInputEvent) {
        if (SwingUtilities.isEventDispatchThread()) {
            newDataInputListener.DataInputCompleted(newInputEvent);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        newDataInputListener.DataInputCompleted(newInputEvent);
                    }
                });
            }
            catch (Exception Ex) {
                Ex.printStackTrace();
            }
        }
    }

    public DataInputManager(int newRecentFileListLength, boolean newAsynchLoadingEnabled) {
        this.RecentFileListLength = newRecentFileListLength;
        this.ThreadName = "DataInput" + this.hashCode();
        this.AsynchLoadingEnabled = newAsynchLoadingEnabled;
    }

    public boolean getAsynchLoadingEnabled() {
        return this.AsynchLoadingEnabled;
    }

    public void setAsynchLoadingEnabled(boolean newAsynchLoadingEnabled) {
        this.AsynchLoadingEnabled = newAsynchLoadingEnabled;
    }

    public Vector<File> getRecentFileList() {
        return new Vector<File>(this.RecentFileList);
    }

    public int getRecentFileListLength() {
        return this.RecentFileListLength;
    }

    public void setRecentFileListLength(int newRecentFileListLength) {
        this.RecentFileListLength = newRecentFileListLength;
        if (this.RecentFileList.size() > this.RecentFileListLength) {
            this.RecentFileList.subList(this.RecentFileListLength, this.RecentFileList.size()).clear();
        }
    }

    public void addFileTargetListener(DataInputFileListener newFileTargetListener) {
        String[] newFileTargetFormats = newFileTargetListener.getSupportedFileFormats();
        Vector<String> FileFormats = new Vector<String>();
        for (String newFileTargetFormat : newFileTargetFormats) {
            if (this.FileFormatMap.containsKey(newFileTargetFormat)) continue;
            FileFormats.add(newFileTargetFormat);
        }
        this.FileTargetListenerList.put(newFileTargetListener, FileFormats);
        for (String FileFormat : FileFormats) {
            this.FileFormatMap.put(FileFormat, newFileTargetListener);
        }
    }

    public void removeFileTargetListener(DataInputFileListener newFileTargetListener) {
        if (this.FileTargetListenerList.containsKey(newFileTargetListener)) {
            Vector<String> FileFormats = this.FileTargetListenerList.get(newFileTargetListener);
            for (String FileFormat : FileFormats) {
                this.FileFormatMap.remove(FileFormat);
            }
            this.FileTargetListenerList.remove(newFileTargetListener);
        }
    }

    public boolean isValidFileData(File newTrgt) {
        if (this.FileFormatMap.containsKey(Files.getExtension(newTrgt))) {
            return true;
        }
        JOptionPane.showMessageDialog(null, "Invalid File FragmentContainerType.", "Error", 0);
        return false;
    }

    public void open(final File newTrgt, final boolean newHistoryViewable, final DataInputListener newDataInputListener, ProgressListener newProgressListener) {
        if (this.isValidFileData(newTrgt)) {
            final DataInputFileListener newInputListener = this.FileFormatMap.get(Files.getExtension(newTrgt));
            final DataInputEvent newInputEvent = new DataInputEvent(newInputListener, newTrgt, this.addRecentFile(newTrgt), Files.getExtension(newTrgt), null, null);
            if (!this.AsynchLoadingEnabled || Thread.currentThread().getName().equals(this.ThreadName)) {
                if (newDataInputListener == null || this.fireDataInputStartedEvent(newDataInputListener, newInputEvent)) {
                    newInputListener.open(newTrgt, newHistoryViewable);
                    if (newDataInputListener != null) {
                        this.fireDataInputCompletedEvent(newDataInputListener, newInputEvent);
                    }
                }
            } else {
                Thread InputThread = new Thread(){

                    @Override
                    public void run() {
                        if (newDataInputListener == null || DataInputManager.this.fireDataInputStartedEvent(newDataInputListener, newInputEvent)) {
                            newInputListener.open(newTrgt, newHistoryViewable);
                            if (newDataInputListener != null) {
                                DataInputManager.this.fireDataInputCompletedEvent(newDataInputListener, newInputEvent);
                            }
                        }
                    }
                };
                InputThread.setName(this.ThreadName);
                InputThread.start();
            }
        }
    }

    public void addTransferableTargetListener(DataInputTransferableListener newTransferableTargetListener) {
        DataFlavor[] newTransferableDataFlavors = newTransferableTargetListener.getSupportedDataFlavors();
        Vector<DataFlavor> DataFlavors = new Vector<DataFlavor>();
        for (DataFlavor newTransferableDataFlavor : newTransferableDataFlavors) {
            if (this.DataFlavorMap.containsKey(newTransferableDataFlavor)) continue;
            DataFlavors.add(newTransferableDataFlavor);
        }
        this.TransferableTargetListenerList.put(newTransferableTargetListener, DataFlavors);
        for (DataFlavor DataFlavor2 : DataFlavors) {
            this.DataFlavorMap.put(DataFlavor2, newTransferableTargetListener);
        }
    }

    public void removeTransferableTargetListener(DataInputTransferableListener newTransferableTargetListener) {
        if (this.TransferableTargetListenerList.containsKey(newTransferableTargetListener)) {
            Vector<DataFlavor> FileFormats = this.TransferableTargetListenerList.get(newTransferableTargetListener);
            for (DataFlavor FileFormat : FileFormats) {
                this.DataFlavorMap.remove(FileFormat);
            }
            this.TransferableTargetListenerList.remove(newTransferableTargetListener);
        }
    }

    public boolean isValidTransferableData(DataFlavor[] newTrgt) {
        for (DataFlavor aNewTrgt : newTrgt) {
            if (!aNewTrgt.equals(DataFlavor.javaFileListFlavor) && !this.DataFlavorMap.containsKey(aNewTrgt)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidTransferableData(DataFlavor newTrgt) {
        return newTrgt.equals(DataFlavor.javaFileListFlavor) || this.DataFlavorMap.containsKey(newTrgt);
    }

    public boolean isValidTransferableData(Transferable newTrgt) {
        try {
            if (newTrgt.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List FileList = (List)newTrgt.getTransferData(DataFlavor.javaFileListFlavor);
                return this.isValidFileData((File)FileList.get(0));
            }
            return this.isValidTransferableData(newTrgt.getTransferDataFlavors());
        }
        catch (Exception Ex) {
            System.out.println("Valid transferable data check failed");
            Ex.printStackTrace();
            return false;
        }
    }

    public void open(final Transferable newTrgt, final DataInputListener newDataInputListener, ProgressListener newProgressListener) {
        if (this.isValidTransferableData(newTrgt)) {
            DataFlavor newTransferFlavor = this.getDataFlavor(newTrgt);
            if (newTransferFlavor.equals(DataFlavor.javaFileListFlavor) && !this.DataFlavorMap.keySet().contains(newTransferFlavor)) {
                File newFile = this.getFile(newTrgt);
                this.open(newFile, true, newDataInputListener, newProgressListener);
            } else {
                final DataInputTransferableListener newInputListener = this.DataFlavorMap.get(newTransferFlavor);
                final DataInputEvent newInputEvent = new DataInputEvent(newInputListener, null, false, null, newTrgt, newTransferFlavor);
                if (!this.AsynchLoadingEnabled || Thread.currentThread().getName().equals(this.ThreadName)) {
                    if (newDataInputListener == null || this.fireDataInputStartedEvent(newDataInputListener, newInputEvent)) {
                        newInputListener.open(newTrgt);
                        if (newDataInputListener != null) {
                            this.fireDataInputCompletedEvent(newDataInputListener, newInputEvent);
                        }
                    }
                } else {
                    Thread InputThread = new Thread(){

                        @Override
                        public void run() {
                            if (newDataInputListener == null || DataInputManager.this.fireDataInputStartedEvent(newDataInputListener, newInputEvent)) {
                                newInputListener.open(newTrgt);
                                if (newDataInputListener != null) {
                                    DataInputManager.this.fireDataInputCompletedEvent(newDataInputListener, newInputEvent);
                                }
                            }
                        }
                    };
                    InputThread.setName(this.ThreadName);
                    InputThread.start();
                }
            }
        }
    }
}

