/*
 * Decompiled with CFR 0.152.
 */
package com.arc.io.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class Files {
    public static String getExtension(File f) {
        String ext = "";
        String fs = f.toString();
        int i = fs.lastIndexOf(46);
        if (i > 0 && i < fs.length() - 1 && i > fs.length() - 6) {
            ext = fs.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static File getFile(File f) {
        try {
            String fs = f.toString();
            return new File(fs.substring(0, fs.lastIndexOf(46)));
        }
        catch (Exception Ex) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File s, File d) throws IOException {
        if (s.exists() && s.isFile() && !s.equals(d)) {
            FileChannel in = null;
            AbstractInterruptibleChannel out = null;
            try {
                in = new FileInputStream(s).getChannel();
                out = new FileOutputStream(d).getChannel();
                in.transferTo(0L, in.size(), (WritableByteChannel)((Object)out));
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File s, OutputStream out) throws IOException {
        if (s.exists() && s.isFile()) {
            FileInputStream in = null;
            try {
                int bytes;
                in = new FileInputStream(s);
                byte[] buffer = new byte[1024];
                while ((bytes = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytes);
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(InputStream in, File d) throws IOException {
        FileOutputStream out = null;
        try {
            int bytes;
            out = new FileOutputStream(d);
            byte[] buffer = new byte[1024];
            while ((bytes = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytes);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public static File relocateFile(File sf, File df, File f) {
        try {
            if (!sf.isDirectory() || !df.isDirectory()) {
                return null;
            }
            if (sf.equals(f)) {
                return df;
            }
            String newSourcePathString = sf.toString();
            String newTargetPathString = f.toString();
            if (newTargetPathString.startsWith(newSourcePathString)) {
                return new File(df, newTargetPathString.substring(newSourcePathString.length(), newTargetPathString.length()));
            }
            return null;
        }
        catch (Exception Ex) {
            return null;
        }
    }

    public static boolean deleteFolder(File f) {
        if (!Files.deleteFolderContents(f)) {
            return false;
        }
        if (!f.delete()) {
            System.out.println("FAILED to delete folder: " + f);
        }
        return true;
    }

    public static boolean deleteFolderContents(File f) {
        File[] FolderContents = f.listFiles();
        if (FolderContents != null && FolderContents.length > 0) {
            for (File FolderContent : FolderContents) {
                if (FolderContent.isFile()) {
                    String FileName = FolderContent.toString();
                    if (FolderContent.delete()) continue;
                    System.out.println("FAILED to delete file: " + FileName);
                    continue;
                }
                if (Files.deleteFolder(FolderContent)) continue;
                return false;
            }
        }
        return true;
    }
}

