/*
 * Decompiled with CFR 0.152.
 */
package com.arc.swing.util;

import java.awt.Component;
import java.awt.Container;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class Threads {
    public static void safeAddComponent(final Component newComponent, final Container currentContainer) {
        if (newComponent != null && currentContainer != null) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            currentContainer.add(newComponent);
                        }
                    });
                }
                catch (InterruptedException Ex) {
                    System.out.println("Swing invokeAndWait interrupted");
                }
                catch (InvocationTargetException Ex) {
                    System.out.println("Swing invokeAndWait failed");
                }
            } else {
                currentContainer.add(newComponent);
            }
        }
    }

    public static void safeAddComponent(final int newIndex, final Component newComponent, final Container currentContainer) {
        if (newComponent != null && currentContainer != null) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            currentContainer.add(newComponent, newIndex);
                        }
                    });
                }
                catch (InterruptedException Ex) {
                    System.out.println("Swing invokeAndWait interrupted");
                }
                catch (InvocationTargetException Ex) {
                    System.out.println("Swing invokeAndWait failed");
                }
            } else {
                currentContainer.add(newComponent, newIndex);
            }
        }
    }

    public static void safeAddComponent(final JComponent newComponent, final Container currentContainer, final Object currentConstraints) {
        if (newComponent != null && currentContainer != null) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            currentContainer.add((Component)newComponent, currentConstraints);
                        }
                    });
                }
                catch (InterruptedException Ex) {
                    System.out.println("Swing invokeAndWait interrupted");
                }
                catch (InvocationTargetException Ex) {
                    System.out.println("Swing invokeAndWait failed");
                }
            } else {
                currentContainer.add((Component)newComponent, currentConstraints);
            }
        }
    }

    public static void safeAddComponent(final int newIndex, final JComponent newComponent, final Container currentContainer, final Object currentConstraints) {
        if (newComponent != null && currentContainer != null) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            currentContainer.add(newComponent, currentConstraints, newIndex);
                        }
                    });
                }
                catch (InterruptedException Ex) {
                    System.out.println("Swing invokeAndWait interrupted");
                }
                catch (InvocationTargetException Ex) {
                    System.out.println("Swing invokeAndWait failed");
                }
            } else {
                currentContainer.add(newComponent, currentConstraints, newIndex);
            }
        }
    }

    public static void safeAddComponent(final JComponent newComponent, final Container currentContainer, final boolean Enabled) {
        if (newComponent != null && currentContainer != null) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            newComponent.setEnabled(Enabled);
                            currentContainer.add(newComponent);
                        }
                    });
                }
                catch (InterruptedException Ex) {
                    System.out.println("Swing invokeAndWait interrupted");
                }
                catch (InvocationTargetException Ex) {
                    System.out.println("Swing invokeAndWait failed");
                }
            } else {
                newComponent.setEnabled(Enabled);
                currentContainer.add(newComponent);
            }
        }
    }

    public static void safeAddComponent(final int newIndex, final JComponent newComponent, final Container currentContainer, final boolean Enabled) {
        if (newComponent != null && currentContainer != null) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            newComponent.setEnabled(Enabled);
                            currentContainer.add((Component)newComponent, newIndex);
                        }
                    });
                }
                catch (InterruptedException Ex) {
                    System.out.println("Swing invokeAndWait interrupted");
                }
                catch (InvocationTargetException Ex) {
                    System.out.println("Swing invokeAndWait failed");
                }
            } else {
                newComponent.setEnabled(Enabled);
                currentContainer.add((Component)newComponent, newIndex);
            }
        }
    }

    public static void safeAddComponent(final JComponent newComponent, final Container currentContainer, final Object currentConstraints, final boolean Enabled) {
        if (newComponent != null && currentContainer != null) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            newComponent.setEnabled(Enabled);
                            currentContainer.add((Component)newComponent, currentConstraints);
                        }
                    });
                }
                catch (InterruptedException Ex) {
                    System.out.println("Swing invokeAndWait interrupted");
                }
                catch (InvocationTargetException Ex) {
                    System.out.println("Swing invokeAndWait failed");
                }
            } else {
                newComponent.setEnabled(Enabled);
                currentContainer.add((Component)newComponent, currentConstraints);
            }
        }
    }

    public static void safeAddComponent(final int newIndex, final JComponent newComponent, final Container currentContainer, final Object currentConstraints, final boolean Enabled) {
        if (newComponent != null && currentContainer != null) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            newComponent.setEnabled(Enabled);
                            currentContainer.add(newComponent, currentConstraints, newIndex);
                        }
                    });
                }
                catch (InterruptedException Ex) {
                    System.out.println("Swing invokeAndWait interrupted");
                }
                catch (InvocationTargetException Ex) {
                    System.out.println("Swing invokeAndWait failed");
                }
            } else {
                newComponent.setEnabled(Enabled);
                currentContainer.add(newComponent, currentConstraints, newIndex);
            }
        }
    }

    public static JComponent safeRemoveComponent(final JComponent currentComponent, final Container currentContainer) {
        if (currentComponent != null && currentContainer != null) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            currentContainer.remove(currentComponent);
                        }
                    });
                }
                catch (InterruptedException Ex) {
                    System.out.println("Swing invokeAndWait interrupted");
                }
                catch (InvocationTargetException Ex) {
                    System.out.println("Swing invokeAndWait failed");
                }
            } else {
                currentContainer.remove(currentComponent);
            }
            return currentComponent;
        }
        return null;
    }

    public static JComponent[] safeRemoveAllComponents(final Container currentContainer) {
        int currentContainerComponentCount;
        if (currentContainer != null && (currentContainerComponentCount = currentContainer.getComponentCount()) > 0) {
            final JComponent[] RemovedComponents = new JComponent[currentContainerComponentCount];
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = 0; i < currentContainerComponentCount; ++i) {
                                RemovedComponents[i] = (JComponent)currentContainer.getComponent(i);
                            }
                            currentContainer.removeAll();
                        }
                    });
                }
                catch (InterruptedException Ex) {
                    System.out.println("Swing invokeAndWait interrupted");
                }
                catch (InvocationTargetException Ex) {
                    System.out.println("Swing invokeAndWait failed");
                }
            } else {
                for (int i = 0; i < currentContainerComponentCount; ++i) {
                    RemovedComponents[i] = (JComponent)currentContainer.getComponent(i);
                }
                currentContainer.removeAll();
                currentContainer.validate();
            }
            return RemovedComponents;
        }
        return null;
    }

    public static void safeSetViewportView(final JComponent newComponent, final JScrollPane currentScrollPane) {
        if (newComponent != null && currentScrollPane != null) {
            if (!SwingUtilities.isEventDispatchThread()) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            currentScrollPane.setViewportView(newComponent);
                        }
                    });
                }
                catch (InterruptedException Ex) {
                    System.out.println("Swing invokeAndWait interrupted");
                }
                catch (InvocationTargetException Ex) {
                    System.out.println("Swing invokeAndWait failed");
                }
            } else {
                currentScrollPane.setViewportView(newComponent);
            }
        }
    }
}

