/*
 * Decompiled with CFR 0.152.
 */
package com.arc.util;

import java.util.Collection;
import java.util.Vector;

public class ClipVector<E>
extends Vector<E> {
    private static final long serialVersionUID = -6906713883676050557L;
    public static final int LIST_EMPTY_IDX = -1;
    public static final int LIST_FIRST_IDX = 0;
    protected boolean Autoclip;

    public ClipVector(int initialCapacity, int capacityIncrement) {
        super(initialCapacity, capacityIncrement);
        this.Autoclip = true;
    }

    public ClipVector(int initialCapacity, int capacityIncrement, boolean autoclip) {
        super(initialCapacity, capacityIncrement);
        this.Autoclip = autoclip;
    }

    public ClipVector(int initialCapacity) {
        super(initialCapacity);
        this.Autoclip = true;
    }

    public ClipVector(int initialCapacity, boolean autoclip) {
        super(initialCapacity);
        this.Autoclip = autoclip;
    }

    public ClipVector() {
        this.Autoclip = true;
    }

    public ClipVector(boolean autoclip) {
        this.Autoclip = autoclip;
    }

    public ClipVector(Collection<? extends E> c) {
        super(c);
        this.Autoclip = true;
    }

    public ClipVector(Collection<? extends E> c, boolean autoclip) {
        super(c);
        this.Autoclip = autoclip;
    }

    @Override
    public void add(int index, E element) {
        super.add(index, element);
        if (this.Autoclip) {
            this.clip(index + 1);
        }
    }

    public void insert(int index, E element) {
        super.add(index, element);
        if (this.Autoclip) {
            this.clip(index + 1);
        }
    }

    public boolean insertAll(int index, Collection<? extends E> c) {
        boolean inserted = super.addAll(index, c);
        if (inserted && this.Autoclip) {
            this.clip(index + c.size());
        }
        return inserted;
    }

    public ClipVector<E> clip(int newClipIdx) {
        ClipVector clipped = new ClipVector();
        while (newClipIdx < this.size()) {
            clipped.add(this.get(newClipIdx));
            this.removeElementAt(newClipIdx);
        }
        return clipped;
    }

    public int firstIndex() {
        return 0;
    }

    @Override
    public E firstElement() {
        return this.size() > 0 ? (E)super.firstElement() : null;
    }

    public int lastIndex() {
        return Math.max(0, this.size() - 1);
    }

    @Override
    public E lastElement() {
        return this.size() > 0 ? (E)super.lastElement() : null;
    }

    public int emptyIndex() {
        return -1;
    }
}

