/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.common;

import com.sun.media.imageioimpl.common.BogusColorSpace;
import com.sun.media.imageioimpl.common.I18N;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public class ImageUtil {
    public static final ColorModel createColorModel(SampleModel sampleModel) {
        if (sampleModel == null) {
            throw new IllegalArgumentException("sampleModel == null!");
        }
        int n = sampleModel.getDataType();
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            default: {
                return null;
            }
        }
        ColorModel colorModel = null;
        int[] nArray = sampleModel.getSampleSize();
        if (sampleModel instanceof ComponentSampleModel) {
            int n2 = sampleModel.getNumBands();
            ColorSpace colorSpace = null;
            colorSpace = n2 <= 2 ? ColorSpace.getInstance(1003) : (n2 <= 4 ? ColorSpace.getInstance(1000) : new BogusColorSpace(n2));
            boolean bl = n2 == 2 || n2 == 4;
            boolean bl2 = false;
            int n3 = bl ? 3 : 1;
            colorModel = new ComponentColorModel(colorSpace, nArray, bl, bl2, n3, n);
        } else {
            if (sampleModel.getNumBands() <= 4 && sampleModel instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
                int[] nArray2 = singlePixelPackedSampleModel.getBitMasks();
                int n4 = 0;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = nArray2.length;
                if (n8 <= 2) {
                    n5 = n6 = nArray2[0];
                    n4 = n6;
                    if (n8 == 2) {
                        n7 = nArray2[1];
                    }
                } else {
                    n4 = nArray2[0];
                    n5 = nArray2[1];
                    n6 = nArray2[2];
                    if (n8 == 4) {
                        n7 = nArray2[3];
                    }
                }
                int n9 = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    n9 += nArray[i];
                }
                return new DirectColorModel(n9, n4, n5, n6, n7);
            }
            if (sampleModel instanceof MultiPixelPackedSampleModel) {
                int n10 = nArray[0];
                int n11 = 1 << n10;
                byte[] byArray = new byte[n11];
                for (int i = 0; i < n11; ++i) {
                    byArray[i] = (byte)(i * 255 / (n11 - 1));
                }
                colorModel = new IndexColorModel(n10, n11, byArray, byArray, byArray);
            }
        }
        return colorModel;
    }

    public static byte[] getPackedBinaryData(Raster raster, Rectangle rectangle) {
        byte[] byArray;
        block29: {
            int n;
            int n2;
            int n3;
            int n4;
            DataBuffer dataBuffer;
            int n5;
            int n6;
            block27: {
                block30: {
                    block28: {
                        SampleModel sampleModel = raster.getSampleModel();
                        if (!ImageUtil.isBinary(sampleModel)) {
                            throw new IllegalArgumentException(I18N.getString("ImageUtil0"));
                        }
                        int n7 = rectangle.x;
                        int n8 = rectangle.y;
                        n6 = rectangle.width;
                        n5 = rectangle.height;
                        dataBuffer = raster.getDataBuffer();
                        int n9 = n7 - raster.getSampleModelTranslateX();
                        int n10 = n8 - raster.getSampleModelTranslateY();
                        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                        n4 = multiPixelPackedSampleModel.getScanlineStride();
                        n3 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n9, n10);
                        n2 = multiPixelPackedSampleModel.getBitOffset(n9);
                        n = (n6 + 7) / 8;
                        if (dataBuffer instanceof DataBufferByte && n3 == 0 && n2 == 0 && n == n4 && ((DataBufferByte)dataBuffer).getData().length == n * n5) {
                            return ((DataBufferByte)dataBuffer).getData();
                        }
                        byArray = new byte[n * n5];
                        int n11 = 0;
                        if (n2 != 0) break block27;
                        if (!(dataBuffer instanceof DataBufferByte)) break block28;
                        byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                        int n12 = n;
                        int n13 = 0;
                        for (int i = 0; i < n5; ++i) {
                            System.arraycopy(byArray2, n3, byArray, n13, n12);
                            n13 += n12;
                            n3 += n4;
                        }
                        break block29;
                    }
                    if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block30;
                    short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                    for (int i = 0; i < n5; ++i) {
                        int n14;
                        int n15 = n3;
                        for (n14 = n6; n14 > 8; n14 -= 16) {
                            short s = sArray[n15++];
                            byArray[n11++] = (byte)(s >>> 8 & 0xFF);
                            byArray[n11++] = (byte)(s & 0xFF);
                        }
                        if (n14 > 0) {
                            byArray[n11++] = (byte)(sArray[n15] >>> 8 & 0xFF);
                        }
                        n3 += n4;
                    }
                    break block29;
                }
                if (!(dataBuffer instanceof DataBufferInt)) break block29;
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                for (int i = 0; i < n5; ++i) {
                    int n16;
                    int n17;
                    int n18 = n3;
                    for (n17 = n6; n17 > 24; n17 -= 32) {
                        n16 = nArray[n18++];
                        byArray[n11++] = (byte)(n16 >>> 24 & 0xFF);
                        byArray[n11++] = (byte)(n16 >>> 16 & 0xFF);
                        byArray[n11++] = (byte)(n16 >>> 8 & 0xFF);
                        byArray[n11++] = (byte)(n16 & 0xFF);
                    }
                    n16 = 24;
                    while (n17 > 0) {
                        byArray[n11++] = (byte)(nArray[n18] >>> n16 & 0xFF);
                        n16 -= 8;
                        n17 -= 8;
                    }
                    n3 += n4;
                }
                break block29;
            }
            if (dataBuffer instanceof DataBufferByte) {
                byte[] byArray3 = ((DataBufferByte)dataBuffer).getData();
                if ((n2 & 7) == 0) {
                    int n19 = n;
                    int n20 = 0;
                    for (int i = 0; i < n5; ++i) {
                        System.arraycopy(byArray3, n3, byArray, n20, n19);
                        n20 += n19;
                        n3 += n4;
                    }
                } else {
                    int n21 = n2 & 7;
                    int n22 = 8 - n21;
                    for (int i = 0; i < n5; ++i) {
                        int n23 = n3;
                        for (int j = n6; j > 0; j -= 8) {
                            byArray[n11++] = j > n22 ? (byte)((byArray3[n23++] & 0xFF) << n21 | (byArray3[n23] & 0xFF) >>> n22) : (byte)((byArray3[n23] & 0xFF) << n21);
                        }
                        n3 += n4;
                    }
                }
            } else if (dataBuffer instanceof DataBufferShort || dataBuffer instanceof DataBufferUShort) {
                short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                for (int i = 0; i < n5; ++i) {
                    int n24 = n2;
                    int n25 = 0;
                    while (n25 < n6) {
                        int n26 = n3 + n24 / 16;
                        int n27 = n24 % 16;
                        int n28 = sArray[n26] & 0xFFFF;
                        if (n27 <= 8) {
                            byArray[n11++] = (byte)(n28 >>> 8 - n27);
                        } else {
                            int n29 = n27 - 8;
                            int n30 = sArray[n26 + 1] & 0xFFFF;
                            byArray[n11++] = (byte)(n28 << n29 | n30 >>> 16 - n29);
                        }
                        n25 += 8;
                        n24 += 8;
                    }
                    n3 += n4;
                }
            } else if (dataBuffer instanceof DataBufferInt) {
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                for (int i = 0; i < n5; ++i) {
                    int n31 = n2;
                    int n32 = 0;
                    while (n32 < n6) {
                        int n33 = n3 + n31 / 32;
                        int n34 = n31 % 32;
                        int n35 = nArray[n33];
                        if (n34 <= 24) {
                            byArray[n11++] = (byte)(n35 >>> 24 - n34);
                        } else {
                            int n36 = n34 - 24;
                            int n37 = nArray[n33 + 1];
                            byArray[n11++] = (byte)(n35 << n36 | n37 >>> 32 - n36);
                        }
                        n32 += 8;
                        n31 += 8;
                    }
                    n3 += n4;
                }
            }
        }
        return byArray;
    }

    public static byte[] getUnpackedBinaryData(Raster raster, Rectangle rectangle) {
        byte[] byArray;
        block8: {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            DataBuffer dataBuffer;
            block9: {
                block7: {
                    SampleModel sampleModel = raster.getSampleModel();
                    if (!ImageUtil.isBinary(sampleModel)) {
                        throw new IllegalArgumentException(I18N.getString("ImageUtil0"));
                    }
                    int n6 = rectangle.x;
                    int n7 = rectangle.y;
                    int n8 = rectangle.width;
                    int n9 = rectangle.height;
                    dataBuffer = raster.getDataBuffer();
                    int n10 = n6 - raster.getSampleModelTranslateX();
                    int n11 = n7 - raster.getSampleModelTranslateY();
                    MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                    n5 = multiPixelPackedSampleModel.getScanlineStride();
                    n4 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n10, n11);
                    n3 = multiPixelPackedSampleModel.getBitOffset(n10);
                    byArray = new byte[n8 * n9];
                    n2 = n7 + n9;
                    n = n6 + n8;
                    int n12 = 0;
                    if (!(dataBuffer instanceof DataBufferByte)) break block7;
                    byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                    for (int i = n7; i < n2; ++i) {
                        int n13 = n4 * 8 + n3;
                        for (int j = n6; j < n; ++j) {
                            byte by = byArray2[n13 / 8];
                            byArray[n12++] = (byte)(by >>> (7 - n13 & 7) & 1);
                            ++n13;
                        }
                        n4 += n5;
                    }
                    break block8;
                }
                if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block9;
                short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                for (int i = n7; i < n2; ++i) {
                    int n14 = n4 * 16 + n3;
                    for (int j = n6; j < n; ++j) {
                        short s = sArray[n14 / 16];
                        byArray[n12++] = (byte)(s >>> 15 - n14 % 16 & 1);
                        ++n14;
                    }
                    n4 += n5;
                }
                break block8;
            }
            if (!(dataBuffer instanceof DataBufferInt)) break block8;
            int[] nArray = ((DataBufferInt)dataBuffer).getData();
            for (int i = n7; i < n2; ++i) {
                int n15 = n4 * 32 + n3;
                for (int j = n6; j < n; ++j) {
                    int n16 = nArray[n15 / 32];
                    byArray[n12++] = (byte)(n16 >>> 31 - n15 % 32 & 1);
                    ++n15;
                }
                n4 += n5;
            }
        }
        return byArray;
    }

    public static void setPackedBinaryData(byte[] byArray, WritableRaster writableRaster, Rectangle rectangle) {
        block41: {
            int n;
            int n2;
            int n3;
            int n4;
            DataBuffer dataBuffer;
            int n5;
            int n6;
            block39: {
                block42: {
                    block40: {
                        SampleModel sampleModel = writableRaster.getSampleModel();
                        if (!ImageUtil.isBinary(sampleModel)) {
                            throw new IllegalArgumentException(I18N.getString("ImageUtil0"));
                        }
                        int n7 = rectangle.x;
                        int n8 = rectangle.y;
                        n6 = rectangle.width;
                        n5 = rectangle.height;
                        dataBuffer = writableRaster.getDataBuffer();
                        int n9 = n7 - writableRaster.getSampleModelTranslateX();
                        int n10 = n8 - writableRaster.getSampleModelTranslateY();
                        MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                        n4 = multiPixelPackedSampleModel.getScanlineStride();
                        n3 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n9, n10);
                        n2 = multiPixelPackedSampleModel.getBitOffset(n9);
                        n = 0;
                        if (n2 != 0) break block39;
                        if (!(dataBuffer instanceof DataBufferByte)) break block40;
                        byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                        if (byArray2 == byArray) {
                            return;
                        }
                        int n11 = (n6 + 7) / 8;
                        int n12 = 0;
                        for (int i = 0; i < n5; ++i) {
                            System.arraycopy(byArray, n12, byArray2, n3, n11);
                            n12 += n11;
                            n3 += n4;
                        }
                        break block41;
                    }
                    if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block42;
                    short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                    for (int i = 0; i < n5; ++i) {
                        int n13;
                        int n14 = n3;
                        for (n13 = n6; n13 > 8; n13 -= 16) {
                            sArray[n14++] = (short)((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
                        }
                        if (n13 > 0) {
                            sArray[n14++] = (short)((byArray[n++] & 0xFF) << 8);
                        }
                        n3 += n4;
                    }
                    break block41;
                }
                if (!(dataBuffer instanceof DataBufferInt)) break block41;
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                for (int i = 0; i < n5; ++i) {
                    int n15;
                    int n16 = n3;
                    for (n15 = n6; n15 > 24; n15 -= 32) {
                        nArray[n16++] = (byArray[n++] & 0xFF) << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
                    }
                    int n17 = 24;
                    while (n15 > 0) {
                        int n18 = n16;
                        nArray[n18] = nArray[n18] | (byArray[n++] & 0xFF) << n17;
                        n17 -= 8;
                        n15 -= 8;
                    }
                    n3 += n4;
                }
                break block41;
            }
            int n19 = (n6 + 7) / 8;
            int n20 = 0;
            if (dataBuffer instanceof DataBufferByte) {
                byte[] byArray3 = ((DataBufferByte)dataBuffer).getData();
                if ((n2 & 7) == 0) {
                    for (int i = 0; i < n5; ++i) {
                        System.arraycopy(byArray, n20, byArray3, n3, n19);
                        n20 += n19;
                        n3 += n4;
                    }
                } else {
                    int n21 = n2 & 7;
                    int n22 = 8 - n21;
                    int n23 = 8 + n22;
                    byte by = (byte)(255 << n22);
                    byte by2 = ~by;
                    for (int i = 0; i < n5; ++i) {
                        int n24 = n3;
                        for (int j = n6; j > 0; j -= 8) {
                            byte by3 = byArray[n++];
                            if (j > n23) {
                                byArray3[n24] = (byte)(byArray3[n24] & by | (by3 & 0xFF) >>> n21);
                                byArray3[++n24] = (byte)((by3 & 0xFF) << n22);
                                continue;
                            }
                            if (j > n22) {
                                byArray3[n24] = (byte)(byArray3[n24] & by | (by3 & 0xFF) >>> n21);
                                byArray3[++n24] = (byte)(byArray3[n24] & by2 | (by3 & 0xFF) << n22);
                                continue;
                            }
                            int n25 = (1 << n22 - j) - 1;
                            byArray3[n24] = (byte)(byArray3[n24] & (by | n25) | (by3 & 0xFF) >>> n21 & ~n25);
                        }
                        n3 += n4;
                    }
                }
            } else if (dataBuffer instanceof DataBufferShort || dataBuffer instanceof DataBufferUShort) {
                short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                int n26 = n2 & 7;
                int n27 = 8 - n26;
                int n28 = 16 + n27;
                short s = (short)(~(255 << n27));
                short s2 = (short)(65535 << n27);
                short s3 = ~s2;
                for (int i = 0; i < n5; ++i) {
                    int n29 = n2;
                    int n30 = n6;
                    int n31 = 0;
                    while (n31 < n6) {
                        int n32 = n3 + (n29 >> 4);
                        int n33 = n29 & 0xF;
                        int n34 = byArray[n++] & 0xFF;
                        if (n33 <= 8) {
                            if (n30 < 8) {
                                n34 &= 255 << 8 - n30;
                            }
                            sArray[n32] = (short)(sArray[n32] & s | n34 << n27);
                        } else if (n30 > n28) {
                            sArray[n32] = (short)(sArray[n32] & s2 | n34 >>> n26 & 0xFFFF);
                            sArray[++n32] = (short)(n34 << n27 & 0xFFFF);
                        } else if (n30 > n27) {
                            sArray[n32] = (short)(sArray[n32] & s2 | n34 >>> n26 & 0xFFFF);
                            sArray[++n32] = (short)(sArray[n32] & s3 | n34 << n27 & 0xFFFF);
                        } else {
                            int n35 = (1 << n27 - n30) - 1;
                            sArray[n32] = (short)(sArray[n32] & (s2 | n35) | n34 >>> n26 & 0xFFFF & ~n35);
                        }
                        n31 += 8;
                        n29 += 8;
                        n30 -= 8;
                    }
                    n3 += n4;
                }
            } else if (dataBuffer instanceof DataBufferInt) {
                int[] nArray = ((DataBufferInt)dataBuffer).getData();
                int n36 = n2 & 7;
                int n37 = 8 - n36;
                int n38 = 32 + n37;
                int n39 = -1 << n37;
                int n40 = ~n39;
                for (int i = 0; i < n5; ++i) {
                    int n41 = n2;
                    int n42 = n6;
                    int n43 = 0;
                    while (n43 < n6) {
                        int n44;
                        int n45 = n3 + (n41 >> 5);
                        int n46 = n41 & 0x1F;
                        int n47 = byArray[n++] & 0xFF;
                        if (n46 <= 24) {
                            n44 = 24 - n46;
                            if (n42 < 8) {
                                n47 &= 255 << 8 - n42;
                            }
                            nArray[n45] = nArray[n45] & ~(255 << n44) | n47 << n44;
                        } else if (n42 > n38) {
                            nArray[n45] = nArray[n45] & n39 | n47 >>> n36;
                            nArray[++n45] = n47 << n37;
                        } else if (n42 > n37) {
                            nArray[n45] = nArray[n45] & n39 | n47 >>> n36;
                            nArray[++n45] = nArray[n45] & n40 | n47 << n37;
                        } else {
                            n44 = (1 << n37 - n42) - 1;
                            nArray[n45] = nArray[n45] & (n39 | n44) | n47 >>> n36 & ~n44;
                        }
                        n43 += 8;
                        n41 += 8;
                        n42 -= 8;
                    }
                    n3 += n4;
                }
            }
        }
    }

    public static void setUnpackedBinaryData(byte[] byArray, WritableRaster writableRaster, Rectangle rectangle) {
        block11: {
            int n;
            int n2;
            int n3;
            int n4;
            DataBuffer dataBuffer;
            int n5;
            int n6;
            block12: {
                block10: {
                    SampleModel sampleModel = writableRaster.getSampleModel();
                    if (!ImageUtil.isBinary(sampleModel)) {
                        throw new IllegalArgumentException(I18N.getString("ImageUtil0"));
                    }
                    int n7 = rectangle.x;
                    int n8 = rectangle.y;
                    n6 = rectangle.width;
                    n5 = rectangle.height;
                    dataBuffer = writableRaster.getDataBuffer();
                    int n9 = n7 - writableRaster.getSampleModelTranslateX();
                    int n10 = n8 - writableRaster.getSampleModelTranslateY();
                    MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                    n4 = multiPixelPackedSampleModel.getScanlineStride();
                    n3 = dataBuffer.getOffset() + multiPixelPackedSampleModel.getOffset(n9, n10);
                    n2 = multiPixelPackedSampleModel.getBitOffset(n9);
                    n = 0;
                    if (!(dataBuffer instanceof DataBufferByte)) break block10;
                    byte[] byArray2 = ((DataBufferByte)dataBuffer).getData();
                    for (int i = 0; i < n5; ++i) {
                        int n11 = n3 * 8 + n2;
                        for (int j = 0; j < n6; ++j) {
                            if (byArray[n++] != 0) {
                                int n12 = n11 / 8;
                                byArray2[n12] = (byte)(byArray2[n12] | (byte)(1 << (7 - n11 & 7)));
                            }
                            ++n11;
                        }
                        n3 += n4;
                    }
                    break block11;
                }
                if (!(dataBuffer instanceof DataBufferShort) && !(dataBuffer instanceof DataBufferUShort)) break block12;
                short[] sArray = dataBuffer instanceof DataBufferShort ? ((DataBufferShort)dataBuffer).getData() : ((DataBufferUShort)dataBuffer).getData();
                for (int i = 0; i < n5; ++i) {
                    int n13 = n3 * 16 + n2;
                    for (int j = 0; j < n6; ++j) {
                        if (byArray[n++] != 0) {
                            int n14 = n13 / 16;
                            sArray[n14] = (short)(sArray[n14] | (short)(1 << 15 - n13 % 16));
                        }
                        ++n13;
                    }
                    n3 += n4;
                }
                break block11;
            }
            if (!(dataBuffer instanceof DataBufferInt)) break block11;
            int[] nArray = ((DataBufferInt)dataBuffer).getData();
            for (int i = 0; i < n5; ++i) {
                int n15 = n3 * 32 + n2;
                for (int j = 0; j < n6; ++j) {
                    if (byArray[n++] != 0) {
                        int n16 = n15 / 32;
                        nArray[n16] = nArray[n16] | 1 << 31 - n15 % 32;
                    }
                    ++n15;
                }
                n3 += n4;
            }
        }
    }

    public static boolean isBinary(SampleModel sampleModel) {
        return sampleModel instanceof MultiPixelPackedSampleModel && ((MultiPixelPackedSampleModel)sampleModel).getPixelBitStride() == 1 && sampleModel.getNumBands() == 1;
    }

    public static ColorModel createColorModel(ColorSpace colorSpace, SampleModel sampleModel) {
        ColorModel colorModel = null;
        if (sampleModel == null) {
            throw new IllegalArgumentException(I18N.getString("ImageUtil1"));
        }
        int n = sampleModel.getNumBands();
        if (n < 1 || n > 4) {
            return null;
        }
        int n2 = sampleModel.getDataType();
        if (sampleModel instanceof ComponentSampleModel) {
            if (n2 < 0 || n2 > 5) {
                return null;
            }
            if (colorSpace == null) {
                colorSpace = n <= 2 ? ColorSpace.getInstance(1003) : ColorSpace.getInstance(1000);
            }
            boolean bl = n == 2 || n == 4;
            int n3 = bl ? 3 : 1;
            boolean bl2 = false;
            int n4 = DataBuffer.getDataTypeSize(n2);
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = n4;
            }
            colorModel = new ComponentColorModel(colorSpace, nArray, bl, bl2, n3, n2);
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            int[] nArray = singlePixelPackedSampleModel.getBitMasks();
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            n = nArray.length;
            if (n <= 2) {
                n6 = n7 = nArray[0];
                n5 = n7;
                if (n == 2) {
                    n8 = nArray[1];
                }
            } else {
                n5 = nArray[0];
                n6 = nArray[1];
                n7 = nArray[2];
                if (n == 4) {
                    n8 = nArray[3];
                }
            }
            int[] nArray2 = singlePixelPackedSampleModel.getSampleSize();
            int n9 = 0;
            for (int i = 0; i < nArray2.length; ++i) {
                n9 += nArray2[i];
            }
            if (colorSpace == null) {
                colorSpace = ColorSpace.getInstance(1000);
            }
            colorModel = new DirectColorModel(colorSpace, n9, n5, n6, n7, n8, false, sampleModel.getDataType());
        } else if (sampleModel instanceof MultiPixelPackedSampleModel) {
            int n10 = ((MultiPixelPackedSampleModel)sampleModel).getPixelBitStride();
            int n11 = 1 << n10;
            byte[] byArray = new byte[n11];
            for (int i = 0; i < n11; ++i) {
                byArray[i] = (byte)(255 * i / (n11 - 1));
            }
            colorModel = new IndexColorModel(n10, n11, byArray, byArray, byArray);
        }
        return colorModel;
    }

    public static int getElementSize(SampleModel sampleModel) {
        int n = DataBuffer.getDataTypeSize(sampleModel.getDataType());
        if (sampleModel instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
            return multiPixelPackedSampleModel.getSampleSize(0) * multiPixelPackedSampleModel.getNumBands();
        }
        if (sampleModel instanceof ComponentSampleModel) {
            return sampleModel.getNumBands() * n;
        }
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            return n;
        }
        return n * sampleModel.getNumBands();
    }

    public static long getTileSize(SampleModel sampleModel) {
        int n = DataBuffer.getDataTypeSize(sampleModel.getDataType());
        if (sampleModel instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
            return (multiPixelPackedSampleModel.getScanlineStride() * multiPixelPackedSampleModel.getHeight() + (multiPixelPackedSampleModel.getDataBitOffset() + n - 1) / n) * ((n + 7) / 8);
        }
        if (sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
            int[] nArray = componentSampleModel.getBandOffsets();
            int n2 = nArray[0];
            for (int i = 1; i < nArray.length; ++i) {
                n2 = Math.max(n2, nArray[i]);
            }
            long l = 0L;
            int n3 = componentSampleModel.getPixelStride();
            int n4 = componentSampleModel.getScanlineStride();
            if (n2 >= 0) {
                l += (long)(n2 + 1);
            }
            if (n3 > 0) {
                l += (long)(n3 * (sampleModel.getWidth() - 1));
            }
            if (n4 > 0) {
                l += (long)(n4 * (sampleModel.getHeight() - 1));
            }
            int[] nArray2 = componentSampleModel.getBankIndices();
            n2 = nArray2[0];
            for (int i = 1; i < nArray2.length; ++i) {
                n2 = Math.max(n2, nArray2[i]);
            }
            return l * (long)(n2 + 1) * (long)((n + 7) / 8);
        }
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            long l = singlePixelPackedSampleModel.getScanlineStride() * (singlePixelPackedSampleModel.getHeight() - 1) + singlePixelPackedSampleModel.getWidth();
            return l * (long)((n + 7) / 8);
        }
        return 0L;
    }

    public static long getBandSize(SampleModel sampleModel) {
        int n = DataBuffer.getDataTypeSize(sampleModel.getDataType());
        if (sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
            int n2 = componentSampleModel.getPixelStride();
            int n3 = componentSampleModel.getScanlineStride();
            long l = Math.min(n2, n3);
            if (n2 > 0) {
                l += (long)(n2 * (sampleModel.getWidth() - 1));
            }
            if (n3 > 0) {
                l += (long)(n3 * (sampleModel.getHeight() - 1));
            }
            return l * (long)((n + 7) / 8);
        }
        return ImageUtil.getTileSize(sampleModel);
    }

    public static boolean isGrayscaleMapping(IndexColorModel indexColorModel) {
        int n;
        int n2;
        if (indexColorModel == null) {
            throw new IllegalArgumentException("icm == null!");
        }
        int n3 = indexColorModel.getMapSize();
        byte[] byArray = new byte[n3];
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n3];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        boolean bl = true;
        for (n2 = 0; n2 < n3; ++n2) {
            n = n2 * 255 / (n3 - 1);
            if (byArray[n2] == n && byArray2[n2] == n && byArray3[n2] == n) continue;
            bl = false;
            break;
        }
        if (!bl) {
            bl = true;
            n2 = 0;
            n = n3 - 1;
            while (n2 < n3) {
                byte by = (byte)(n * 255 / (n3 - 1));
                if (byArray[n2] != by || byArray2[n2] != by || byArray3[n2] != by) {
                    bl = false;
                    break;
                }
                ++n2;
                --n;
            }
        }
        return bl;
    }

    public static boolean isIndicesForGrayscale(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (byArray.length != byArray2.length || byArray.length != byArray3.length) {
            return false;
        }
        int n = byArray.length;
        if (n != 256) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            byte by = (byte)i;
            if (byArray[i] == by && byArray2[i] == by && byArray3[i] == by) continue;
            return false;
        }
        return true;
    }

    public static String convertObjectToString(Object object) {
        if (object == null) {
            return "";
        }
        String string = "";
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            for (int i = 0; i < byArray.length; ++i) {
                string = string + byArray[i] + " ";
            }
            return string;
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            for (int i = 0; i < nArray.length; ++i) {
                string = string + nArray[i] + " ";
            }
            return string;
        }
        if (object instanceof short[]) {
            short[] sArray = (short[])object;
            for (int i = 0; i < sArray.length; ++i) {
                string = string + sArray[i] + " ";
            }
            return string;
        }
        return object.toString();
    }

    public static final void canEncodeImage(ImageWriter imageWriter, ImageTypeSpecifier imageTypeSpecifier) throws IIOException {
        ImageWriterSpi imageWriterSpi = imageWriter.getOriginatingProvider();
        if (imageTypeSpecifier != null && imageWriterSpi != null && !imageWriterSpi.canEncodeImage(imageTypeSpecifier)) {
            throw new IIOException(I18N.getString("ImageUtil2") + " " + imageWriter.getClass().getName());
        }
    }

    public static final void canEncodeImage(ImageWriter imageWriter, ColorModel colorModel, SampleModel sampleModel) throws IIOException {
        ImageTypeSpecifier imageTypeSpecifier = null;
        if (colorModel != null && sampleModel != null) {
            imageTypeSpecifier = new ImageTypeSpecifier(colorModel, sampleModel);
        }
        ImageUtil.canEncodeImage(imageWriter, imageTypeSpecifier);
    }

    public static final boolean imageIsContiguous(RenderedImage renderedImage) {
        SampleModel sampleModel;
        Object object;
        if (renderedImage instanceof BufferedImage) {
            object = ((BufferedImage)renderedImage).getRaster();
            sampleModel = ((Raster)object).getSampleModel();
        } else {
            sampleModel = renderedImage.getSampleModel();
        }
        if (sampleModel instanceof ComponentSampleModel) {
            object = (ComponentSampleModel)sampleModel;
            if (((ComponentSampleModel)object).getPixelStride() != ((SampleModel)object).getNumBands()) {
                return false;
            }
            int[] nArray = ((ComponentSampleModel)object).getBandOffsets();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == i) continue;
                return false;
            }
            int[] nArray2 = ((ComponentSampleModel)object).getBankIndices();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray2[i] == 0) continue;
                return false;
            }
            return true;
        }
        return ImageUtil.isBinary(sampleModel);
    }

    public static final ImageTypeSpecifier getDestinationType(ImageReadParam imageReadParam, Iterator iterator) throws IIOException {
        if (iterator == null || !iterator.hasNext()) {
            throw new IllegalArgumentException("imageTypes null or empty!");
        }
        ImageTypeSpecifier imageTypeSpecifier = null;
        if (imageReadParam != null) {
            imageTypeSpecifier = imageReadParam.getDestinationType();
        }
        if (imageTypeSpecifier == null) {
            Object e = iterator.next();
            if (!(e instanceof ImageTypeSpecifier)) {
                throw new IllegalArgumentException("Non-ImageTypeSpecifier retrieved from imageTypes!");
            }
            imageTypeSpecifier = (ImageTypeSpecifier)e;
        } else {
            boolean bl = false;
            while (iterator.hasNext()) {
                ImageTypeSpecifier imageTypeSpecifier2 = (ImageTypeSpecifier)iterator.next();
                if (!imageTypeSpecifier2.equals(imageTypeSpecifier)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new IIOException("Destination type from ImageReadParam does not match!");
            }
        }
        return imageTypeSpecifier;
    }

    public static boolean isNonStandardICCColorSpace(ColorSpace colorSpace) {
        boolean bl = false;
        try {
            bl = colorSpace instanceof ICC_ColorSpace && !colorSpace.isCS_sRGB() && !colorSpace.equals(ColorSpace.getInstance(1004)) && !colorSpace.equals(ColorSpace.getInstance(1003)) && !colorSpace.equals(ColorSpace.getInstance(1001)) && !colorSpace.equals(ColorSpace.getInstance(1002));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return bl;
    }

    public static List getJDKImageReaderWriterSPI(ServiceRegistry serviceRegistry, String string, boolean bl) {
        String string2;
        Class clazz;
        IIORegistry iIORegistry = (IIORegistry)serviceRegistry;
        if (bl) {
            clazz = ImageReaderSpi.class;
            string2 = " image reader";
        } else {
            clazz = ImageWriterSpi.class;
            string2 = " image writer";
        }
        Iterator iterator = iIORegistry.getServiceProviders(clazz, true);
        String string3 = "standard " + string + string2;
        String string4 = "com.sun.media.imageioimpl";
        Locale locale = Locale.getDefault();
        ArrayList<ImageReaderWriterSpi> arrayList = new ArrayList<ImageReaderWriterSpi>();
        block0: while (iterator.hasNext()) {
            ImageReaderWriterSpi imageReaderWriterSpi = (ImageReaderWriterSpi)iterator.next();
            if (!imageReaderWriterSpi.getVendorName().startsWith("Sun Microsystems") || !string3.equalsIgnoreCase(imageReaderWriterSpi.getDescription(locale)) || imageReaderWriterSpi.getPluginClassName().startsWith(string4)) continue;
            String[] stringArray = imageReaderWriterSpi.getFormatNames();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equalsIgnoreCase(string)) continue;
                arrayList.add(imageReaderWriterSpi);
                continue block0;
            }
        }
        return arrayList;
    }

    public static void processOnRegistration(ServiceRegistry serviceRegistry, Class clazz, String string, ImageReaderWriterSpi imageReaderWriterSpi, int n, int n2) {
        String string2 = System.getProperty("java.vendor");
        String string3 = System.getProperty("java.specification.version");
        int n3 = string3.indexOf("1.");
        string3 = string3.substring(n3 + 2);
        int n4 = Integer.parseInt(string3);
        if (string2.equals("Sun Microsystems Inc.")) {
            List list = imageReaderWriterSpi instanceof ImageReaderSpi ? ImageUtil.getJDKImageReaderWriterSPI(serviceRegistry, string, true) : ImageUtil.getJDKImageReaderWriterSPI(serviceRegistry, string, false);
            if (n4 >= n && list.size() != 0) {
                serviceRegistry.deregisterServiceProvider(imageReaderWriterSpi, clazz);
            } else {
                for (int i = 0; i < list.size(); ++i) {
                    if (n4 >= n2) {
                        serviceRegistry.setOrdering(clazz, list.get(i), imageReaderWriterSpi);
                        continue;
                    }
                    serviceRegistry.setOrdering(clazz, imageReaderWriterSpi, list.get(i));
                }
            }
        }
    }

    public static int readMultiByteInteger(ImageInputStream imageInputStream) throws IOException {
        byte by = imageInputStream.readByte();
        int n = by & 0x7F;
        while ((by & 0x80) == 128) {
            n <<= 7;
            by = imageInputStream.readByte();
            n |= by & 0x7F;
        }
        return n;
    }
}

