/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.clib;

import com.sun.media.imageioimpl.plugins.clib.I18N;
import com.sun.medialib.codec.jiio.mediaLibImage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageWriterSpi;

public abstract class CLibImageWriter
extends ImageWriter {
    private static final Object getDataBufferData(DataBuffer dataBuffer) {
        Object[] objectArray;
        int n = dataBuffer.getDataType();
        switch (n) {
            case 0: {
                objectArray = ((DataBufferByte)dataBuffer).getData();
                break;
            }
            case 1: {
                objectArray = ((DataBufferUShort)dataBuffer).getData();
                break;
            }
            default: {
                throw new IllegalArgumentException(I18N.getString("Generic0") + " " + n);
            }
        }
        return objectArray;
    }

    private static final int getMediaLibDataType(int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 6;
                break;
            }
            default: {
                throw new IllegalArgumentException(I18N.getString("Generic0") + " " + n);
            }
        }
        return n2;
    }

    private static final int getMediaLibFormat(SampleModel sampleModel, ColorModel colorModel) {
        if (sampleModel == null) {
            throw new IllegalArgumentException("sampleModel == null!");
        }
        int n = 0;
        if (sampleModel instanceof SinglePixelPackedSampleModel && sampleModel.getNumBands() == 4 && colorModel != null && colorModel.hasAlpha()) {
            int[] nArray = ((SinglePixelPackedSampleModel)sampleModel).getBitMasks();
            if (nArray[3] == -16777216) {
                if (nArray[0] == 255 && nArray[1] == 65280 && nArray[2] == 0xFF0000) {
                    n = 8;
                } else if (nArray[0] == 0xFF0000 && nArray[1] == 65280 && nArray[2] == 255) {
                    n = 7;
                }
            }
        } else if (sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
            int[] nArray = componentSampleModel.getBandOffsets();
            int n2 = componentSampleModel.getPixelStride();
            if (n2 == nArray.length) {
                int n3;
                int n4 = n2;
                boolean bl = true;
                int[] nArray2 = componentSampleModel.getBankIndices();
                for (n3 = 1; n3 < nArray2.length; ++n3) {
                    if (nArray2[n3] == nArray2[0]) continue;
                    bl = false;
                }
                if (bl) {
                    if (colorModel instanceof IndexColorModel) {
                        n = 1;
                    } else if (n4 == 1) {
                        n = 2;
                    } else if (n4 == 2 && nArray[0] == 0 && nArray[1] == 1) {
                        n = 9;
                    } else if (n4 == 3) {
                        int n5 = n3 = colorModel != null ? colorModel.getColorSpace().getType() : 5;
                        if (n3 == 5) {
                            if (nArray[0] == 2 && nArray[1] == 1 && nArray[2] == 0) {
                                n = 4;
                            } else if (nArray[0] == 0 && nArray[1] == 1 && nArray[2] == 2) {
                                n = 3;
                            }
                        } else if (n3 == 4 && nArray[0] == 0 && nArray[1] == 1 && nArray[2] == 2) {
                            n = 12;
                        }
                    } else if (n4 == 4) {
                        int n6 = n3 = colorModel != null ? colorModel.getColorSpace().getType() : 5;
                        if (n3 == 5) {
                            if (nArray[3] == 0) {
                                if (nArray[0] == 3 && nArray[1] == 2 && nArray[2] == 1) {
                                    n = 6;
                                } else if (nArray[0] == 1 && nArray[1] == 2 && nArray[2] == 3) {
                                    n = 5;
                                }
                            } else if (nArray[3] == 3) {
                                if (nArray[0] == 0 && nArray[1] == 1 && nArray[2] == 2) {
                                    n = 10;
                                } else if (nArray[0] == 2 && nArray[1] == 1 && nArray[2] == 0) {
                                    n = 15;
                                }
                            }
                        } else if (n3 == 9 && nArray[0] == 0 && nArray[1] == 1 && nArray[2] == 2 && nArray[3] == 3) {
                            n = 11;
                        } else if (n3 == 4 && nArray[0] == 0 && nArray[1] == 1 && nArray[2] == 2 && nArray[3] == 3) {
                            n = colorModel != null && colorModel.hasAlpha() ? 13 : 14;
                        }
                    }
                }
            }
        }
        return n;
    }

    private static final Raster getContiguousData(RenderedImage renderedImage, Rectangle rectangle) {
        Raster raster;
        if (renderedImage == null) {
            throw new IllegalArgumentException("im == null");
        }
        if (rectangle == null) {
            throw new IllegalArgumentException("region == null");
        }
        if (renderedImage.getNumXTiles() == 1 && renderedImage.getNumYTiles() == 1) {
            raster = renderedImage.getTile(renderedImage.getMinTileX(), renderedImage.getMinTileY());
            Rectangle rectangle2 = raster.getBounds();
            if (!rectangle2.equals(rectangle)) {
                raster = raster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
            }
        } else {
            SampleModel sampleModel = renderedImage.getSampleModel();
            WritableRaster writableRaster = sampleModel.getSampleSize(0) == 8 ? Raster.createInterleavedRaster(0, renderedImage.getWidth(), renderedImage.getHeight(), sampleModel.getNumBands(), new Point(renderedImage.getMinX(), renderedImage.getMinY())) : null;
            raster = renderedImage.copyData(writableRaster);
        }
        return raster;
    }

    private static void reformat(Raster raster, int[] nArray, int n, int n2, WritableRaster writableRaster) {
        int n3;
        if (raster == null) {
            throw new IllegalArgumentException("source == null!");
        }
        if (writableRaster == null) {
            throw new IllegalArgumentException("dst == null!");
        }
        Rectangle rectangle = raster.getBounds();
        if (rectangle.isEmpty()) {
            throw new IllegalArgumentException("source.getBounds().isEmpty()!");
        }
        boolean bl = false;
        int n4 = raster.getSampleModel().getNumBands();
        if (nArray != null) {
            if (nArray.length > n4) {
                throw new IllegalArgumentException("sourceBands.length > numSourceBands!");
            }
            n3 = nArray.length == n4 ? 1 : 0;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] < 0 || nArray[i] >= n4) {
                    throw new IllegalArgumentException("sourceBands[i] < 0 || sourceBands[i] >= numSourceBands!");
                }
                if (nArray[i] == i) continue;
                n3 = 0;
            }
            bl = n3 == 0;
        }
        n3 = rectangle.width;
        int[] nArray2 = new int[n3 * n4];
        int n5 = rectangle.x;
        int n6 = rectangle.y;
        int n7 = nArray != null ? nArray.length : n4;
        int n8 = writableRaster.getWidth();
        int n9 = writableRaster.getHeight() - 1;
        int n10 = n4 * n;
        for (int i = 0; i <= n9; ++i) {
            int n11;
            int n12;
            int n13;
            int n14;
            raster.getPixels(n5, n6, n3, 1, nArray2);
            if (bl) {
                n14 = 0;
                n13 = 0;
                for (n12 = 0; n12 < n8; ++n12) {
                    for (n11 = 0; n11 < n7; ++n11) {
                        nArray2[n13++] = nArray2[n14 + nArray[n11]];
                    }
                    n14 += n10;
                }
            } else {
                n14 = n10;
                n13 = n4;
                for (n12 = 1; n12 < n8; ++n12) {
                    n11 = n14;
                    for (int j = 0; j < n4; ++j) {
                        nArray2[n13++] = nArray2[n11++];
                    }
                    n14 += n10;
                }
            }
            writableRaster.setPixels(0, i, n8, 1, nArray2);
            n6 += n2;
        }
    }

    protected CLibImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    public IIOMetadata convertImageMetadata(IIOMetadata iIOMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata convertStreamMetadata(IIOMetadata iIOMetadata, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) {
        return null;
    }

    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) {
        return null;
    }

    private static final Rectangle getSourceRegion(ImageWriteParam imageWriteParam, int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (imageWriteParam != null) {
            Rectangle rectangle2 = imageWriteParam.getSourceRegion();
            if (rectangle2 != null) {
                rectangle = rectangle.intersection(rectangle2);
            }
            int n5 = imageWriteParam.getSubsamplingXOffset();
            int n6 = imageWriteParam.getSubsamplingYOffset();
            rectangle.x += n5;
            rectangle.y += n6;
            rectangle.width -= n5;
            rectangle.height -= n6;
        }
        return rectangle;
    }

    protected mediaLibImage getMediaLibImage(RenderedImage renderedImage, ImageWriteParam imageWriteParam, boolean bl, int[] nArray) {
        int[] nArray2;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray3;
        if (nArray == null) {
            throw new IllegalArgumentException("supportedFormats == null!");
        }
        Rectangle rectangle = CLibImageWriter.getSourceRegion(imageWriteParam, renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        if (rectangle.isEmpty()) {
            throw new IllegalArgumentException("sourceRegion.isEmpty()");
        }
        boolean bl2 = false;
        boolean bl3 = false;
        int n6 = 0;
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n7 = sampleModel.getNumBands();
        int[] nArray4 = nArray3 = imageWriteParam != null ? imageWriteParam.getSourceBands() : null;
        if (nArray3 != null) {
            n5 = nArray3.length;
            if (n5 != n7) {
                bl2 = true;
            } else {
                for (n4 = 0; n4 < n7; ++n4) {
                    if (nArray3[n4] == n4) continue;
                    bl2 = true;
                    break;
                }
            }
        } else {
            n5 = n7;
        }
        if (!(bl2 || imageWriteParam == null || imageWriteParam.getSourceXSubsampling() == 1 && imageWriteParam.getSourceXSubsampling() == 1)) {
            bl2 = true;
        }
        if (!bl2) {
            if (bl && sampleModel.getNumBands() == 1 && sampleModel.getSampleSize(0) == 1 && sampleModel instanceof MultiPixelPackedSampleModel && sampleModel.getDataType() == 0) {
                MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
                if (multiPixelPackedSampleModel.getPixelBitStride() == 1) {
                    bl3 = true;
                } else {
                    bl2 = true;
                }
            } else {
                n6 = CLibImageWriter.getMediaLibFormat(sampleModel, renderedImage.getColorModel());
                bl2 = true;
                n4 = nArray.length;
                for (int i = 0; i < n4; ++i) {
                    if (n6 != nArray[i]) continue;
                    bl2 = false;
                    break;
                }
            }
        }
        Raster raster = null;
        if (bl2) {
            WritableRaster writableRaster;
            SampleModel sampleModel2;
            int n8;
            int[] nArray5 = sampleModel.getSampleSize();
            int n9 = nArray5[0];
            for (n3 = 1; n3 < n7; ++n3) {
                n9 = Math.max(n9, nArray5[n3]);
            }
            if (n9 <= 8) {
                n3 = 0;
            } else if (n9 <= 16) {
                n3 = 1;
            } else {
                throw new UnsupportedOperationException(I18N.getString("CLibImageWriter0") + " " + n9);
            }
            if (imageWriteParam != null) {
                int n10 = imageWriteParam.getSourceXSubsampling();
                n8 = imageWriteParam.getSourceYSubsampling();
                n2 = (rectangle.width + n10 - 1) / n10;
                n = (rectangle.height + n8 - 1) / n8;
            } else {
                n2 = rectangle.width;
                n = rectangle.height;
            }
            nArray2 = new int[n5];
            for (n8 = 0; n8 < n5; ++n8) {
                nArray2[n8] = n8;
            }
            if (bl && sampleModel.getNumBands() == 1 && n9 == 1) {
                sampleModel2 = new MultiPixelPackedSampleModel(n3, n2, n, 1);
                bl3 = true;
            } else {
                sampleModel2 = new PixelInterleavedSampleModel(n3, n2, n, nArray2.length, n2 * n7, nArray2);
            }
            WritableRaster writableRaster2 = Raster.createWritableRaster(sampleModel2, null);
            if (imageWriteParam != null && (imageWriteParam.getSourceXSubsampling() != 1 || imageWriteParam.getSourceXSubsampling() != 1)) {
                CLibImageWriter.reformat(CLibImageWriter.getContiguousData(renderedImage, rectangle), nArray3, imageWriteParam.getSourceXSubsampling(), imageWriteParam.getSourceYSubsampling(), writableRaster2);
            } else if (nArray3 == null && renderedImage.getSampleModel().getClass().isInstance(sampleModel2) && sampleModel2.getTransferType() == renderedImage.getSampleModel().getTransferType()) {
                writableRaster = writableRaster2.createWritableTranslatedChild(rectangle.x, rectangle.y);
                renderedImage.copyData(writableRaster);
            } else {
                writableRaster = writableRaster2.createWritableTranslatedChild(rectangle.x, rectangle.y);
                Raster raster2 = CLibImageWriter.getContiguousData(renderedImage, rectangle);
                if (nArray3 != null) {
                    raster2 = raster2.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, nArray3);
                }
                writableRaster.setRect(raster2);
            }
            raster = writableRaster2;
            sampleModel = writableRaster2.getSampleModel();
        } else {
            raster = CLibImageWriter.getContiguousData(renderedImage, rectangle).createTranslatedChild(0, 0);
            sampleModel = raster.getSampleModel();
            n6 = CLibImageWriter.getMediaLibFormat(sampleModel, renderedImage.getColorModel());
        }
        mediaLibImage mediaLibImage2 = null;
        if (bl3) {
            MultiPixelPackedSampleModel multiPixelPackedSampleModel = (MultiPixelPackedSampleModel)sampleModel;
            n3 = multiPixelPackedSampleModel.getScanlineStride();
            n2 = raster.getDataBuffer().getOffset() - raster.getSampleModelTranslateY() * n3 - raster.getSampleModelTranslateX() / 8 + multiPixelPackedSampleModel.getOffset(0, 0);
            Object object = CLibImageWriter.getDataBufferData(raster.getDataBuffer());
            mediaLibImage2 = new mediaLibImage(0, 1, raster.getWidth(), raster.getHeight(), n3, n2, (byte)multiPixelPackedSampleModel.getBitOffset(0), object);
        } else {
            int n11;
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
            n3 = CLibImageWriter.getMediaLibDataType(sampleModel.getDataType());
            Object object = CLibImageWriter.getDataBufferData(raster.getDataBuffer());
            n = componentSampleModel.getScanlineStride();
            nArray2 = componentSampleModel.getBandOffsets();
            int n12 = nArray2[0];
            for (n11 = 1; n11 < nArray2.length; ++n11) {
                if (nArray2[n11] >= n12) continue;
                n12 = nArray2[n11];
            }
            n11 = (raster.getMinY() - raster.getSampleModelTranslateY()) * n + (raster.getMinX() - raster.getSampleModelTranslateX()) * n7 + n12;
            mediaLibImage2 = !bl2 && n6 != 0 ? new mediaLibImage(n3, n7, raster.getWidth(), raster.getHeight(), n, n11, n6, object) : new mediaLibImage(n3, n7, raster.getWidth(), raster.getHeight(), n, n11, object);
        }
        return mediaLibImage2;
    }
}

