/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.jpeg2000;

import com.sun.media.imageioimpl.plugins.jpeg2000.BitsPerComponentBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.Box;
import com.sun.media.imageioimpl.plugins.jpeg2000.ChannelDefinitionBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ColorSpecificationBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ComponentMappingBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.FileTypeBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.HeaderBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.I18N;
import com.sun.media.imageioimpl.plugins.jpeg2000.IISRandomAccessIO;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageReader;
import com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadataFormat;
import com.sun.media.imageioimpl.plugins.jpeg2000.PaletteBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.ResolutionBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.SignatureBox;
import com.sun.media.imageioimpl.plugins.jpeg2000.XMLBox;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import jj2000.j2k.fileformat.reader.FileFormatReader;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class J2KMetadata
extends IIOMetadata
implements Cloneable {
    static final String nativeMetadataFormatName = "com_sun_media_imageio_plugins_jpeg2000_image_1.0";
    private J2KMetadataFormat format;
    private ArrayList boxes = new ArrayList();

    public J2KMetadata() {
        super(true, nativeMetadataFormatName, "com.sun.media.imageioimpl.plugins.jpeg2000.J2KMetadataFormat", null, null);
        this.format = (J2KMetadataFormat)this.getMetadataFormat(nativeMetadataFormatName);
    }

    public J2KMetadata(ImageInputStream imageInputStream, J2KImageReader j2KImageReader) throws IOException {
        this();
        IISRandomAccessIO iISRandomAccessIO = new IISRandomAccessIO(imageInputStream);
        imageInputStream.mark();
        FileFormatReader fileFormatReader = new FileFormatReader(iISRandomAccessIO, this);
        fileFormatReader.readFileFormat();
        imageInputStream.reset();
    }

    public J2KMetadata(ImageWriteParam imageWriteParam, ImageWriter imageWriter) {
        this(null, imageWriteParam, imageWriter);
    }

    public J2KMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam, ImageWriter imageWriter) {
        this(imageTypeSpecifier != null ? imageTypeSpecifier.getColorModel() : null, imageTypeSpecifier != null ? imageTypeSpecifier.getSampleModel() : null, 0, 0, imageWriteParam, imageWriter);
    }

    public J2KMetadata(ColorModel colorModel, SampleModel sampleModel, int n, int n2, ImageWriteParam imageWriteParam, ImageWriter imageWriter) {
        this();
        int n3;
        int n4;
        this.addNode(new SignatureBox());
        this.addNode(new FileTypeBox(1785737760, 0, new int[]{1785737760}));
        ImageTypeSpecifier imageTypeSpecifier = null;
        if (imageWriteParam != null) {
            imageTypeSpecifier = imageWriteParam.getDestinationType();
            if (colorModel == null && sampleModel == null) {
                colorModel = imageTypeSpecifier == null ? null : imageTypeSpecifier.getColorModel();
                sampleModel = imageTypeSpecifier == null ? null : imageTypeSpecifier.getSampleModel();
            }
        }
        int[] nArray = null;
        if (colorModel != null) {
            nArray = colorModel.getComponentSize();
        } else if (sampleModel != null) {
            nArray = sampleModel.getSampleSize();
        }
        int n5 = 255;
        if (nArray != null) {
            n5 = nArray[0];
            n4 = nArray.length;
            for (n3 = 1; n3 < n4; ++n3) {
                if (nArray[n3] <= n5) continue;
                n5 = nArray[n3];
            }
        }
        if (colorModel != null) {
            ColorSpace colorSpace = colorModel.getColorSpace();
            n3 = colorSpace instanceof ICC_ColorSpace;
            int n6 = colorSpace.getType();
            if (n6 == 5) {
                this.addNode(new ColorSpecificationBox(1, 0, 0, 16, null));
            } else if (n6 == 6) {
                this.addNode(new ColorSpecificationBox(1, 0, 0, 17, null));
            } else if (colorSpace instanceof ICC_ColorSpace) {
                this.addNode(new ColorSpecificationBox(2, 0, 0, 0, ((ICC_ColorSpace)colorSpace).getProfile()));
            }
            if (colorModel.hasAlpha()) {
                this.addNode(new ChannelDefinitionBox(colorModel));
            }
            if (colorModel instanceof IndexColorModel) {
                this.addNode(new PaletteBox((IndexColorModel)colorModel));
                int n7 = colorModel.getComponentSize().length;
                short[] sArray = new short[n7];
                byte[] byArray = new byte[n7];
                byte[] byArray2 = new byte[n7];
                for (int i = 0; i < n7; ++i) {
                    sArray[i] = 0;
                    byArray[i] = 1;
                    byArray2[i] = (byte)i;
                }
                this.addNode(new ComponentMappingBox(sArray, byArray, byArray2));
            }
        }
        if (sampleModel != null) {
            if (n <= 0) {
                n = sampleModel.getWidth();
            }
            if (n2 <= 0) {
                n2 = sampleModel.getHeight();
            }
            n4 = n5 == 255 ? 255 : n5 - 1 | (this.isOriginalSigned(sampleModel) ? 128 : 0);
            this.addNode(new HeaderBox(n2, n, sampleModel.getNumBands(), n4, 7, colorModel == null ? 1 : 0, this.getElement("JPEG2000IntellectualPropertyRightsBox") == null ? 0 : 1));
        }
    }

    public Object clone() {
        J2KMetadata j2KMetadata = null;
        try {
            j2KMetadata = (J2KMetadata)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.boxes != null) {
            int n = this.boxes.size();
            for (int i = 0; i < n; ++i) {
                j2KMetadata.addNode((Box)this.boxes.get(i));
            }
        }
        return j2KMetadata;
    }

    public Node getAsTree(String string) {
        if (string == null) {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata0"));
        }
        if (string.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (string.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException(I18N.getString("J2KMetadata1") + " " + string);
    }

    IIOMetadataNode getNativeTree() {
        Box box;
        int n;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode(nativeMetadataFormatName);
        Box box2 = null;
        Box box3 = null;
        Box box4 = null;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = this.boxes.size();
        int n6 = 0;
        for (n = 0; n < n5 && n6 < 3; ++n) {
            box = (Box)this.boxes.get(n);
            if (Box.getName(box.getType()).equals("JPEG2000SignatureBox")) {
                box2 = box;
                n2 = n;
                ++n6;
                continue;
            }
            if (Box.getName(box.getType()).equals("JPEG2000FileTypeBox")) {
                box3 = box;
                n3 = n;
                ++n6;
                continue;
            }
            if (!Box.getName(box.getType()).equals("JPEG2000HeaderBox")) continue;
            box4 = box;
            n4 = n;
            ++n6;
        }
        if (box2 != null) {
            this.insertNodeIntoTree(iIOMetadataNode, box2.getNativeNode());
        }
        if (box3 != null) {
            this.insertNodeIntoTree(iIOMetadataNode, box3.getNativeNode());
        }
        if (box4 != null) {
            this.insertNodeIntoTree(iIOMetadataNode, box4.getNativeNode());
        }
        for (n = 0; n < n5; ++n) {
            if (n == n2 || n == n3 || n == n4) continue;
            box = (Box)this.boxes.get(n);
            IIOMetadataNode iIOMetadataNode2 = box.getNativeNode();
            this.insertNodeIntoTree(iIOMetadataNode, iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardChromaNode() {
        HeaderBox headerBox = (HeaderBox)this.getElement("JPEG2000HeaderBox");
        PaletteBox paletteBox = (PaletteBox)this.getElement("JPEG2000PaletteBox");
        ColorSpecificationBox colorSpecificationBox = (ColorSpecificationBox)this.getElement("JPEG2000ColorSpecificationBox");
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IIOMetadataNode iIOMetadataNode2 = null;
        if (headerBox != null) {
            if (headerBox.getUnknownColorspace() == 0 && colorSpecificationBox != null && colorSpecificationBox.getMethod() == 1) {
                iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
                int n = colorSpecificationBox.getEnumeratedColorSpace();
                if (n == 16) {
                    iIOMetadataNode2.setAttribute("name", "RGB");
                }
                if (n == 17) {
                    iIOMetadataNode2.setAttribute("name", "GRAY");
                }
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
            iIOMetadataNode2 = new IIOMetadataNode("NumChannels");
            iIOMetadataNode2.setAttribute("value", "" + headerBox.getNumComponents());
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            if (paletteBox != null) {
                iIOMetadataNode2.setAttribute("value", "" + paletteBox.getNumComp());
                iIOMetadataNode2 = new IIOMetadataNode("Palette");
                byte[][] byArray = paletteBox.getLUT();
                int n = byArray[0].length;
                int n2 = byArray.length;
                for (int i = 0; i < n; ++i) {
                    IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("PaletteEntry");
                    iIOMetadataNode3.setAttribute("index", "" + i);
                    iIOMetadataNode3.setAttribute("red", "" + (byArray[0][i] & 0xFF));
                    iIOMetadataNode3.setAttribute("green", "" + (byArray[1][i] & 0xFF));
                    iIOMetadataNode3.setAttribute("blue", "" + (byArray[2][i] & 0xFF));
                    if (n2 == 4) {
                        iIOMetadataNode3.setAttribute("alpha", "" + (byArray[3][i] & 0xFF));
                    }
                    iIOMetadataNode2.appendChild(iIOMetadataNode3);
                }
                iIOMetadataNode.appendChild(iIOMetadataNode2);
            }
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Compression");
        IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("CompressionTypeName");
        iIOMetadataNode2.setAttribute("value", "JPEG2000");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardDataNode() {
        Object object;
        Object object2;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Data");
        PaletteBox paletteBox = (PaletteBox)this.getElement("JPEG2000PaletteBox");
        boolean bl = false;
        if (paletteBox != null) {
            object2 = new IIOMetadataNode("SampleFormat");
            ((IIOMetadataNode)object2).setAttribute("value", "Index");
            iIOMetadataNode.appendChild((Node)object2);
            bl = true;
        }
        object2 = (BitsPerComponentBox)this.getElement("JPEG2000BitsPerComponentBox");
        String string = "";
        boolean bl2 = false;
        boolean bl3 = false;
        if (object2 != null) {
            object = ((BitsPerComponentBox)object2).getBitDepth();
            if ((object[0] & 0x80) == 128) {
                bl2 = true;
            }
            int n = ((Object)object).length;
            for (int i = 0; i < n; ++i) {
                string = string + ((object[i] & 0x7F) + 1);
                if (i == n - 1) continue;
                string = string + " ";
            }
            bl3 = true;
        } else {
            object = (HeaderBox)this.getElement("JPEG2000HeaderBox");
            if (object != null) {
                int n = object.getBitDepth();
                if ((n & 0x80) == 128) {
                    bl2 = true;
                }
                n = (n & 0x7F) + 1;
                int n2 = object.getNumComponents();
                for (int i = 0; i < n2; ++i) {
                    string = string + n;
                    if (i == n2 - 1) continue;
                    string = string + " ";
                }
                bl3 = true;
            }
        }
        object = null;
        if (bl3) {
            object = new IIOMetadataNode("BitsPerSample");
            object.setAttribute("value", string);
            iIOMetadataNode.appendChild((Node)object);
        }
        object = new IIOMetadataNode("PlanarConfiguration");
        object.setAttribute("value", "TileInterleaved");
        iIOMetadataNode.appendChild((Node)object);
        if (!bl && bl3) {
            object = new IIOMetadataNode("SampleFormat");
            object.setAttribute("value", bl2 ? "SignedIntegral" : "UnsignedIntegral");
            iIOMetadataNode.appendChild((Node)object);
        }
        return iIOMetadataNode;
    }

    protected IIOMetadataNode getStandardDimensionNode() {
        ResolutionBox resolutionBox = (ResolutionBox)this.getElement("JPEG2000CaptureResolutionBox");
        if (resolutionBox != null) {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
            float f = resolutionBox.getHorizontalResolution();
            float f2 = resolutionBox.getVerticalResolution();
            float f3 = f2 / f;
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("PixelAspectRatio");
            iIOMetadataNode2.setAttribute("value", "" + f3);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2 = new IIOMetadataNode("HorizontalPixelSize");
            iIOMetadataNode2.setAttribute("value", "" + 1000.0f / f);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2 = new IIOMetadataNode("VerticalPixelSize");
            iIOMetadataNode2.setAttribute("value", "" + 1000.0f / f2);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            return iIOMetadataNode;
        }
        return null;
    }

    protected IIOMetadataNode getStandardTransparencyNode() {
        ChannelDefinitionBox channelDefinitionBox = (ChannelDefinitionBox)this.getElement("JPEG2000ChannelDefinitionBox");
        if (channelDefinitionBox != null) {
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Transparency");
            boolean bl = false;
            boolean bl2 = false;
            short[] sArray = channelDefinitionBox.getTypes();
            for (int i = 0; i < sArray.length; ++i) {
                if (sArray[i] == 1) {
                    bl = true;
                }
                if (sArray[i] != 2) continue;
                bl2 = true;
            }
            String string = "none";
            if (bl2) {
                string = "premultiplied";
            } else if (bl) {
                string = "nonpremultiplied";
            }
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Alpha");
            iIOMetadataNode2.setAttribute("value", string);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            return iIOMetadataNode;
        }
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Transparency");
        IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("Alpha");
        iIOMetadataNode3.setAttribute("value", "none");
        iIOMetadataNode.appendChild(iIOMetadataNode3);
        return null;
    }

    protected IIOMetadataNode getStandardTextNode() {
        if (this.boxes == null) {
            return null;
        }
        IIOMetadataNode iIOMetadataNode = null;
        Iterator iterator = this.boxes.iterator();
        while (iterator.hasNext()) {
            Box box = (Box)iterator.next();
            if (!(box instanceof XMLBox)) continue;
            if (iIOMetadataNode == null) {
                iIOMetadataNode = new IIOMetadataNode("Text");
            }
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
            String string = new String(box.getContent());
            iIOMetadataNode2.setAttribute("value", string);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void mergeTree(String string, Node node) throws IIOInvalidTreeException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata0"));
        }
        if (node == null) {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata2"));
        }
        if (string.equals(nativeMetadataFormatName) && node.getNodeName().equals(nativeMetadataFormatName)) {
            this.mergeNativeTree(node);
        } else if (string.equals("javax_imageio_1.0")) {
            this.mergeStandardTree(node);
        } else {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata1") + " " + string);
        }
    }

    public void setFromTree(String string, Node node) throws IIOInvalidTreeException {
        if (string == null) {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata0"));
        }
        if (node == null) {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata2"));
        }
        if (string.equals(nativeMetadataFormatName) && node.getNodeName().equals(nativeMetadataFormatName)) {
            this.boxes = new ArrayList();
            this.mergeNativeTree(node);
        } else if (string.equals("javax_imageio_1.0")) {
            this.boxes = new ArrayList();
            this.mergeStandardTree(node);
        } else {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata1") + " " + string);
        }
    }

    public void reset() {
        this.boxes.clear();
    }

    public void addNode(Box box) {
        if (this.boxes == null) {
            this.boxes = new ArrayList();
        }
        this.replace(Box.getName(box.getType()), box);
    }

    public Box getElement(String string) {
        for (int i = this.boxes.size() - 1; i >= 0; --i) {
            Box box = (Box)this.boxes.get(i);
            if (!string.equals(Box.getName(box.getType()))) continue;
            return box;
        }
        return null;
    }

    private void mergeNativeTree(Node node) throws IIOInvalidTreeException {
        NodeList nodeList = node.getChildNodes();
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (this.format.getParent(string) == null) continue;
            if (this.format.isLeaf(string)) {
                String string2 = (String)Box.getAttribute(node2, "Type");
                Box box = Box.createBox(Box.getTypeInt(string2), node2);
                if (this.format.singleInstance(string) && this.getElement(string) != null) {
                    this.replace(string, box);
                    continue;
                }
                this.boxes.add(box);
                continue;
            }
            this.mergeNativeTree(node2);
        }
    }

    private void mergeStandardTree(Node node) throws IIOInvalidTreeException {
        NodeList nodeList = node.getChildNodes();
        int n = 0;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals("Chroma")) {
                NodeList nodeList2 = node2.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node3 = nodeList2.item(j);
                    String string2 = node3.getNodeName();
                    if (string2.equals("NumChannels")) {
                        String string3 = (String)Box.getAttribute(node3, "value");
                        n = new Integer(string3);
                    }
                    if (string2.equals("ColorSpaceType")) {
                        this.createColorSpecificationBoxFromStandardNode(node3);
                    }
                    if (!string2.equals("Palette")) continue;
                    this.createPaletteBoxFromStandardNode(node3);
                }
                continue;
            }
            if (string.equals("Compression")) continue;
            if (string.equals("Data")) {
                this.createBitsPerComponentBoxFromStandardNode(node2);
                this.createHeaderBoxFromStandardNode(node2, n);
                continue;
            }
            if (string.equals("Dimension")) {
                this.createResolutionBoxFromStandardNode(node2);
                continue;
            }
            if (string.equals("Document")) {
                this.createXMLBoxFromStandardNode(node2);
                continue;
            }
            if (string.equals("Text")) {
                this.createXMLBoxFromStandardNode(node2);
                continue;
            }
            if (string.equals("Transparency")) {
                this.createChannelDefinitionFromStandardNode(node2);
                continue;
            }
            throw new IIOInvalidTreeException(I18N.getString("J2KMetadata3") + " " + string, node2);
        }
    }

    private void createColorSpecificationBoxFromStandardNode(Node node) {
        int n;
        if (node.getNodeName() != "ColorSpaceType") {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata4"));
        }
        String string = (String)Box.getAttribute(node, "name");
        int n2 = string.equals("RGB") ? 16 : (n = string.equals("Gray") ? 17 : 0);
        if (n == 16 || n == 17) {
            this.replace("JPEG2000ColorSpecificationBox", new ColorSpecificationBox(1, 0, 0, n, null));
        }
    }

    private void createPaletteBoxFromStandardNode(Node node) {
        Object object;
        int n;
        if (node.getNodeName() != "Palette") {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata5"));
        }
        NodeList nodeList = node.getChildNodes();
        int n2 = -1;
        boolean bl = false;
        for (n = 0; n < nodeList.getLength(); ++n) {
            Node node2 = nodeList.item(n);
            String string = node2.getNodeName();
            if (!string.equals("PaletteEntry")) continue;
            object = (String)Box.getAttribute(node2, "index");
            int n3 = new Integer((String)object);
            if (n3 > n2) {
                n2 = n3;
            }
            if (Box.getAttribute(node2, "alpha") == null) continue;
            bl = true;
        }
        n = 32;
        for (int i = Integer.MIN_VALUE; i != 0 && (n2 & i) == 0; i >>>= 1) {
            --n;
        }
        int n4 = 1 << n;
        object = new byte[n4];
        byte[] byArray = new byte[n4];
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = bl ? new byte[n4] : null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node3 = nodeList.item(i);
            String string = node3.getNodeName();
            if (!string.equals("PaletteEntry")) continue;
            String string2 = (String)Box.getAttribute(node3, "index");
            int n5 = new Integer(string2);
            string2 = (String)Box.getAttribute(node3, "red");
            object[n5] = (byte)new Integer(string2).intValue();
            string2 = (String)Box.getAttribute(node3, "green");
            byArray[n5] = (byte)new Integer(string2).intValue();
            string2 = (String)Box.getAttribute(node3, "blue");
            byArray2[n5] = (byte)new Integer(string2).intValue();
            int n6 = -1;
            string2 = (String)Box.getAttribute(node3, "alpha");
            if (string2 != null) {
                n6 = (byte)new Integer(string2).intValue();
            }
            if (byArray3 == null) continue;
            byArray3[n5] = n6;
        }
        IndexColorModel indexColorModel = byArray3 == null ? new IndexColorModel(n, n4, (byte[])object, byArray, byArray2) : new IndexColorModel(n, n4, (byte[])object, byArray, byArray2, byArray3);
        this.replace("JPEG2000PaletteBox", new PaletteBox(indexColorModel));
    }

    private void createBitsPerComponentBoxFromStandardNode(Node node) {
        int n;
        if (node.getNodeName() != "Data") {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata6"));
        }
        NodeList nodeList = node.getChildNodes();
        byte[] byArray = null;
        boolean bl = false;
        for (n = 0; n < nodeList.getLength(); ++n) {
            String string;
            Node node2 = nodeList.item(n);
            String string2 = node2.getNodeName();
            if (string2.equals("BitsPerSample")) {
                string = (String)Box.getAttribute(node2, "value");
                byArray = (byte[])Box.parseByteArray(string).clone();
                continue;
            }
            if (!string2.equals("SampleFormat")) continue;
            string = (String)Box.getAttribute(node2, "value");
            bl = string.equals("SignedIntegral");
        }
        if (byArray != null) {
            for (n = 0; n < byArray.length; ++n) {
                byArray[n] = (byte)((byArray[n] & 0xFF) - 1);
                if (!bl) continue;
                int n2 = n;
                byArray[n2] = (byte)(byArray[n2] | 0x80);
            }
            this.replace("JPEG2000BitsPerComponent", new BitsPerComponentBox(byArray));
        }
    }

    private void createResolutionBoxFromStandardNode(Node node) {
        if (node.getNodeName() != "Dimension") {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata7"));
        }
        NodeList nodeList = node.getChildNodes();
        float f = 0.0f;
        float f2 = 0.0f;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node2 = nodeList.item(i);
            String string2 = node2.getNodeName();
            if (string2.equals("HorizontalPixelSize")) {
                string = (String)Box.getAttribute(node2, "value");
                f = new Float(string).floatValue();
                f = 1000.0f / f;
                bl = true;
            }
            if (!string2.equals("VerticalPixelSize")) continue;
            string = (String)Box.getAttribute(node2, "value");
            f2 = new Float(string).floatValue();
            f2 = 1000.0f / f2;
            bl2 = true;
        }
        if (bl && !bl2) {
            f2 = f;
        } else if (bl2 && !bl) {
            f = f2;
        }
        if (bl || bl2) {
            this.replace("JPEG2000CaptureResolutionBox", new ResolutionBox(1919251299, f, f2));
        }
    }

    private void createXMLBoxFromStandardNode(Node node) {
        NodeList nodeList = node.getChildNodes();
        String string = "<" + node.getNodeName() + ">";
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string2 = node2.getNodeName();
            string = string + "<" + string2 + " ";
            NamedNodeMap namedNodeMap = node2.getAttributes();
            for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                Node node3 = namedNodeMap.item(j);
                string = string + node3.getNodeName() + "=\"" + node3.getNodeValue() + "\" ";
            }
            string = string + " />";
        }
        string = string + "</" + node.getNodeName() + ">";
        this.boxes.add(new XMLBox(string.getBytes()));
    }

    private void createHeaderBoxFromStandardNode(Node node, int n) {
        HeaderBox headerBox = (HeaderBox)this.getElement("JPEG2000HeaderBox");
        byte by = (byte)(this.getElement("JPEG2000ColorSpecificationBox") == null ? 1 : 0);
        if (headerBox != null) {
            if (n == 0) {
                // empty if block
            }
            n = headerBox.getNumComponents();
            headerBox = new HeaderBox(headerBox.getHeight(), headerBox.getWidth(), n, headerBox.getBitDepth(), headerBox.getCompressionType(), by, headerBox.getIntellectualProperty());
        } else {
            headerBox = new HeaderBox(0, 0, n, 0, 0, by, 0);
        }
        this.replace("JPEG2000HeaderBox", headerBox);
    }

    private void createChannelDefinitionFromStandardNode(Node node) {
        Object object;
        Object object2;
        Object object3;
        int n;
        if (node.getNodeName() != "Transparency") {
            throw new IllegalArgumentException(I18N.getString("J2KMetadata8"));
        }
        HeaderBox headerBox = (HeaderBox)this.getElement("JPEG2000HeaderBox");
        int n2 = 3;
        if (headerBox != null) {
            n2 = headerBox.getNumComponents();
        }
        NodeList nodeList = node.getChildNodes();
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < nodeList.getLength(); ++n) {
            object3 = nodeList.item(n);
            object2 = object3.getNodeName();
            if (!((String)object2).equals("Alpha")) continue;
            object = (String)Box.getAttribute((Node)object3, "value");
            if (((String)object).equals("premultiplied")) {
                bl2 = true;
            }
            if (!((String)object).equals("nonpremultiplied")) continue;
            bl = true;
        }
        if (!bl) {
            return;
        }
        n = (short)(n2 * (bl2 ? 3 : 2));
        object3 = new short[n];
        object2 = new short[n];
        object = new short[n];
        ChannelDefinitionBox.fillBasedOnBands(n2, bl2, (short[])object3, (short[])object2, (short[])object);
        this.replace("JPEG2000ChannelDefinitionBox", new ChannelDefinitionBox((short[])object3, (short[])object2, (short[])object));
    }

    private void replace(String string, Box box) {
        for (int i = this.boxes.size() - 1; i >= 0; --i) {
            Box box2 = (Box)this.boxes.get(i);
            if (!string.equals(Box.getName(box2.getType()))) continue;
            this.boxes.set(i, box);
            return;
        }
        this.boxes.add(box);
    }

    private boolean insertNodeIntoTree(IIOMetadataNode iIOMetadataNode, IIOMetadataNode iIOMetadataNode2) {
        String string = iIOMetadataNode2.getNodeName();
        String string2 = this.format.getParent(string);
        if (string2 == null) {
            return false;
        }
        IIOMetadataNode iIOMetadataNode3 = this.getNodeFromTree(iIOMetadataNode, string2, string);
        if (iIOMetadataNode3 == null) {
            iIOMetadataNode3 = this.createNodeIntoTree(iIOMetadataNode, string2);
        }
        iIOMetadataNode3.appendChild(iIOMetadataNode2);
        return true;
    }

    private IIOMetadataNode getNodeFromTree(IIOMetadataNode iIOMetadataNode, String string, String string2) {
        if (string.equals(iIOMetadataNode.getNodeName())) {
            return iIOMetadataNode;
        }
        NodeList nodeList = iIOMetadataNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            IIOMetadataNode iIOMetadataNode2 = (IIOMetadataNode)nodeList.item(i);
            if (iIOMetadataNode2.getNodeName().equals(string)) {
                if (string.equals("JPEG2000UUIDInfoBox") && this.checkUUIDInfoBox(iIOMetadataNode2, string2)) continue;
                return iIOMetadataNode2;
            }
            if ((iIOMetadataNode2 = this.getNodeFromTree(iIOMetadataNode2, string, string2)) == null) continue;
            return iIOMetadataNode2;
        }
        return null;
    }

    private IIOMetadataNode createNodeIntoTree(IIOMetadataNode iIOMetadataNode, String string) {
        IIOMetadataNode iIOMetadataNode2 = this.getNodeFromTree(iIOMetadataNode, string, null);
        if (iIOMetadataNode2 != null) {
            return iIOMetadataNode2;
        }
        iIOMetadataNode2 = new IIOMetadataNode(string);
        String string2 = this.format.getParent(string);
        IIOMetadataNode iIOMetadataNode3 = this.createNodeIntoTree(iIOMetadataNode, string2);
        iIOMetadataNode3.appendChild(iIOMetadataNode2);
        return iIOMetadataNode2;
    }

    private boolean isOriginalSigned(SampleModel sampleModel) {
        int n = sampleModel.getDataType();
        return n != 0 && n != 1;
    }

    private boolean checkUUIDInfoBox(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)nodeList.item(i);
            String string2 = iIOMetadataNode.getNodeName();
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }
}

