/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.raw;

import com.sun.media.imageio.stream.RawImageInputStream;
import com.sun.media.imageioimpl.plugins.raw.I18N;
import com.sun.media.imageioimpl.plugins.raw.RawRenderedImage;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;

public class RawImageReader
extends ImageReader {
    private RawImageInputStream iis = null;

    public static void computeRegionsWrapper(ImageReadParam imageReadParam, int n, int n2, BufferedImage bufferedImage, Rectangle rectangle, Rectangle rectangle2) {
        RawImageReader.computeRegions(imageReadParam, n, n2, bufferedImage, rectangle, rectangle2);
    }

    public RawImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    public void setInput(Object object, boolean bl, boolean bl2) {
        super.setInput(object, bl, bl2);
        this.iis = (RawImageInputStream)object;
    }

    public int getNumImages(boolean bl) throws IOException {
        return this.iis.getNumImages();
    }

    public int getWidth(int n) throws IOException {
        this.checkIndex(n);
        return this.iis.getImageDimension((int)n).width;
    }

    public int getHeight(int n) throws IOException {
        this.checkIndex(n);
        return this.iis.getImageDimension((int)n).height;
    }

    public int getTileWidth(int n) throws IOException {
        this.checkIndex(n);
        return this.iis.getImageType().getSampleModel().getWidth();
    }

    public int getTileHeight(int n) throws IOException {
        this.checkIndex(n);
        return this.iis.getImageType().getSampleModel().getHeight();
    }

    private void checkIndex(int n) throws IOException {
        if (n < 0 || n >= this.getNumImages(true)) {
            throw new IndexOutOfBoundsException(I18N.getString("RawImageReader0"));
        }
    }

    public Iterator getImageTypes(int n) throws IOException {
        this.checkIndex(n);
        ArrayList<ImageTypeSpecifier> arrayList = new ArrayList<ImageTypeSpecifier>(1);
        arrayList.add(this.iis.getImageType());
        return arrayList.iterator();
    }

    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam();
    }

    public IIOMetadata getImageMetadata(int n) throws IOException {
        return null;
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    public boolean isRandomAccessEasy(int n) throws IOException {
        this.checkIndex(n);
        return true;
    }

    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        WritableRaster writableRaster;
        if (imageReadParam == null) {
            imageReadParam = this.getDefaultReadParam();
        }
        this.checkIndex(n);
        this.clearAbortRequest();
        this.processImageStarted(n);
        BufferedImage bufferedImage = imageReadParam.getDestination();
        RawRenderedImage rawRenderedImage = new RawRenderedImage(this.iis, this, imageReadParam, n);
        Point point = imageReadParam.getDestinationOffset();
        if (bufferedImage == null) {
            ColorModel colorModel = rawRenderedImage.getColorModel();
            SampleModel sampleModel = rawRenderedImage.getSampleModel();
            ImageTypeSpecifier imageTypeSpecifier = imageReadParam.getDestinationType();
            if (imageTypeSpecifier != null) {
                colorModel = imageTypeSpecifier.getColorModel();
            }
            writableRaster = Raster.createWritableRaster(sampleModel.createCompatibleSampleModel(rawRenderedImage.getMinX() + rawRenderedImage.getWidth(), rawRenderedImage.getMinY() + rawRenderedImage.getHeight()), new Point(0, 0));
            bufferedImage = new BufferedImage(colorModel, writableRaster, colorModel != null ? colorModel.isAlphaPremultiplied() : false, new Hashtable());
        } else {
            writableRaster = bufferedImage.getWritableTile(0, 0);
        }
        rawRenderedImage.setDestImage(bufferedImage);
        rawRenderedImage.readAsRaster(writableRaster);
        rawRenderedImage.clearDestImage();
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return bufferedImage;
    }

    public RenderedImage readAsRenderedImage(int n, ImageReadParam imageReadParam) throws IOException {
        if (imageReadParam == null) {
            imageReadParam = this.getDefaultReadParam();
        }
        this.checkIndex(n);
        this.clearAbortRequest();
        this.processImageStarted(0);
        RawRenderedImage rawRenderedImage = new RawRenderedImage(this.iis, this, imageReadParam, n);
        if (this.abortRequested()) {
            this.processReadAborted();
        } else {
            this.processImageComplete();
        }
        return rawRenderedImage;
    }

    public Raster readRaster(int n, ImageReadParam imageReadParam) throws IOException {
        BufferedImage bufferedImage = this.read(n, imageReadParam);
        return bufferedImage.getData();
    }

    public boolean canReadRaster() {
        return true;
    }

    public void reset() {
        super.reset();
        this.iis = null;
    }

    public void processImageUpdateWrapper(BufferedImage bufferedImage, int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        this.processImageUpdate(bufferedImage, n, n2, n3, n4, n5, n6, nArray);
    }

    public void processImageProgressWrapper(float f) {
        this.processImageProgress(f);
    }

    public boolean getAbortRequest() {
        return this.abortRequested();
    }
}

