/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.imageioimpl.plugins.tiff;

import com.sun.media.imageioimpl.plugins.tiff.TIFFFaxCompressor;
import com.sun.media.imageioimpl.plugins.tiff.TIFFFaxDecompressor;
import java.io.IOException;
import javax.imageio.IIOException;

public class TIFFRLECompressor
extends TIFFFaxCompressor {
    public TIFFRLECompressor() {
        super("CCITT RLE", 2, true);
    }

    public int encodeRLE(byte[] byArray, int n, int n2, int n3, byte[] byArray2) {
        this.initBitBuf();
        int n4 = this.encode1D(byArray, n, n2, n3, byArray2, 0);
        while (this.ndex > 0) {
            byArray2[n4++] = (byte)(this.bits >>> 24);
            this.bits <<= 8;
            this.ndex -= 8;
        }
        if (this.inverseFill) {
            byte[] byArray3 = TIFFFaxDecompressor.flipTable;
            for (int i = 0; i < n4; ++i) {
                byArray2[i] = byArray3[byArray2[i] & 0xFF];
            }
        }
        return n4;
    }

    public int encode(byte[] byArray, int n, int n2, int n3, int[] nArray, int n4) throws IOException {
        if (nArray.length != 1 || nArray[0] != 1) {
            throw new IIOException("Bits per sample must be 1 for RLE compression!");
        }
        int n5 = 9 * ((n2 + 1) / 2) + 2;
        byte[] byArray2 = new byte[(n5 + 7) / 8];
        int n6 = 0;
        int n7 = n;
        for (int i = 0; i < n3; ++i) {
            int n8 = this.encodeRLE(byArray, n7, 0, n2, byArray2);
            this.stream.write(byArray2, 0, n8);
            n7 += n4;
            n6 += n8;
        }
        return n6;
    }
}

