/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import loci.common.DataTools;
import loci.common.Location;
import loci.common.RandomAccessStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.ByteVector;
import loci.formats.meta.FilterMetadata;

public class ICSReader
extends FormatReader {
    private static final String[] CATEGORIES = new String[]{"ics_version", "filename", "source", "layout", "representation", "parameter", "sensor", "history", "document", "view", "end"};
    private static final String[] SUB_CATEGORIES = new String[]{"file", "offset", "parameters", "order", "sizes", "coordinates", "significant_bits", "format", "sign", "compression", "byte_order", "origin", "scale", "units", "labels", "SCIL_TYPE", "type", "model", "s_params", "laser", "gain*", "dwell", "shutter*", "pinhole", "laser*", "version", "objective", "PassCount", "step*", "view", "view*", "date", "GMTdate", "label", "software", "author", "length", "Z (background)", "dimensions", "rep period", "image form", "extents", "offsets", "region", "expon. order", "a*", "tau*", "noiseval", "excitationfwhm", "created on", "text", "other text", "mode", "CFD limit low", "CFD limit high", "CFD zc level", "CFD holdoff", "SYNC zc level", "SYNC freq div", "SYNC holdoff", "TAC range", "TAC gain", "TAC offset", "TAC limit low", "ADC resolution", "Ext latch delay", "collection time", "repeat time", "stop on time", "stop on O'flow", "dither range", "count increment", "memory bank", "sync threshold", "dead time comp", "polarity", "line compressio", "scan flyback", "scan borders", "pixel time", "pixel clock", "trigger", "scan pixels x", "scan pixels y", "routing chan x", "routing chan y", "detector type", "channel*", "filter*", "wavelength*", "black level*", "gain*", "ht*", "scan resolution", "scan speed", "scan zoom", "scan pattern", "scan pos x", "scan pos y", "transmission", "x amplitude", "y amplitude", "x offset", "y offset", "x delay", "y delay", "beam zoom", "mirror *", "direct turret", "desc exc turret", "desc emm turret", "cube", "stage_xyzum", "cube descriptio", "camera", "exposure", "bits/pixel", "black level", "binning", "left", "top", "cols", "rows", "gain", "significant_channels", "allowedlinemodes", "real_significant_bits", "sample_width", "range", "ch", "lower_limit", "higher_limit", "passcount", "detector", "dateGMT", "RefrInxMedium", "RefrInxLensMedium"};
    private static final String[] SUB_SUB_CATEGORIES = new String[]{"Channels", "PinholeRadius", "LambdaEx", "LambdaEm", "ExPhotonCnt", "RefInxMedium", "NumAperture", "RefInxLensMedium", "PinholeSpacing", "power", "wavelength", "name", "Type", "Magnification", "NA", "WorkingDistance", "Immersion", "Pinhole", "Channel *", "Gain *", "Shutter *", "Position", "Size", "Port", "Cursor", "Color", "BlackLevel", "Saturation", "Gamma", "IntZoom", "Live", "Synchronize", "ShowIndex", "AutoResize", "UseUnits", "Zoom", "IgnoreAspect", "ShowCursor", "ShowAll", "Axis", "Order", "Tile", "scale", "DimViewOption"};
    private String currentIcsId;
    private String currentIdsId;
    private Location icsIn;
    private int bitsPerPixel;
    private boolean versionTwo;
    private byte[] data;
    private String em;
    private String ex;
    private long offset;
    private boolean gzip;
    private boolean invertY;
    private String imageName;
    private String date;
    private String magnification;
    private String lastName;
    private String description;
    private String objectiveModel;
    private String immersion;
    private String lensNA;
    private String workingDistance;
    private Hashtable gains;
    private Hashtable wavelengths;
    private Hashtable pinholes;
    private Hashtable channelNames;
    private String[] stagePos;

    public ICSReader() {
        super("Image Cytometry Standard", new String[]{"ics", "ids"});
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        return false;
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        int row;
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        int bpp = this.bitsPerPixel / 8;
        int len = this.getSizeX() * this.getSizeY() * bpp * this.getRGBChannelCount();
        int pixel = bpp * this.getRGBChannelCount();
        int rowLen = w * pixel;
        this.in.seek(this.offset + (long)(no * len));
        if (!this.isRGB() && this.getSizeC() > 4) {
            if (!this.gzip && this.data == null) {
                this.data = new byte[len * this.getSizeC()];
                this.in.read(this.data);
            }
            for (row = y; row < h + y; ++row) {
                for (int col = x; col < w + x; ++col) {
                    System.arraycopy(this.data, bpp * (no + this.getSizeC() * (row * this.getSizeX() + col)), buf, bpp * (row * w + col), bpp);
                }
            }
        } else if (this.gzip) {
            if (x == 0 && this.getSizeX() == w) {
                System.arraycopy(this.data, len * no + y * rowLen, buf, 0, h * rowLen);
            } else {
                for (row = y; row < h + y; ++row) {
                    System.arraycopy(this.data, len * no + row * this.getSizeX() * pixel + x * pixel, buf, row * rowLen, rowLen);
                }
            }
        } else {
            this.readPlane(this.in, x, y, w, h, buf);
        }
        if (this.invertY) {
            byte[] row2 = new byte[rowLen];
            for (int r = 0; r < h / 2; ++r) {
                System.arraycopy(buf, r * rowLen, row2, 0, rowLen);
                System.arraycopy(buf, (h - r - 1) * rowLen, buf, r * rowLen, rowLen);
                System.arraycopy(row2, 0, buf, (h - r - 1) * rowLen, rowLen);
            }
        }
        return buf;
    }

    public String[] getUsedFiles() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.versionTwo) {
            return new String[]{this.currentId};
        }
        return new String[]{this.currentIdsId, this.currentIcsId};
    }

    public void close() throws IOException {
        super.close();
        this.icsIn = null;
        this.currentIcsId = null;
        this.currentIdsId = null;
        this.data = null;
        this.bitsPerPixel = 0;
        this.versionTwo = false;
        this.gzip = false;
        this.invertY = false;
        this.lensNA = null;
        this.immersion = null;
        this.objectiveModel = null;
        this.date = null;
        this.imageName = null;
        this.description = null;
        this.lastName = null;
        this.magnification = null;
        this.workingDistance = null;
        this.channelNames = null;
        this.pinholes = null;
        this.wavelengths = null;
        this.gains = null;
        this.stagePos = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        String test;
        char[] c;
        String ext;
        if (debug) {
            this.debug("ICSReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.status("Finding companion file");
        String icsId = id;
        String idsId = id;
        int dot = id.lastIndexOf(".");
        String string = ext = dot < 0 ? "" : id.substring(dot + 1).toLowerCase();
        if (ext.equals("ics")) {
            c = idsId.toCharArray();
            int n = c.length - 2;
            c[n] = (char)(c[n] + '\u0001');
            idsId = new String(c);
        } else if (ext.equals("ids")) {
            c = icsId.toCharArray();
            int n = c.length - 2;
            c[n] = (char)(c[n] - '\u0001');
            icsId = new String(c);
        }
        if (icsId == null) {
            throw new FormatException("No ICS file found.");
        }
        Location icsFile = new Location(icsId);
        if (!icsFile.exists()) {
            throw new FormatException("ICS file not found.");
        }
        this.status("Checking file version");
        RandomAccessStream f = new RandomAccessStream(icsId);
        if (f.readString(17).trim().equals("ics_version\t2.0")) {
            this.in = new RandomAccessStream(icsId);
            this.versionTwo = true;
        } else {
            if (idsId == null) {
                throw new FormatException("No IDS file found.");
            }
            Location idsFile = new Location(idsId);
            if (!idsFile.exists()) {
                throw new FormatException("IDS file not found.");
            }
            this.currentIdsId = idsId;
            this.in = new RandomAccessStream(idsId);
        }
        f.close();
        this.currentIcsId = icsId;
        this.icsIn = icsFile;
        this.status("Reading metadata");
        String layoutSizes = null;
        String layoutOrder = null;
        String byteOrder = null;
        String rFormat = null;
        String compression = null;
        String scale = null;
        RandomAccessStream reader = new RandomAccessStream(this.icsIn.getAbsolutePath());
        reader.seek(0L);
        String line = reader.readLine();
        line = reader.readLine();
        boolean signed = false;
        StringBuffer textBlock = new StringBuffer();
        String[] sizes = null;
        String[] labels = null;
        String[] lengths = null;
        while (line != null && !line.trim().equals("end")) {
            String[] tokens = null;
            tokens = line.indexOf("\t") != -1 ? line.split("\t") : line.split(" ");
            StringBuffer key = new StringBuffer();
            for (int q = 0; q < tokens.length; ++q) {
                int i2;
                tokens[q] = tokens[q].trim();
                if (tokens[q].length() == 0) continue;
                boolean foundValue = true;
                for (i2 = 0; i2 < CATEGORIES.length; ++i2) {
                    if (!this.matches(CATEGORIES[i2], tokens[q])) continue;
                    foundValue = false;
                    break;
                }
                if (foundValue) {
                    for (i2 = 0; i2 < SUB_CATEGORIES.length; ++i2) {
                        if (!this.matches(SUB_CATEGORIES[i2], tokens[q])) continue;
                        foundValue = false;
                        break;
                    }
                }
                if (foundValue) {
                    for (i2 = 0; i2 < SUB_SUB_CATEGORIES.length; ++i2) {
                        if (!this.matches(SUB_SUB_CATEGORIES[i2], tokens[q])) continue;
                        foundValue = false;
                        break;
                    }
                }
                if (foundValue) {
                    int n;
                    StringBuffer value = new StringBuffer();
                    value.append(tokens[q++]);
                    while (q < tokens.length) {
                        value.append(" ");
                        value.append(tokens[q].trim());
                        ++q;
                    }
                    String k = key.toString().trim();
                    String v = value.toString().trim();
                    this.addMeta(k, v);
                    k = k.replaceAll("\t", " ");
                    if (k.equalsIgnoreCase("layout sizes")) {
                        layoutSizes = v;
                        continue;
                    }
                    if (k.equalsIgnoreCase("layout order")) {
                        layoutOrder = v;
                        continue;
                    }
                    if (k.equalsIgnoreCase("representation byte_order")) {
                        byteOrder = v;
                        continue;
                    }
                    if (k.equalsIgnoreCase("representation format")) {
                        rFormat = v;
                        continue;
                    }
                    if (k.equalsIgnoreCase("representation compression")) {
                        compression = v;
                        continue;
                    }
                    if (k.equalsIgnoreCase("parameter scale")) {
                        scale = v;
                        continue;
                    }
                    if (k.equalsIgnoreCase("representation sign")) {
                        signed = v.equals("signed");
                        continue;
                    }
                    if (k.equalsIgnoreCase("sensor s_params LambdaEm")) {
                        this.em = v;
                        continue;
                    }
                    if (k.equalsIgnoreCase("sensor s_params LambdaEx")) {
                        this.ex = v;
                        continue;
                    }
                    if (k.equalsIgnoreCase("history software") && v.indexOf("SVI") != -1) {
                        this.invertY = true;
                        continue;
                    }
                    if (k.equalsIgnoreCase("history") || k.equalsIgnoreCase("history text")) {
                        textBlock.append(v);
                        textBlock.append("\n");
                        this.metadata.remove(k);
                        continue;
                    }
                    if (k.equalsIgnoreCase("filename")) {
                        this.imageName = v;
                        continue;
                    }
                    if (k.equalsIgnoreCase("history date") || k.equalsIgnoreCase("history created on")) {
                        if (v.indexOf(" ") == -1) continue;
                        this.date = v.substring(0, v.lastIndexOf(" "));
                        String[] formats = new String[]{"EEEE, MMMM dd, yyyy HH:mm:ss", "EEE dd MMMM yyyy HH:mm:ss", "EEE MMM dd HH:mm:ss yyyy", "EE dd MMM yyyy HH:mm:ss z"};
                        boolean success = false;
                        for (n = 0; n < formats.length; ++n) {
                            try {
                                this.date = DataTools.formatDate(this.date, formats[n]);
                                success = true;
                                continue;
                            }
                            catch (NullPointerException e) {
                                // empty catch block
                            }
                        }
                        if (success) continue;
                        this.date = null;
                        continue;
                    }
                    if (k.startsWith("history gain")) {
                        int n2 = 0;
                        try {
                            n2 = Integer.parseInt(k.substring(12).trim());
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        if (this.gains == null) {
                            this.gains = new Hashtable();
                        }
                        this.gains.put(new Integer(n2), v);
                        continue;
                    }
                    if (k.startsWith("history laser") && k.endsWith("wavelength")) {
                        int laser = Integer.parseInt(k.substring(13, k.indexOf(" ", 13)));
                        v = v.replaceAll("nm", "").trim();
                        if (this.wavelengths == null) {
                            this.wavelengths = new Hashtable();
                        }
                        this.wavelengths.put(new Integer(laser), v);
                        continue;
                    }
                    if (k.equalsIgnoreCase("history objective type")) {
                        this.objectiveModel = v;
                        continue;
                    }
                    if (k.equalsIgnoreCase("history objective immersion")) {
                        this.immersion = v;
                        continue;
                    }
                    if (k.equalsIgnoreCase("history objective NA")) {
                        this.lensNA = v;
                        continue;
                    }
                    if (k.equalsIgnoreCase("history objective WorkingDistance")) {
                        this.workingDistance = v;
                        continue;
                    }
                    if (k.equalsIgnoreCase("history objective magnification")) {
                        this.magnification = v;
                        continue;
                    }
                    if (k.equalsIgnoreCase("sensor s_params PinholeRadius")) {
                        String[] pins = v.split(" ");
                        int channel = 0;
                        if (this.pinholes == null) {
                            this.pinholes = new Hashtable();
                        }
                        for (n = 0; n < pins.length; ++n) {
                            if (pins[n].trim().equals("")) continue;
                            this.pinholes.put(new Integer(channel++), pins[n]);
                        }
                        continue;
                    }
                    if (k.equalsIgnoreCase("history author")) {
                        this.lastName = v;
                        continue;
                    }
                    if (k.equalsIgnoreCase("history extents")) {
                        sizes = v.split(" ");
                        continue;
                    }
                    if (k.equalsIgnoreCase("history lengths")) {
                        lengths = v.split(" ");
                        continue;
                    }
                    if (k.equalsIgnoreCase("history labels")) {
                        labels = v.split(" ");
                        continue;
                    }
                    if (k.equalsIgnoreCase("history stage_xyzum")) {
                        this.stagePos = v.split(" ");
                        continue;
                    }
                    if (k.equalsIgnoreCase("history other text")) {
                        this.description = v;
                        continue;
                    }
                    if (k.startsWith("history step") && k.endsWith("name")) {
                        Integer n3 = new Integer(k.substring(12, k.indexOf(" ", 12)));
                        if (this.channelNames == null) {
                            this.channelNames = new Hashtable();
                        }
                        this.channelNames.put(n3, v);
                        continue;
                    }
                    if (!k.equalsIgnoreCase("parameter ch")) continue;
                    String[] names = v.split(" ");
                    if (this.channelNames == null) {
                        this.channelNames = new Hashtable();
                    }
                    for (int n4 = 0; n4 < names.length; ++n4) {
                        this.channelNames.put(new Integer(n4), names[n4].trim());
                    }
                    continue;
                }
                key.append(tokens[q]);
                key.append(" ");
            }
            line = reader.readLine();
            if (!line.trim().equals("")) continue;
            line = null;
        }
        reader.close();
        this.addMeta("history text", textBlock.toString());
        this.status("Populating metadata");
        if (this.invertY) {
            signed = false;
        }
        layoutOrder = layoutOrder.trim();
        StringTokenizer t1 = new StringTokenizer(layoutSizes);
        StringTokenizer t2 = new StringTokenizer(layoutOrder);
        this.core[0].rgb = layoutOrder.indexOf("ch") >= 0 && layoutOrder.indexOf("ch") < layoutOrder.indexOf("x");
        this.core[0].dimensionOrder = "XY";
        while (t1.hasMoreTokens() && t2.hasMoreTokens()) {
            String imageToken = t1.nextToken().trim();
            String orderToken = t2.nextToken().trim();
            if (orderToken.equals("bits")) {
                this.bitsPerPixel = Integer.parseInt(imageToken);
                continue;
            }
            if (orderToken.equals("x")) {
                this.core[0].sizeX = Integer.parseInt(imageToken);
                continue;
            }
            if (orderToken.equals("y")) {
                this.core[0].sizeY = Integer.parseInt(imageToken);
                continue;
            }
            if (orderToken.equals("z")) {
                this.core[0].sizeZ = Integer.parseInt(imageToken);
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
                continue;
            }
            if (orderToken.equals("ch")) {
                this.core[0].sizeC = Integer.parseInt(imageToken);
                if (this.getSizeC() > 4) {
                    this.core[0].rgb = false;
                }
                this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
                continue;
            }
            this.core[0].sizeT = Integer.parseInt(imageToken);
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
        }
        if (this.getDimensionOrder().indexOf("Z") == -1) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
        }
        if (this.getDimensionOrder().indexOf("T") == -1) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
        }
        if (this.getDimensionOrder().indexOf("C") == -1) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
        }
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        if (this.getImageCount() == 0) {
            this.core[0].imageCount = 1;
        }
        this.core[0].rgb = this.isRGB() && this.getSizeC() > 1;
        this.core[0].interleaved = this.isRGB();
        this.core[0].imageCount = this.getSizeZ() * this.getSizeT();
        if (!this.isRGB()) {
            this.core[0].imageCount *= this.getSizeC();
        }
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        String endian = byteOrder;
        this.core[0].littleEndian = true;
        if (endian != null) {
            StringTokenizer endianness = new StringTokenizer(endian);
            String firstByte = endianness.nextToken();
            int first = Integer.parseInt(firstByte);
            this.core[0].littleEndian = rFormat.equals("real") ? first == 1 : first != 1;
        }
        boolean bl = this.gzip = (test = compression) == null ? false : test.equals("gzip");
        if (this.versionTwo) {
            String s = this.in.readLine();
            while (!s.trim().equals("end")) {
                s = this.in.readLine();
            }
        }
        this.offset = this.in.getFilePointer();
        if (this.gzip && (this.in.length() - this.in.getFilePointer()) / (long)this.getImageCount() < (long)(this.getSizeX() * this.getSizeY() * this.bitsPerPixel / 8)) {
            this.data = new byte[(int)(this.in.length() - this.in.getFilePointer())];
            this.status("Decompressing pixel data");
            this.in.read(this.data);
            byte[] buf = new byte[8192];
            ByteVector v = new ByteVector();
            try {
                GZIPInputStream decompressor = new GZIPInputStream(new ByteArrayInputStream(this.data));
                int r = decompressor.read(buf, 0, buf.length);
                while (r > 0) {
                    v.add(buf, 0, r);
                    r = decompressor.read(buf, 0, buf.length);
                }
                this.data = v.toByteArray();
            }
            catch (IOException dfe) {
                throw new FormatException("Error uncompressing gzip'ed data", dfe);
            }
        } else {
            this.gzip = false;
        }
        this.status("Populating metadata");
        String fmt = rFormat;
        if (this.bitsPerPixel < 32) {
            boolean bl2 = this.core[0].littleEndian = !this.isLittleEndian();
        }
        if (fmt.equals("real") && this.bitsPerPixel == 32) {
            this.core[0].pixelType = 6;
        } else if (fmt.equals("real") && this.bitsPerPixel == 64) {
            this.core[0].pixelType = 7;
        } else if (fmt.equals("integer")) {
            while (this.bitsPerPixel % 8 != 0) {
                ++this.bitsPerPixel;
            }
            if (this.bitsPerPixel == 24 || this.bitsPerPixel == 48) {
                this.bitsPerPixel /= 3;
            }
            switch (this.bitsPerPixel) {
                case 8: {
                    this.core[0].pixelType = signed ? 0 : 1;
                    break;
                }
                case 16: {
                    this.core[0].pixelType = signed ? 2 : 3;
                    break;
                }
                case 32: {
                    this.core[0].pixelType = signed ? 4 : 5;
                }
            }
        } else {
            throw new RuntimeException("Unknown pixel format: " + fmt);
        }
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this);
        store.setImageName(this.imageName, 0);
        if (this.date != null) {
            store.setImageCreationDate(this.date, 0);
        } else {
            MetadataTools.setDefaultCreationDate(store, id, 0);
        }
        store.setImageDescription(this.description, 0);
        store.setInstrumentID("Instrument:0", 0);
        store.setImageInstrumentRef("Instrument:0", 0);
        String pixelSizes = scale;
        String o = layoutOrder;
        if (pixelSizes != null) {
            StringTokenizer pixelSizeTokens = new StringTokenizer(pixelSizes);
            StringTokenizer axisTokens = new StringTokenizer(o);
            Float pixX = null;
            Float pixY = null;
            Float pixZ = null;
            Float pixT = null;
            Integer pixC = null;
            while (pixelSizeTokens.hasMoreTokens()) {
                String axis = axisTokens.nextToken().trim().toLowerCase();
                String size = pixelSizeTokens.nextToken().trim();
                if (axis.equals("x")) {
                    pixX = new Float(size);
                    continue;
                }
                if (axis.equals("y")) {
                    pixY = new Float(size);
                    continue;
                }
                if (axis.equals("z")) {
                    pixZ = new Float(size);
                    continue;
                }
                if (axis.equals("t")) {
                    pixT = new Float(size);
                    continue;
                }
                if (!axis.equals("ch")) continue;
                pixC = new Integer(new Float(size).intValue());
            }
            store.setDimensionsPhysicalSizeX(pixX, 0, 0);
            store.setDimensionsPhysicalSizeY(pixY, 0, 0);
            store.setDimensionsPhysicalSizeZ(pixZ, 0, 0);
            store.setDimensionsTimeIncrement(pixT, 0, 0);
            if (pixC != null && pixC > 0) {
                store.setDimensionsWaveIncrement(pixC, 0, 0);
            }
        } else if (sizes != null) {
            for (int i3 = 0; i3 < sizes.length; ++i3) {
                float size = Float.parseFloat(sizes[i3].trim());
                if (i3 == 0) {
                    store.setDimensionsPhysicalSizeX(new Float(size /= (float)this.getSizeX()), 0, 0);
                    continue;
                }
                if (i3 != 1) continue;
                store.setDimensionsPhysicalSizeY(new Float(size /= (float)this.getSizeY()), 0, 0);
            }
        }
        if (this.em != null) {
            String[] emTokens = this.em.split(" ");
            int channel = 0;
            for (int i4 = 0; i4 < emTokens.length; ++i4) {
                if (emTokens[i4].trim().equals("")) continue;
                store.setLogicalChannelEmWave(new Integer((int)Float.parseFloat(emTokens[i4])), 0, channel++);
            }
        }
        if (this.ex != null) {
            String[] exTokens = this.ex.split(" ");
            int channel = 0;
            for (int i5 = 0; i5 < exTokens.length; ++i5) {
                if (exTokens[i5].trim().equals("")) continue;
                store.setLogicalChannelExWave(new Integer((int)Float.parseFloat(exTokens[i5])), 0, channel++);
            }
        }
        for (i = 0; i < this.getSizeC(); ++i) {
            Integer channel = new Integer(i);
            if (this.channelNames != null) {
                String name = (String)this.channelNames.get(channel);
                store.setLogicalChannelName(name, 0, i);
            }
            if (this.pinholes == null) continue;
            String pinhole = (String)this.pinholes.get(channel);
            store.setLogicalChannelPinholeSize(new Float(pinhole), 0, i);
        }
        if (this.wavelengths != null) {
            for (i = 1; i <= this.wavelengths.size(); ++i) {
                String wavelength = (String)this.wavelengths.get(new Integer(i));
                if (wavelength == null) continue;
                store.setLaserWavelength(new Integer(wavelength), 0, i - 1);
            }
        }
        if (this.objectiveModel != null) {
            store.setObjectiveModel(this.objectiveModel, 0, 0);
        }
        if (this.immersion != null) {
            store.setObjectiveImmersion(this.immersion, 0, 0);
        } else {
            store.setObjectiveImmersion("Unknown", 0, 0);
        }
        if (this.lensNA != null) {
            store.setObjectiveLensNA(new Float(this.lensNA), 0, 0);
        }
        if (this.workingDistance != null) {
            store.setObjectiveWorkingDistance(new Float(this.workingDistance), 0, 0);
        }
        if (this.magnification != null) {
            store.setObjectiveCalibratedMagnification(new Float(this.magnification), 0, 0);
        }
        store.setObjectiveCorrection("Unknown", 0, 0);
        store.setObjectiveID("Objective:0", 0, 0);
        store.setObjectiveSettingsObjective("Objective:0", 0);
        if (this.gains != null) {
            for (i = 0; i < this.gains.size(); ++i) {
                if (!this.gains.containsKey(new Integer(i + 1))) continue;
                store.setDetectorSettingsGain(new Float((String)this.gains.get(new Integer(i + 1))), 0, i);
                store.setDetectorType("Unknown", 0, i);
                store.setDetectorID("Detector:" + i, 0, i);
                store.setDetectorSettingsDetector("Detector:0", 0, i);
            }
        }
        store.setExperimenterLastName(this.lastName, 0);
        if (this.stagePos != null) {
            for (i = 0; i < this.getImageCount(); ++i) {
                if (this.stagePos.length > 0) {
                    store.setStagePositionPositionX(new Float(this.stagePos[0]), 0, 0, i);
                }
                if (this.stagePos.length > 1) {
                    store.setStagePositionPositionY(new Float(this.stagePos[1]), 0, 0, i);
                }
                if (this.stagePos.length <= 2) continue;
                store.setStagePositionPositionZ(new Float(this.stagePos[2]), 0, 0, i);
            }
        }
    }

    private boolean matches(String pattern, String text) {
        if (text == null || pattern == null) {
            return false;
        }
        if (text.equalsIgnoreCase(pattern)) {
            return true;
        }
        if (!pattern.endsWith("*")) {
            return false;
        }
        return text.startsWith(pattern.substring(0, pattern.length() - 1));
    }
}

