/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.meta.FilterMetadata;

public class IvisionReader
extends FormatReader {
    private boolean color16;
    private boolean squareRoot;
    private byte[] lut;
    private long imageOffset;

    public IvisionReader() {
        super("IVision", "ipm");
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        return true;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        int planeSize = this.getSizeX() * this.getSizeY() * this.getSizeC();
        planeSize = this.color16 ? 2 * (planeSize / 3) : (this.squareRoot ? (planeSize *= 2) : (planeSize *= FormatTools.getBytesPerPixel(this.getPixelType())));
        this.in.seek(this.imageOffset + (long)(planeSize * no));
        if (this.color16) {
            throw new FormatException("16-bit color iVision files are not supported");
        }
        if (this.squareRoot) {
            throw new FormatException("Square-root iVision files are not supported");
        }
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    public void close() throws IOException {
        super.close();
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("IvisionReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.status("Populating metadata");
        String version = this.in.readString(4);
        int fileFormat = this.in.read();
        int dataType = this.in.read();
        this.core[0].sizeC = 1;
        switch (dataType) {
            case 0: {
                this.core[0].pixelType = 1;
                break;
            }
            case 1: {
                this.core[0].pixelType = 2;
                break;
            }
            case 2: {
                this.core[0].pixelType = 4;
                break;
            }
            case 3: {
                this.core[0].pixelType = 6;
                break;
            }
            case 4: {
                this.core[0].pixelType = 1;
                this.core[0].sizeC = 3;
                this.color16 = true;
                break;
            }
            case 5: {
                this.core[0].pixelType = 1;
                this.core[0].sizeC = 4;
                break;
            }
            case 6: {
                this.core[0].pixelType = 3;
                break;
            }
            case 7: {
                this.core[0].pixelType = 6;
                this.squareRoot = true;
                break;
            }
            case 8: {
                this.core[0].pixelType = 3;
                this.core[0].sizeC = 3;
            }
        }
        this.core[0].sizeX = this.in.readInt();
        this.core[0].sizeY = this.in.readInt();
        this.in.skipBytes(6);
        this.core[0].sizeZ = this.in.readShort();
        this.in.skipBytes(50);
        this.core[0].sizeT = 1;
        if (this.getSizeX() > 1 && this.getSizeY() > 1) {
            this.lut = new byte[2048];
            this.in.read(this.lut);
        }
        this.imageOffset = this.in.getFilePointer();
        this.core[0].rgb = this.getSizeC() > 1;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].littleEndian = false;
        this.core[0].interleaved = true;
        this.core[0].indexed = false;
        this.core[0].imageCount = this.getSizeZ() * this.getSizeT();
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this, true);
    }
}

