/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.RandomAccessStream;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.TiffTools;
import loci.formats.in.BaseTiffReader;
import loci.formats.in.MetamorphHandler;
import loci.formats.meta.FilterMetadata;
import org.xml.sax.helpers.DefaultHandler;

public class MetamorphTiffReader
extends BaseTiffReader {
    public MetamorphTiffReader() {
        super("Metamorph TIFF", new String[]{"tif", "tiff"});
        this.blockCheckLen = 524288;
        this.suffixSufficient = false;
    }

    public boolean isThisType(String name, boolean open) {
        if (!open) {
            return false;
        }
        try {
            RandomAccessStream stream = new RandomAccessStream(name);
            boolean isThisType = this.isThisType(stream);
            stream.close();
            return isThisType;
        }
        catch (IOException e) {
            if (debug) {
                this.trace(e);
            }
            return false;
        }
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        if (!FormatTools.validStream(stream, this.blockCheckLen, false)) {
            return false;
        }
        String comment = TiffTools.getComment(TiffTools.getFirstIFD(stream));
        return comment != null && comment.trim().startsWith("<MetaData>");
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("MetamorphTiffReader.initFile(" + id + ")");
        }
        super.initFile(id);
        String[] comments = new String[this.ifds.length];
        MetamorphHandler handler = new MetamorphHandler(this.getMetadata());
        for (int i = 0; i < comments.length; ++i) {
            comments[i] = TiffTools.getComment(this.ifds[i]);
            DataTools.parseXML(comments[i], (DefaultHandler)handler);
        }
        this.core[0].sizeC = 0;
        Vector timestamps = handler.getTimestamps();
        Vector wavelengths = handler.getWavelengths();
        Vector zPositions = handler.getZPositions();
        Vector<Integer> uniqueC = new Vector<Integer>();
        for (int i = 0; i < zPositions.size(); ++i) {
            Integer c = (Integer)wavelengths.get(i);
            if (uniqueC.contains(c)) continue;
            uniqueC.add(c);
            ++this.core[0].sizeC;
        }
        this.core[0].sizeT = timestamps.size();
        if (this.core[0].sizeT == 0) {
            this.core[0].sizeT = 1;
        }
        this.core[0].sizeZ = this.ifds.length / (this.getSizeT() * this.getSizeC());
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this, true);
        store.setImageName(handler.getImageName(), 0);
        store.setImageDescription("", 0);
        SimpleDateFormat parse = new SimpleDateFormat("yyyyMMdd HH:mm:ss.SSS");
        Date d = parse.parse(handler.getDate(), new ParsePosition(0));
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        SimpleDateFormat tsfmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        for (int i = 0; i < timestamps.size(); ++i) {
            Date td = parse.parse((String)timestamps.get(i), new ParsePosition(0));
            this.addMeta("timestamp " + i, tsfmt.format(td));
        }
        long startDate = 0L;
        if (timestamps.size() > 0) {
            startDate = parse.parse((String)timestamps.get(0), new ParsePosition(0)).getTime();
        }
        for (int i = 0; i < this.getImageCount(); ++i) {
            int[] coords = this.getZCTCoords(i);
            if (coords[2] >= timestamps.size()) continue;
            String stamp = (String)timestamps.get(coords[2]);
            long ms = parse.parse(stamp, new ParsePosition(0)).getTime();
            store.setPlaneTimingDeltaT(new Float(ms - startDate), 0, 0, i);
            store.setPlaneTimingExposureTime(new Float(0.0f), 0, 0, i);
        }
        store.setImageCreationDate(fmt.format(d), 0);
        store.setImagingEnvironmentTemperature(new Float(handler.getTemperature()), 0);
        store.setDimensionsPhysicalSizeX(new Float(handler.getPixelSizeX()), 0, 0);
        store.setDimensionsPhysicalSizeY(new Float(handler.getPixelSizeY()), 0, 0);
    }
}

