/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.Point;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.RandomAccessStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.codec.ByteVector;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.ZlibCodec;
import loci.formats.in.LegacyND2Reader;
import loci.formats.meta.FilterMetadata;
import loci.formats.meta.MetadataStore;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class ND2Reader
extends FormatReader {
    private long[][] offsets;
    private boolean isJPEG;
    private boolean isLossless;
    private Vector zs = new Vector();
    private Vector ts = new Vector();
    private Vector tsT = new Vector();
    private int numSeries;
    private float pixelSizeX;
    private float pixelSizeY;
    private float pixelSizeZ;
    private String voltage;
    private String mag;
    private String na;
    private String objectiveModel;
    private String immersion;
    private Vector channelNames;
    private Vector binning;
    private Vector speed;
    private Vector gain;
    private Vector temperature;
    private Vector exposureTime;
    private Vector modality;
    private Vector exWave;
    private Vector emWave;
    private Vector power;
    private String cameraModel;
    private LegacyND2Reader legacyReader;
    private boolean legacy = false;

    public ND2Reader() {
        super("Nikon ND2", new String[]{"nd2", "jp2"});
        this.blockCheckLen = 8;
    }

    public void setLegacy(boolean legacy) {
        this.legacy = legacy;
        if (this.legacy) {
            if (this.legacyReader == null) {
                this.legacyReader = new LegacyND2Reader();
            }
        } else {
            this.legacyReader = null;
        }
    }

    public boolean isThisType(RandomAccessStream stream) throws IOException {
        if (!FormatTools.validStream(stream, this.blockCheckLen, false)) {
            return false;
        }
        stream.seek(4L);
        return stream.readInt() == 1783636000;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        if (this.legacy) {
            return this.legacyReader.openBytes(no, buf, x, y, w, h);
        }
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length, w, h);
        this.in.seek(this.offsets[this.series][no]);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int pixel = bpp * this.getRGBChannelCount();
        long maxFP = no == this.getImageCount() - 1 ? this.in.length() : this.offsets[this.series][no + 1];
        CodecOptions options = new CodecOptions();
        options.littleEndian = this.isLittleEndian();
        options.interleaved = this.isInterleaved();
        options.maxBytes = (int)maxFP;
        if (this.isJPEG) {
            byte[] tmp = new JPEG2000Codec().decompress(this.in, options);
            for (int row = y; row < h + y; ++row) {
                System.arraycopy(tmp, pixel * row * this.getSizeX(), buf, pixel * w * (row - y), pixel * w);
            }
            System.arraycopy(tmp, 0, buf, 0, Math.min(tmp.length, buf.length));
            tmp = null;
        } else if (this.isLossless) {
            int effectiveX = this.getSizeX();
            if (this.getSizeX() % 2 != 0) {
                ++effectiveX;
            }
            byte[] t = new ZlibCodec().decompress(this.in, options);
            for (int row = 0; row < h; ++row) {
                int offset = (row + y) * effectiveX * pixel + x * pixel;
                if (offset + w * pixel > t.length) continue;
                System.arraycopy(t, offset, buf, row * w * pixel, w * pixel);
            }
        } else {
            this.readPlane(this.in, x, y, w, h, buf);
        }
        return buf;
    }

    public void setNormalized(boolean normalize) {
        super.setNormalized(normalize);
        if (this.legacy) {
            this.legacyReader.setNormalized(normalize);
        }
    }

    public void setMetadataCollected(boolean collect) {
        super.setMetadataCollected(collect);
        if (this.legacy) {
            this.legacyReader.setMetadataCollected(collect);
        }
    }

    public void setOriginalMetadataPopulated(boolean populate) {
        super.setOriginalMetadataPopulated(populate);
        if (this.legacy) {
            this.legacyReader.setOriginalMetadataPopulated(populate);
        }
    }

    public void setMetadataFiltered(boolean filter) {
        super.setMetadataFiltered(filter);
        if (this.legacy) {
            this.legacyReader.setMetadataFiltered(filter);
        }
    }

    public void setMetadataStore(MetadataStore store) {
        super.setMetadataStore(store);
        if (this.legacy) {
            this.legacyReader.setMetadataStore(store);
        }
    }

    public void close() throws IOException {
        super.close();
        if (this.legacyReader != null) {
            this.legacyReader.close();
        }
        this.legacyReader = null;
        this.legacy = false;
        this.offsets = null;
        this.zs.clear();
        this.ts.clear();
        this.isLossless = false;
        this.isJPEG = false;
        this.numSeries = 0;
        this.tsT.clear();
        this.pixelSizeZ = 0.0f;
        this.pixelSizeY = 0.0f;
        this.pixelSizeX = 0.0f;
        this.immersion = null;
        this.objectiveModel = null;
        this.na = null;
        this.mag = null;
        this.voltage = null;
        this.channelNames = null;
        this.binning = null;
        this.speed = null;
        this.gain = null;
        this.temperature = null;
        this.exposureTime = null;
        this.modality = null;
        this.exWave = null;
        this.emWave = null;
        this.power = null;
        this.cameraModel = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        int numBands;
        if (debug) {
            this.debug("ND2Reader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.channelNames = new Vector();
        this.binning = new Vector();
        this.speed = new Vector();
        this.gain = new Vector();
        this.temperature = new Vector();
        this.exposureTime = new Vector();
        this.modality = new Vector();
        this.exWave = new Vector();
        this.emWave = new Vector();
        this.power = new Vector();
        if (this.legacy) {
            this.legacyReader.close();
            this.legacyReader.setId(id);
            this.core = this.legacyReader.getCoreMetadata();
            this.metadataStore = this.legacyReader.getMetadataStore();
            return;
        }
        this.in = new RandomAccessStream(id);
        if (this.in.read() == -38 && this.in.read() == -50) {
            int i2;
            int i3;
            this.isJPEG = false;
            this.in.seek(0L);
            this.in.order(true);
            Vector<Long> imageOffsets = new Vector<Long>();
            Vector<Point> imageLengths = new Vector<Point>();
            Vector<Long> xmlOffsets = new Vector<Long>();
            Vector<Point> xmlLengths = new Vector<Point>();
            Vector<Long> customDataOffsets = new Vector<Long>();
            Vector<Point> customDataLengths = new Vector<Point>();
            while (this.in.getFilePointer() < this.in.length() && this.in.getFilePointer() >= 0L) {
                while (this.in.read() != -38) {
                }
                this.in.skipBytes(3);
                int lenOne = this.in.readInt();
                int lenTwo = this.in.readInt();
                int len = lenOne + lenTwo;
                this.in.skipBytes(4);
                String blockType = this.in.readString(12);
                long fp = this.in.getFilePointer() - 12L;
                this.in.skipBytes(len - 12);
                if (blockType.startsWith("ImageDataSeq")) {
                    imageOffsets.add(new Long(fp));
                    imageLengths.add(new Point(lenOne, lenTwo));
                    continue;
                }
                if (blockType.startsWith("Image")) {
                    xmlOffsets.add(new Long(fp));
                    xmlLengths.add(new Point(lenOne, lenTwo));
                    continue;
                }
                if (!blockType.startsWith("CustomData|A")) continue;
                customDataOffsets.add(new Long(fp));
                customDataLengths.add(new Point(lenOne, lenTwo));
            }
            ND2Handler handler = new ND2Handler();
            ByteVector xml = new ByteVector();
            for (int i4 = 0; i4 < xmlOffsets.size(); ++i4) {
                long offset = (Long)xmlOffsets.get(i4);
                Point p = (Point)xmlLengths.get(i4);
                int length = p.x + p.y;
                byte[] b = new byte[length];
                this.in.seek(offset);
                this.in.read(b);
                int off = 0;
                for (int j = 0; j < length; ++j) {
                    char c = (char)b[j];
                    if (off == 0 && c == '!' || c == '\u0000') {
                        off = j + 1;
                    }
                    if (!Character.isISOControl(c) && Character.isDefined(c)) continue;
                    b[j] = 32;
                }
                if (length - off < 5 || b[off] != 60 || b[off + 1] != 63 || b[off + 2] != 120 || b[off + 3] != 109 || b[off + 4] != 108) continue;
                boolean endBracketFound = false;
                while (!endBracketFound) {
                    if (b[off++] != 62) continue;
                    endBracketFound = true;
                }
                xml.add(b, off, b.length - off);
            }
            String xmlString = new String(xml.toByteArray());
            xmlString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><ND2>" + xmlString + "</ND2>";
            DataTools.parseXML(xmlString, (DefaultHandler)handler);
            if (this.numSeries == 0) {
                this.numSeries = 1;
            }
            if (this.getSizeZ() == 0) {
                for (int i5 = 0; i5 < this.getSeriesCount(); ++i5) {
                    this.core[i5].sizeZ = 1;
                }
            }
            if (this.getSizeT() == 0) {
                for (int i6 = 0; i6 < this.getSeriesCount(); ++i6) {
                    this.core[i6].sizeT = 1;
                }
            }
            for (i3 = 0; i3 < this.getSeriesCount(); ++i3) {
                this.core[i3].imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
                if (imageOffsets.size() < this.core[i3].imageCount) {
                    this.core[i3].imageCount /= this.getSizeC();
                }
                if (this.core[i3].imageCount <= imageOffsets.size() / this.getSeriesCount()) continue;
                if (this.core[i3].imageCount == imageOffsets.size()) {
                    CoreMetadata originalCore = this.core[0];
                    this.core = new CoreMetadata[]{originalCore};
                    this.numSeries = 1;
                    break;
                }
                this.core[i3].imageCount = imageOffsets.size() / this.getSeriesCount();
                this.core[i3].sizeZ = 1;
                this.core[i3].sizeT = this.core[i3].imageCount;
            }
            this.offsets = new long[this.numSeries][this.getImageCount()];
            for (i3 = 0; i3 < imageOffsets.size(); ++i3) {
                long offset = (Long)imageOffsets.get(i3);
                Point p = (Point)imageLengths.get(i3);
                int length = p.x + p.y;
                this.in.seek(offset);
                byte[] b = new byte[length];
                this.in.read(b);
                StringBuffer sb = new StringBuffer();
                int pt = 13;
                while (b[pt] != 33) {
                    sb.append((char)b[pt++]);
                }
                int ndx = Integer.parseInt(sb.toString());
                if (this.getSizeC() == 0) {
                    int sizeC = length / (this.getSizeX() * this.getSizeY() * FormatTools.getBytesPerPixel(this.getPixelType()));
                    for (int q = 0; q < this.getSeriesCount(); ++q) {
                        this.core[q].sizeC = sizeC;
                    }
                }
                int seriesIndex = ndx / (this.getSizeT() * this.getSizeZ());
                int plane = ndx % (this.getSizeT() * this.getSizeZ());
                if (seriesIndex < this.offsets.length && plane < this.offsets[seriesIndex].length) {
                    this.offsets[seriesIndex][plane] = offset + (long)p.x + 8L;
                }
                b = null;
            }
            Vector<long[]> tmpOffsets = new Vector<long[]>();
            for (i2 = 0; i2 < this.offsets.length; ++i2) {
                if (this.offsets[i2][0] <= 0L) continue;
                tmpOffsets.add(this.offsets[i2]);
            }
            this.offsets = new long[tmpOffsets.size()][];
            for (i2 = 0; i2 < tmpOffsets.size(); ++i2) {
                this.offsets[i2] = (long[])tmpOffsets.get(i2);
            }
            if (this.offsets.length != this.getSeriesCount()) {
                int x = this.getSizeX();
                int y = this.getSizeY();
                int c = this.getSizeC();
                int pixelType = this.getPixelType();
                boolean rgb = this.isRGB();
                this.core = new CoreMetadata[this.offsets.length];
                for (int i7 = 0; i7 < this.offsets.length; ++i7) {
                    this.core[i7] = new CoreMetadata();
                    this.core[i7].sizeX = x;
                    this.core[i7].sizeY = y;
                    this.core[i7].sizeC = c == 0 ? 1 : c;
                    this.core[i7].pixelType = pixelType;
                    this.core[i7].rgb = rgb;
                    this.core[i7].sizeZ = 1;
                    int invalid = 0;
                    for (int q = 0; q < this.offsets[i7].length; ++q) {
                        if (this.offsets[i7][q] != 0L) continue;
                        ++invalid;
                    }
                    this.core[i7].imageCount = this.offsets[i7].length - invalid;
                    this.core[i7].sizeT = this.core[i7].imageCount / (rgb ? 1 : this.core[i7].sizeC);
                    if (this.core[i7].sizeT != 0) continue;
                    this.core[i7].sizeT = 1;
                }
            } else {
                for (i2 = 0; i2 < this.getSeriesCount(); ++i2) {
                    this.core[i2].sizeX = this.getSizeX();
                    this.core[i2].sizeY = this.getSizeY();
                    this.core[i2].sizeC = this.getSizeC() == 0 ? 1 : this.getSizeC();
                    this.core[i2].sizeZ = this.getSizeZ() == 0 ? 1 : this.getSizeZ();
                    this.core[i2].sizeT = this.getSizeT() == 0 ? 1 : this.getSizeT();
                    this.core[i2].imageCount = this.getImageCount();
                    this.core[i2].pixelType = this.getPixelType();
                }
            }
            for (i2 = 0; i2 < this.getSeriesCount(); ++i2) {
                this.core[i2].dimensionOrder = "XYCZT";
                this.core[i2].rgb = this.getSizeC() > 1;
                this.core[i2].littleEndian = true;
                this.core[i2].interleaved = true;
                this.core[i2].indexed = false;
                this.core[i2].falseColor = false;
                this.core[i2].metadataComplete = true;
                this.core[i2].imageCount = this.core[i2].sizeZ * this.core[i2].sizeT;
                if (this.core[i2].rgb) continue;
                this.core[i2].imageCount *= this.core[i2].sizeC;
            }
            if (customDataOffsets.size() > 0) {
                this.in.seek((Long)customDataOffsets.get(0));
                Point p = (Point)customDataLengths.get(0);
                int len = p.x + p.y;
                int timestampBytes = imageOffsets.size() * 8;
                this.in.skipBytes(len - timestampBytes);
                for (int series = 0; series < this.getSeriesCount(); ++series) {
                    for (int plane = 0; plane < this.getImageCount(); ++plane) {
                        double time = this.in.readDouble() / 1000.0;
                        this.tsT.add(new Double(time));
                        this.addMeta("series " + series + " timestamp " + plane, time);
                    }
                }
            }
            this.populateMetadataStore();
            return;
        }
        this.in.seek(0L);
        this.isJPEG = true;
        this.status("Calculating image offsets");
        Vector<Long> vs = new Vector<Long>();
        long pos = this.in.getFilePointer();
        boolean lastBoxFound = false;
        int length = 0;
        int box = 0;
        int x = 0;
        int y = 0;
        int c = 0;
        int type = 0;
        while (!lastBoxFound) {
            pos = this.in.getFilePointer();
            if (pos + (long)(length = this.in.readInt()) >= this.in.length() || length == 0) {
                lastBoxFound = true;
            }
            box = this.in.readInt();
            pos = this.in.getFilePointer();
            length -= 8;
            if (box == 1785737827) {
                vs.add(new Long(pos));
            } else if (box == 1785737832) {
                this.in.skipBytes(4);
                String s = this.in.readString(4);
                if (s.equals("ihdr")) {
                    y = this.in.readInt();
                    x = this.in.readInt();
                    c = this.in.readShort();
                    type = this.in.readInt();
                    type = type == 252117248 || type == 0xF070000 ? 3 : 1;
                }
            }
            if (lastBoxFound || box == 1785737832) continue;
            this.in.skipBytes(length);
        }
        this.status("Finding XML metadata");
        this.in.seek((Long)vs.get(vs.size() - 1));
        boolean found = false;
        long off = -1L;
        byte[] buf = new byte[8192];
        block20: while (!found && this.in.getFilePointer() < this.in.length()) {
            int read = 0;
            if (this.in.getFilePointer() == ((Long)vs.get(vs.size() - 1)).longValue()) {
                read = this.in.read(buf);
            } else {
                System.arraycopy(buf, buf.length - 10, buf, 0, 10);
                read = this.in.read(buf, 10, buf.length - 10);
            }
            if (read == buf.length) {
                read -= 10;
            }
            for (int i8 = 0; i8 < read + 9; ++i8) {
                if (buf[i8] != -1 || buf[i8 + 1] != -39) continue;
                found = true;
                off = this.in.getFilePointer() - (long)(read + 10) + (long)i8;
                i8 = buf.length;
                continue block20;
            }
        }
        buf = null;
        this.status("Parsing XML");
        if (off > 0L && off < this.in.length() - 5L && this.in.length() - off - 5L > 14L) {
            this.in.seek(off + 5L);
            String xml = this.in.readString((int)(this.in.length() - this.in.getFilePointer()));
            StringTokenizer st = new StringTokenizer(xml, "\n");
            StringBuffer sb = new StringBuffer();
            sb.append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><NIKON>");
            while (st.hasMoreTokens()) {
                String token = st.nextToken().trim();
                if (token.indexOf("<!--") != -1 || token.indexOf("VCAL") != -1 || !token.startsWith("<")) continue;
                sb.append(token);
            }
            sb.append("</NIKON>");
            xml = sb.toString();
            this.status("Finished assembling XML string");
            ND2Handler handler = new ND2Handler();
            int offset = 0;
            byte[] b = xml.getBytes();
            int len = b.length;
            for (int i9 = 0; i9 < len; ++i9) {
                char ch = (char)b[i9];
                if (offset == 0 && ch == '!') {
                    offset = i9 + 1;
                }
                if (!Character.isISOControl(ch) && Character.isDefined(ch)) continue;
                b[i9] = 32;
            }
            DataTools.parseXML(new String(b, offset, len - offset), (DefaultHandler)handler);
            xml = null;
        }
        this.status("Populating metadata");
        this.core[0].pixelType = 1;
        this.offsets = new long[1][2];
        this.offsets[0][0] = (Long)vs.get(0);
        if (this.offsets[0].length > 1 && vs.size() > 1) {
            this.offsets[0][1] = (Long)vs.get(1);
        }
        this.in.seek(this.offsets[0][0]);
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        int n = c = (numBands = c) > 1 ? numBands : this.getSizeC();
        if (numBands == 1 && this.getImageCount() == 1) {
            c = 1;
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            this.core[i].sizeC = c;
            this.core[i].rgb = numBands > 1;
            this.core[i].pixelType = type;
        }
        if (this.getImageCount() == 0) {
            int channels;
            this.core[0].imageCount = vs.size();
            this.core[0].sizeZ = Math.max(this.zs.size(), 1);
            this.core[0].sizeT = Math.max(this.ts.size(), 1);
            int n2 = channels = this.isRGB() ? 1 : this.getSizeC();
            if (channels * this.getSizeZ() * this.getSizeT() != this.getImageCount()) {
                this.core[0].sizeZ = 1;
                this.core[0].sizeT = this.getImageCount() / channels;
                this.core[0].imageCount = this.getSizeZ() * this.getSizeT() * channels;
            }
        }
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            this.core[i].sizeZ = this.getSizeZ();
            this.core[i].sizeT = this.getSizeT();
            this.core[i].imageCount = this.getSizeZ() * this.getSizeT() * (this.isRGB() ? 1 : this.getSizeC());
            this.core[i].dimensionOrder = "XYCZT";
            this.core[i].sizeX = x;
            this.core[i].sizeY = y;
            this.core[i].interleaved = false;
            this.core[i].littleEndian = false;
            this.core[i].metadataComplete = true;
        }
        if (this.numSeries == 0) {
            this.numSeries = 1;
        }
        this.offsets = new long[this.numSeries][this.getImageCount()];
        int nplanes = this.getSizeZ() * this.getEffectiveSizeC();
        for (int i10 = 0; i10 < this.getSizeT(); ++i10) {
            for (int j = 0; j < this.numSeries; ++j) {
                for (int q = 0; q < nplanes; ++q) {
                    this.offsets[j][i10 * nplanes + q] = (Long)vs.remove(0);
                }
            }
        }
        this.populateMetadataStore();
    }

    private void populateMetadataStore() {
        int i;
        FilterMetadata store = new FilterMetadata(this.getMetadataStore(), this.isMetadataFiltered());
        MetadataTools.populatePixels(store, this, true);
        store.setInstrumentID("Instrument:0", 0);
        for (i = 0; i < this.getSeriesCount(); ++i) {
            store.setImageName("Series " + i, i);
            MetadataTools.setDefaultCreationDate(store, this.currentId, i);
            store.setImageInstrumentRef("Instrument:0", i);
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            store.setDimensionsPhysicalSizeX(new Float(this.pixelSizeX), i, 0);
            store.setDimensionsPhysicalSizeY(new Float(this.pixelSizeY), i, 0);
            store.setDimensionsPhysicalSizeZ(new Float(this.pixelSizeZ), i, 0);
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            if (this.tsT.size() <= 0) continue;
            this.setSeries(i);
            for (int n = 0; n < this.getImageCount(); ++n) {
                int[] coords = this.getZCTCoords(n);
                int stampIndex = coords[2];
                if (this.tsT.size() == this.getImageCount()) {
                    stampIndex = n;
                }
                float stamp = ((Double)this.tsT.get(stampIndex)).floatValue();
                store.setPlaneTimingDeltaT(new Float(stamp), i, 0, n);
                int index = i * this.getSizeC() + coords[1];
                if (index >= this.exposureTime.size()) continue;
                store.setPlaneTimingExposureTime((Float)this.exposureTime.get(index), i, 0, n);
            }
        }
        store.setDetectorID("Detector:0", 0, 0);
        store.setDetectorModel(this.cameraModel, 0, 0);
        store.setDetectorType("Unknown", 0, 0);
        for (i = 0; i < this.getSeriesCount(); ++i) {
            for (int c = 0; c < this.getSizeC(); ++c) {
                int index = i * this.getSizeC() + c;
                if (index < this.channelNames.size()) {
                    store.setLogicalChannelName((String)this.channelNames.get(index), i, c);
                }
                if (index < this.modality.size()) {
                    store.setLogicalChannelMode((String)this.modality.get(index), i, c);
                }
                if (index < this.emWave.size()) {
                    store.setLogicalChannelEmWave((Integer)this.emWave.get(index), i, c);
                }
                if (index < this.exWave.size()) {
                    store.setLogicalChannelExWave((Integer)this.exWave.get(index), i, c);
                }
                if (index < this.binning.size()) {
                    store.setDetectorSettingsBinning((String)this.binning.get(index), i, c);
                }
                if (index < this.gain.size()) {
                    store.setDetectorSettingsGain((Float)this.gain.get(index), i, c);
                }
                if (index < this.speed.size()) {
                    store.setDetectorSettingsReadOutRate((Float)this.speed.get(index), i, c);
                }
                store.setDetectorSettingsDetector("Detector:0", i, c);
            }
        }
        for (i = 0; i < this.getSeriesCount(); ++i) {
            if (i * this.getSizeC() >= this.temperature.size()) continue;
            Float temp = (Float)this.temperature.get(i * this.getSizeC());
            store.setImagingEnvironmentTemperature(temp, i);
        }
        if (this.voltage != null) {
            store.setDetectorSettingsVoltage(new Float(this.voltage), 0, 0);
        }
        if (this.na != null) {
            store.setObjectiveLensNA(new Float(this.na), 0, 0);
        }
        if (this.mag != null) {
            store.setObjectiveCalibratedMagnification(new Float(this.mag), 0, 0);
        }
        if (this.objectiveModel != null) {
            store.setObjectiveModel(this.objectiveModel, 0, 0);
        }
        if (this.immersion == null) {
            this.immersion = "Unknown";
        }
        store.setObjectiveImmersion(this.immersion, 0, 0);
        store.setObjectiveCorrection("Unknown", 0, 0);
        store.setObjectiveID("Objective:0", 0, 0);
        for (i = 0; i < this.getSeriesCount(); ++i) {
            store.setObjectiveSettingsObjective("Objective:0", 0);
        }
        this.setSeries(0);
    }

    private void parseKeyAndValue(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        this.addMeta(key, value);
        if (key.endsWith("dCalibration")) {
            this.pixelSizeY = this.pixelSizeX = Float.parseFloat(value);
        } else if (key.endsWith("dAspect")) {
            this.pixelSizeZ = Float.parseFloat(value);
        } else if (key.endsWith("Gain")) {
            this.gain.add(new Float(value));
        } else if (key.endsWith("dLampVoltage")) {
            this.voltage = value;
        } else if (key.endsWith("dObjectiveMag")) {
            this.mag = value;
        } else if (key.endsWith("dObjectiveNA")) {
            this.na = value;
        } else if (key.equals("sObjective") || key.equals("wsObjectiveName")) {
            String[] tokens = value.split(" ");
            int magIndex = -1;
            for (int i = 0; i < tokens.length; ++i) {
                if (!tokens[i].endsWith("x")) continue;
                magIndex = i;
                break;
            }
            StringBuffer model = new StringBuffer();
            for (int i = 0; i < magIndex; ++i) {
                model.append(tokens[i]);
                if (i >= magIndex - 1) continue;
                model.append(" ");
            }
            this.objectiveModel = model.toString();
            this.immersion = tokens[magIndex + 1];
        } else if (key.endsWith("dTimeMSec")) {
            long v = (long)Double.parseDouble(value);
            if (!this.ts.contains(new Long(v))) {
                this.ts.add(new Long(v));
                this.addMeta("number of timepoints", this.ts.size());
            }
        } else if (key.endsWith("dZPos")) {
            long v = (long)Double.parseDouble(value);
            if (!this.zs.contains(new Long(v))) {
                this.zs.add(new Long(v));
            }
        } else if (key.endsWith("uiCount")) {
            if (this.getSizeT() == 0) {
                this.core[0].sizeT = Integer.parseInt(value);
            }
        } else if (key.equals("VirtualComponents")) {
            if (this.getSizeC() == 0) {
                this.core[0].sizeC = Integer.parseInt(value);
            }
        } else if (key.startsWith("TextInfoItem") || key.endsWith("TextInfoItem")) {
            this.metadata.remove(key);
            value = value.replaceAll("&#x000d;&#x000a;", "\n");
            StringTokenizer tokens = new StringTokenizer(value, "\n");
            while (tokens.hasMoreTokens()) {
                String t = tokens.nextToken().trim();
                if (t.startsWith("Dimensions:")) {
                    t = t.substring(11);
                    StringTokenizer dims = new StringTokenizer(t, " x ");
                    this.core[0].sizeZ = 1;
                    this.core[0].sizeT = 1;
                    this.core[0].sizeC = 1;
                    while (dims.hasMoreTokens()) {
                        String dim = dims.nextToken().trim();
                        int v = Integer.parseInt(dim.replaceAll("\\D", ""));
                        v = Math.max(v, 1);
                        if (dim.startsWith("XY")) {
                            this.numSeries = v;
                            if (this.numSeries <= 1) continue;
                            int x = this.getSizeX();
                            int y = this.getSizeY();
                            int z = this.getSizeZ();
                            int tSize = this.getSizeT();
                            int c = this.getSizeC();
                            this.core = new CoreMetadata[this.numSeries];
                            for (int i = 0; i < this.numSeries; ++i) {
                                this.core[i] = new CoreMetadata();
                                this.core[i].sizeX = x;
                                this.core[i].sizeY = y;
                                this.core[i].sizeZ = z == 0 ? 1 : z;
                                this.core[i].sizeC = c == 0 ? 1 : c;
                                this.core[i].sizeT = tSize == 0 ? 1 : tSize;
                            }
                            continue;
                        }
                        if (dim.startsWith("T")) {
                            this.core[0].sizeT = v;
                            continue;
                        }
                        if (dim.startsWith("Z")) {
                            this.core[0].sizeZ = v;
                            continue;
                        }
                        this.core[0].sizeC = v;
                    }
                    this.core[0].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
                    continue;
                }
                if (t.startsWith("Number of Picture Planes")) {
                    this.core[0].sizeC = Integer.parseInt(t.replaceAll("\\D", ""));
                    continue;
                }
                String[] v = t.split(":");
                if (v.length == 2) {
                    if (v[0].equals("Name")) {
                        this.channelNames.add(v[1]);
                        continue;
                    }
                    if (v[0].equals("Modality")) {
                        this.modality.add(v[1]);
                        continue;
                    }
                    if (v[0].equals("Camera Type")) {
                        this.cameraModel = v[1];
                        continue;
                    }
                    if (v[0].equals("Binning")) {
                        this.binning.add(v[1]);
                        continue;
                    }
                    if (v[0].equals("Readout Speed")) {
                        int last = v[1].lastIndexOf(" ");
                        if (last != -1) {
                            v[1] = v[1].substring(0, last);
                        }
                        this.speed.add(new Float(v[1]));
                        continue;
                    }
                    if (v[0].equals("Temperature")) {
                        String temp = v[1].replaceAll("[\\D&&[^-.]]", "");
                        this.temperature.add(new Float(temp));
                        continue;
                    }
                    if (!v[0].equals("Exposure")) continue;
                    String[] s = v[1].trim().split(" ");
                    try {
                        float time = Float.parseFloat(s[0]);
                        if (s[1].equals("ms")) {
                            time /= 1000.0f;
                        }
                        this.exposureTime.add(new Float(time));
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (v[0].startsWith("- Step")) {
                    int space = v[0].indexOf(" ", v[0].indexOf("Step") + 1);
                    int last = v[0].indexOf(" ", space + 1);
                    if (last == -1) {
                        last = v[0].length();
                    }
                    this.pixelSizeZ = Float.parseFloat(v[0].substring(space, last));
                    continue;
                }
                if (!v[0].equals("Line")) continue;
                String[] values = t.split(";");
                for (int q = 0; q < values.length; ++q) {
                    int colon = values[q].indexOf(":");
                    String nextKey = values[q].substring(0, colon).trim();
                    String nextValue = values[q].substring(colon + 1).trim();
                    if (nextKey.equals("Emission wavelength")) {
                        this.emWave.add(new Integer(nextValue));
                        continue;
                    }
                    if (nextKey.equals("Excitation wavelength")) {
                        this.exWave.add(new Integer(nextValue));
                        continue;
                    }
                    if (!nextKey.equals("Power")) continue;
                    this.power.add(new Integer((int)Float.parseFloat(nextValue)));
                }
            }
        }
    }

    class ND2Handler
    extends DefaultHandler {
        private String prefix = null;

        ND2Handler() {
        }

        public void endElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("CalibrationSeq") || qName.equals("MetadataSeq")) {
                this.prefix = null;
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            String value = attributes.getValue("value");
            if (qName.equals("uiWidth")) {
                ((ND2Reader)ND2Reader.this).core[0].sizeX = Integer.parseInt(value);
            } else if (qName.equals("uiWidthBytes") || qName.equals("uiBpcInMemory")) {
                int div = qName.equals("uiWidthBytes") ? ND2Reader.this.getSizeX() : 8;
                int bytes = Integer.parseInt(value) / div;
                switch (bytes) {
                    case 2: {
                        ((ND2Reader)ND2Reader.this).core[0].pixelType = 3;
                        break;
                    }
                    case 4: {
                        ((ND2Reader)ND2Reader.this).core[0].pixelType = 5;
                        break;
                    }
                    default: {
                        ((ND2Reader)ND2Reader.this).core[0].pixelType = 1;
                    }
                }
                ND2Reader.this.parseKeyAndValue(qName, value);
            } else if (qName.startsWith("item_")) {
                int v = Integer.parseInt(qName.substring(qName.indexOf("_") + 1));
                if (v == ND2Reader.this.numSeries) {
                    ND2Reader.this.numSeries++;
                }
            } else if (qName.equals("uiCompCount")) {
                int v = Integer.parseInt(value);
                ((ND2Reader)ND2Reader.this).core[0].sizeC = Math.max(ND2Reader.this.getSizeC(), v);
            } else if (qName.equals("uiHeight")) {
                ((ND2Reader)ND2Reader.this).core[0].sizeY = Integer.parseInt(value);
            } else if (qName.startsWith("TextInfo")) {
                ND2Reader.this.parseKeyAndValue(qName, attributes.getValue("Text"));
                ND2Reader.this.parseKeyAndValue(qName, value);
            } else if (qName.equals("dCompressionParam")) {
                ND2Reader.this.isLossless = Integer.parseInt(value) > 0;
                ND2Reader.this.parseKeyAndValue(qName, value);
            } else if (qName.equals("CalibrationSeq") || qName.equals("MetadataSeq")) {
                this.prefix = qName + " " + attributes.getValue("_SEQUENCE_INDEX");
            } else {
                StringBuffer sb = new StringBuffer();
                if (this.prefix != null) {
                    sb.append(this.prefix);
                    sb.append(" ");
                }
                sb.append(qName);
                ND2Reader.this.parseKeyAndValue(sb.toString(), value);
            }
        }
    }
}

