/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.out;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;
import loci.common.DataTools;
import loci.formats.AWTImageTools;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.FormatWriter;

public class AVIWriter
extends FormatWriter {
    private RandomAccessFile raFile;
    private int planesWritten = 0;
    private int bytesPerPixel;
    private File file;
    private int xDim;
    private int yDim;
    private int zDim;
    private int tDim;
    private int xPad;
    private int microSecPerFrame;
    private long saveFileSize;
    private long saveLIST1Size;
    private long saveLIST1subSize;
    private long savestrfSize;
    private long savestrnPos;
    private long saveJUNKsignature;
    private int paddingBytes;
    private long saveLIST2Size;
    private byte[] dataSignature;
    private Vector savedbLength;
    private long idx1Pos;
    private long endPos;
    private long saveidx1Length;
    private int z;
    private long savemovi;
    private int xMod;
    private long frameOffset;
    private long frameOffset2;

    public AVIWriter() {
        super("Audio Video Interleave", "avi");
    }

    public void saveImage(Image image, int series, boolean lastInSeries, boolean last) throws FormatException, IOException {
        int i;
        if (image == null) {
            throw new FormatException("Image is null");
        }
        BufferedImage img = AWTImageTools.makeBuffered(image, this.cm);
        int type = AWTImageTools.getPixelType(img);
        if (!DataTools.containsValue(this.getPixelTypes(), type)) {
            throw new FormatException("Unsupported image type '" + FormatTools.getPixelTypeString(type) + "'.");
        }
        byte[][] byteData = AWTImageTools.getBytes(img);
        if (byteData.length == 2) {
            byte[][] tmpByteData = byteData;
            byteData = new byte[3][tmpByteData[0].length];
            byteData[0] = tmpByteData[0];
            byteData[1] = tmpByteData[1];
        }
        byte[][] lut = null;
        if (img.getColorModel() instanceof IndexColorModel) {
            lut = new byte[4][256];
            IndexColorModel model = (IndexColorModel)img.getColorModel();
            model.getReds(lut[0]);
            model.getGreens(lut[1]);
            model.getBlues(lut[2]);
            model.getAlphas(lut[3]);
        }
        if (!this.initialized) {
            this.initialized = true;
            this.planesWritten = 0;
            this.bytesPerPixel = byteData.length;
            this.file = new File(this.currentId);
            this.raFile = new RandomAccessFile(this.file, "rw");
            this.raFile.seek(this.raFile.length());
            this.saveFileSize = 4L;
            this.saveLIST1Size = 16L;
            this.saveLIST1subSize = 92L;
            this.frameOffset = 48L;
            this.frameOffset2 = 140L;
            this.savestrfSize = 168L;
            this.savestrnPos = this.savestrfSize + 44L + (long)(this.bytesPerPixel == 1 ? 1024 : 0);
            this.saveJUNKsignature = this.savestrnPos + 24L;
            this.saveLIST2Size = 4088L;
            this.savemovi = 4092L;
            this.savedbLength = new Vector();
            this.dataSignature = new byte[4];
            this.dataSignature[0] = 48;
            this.dataSignature[1] = 48;
            this.dataSignature[2] = 100;
            this.dataSignature[3] = 98;
            this.tDim = 1;
            this.zDim = 1;
            this.yDim = img.getHeight();
            this.xDim = img.getWidth();
            this.xPad = 0;
            this.xMod = this.xDim % 4;
            if (this.xMod != 0) {
                this.xPad = 4 - this.xMod;
                this.xDim += this.xPad;
            }
            if (this.raFile.length() == 0L) {
                DataTools.writeString(this.raFile, "RIFF");
                DataTools.writeInt(this.raFile, 0, true);
                DataTools.writeString(this.raFile, "AVI ");
                DataTools.writeString(this.raFile, "LIST");
                DataTools.writeInt(this.raFile, this.bytesPerPixel == 1 ? 1240 : 216, true);
                DataTools.writeString(this.raFile, "hdrl");
                DataTools.writeString(this.raFile, "avih");
                DataTools.writeInt(this.raFile, 56, true);
                this.microSecPerFrame = (int)(1.0 / (double)this.fps * 1000000.0);
                DataTools.writeInt(this.raFile, this.microSecPerFrame, true);
                DataTools.writeInt(this.raFile, 0, true);
                DataTools.writeInt(this.raFile, 0, true);
                DataTools.writeInt(this.raFile, 16, true);
                DataTools.writeInt(this.raFile, this.zDim * this.tDim, true);
                DataTools.writeInt(this.raFile, 0, true);
                DataTools.writeInt(this.raFile, 1, true);
                DataTools.writeInt(this.raFile, 0, true);
                DataTools.writeInt(this.raFile, this.xDim - this.xPad, true);
                DataTools.writeInt(this.raFile, this.yDim, true);
                DataTools.writeInt(this.raFile, 0, true);
                DataTools.writeInt(this.raFile, 0, true);
                DataTools.writeInt(this.raFile, 0, true);
                DataTools.writeInt(this.raFile, 0, true);
                DataTools.writeString(this.raFile, "LIST");
                DataTools.writeInt(this.raFile, this.bytesPerPixel == 1 ? 1164 : 140, true);
                DataTools.writeString(this.raFile, "strl");
                DataTools.writeString(this.raFile, "strh");
                DataTools.writeInt(this.raFile, 56, true);
                DataTools.writeString(this.raFile, "vids");
                DataTools.writeString(this.raFile, "DIB ");
                DataTools.writeInt(this.raFile, 0, true);
                DataTools.writeInt(this.raFile, 0, true);
                DataTools.writeInt(this.raFile, 0, true);
                DataTools.writeInt(this.raFile, 1, true);
                DataTools.writeInt(this.raFile, this.fps, true);
                DataTools.writeInt(this.raFile, 0, true);
                DataTools.writeInt(this.raFile, this.tDim * this.zDim, true);
                DataTools.writeInt(this.raFile, 0, true);
                DataTools.writeInt(this.raFile, -1, true);
                DataTools.writeInt(this.raFile, 0, true);
                DataTools.writeShort(this.raFile, 0, true);
                DataTools.writeShort(this.raFile, 0, true);
                DataTools.writeShort(this.raFile, 0, true);
                DataTools.writeShort(this.raFile, 0, true);
                DataTools.writeString(this.raFile, "strf");
                DataTools.writeInt(this.raFile, this.bytesPerPixel == 1 ? 1068 : 44, true);
                DataTools.writeInt(this.raFile, 40, true);
                DataTools.writeInt(this.raFile, this.xDim, true);
                DataTools.writeInt(this.raFile, this.yDim, true);
                DataTools.writeShort(this.raFile, 1, true);
                int bitsPerPixel = this.bytesPerPixel == 3 ? 24 : 8;
                DataTools.writeShort(this.raFile, (short)bitsPerPixel, true);
                DataTools.writeInt(this.raFile, 0, true);
                DataTools.writeInt(this.raFile, 0, true);
                DataTools.writeInt(this.raFile, 0, true);
                DataTools.writeInt(this.raFile, 0, true);
                int nColors = lut == null ? 0 : 256;
                DataTools.writeInt(this.raFile, nColors, true);
                DataTools.writeInt(this.raFile, 0, true);
                if (this.bytesPerPixel == 1) {
                    if (lut != null) {
                        for (i = 0; i < 256; ++i) {
                            this.raFile.write(lut[2][i]);
                            this.raFile.write(lut[1][i]);
                            this.raFile.write(lut[0][i]);
                            this.raFile.write(lut[3][i]);
                        }
                    } else {
                        byte[] lutWrite = new byte[1024];
                        for (int i2 = 0; i2 < 256; ++i2) {
                            lutWrite[4 * i2] = (byte)i2;
                            lutWrite[4 * i2 + 1] = (byte)i2;
                            lutWrite[4 * i2 + 2] = (byte)i2;
                            lutWrite[4 * i2 + 3] = 0;
                        }
                        this.raFile.write(lutWrite);
                    }
                }
                this.raFile.seek(this.savestrfSize);
                DataTools.writeInt(this.raFile, (int)(this.savestrnPos - (this.savestrfSize + 4L)), true);
                this.raFile.seek(this.savestrnPos);
                DataTools.writeString(this.raFile, "strn");
                DataTools.writeInt(this.raFile, 16, true);
                DataTools.writeString(this.raFile, "FileAVI write  ");
                this.raFile.seek(this.saveLIST1Size);
                DataTools.writeInt(this.raFile, (int)(this.saveJUNKsignature - (this.saveLIST1Size + 4L)), true);
                this.raFile.seek(this.saveLIST1subSize);
                DataTools.writeInt(this.raFile, (int)(this.saveJUNKsignature - (this.saveLIST1subSize + 4L)), true);
                this.raFile.seek(this.saveJUNKsignature);
                DataTools.writeString(this.raFile, "JUNK");
                this.paddingBytes = (int)(4084L - (this.saveJUNKsignature + 8L));
                DataTools.writeInt(this.raFile, this.paddingBytes, true);
                for (i = 0; i < this.paddingBytes / 2; ++i) {
                    DataTools.writeShort(this.raFile, 0, true);
                }
                DataTools.writeString(this.raFile, "LIST");
                this.saveLIST2Size = this.raFile.getFilePointer();
                DataTools.writeInt(this.raFile, 0, true);
                DataTools.writeString(this.raFile, "movi");
            }
        }
        int width = this.xDim - this.xPad;
        int height = byteData[0].length / width;
        this.raFile.write(this.dataSignature);
        this.savedbLength.add(new Long(this.raFile.getFilePointer()));
        DataTools.writeInt(this.raFile, this.bytesPerPixel * this.xDim * this.yDim, true);
        if (this.bytesPerPixel == 1) {
            for (i = height - 1; i >= 0; --i) {
                this.raFile.write(byteData[0], i * width, width);
                for (int j = 0; j < this.xPad; ++j) {
                    this.raFile.write(0);
                }
            }
        } else {
            byte[] buf = new byte[this.bytesPerPixel * this.xDim * this.yDim];
            int offset = 0;
            int next = 0;
            for (int i3 = height - 1; i3 >= 0; --i3) {
                for (int j = 0; j < width; ++j) {
                    offset = i3 * width + j;
                    for (int k = byteData.length - 1; k >= 0; --k) {
                        buf[next++] = byteData[k][offset];
                    }
                }
                next += this.xPad * byteData.length;
            }
            this.raFile.write(buf);
            buf = null;
        }
        ++this.planesWritten;
        if (last) {
            this.idx1Pos = this.raFile.getFilePointer();
            this.raFile.seek(this.saveLIST2Size);
            DataTools.writeInt(this.raFile, (int)(this.idx1Pos - (this.saveLIST2Size + 4L)), true);
            this.raFile.seek(this.idx1Pos);
            DataTools.writeString(this.raFile, "idx1");
            this.saveidx1Length = this.raFile.getFilePointer();
            DataTools.writeInt(this.raFile, 4 + this.planesWritten * 16, true);
            this.z = 0;
            while (this.z < this.planesWritten) {
                this.raFile.write(this.dataSignature);
                if (this.z == 0) {
                    DataTools.writeInt(this.raFile, 16, true);
                } else {
                    DataTools.writeInt(this.raFile, 0, true);
                }
                DataTools.writeInt(this.raFile, (int)((Long)this.savedbLength.get(this.z) - 4L - this.savemovi), true);
                DataTools.writeInt(this.raFile, this.bytesPerPixel * this.xDim * this.yDim, true);
                ++this.z;
            }
            this.endPos = this.raFile.getFilePointer();
            this.raFile.seek(this.saveFileSize);
            DataTools.writeInt(this.raFile, (int)(this.endPos - (this.saveFileSize + 4L)), true);
            this.raFile.seek(this.saveidx1Length);
            DataTools.writeInt(this.raFile, (int)(this.endPos - (this.saveidx1Length + 4L)), true);
            this.raFile.seek(this.frameOffset);
            DataTools.writeInt(this.raFile, this.planesWritten, true);
            this.raFile.seek(this.frameOffset2);
            DataTools.writeInt(this.raFile, this.planesWritten, true);
            this.raFile.close();
        }
    }

    public boolean canDoStacks() {
        return true;
    }

    public int[] getPixelTypes() {
        return new int[]{1};
    }

    public void close() throws IOException {
        if (this.raFile != null) {
            this.raFile.close();
        }
        this.raFile = null;
        this.currentId = null;
        this.initialized = false;
    }
}

